/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.tool;

import com.sdjxd.hussar.core.base72.GlobalSql;
import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.base.Context;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.DataSource;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.organ.Organ;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.roles.service.ManageRole;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.DateTool;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class StringTool {
    static char[] compart = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g'};
    static char emptyChar = (char)49;
    static char transChar = (char)64;
    static String transString = new String(new char[]{transChar});
    static String replaceString = new String(new char[]{transChar, transChar});

    public static String arrayToStr(Object[] array) {
        return BeanTool.toJson(array);
    }

    public static String arrayToStr(int[] array) {
        String json = BeanTool.toJson(array);
        return json;
    }

    static String arrayToStr(List list, int level) {
        char compartChar = compart[level];
        StringBuffer buffer = new StringBuffer(256);
        int i = 0;
        while (i < list.size()) {
            buffer.append(transChar).append(compartChar);
            Object obj = list.get(i);
            if (obj instanceof String) {
                String temp = (String)obj;
                if (temp.indexOf(transChar) >= 0) {
                    buffer.append(StringTool.replace(temp, transString, replaceString));
                } else {
                    buffer.append(temp);
                }
            } else {
                buffer.append(StringTool.arrayToStr((List)obj, level + 1));
            }
            ++i;
        }
        String str = buffer.length() > 0 ? buffer.substring(2) : "";
        return str;
    }

    public static String format(String str, String arg0) {
        if (arg0 == null) {
            return StringTool.format(str, new String[]{""});
        }
        return StringTool.format(str, new String[]{arg0});
    }

    public static String format(String str, String arg0, String arg1) {
        return StringTool.format(str, new String[]{arg0, arg1});
    }

    public static String format(String str, String arg0, String arg1, String arg2) {
        return StringTool.format(str, new String[]{arg0, arg1, arg2});
    }

    public static String format(String str, String arg0, String arg1, String arg2, String arg3) {
        return StringTool.format(str, new String[]{arg0, arg1, arg2, arg3});
    }

    public static String format(String str, String[] arg) {
        String ostr = str;
        int i = 0;
        while (i < arg.length) {
            ostr = StringTool.replace(ostr, "{" + i + "}", arg[i]);
            ++i;
        }
        return ostr;
    }

    public static String format(String str, Object ... arg) {
        String ostr = str;
        int i = 0;
        while (i < arg.length) {
            ostr = ostr.replace("{" + i + "}", arg[i] == null ? "" : arg[i].toString());
            ++i;
        }
        return ostr;
    }

    public static String leftPad(String str, int length, char paddingChar) {
        return StringUtils.leftPad((String)str, (int)length, (char)paddingChar);
    }

    public static String rightPad(String str, int length, char paddingChar) {
        return StringUtils.rightPad((String)str, (int)length, (char)paddingChar);
    }

    public static String replace(String str, String oldStr, String newStr) {
        if (str == null) {
            return null;
        }
        String repstr = str;
        if (newStr.indexOf("$") != -1) {
            while (newStr.indexOf("$") != -1) {
                newStr = newStr.replace("$", "<:s:>");
            }
            newStr.replaceAll("<:s:>", "\\\\\\\\\\$");
        }
        return repstr.replaceAll(StringTool.toUnicode(oldStr), newStr);
    }

    public static Object[] strToArray(String str) {
        Object[] array;
        Object obj;
        if (str == null) {
            return null;
        }
        if (str.startsWith("\"")) {
            str = str.substring(1, str.length());
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        if ((obj = BeanTool.parse(str)) == null) {
            array = null;
        } else if (!obj.getClass().isArray()) {
            array = (Object[])Array.newInstance(obj.getClass(), 1);
            array[0] = obj;
        } else {
            array = (Object[])obj;
        }
        return array;
    }

    static List strToArray(String arg, int level) {
        String str = arg == null ? "" : arg;
        ArrayList<Object> list = new ArrayList<Object>();
        List curList = StringTool.split(str, level);
        if (curList.size() > 1) {
            for (String currentStr : curList) {
                List subList = StringTool.strToArray(currentStr, level + 1);
                if (subList.size() > 1) {
                    list.add(subList);
                    continue;
                }
                list.add(StringTool.replace(currentStr, replaceString, transString));
            }
        } else {
            list.add(StringTool.replace(str, replaceString, transString));
        }
        return list;
    }

    static List split(String str, int level) {
        char compartChar = compart[level];
        String input = str;
        ArrayList<String> array = new ArrayList<String>();
        char pre2 = emptyChar;
        char pre1 = emptyChar;
        int start = 0;
        int i = 0;
        while (i < input.length()) {
            char cur = input.charAt(i);
            if (pre2 != transChar && pre1 == transChar && cur == compartChar) {
                array.add(input.substring(start, i - 1));
                start = i + 1;
            }
            pre2 = pre2 == transChar && pre1 == transChar ? emptyChar : pre1;
            pre1 = cur;
            ++i;
        }
        array.add(input.substring(start, input.length()));
        return array;
    }

    public static String toUnicode(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(str.length() * 6);
        char[] c = str.toCharArray();
        int i = 0;
        while (i < c.length) {
            buffer.append("\\u");
            buffer.append(StringTool.leftPad(Integer.toHexString(c[i]), 4, '0'));
            ++i;
        }
        return buffer.toString();
    }

    public static String escapeUrl(String str) {
        try {
            return URLEncoder.encode(str, "gbk");
        }
        catch (UnsupportedEncodingException exp) {
            return str;
        }
    }

    public static String unescapeUrl(String str) {
        try {
            return URLDecoder.decode(str, "gbk");
        }
        catch (UnsupportedEncodingException exp) {
            return str;
        }
    }

    public static String escapeHtml(String str) {
        return StringEscapeUtils.escapeHtml((String)str);
    }

    public static String getPureText(String text) {
        return text.replaceAll("<(.*)>", "");
    }

    public static String escapeSql(String str) {
        return StringEscapeUtils.escapeSql((String)str);
    }

    public static String escapeJavaScript(String str) {
        return StringEscapeUtils.escapeJavaScript((String)str);
    }

    public static String trimLeft(String str, String trimStr) {
        int len;
        if (trimStr == null || (len = trimStr.length()) <= 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str);
        while (len <= sb.length() && sb.substring(0, len).equals(trimStr)) {
            sb.delete(0, len);
        }
        return sb.toString();
    }

    public static String trimRight(String str, String trimStr) {
        int len;
        if (trimStr == null || (len = trimStr.length()) <= 0) {
            return str;
        }
        int newLen = str.length();
        StringBuffer sb = new StringBuffer(str);
        while (len <= newLen && sb.substring(newLen - len, newLen).equals(trimStr)) {
            sb.setLength(newLen -= len);
        }
        return sb.toString();
    }

    public static String escapeXml(String str) {
        return StringEscapeUtils.escapeXml((String)str);
    }

    public static String toUtf8String(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
            } else {
                byte[] b;
                try {
                    b = Character.toString(c).getBytes("utf-8");
                }
                catch (Exception ex) {
                    b = new byte[]{};
                }
                int j = 0;
                while (j < b.length) {
                    int k = b[j];
                    if (k < 0) {
                        k += 256;
                    }
                    sb.append("%" + Integer.toHexString(k).toUpperCase());
                    ++j;
                }
            }
            ++i;
        }
        String s_utf8 = sb.toString();
        sb.delete(0, sb.length());
        sb.setLength(0);
        sb = null;
        return s_utf8;
    }

    public static String replaceKeyWord(String sstr) {
        if (sstr == null || sstr.length() == 0) {
            return sstr;
        }
        return StringTool.replaceKeyWord(sstr, null);
    }

    public static String replaceHTML(String str) {
        str = str.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        return str;
    }

    public static String replaceKeyWord(String sstr, BaseObject obj) {
        if (sstr == null || sstr.length() == 0) {
            return sstr;
        }
        String ostr = sstr;
        String regex = "\\[(\\w+)\\.([^\\]]*)\\]";
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(ostr);
        Context context = Global.getContext();
        HashMap<String, String> replacement = new HashMap<String, String>();
        while (m.find()) {
            String urlPara;
            List organId;
            User user;
            String matchStr = m.group();
            String matchName = m.group(1);
            String matchArg = m.group(2);
            String matchValue = matchStr;
            if (replacement.containsKey(matchStr)) continue;
            if (matchName.equals("url") && context != null) {
                Object ob;
                matchValue = context.getParameter(matchArg);
                if (!StringTool.isEmpty(matchValue) && matchValue.startsWith("{") && (ob = BeanTool.parse(matchValue)) instanceof Map) {
                    Map queryParam = (Map)ob;
                    try {
                        matchValue = GlobalSql.getQuerySql((Map)queryParam);
                    }
                    catch (Exception exception) {}
                }
            } else if (matchName.equals("req") && context != null) {
                matchValue = (String)context.getRequest(matchArg);
            } else if (matchName.equals("user") && User.getCurrentUser() != null) {
                user = User.getCurrentUser();
                matchValue = matchArg.equals("id") ? user.getId() : (matchArg.equals("name") ? user.getName() : (matchArg.equals("code") ? user.getCode() : (matchArg.equals("org") ? user.getDeptName() : (matchArg.equals("orgid") ? user.getDeptId() : (matchArg.equals("comp") ? user.getCompName() : (matchArg.equals("compid") ? user.getCompId() : (matchArg.equals("roles") ? user.getStrRoles() : BeanTool.getFieldValueString(user, matchArg))))))));
            } else if (matchName.equals("sess") && context != null) {
                matchValue = (String)context.getSession(matchArg);
            } else if (matchName.equals("globalconfig")) {
                matchValue = Global.getConfig(matchArg);
            } else if (matchName.equals("globalconfigMethod")) {
                matchValue = Global.getConfig(matchArg);
                String[] info = matchValue.split("\\.");
                if (info != null && info.length > 1) {
                    String className = info[0];
                    String methodName = "";
                    if (info.length > 2) {
                        int k = 1;
                        while (k < info.length - 1) {
                            className = String.valueOf(className) + "." + info[k];
                            ++k;
                        }
                    }
                    methodName = info[info.length - 1];
                    if (!className.equals("") && !methodName.equals("")) {
                        Object[] arg = new String[]{matchArg};
                        try {
                            Object data = BeanTool.invokeMethod(className, methodName, arg);
                            matchValue = data.toString();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else if (matchName.equals("app")) {
                if (matchArg.equals("path")) {
                    matchValue = Global.getPath();
                } else if (matchArg.equals("name")) {
                    matchValue = Global.getName();
                }
            } else if (matchName.equals("db")) {
                if (matchArg.equals("mode")) {
                    matchValue = DataSource.getDataSource().getSchema();
                }
            } else if (matchName.equals("now")) {
                Date curDate = new Date();
                if (matchArg.equals("weekth")) {
                    matchValue = Integer.toString(DateTool.getWeekOfYear());
                } else if (matchArg.equals("weekbegin")) {
                    Date beginDate = DateTool.getFirstDayOfWeek(curDate);
                    matchValue = DateTool.formatDateTime(beginDate);
                } else if (matchArg.equals("weekend")) {
                    Date endDate = DateTool.getLastDayOfWeek(curDate);
                    matchValue = DateTool.formatDateTime(endDate);
                } else if (matchArg.equals("preMonth")) {
                    Date preMonth = DateTool.getPreMonth(curDate);
                    matchValue = DateTool.formatDateTime(preMonth);
                } else {
                    matchValue = matchArg.equals("quarter") ? String.valueOf(DateTool.getQuarter(curDate)) : DateTool.getNow(matchArg);
                }
            } else if (matchName.equals("obj") && obj != null) {
                matchValue = obj.getFieldValueString(matchArg);
            } else if (matchName.equals("sql")) {
                matchValue = (String)BeanTool.getFieldValue("com.sdjxd.pms.platform.sqlOfDistinctDB.sql", String.valueOf(matchArg) + "_" + DataSource.getDataSource().getDbType().getName());
                matchValue = StringTool.replaceKeyWord(matchValue);
            } else if (matchName.equals("organLimit")) {
                organId = null;
                if (matchArg.equals("curUser")) {
                    organId = Organ.getCurUserLimit();
                } else if (matchArg.equals("curOrgan")) {
                    organId = Organ.getCurUserOrganLimit();
                } else if (matchArg.equals("curUserAndOrgan")) {
                    organId = Organ.getCurUserLimit();
                    List temp = Organ.getCurUserOrganLimit();
                    if (organId == null) {
                        organId = temp;
                    } else if (temp != null) {
                        organId.addAll(temp);
                    }
                }
                if (organId == null || organId.size() == 0) {
                    matchValue = " 1=1 ";
                } else {
                    matchValue = "";
                    int i = 0;
                    while (i < organId.size()) {
                        if (i > 0) {
                            matchValue = String.valueOf(matchValue) + ",";
                        }
                        matchValue = String.valueOf(matchValue) + "'";
                        matchValue = String.valueOf(matchValue) + organId.get(i);
                        matchValue = String.valueOf(matchValue) + "'";
                        ++i;
                    }
                    matchValue = "T.ORGANISEID IN (" + matchValue + ")";
                }
            } else if (matchName.equals("filt")) {
                if (Global.getConfig("isFilt").equals("1")) {
                    List roleId;
                    List menuId;
                    matchValue = "";
                    if (matchArg.equals("curMenu")) {
                        menuId = null;
                        menuId = ManageRole.getCurMenuLimit();
                        matchValue = DbOper.toIn1000Sql("T.MENUID", menuId);
                    } else if (matchArg.equals("curMenus")) {
                        menuId = null;
                        menuId = ManageRole.getCurMenuLimit();
                        matchValue = DbOper.toIn1000Sql("MENUID", menuId);
                    } else if (matchArg.equals("curOrgan")) {
                        organId = null;
                        organId = ManageRole.getCurOrganLimit();
                        matchValue = DbOper.toIn1000Sql("T.ORGANISEID", organId);
                    } else if (matchArg.equals("curOrganList")) {
                        organId = null;
                        organId = ManageRole.getCurOrganLimit();
                        matchValue = DbOper.toIn1000Sql("ORGANISEID", organId);
                    } else if (matchArg.equals("curOrgans")) {
                        organId = null;
                        organId = ManageRole.getCurOrganLimit();
                        matchValue = DbOper.toIn1000Sql("ORGANISEID", organId);
                    } else if (matchArg.equals("curUserOrgans")) {
                        organId = null;
                        organId = ManageRole.getCurOrganLimit();
                        matchValue = DbOper.toIn1000Sql("DEPTID", organId);
                    } else if (matchArg.equals("curOrganContentParent")) {
                        organId = null;
                        organId = ManageRole.getCurManageOrganWithParent();
                        matchValue = DbOper.toIn1000Sql("T.ORGANISEID", organId);
                    } else if (matchArg.equals("curRole")) {
                        roleId = null;
                        roleId = ManageRole.getCurManagedRoleLimit();
                        matchValue = DbOper.toIn1000Sql("T.SHEETID", roleId);
                    } else if (matchArg.equals("curRoles")) {
                        roleId = null;
                        roleId = ManageRole.getCurManagedRoleLimit();
                        matchValue = DbOper.toIn1000Sql("SHEETID", roleId);
                    } else if (matchArg.equals("curMRole")) {
                        String MRoleID = ManageRole.getCurRoleLimit();
                        matchValue = "T.SHEETID = '" + MRoleID + "'";
                    } else if (matchArg.equals("curUserRole")) {
                        user = User.getCurrentUser();
                        matchValue = "T.SHEETID  in (select ROLEID from JXD7_XT_ROLEMROLE where manageroleid =(select ROLEPREID from JXD7_XT_ROLE R,JXD7_XT_USERROLE UR where R.sheetid = UR.roleid and  R.roletype = '1' and UR.userid = '" + user.getId() + "' ))";
                    }
                } else {
                    matchValue = " 1=1 ";
                }
            } else if (matchName.equals("root")) {
                if (Global.getConfig("isFilt").equals("1")) {
                    if (matchArg.equals("curOrg")) {
                        user = User.getCurrentUser();
                        matchValue = "T.ORGANISEID = '" + user.getCompId() + "'";
                    }
                } else if (matchValue.equals("curOrg")) {
                    matchValue = "T.PREORGANISEID is null AND T.DATASTATUSID=1";
                }
            } else if (matchName.equals("userParent")) {
                if (Global.getConfig("isFilt").equals("1")) {
                    matchValue = "";
                    urlPara = context.getParameter(matchArg);
                    if (matchArg.equals("mroleid")) {
                        List organId2 = null;
                        organId2 = ManageRole.getCurOrganLimi(urlPara);
                        matchValue = DbOper.toIn1000Sql("T.DEPTID", organId2);
                    } else if (matchArg.equals("mroleidList")) {
                        List organId3 = null;
                        organId3 = ManageRole.getCurOrganLimi(urlPara);
                        matchValue = DbOper.toIn1000Sql("DEPTID", organId3);
                    }
                } else {
                    matchValue = " 1=1 ";
                }
            } else if (matchName.equals("organParent")) {
                if (Global.getConfig("isFilt").equals("1")) {
                    matchValue = "";
                    urlPara = context.getParameter(matchArg);
                    if (matchArg.equals("pid")) {
                        List organId4 = null;
                        organId4 = ManageRole.getCurManageOrganWithParent(urlPara);
                        matchValue = DbOper.toIn1000Sql("T.ORGANISEID", organId4);
                    } else if (matchArg.equals("mroleid")) {
                        List organId5 = null;
                        organId5 = ManageRole.getCurManageOrganWithParent(urlPara);
                        matchValue = DbOper.toIn1000Sql("T.ORGANISEID", organId5);
                    }
                } else {
                    matchValue = " 1=1 ";
                }
            } else if (matchName.equals("custom")) {
                matchValue = StringTool.replaceKeyWord(Global.getConfig(matchArg));
            }
            if (matchValue == null) {
                matchValue = "";
            }
            replacement.put(matchStr, matchValue);
        }
        replacement.put("$appRoot", Global.getName());
        return StringTool.replace(ostr, replacement);
    }

    public static String replace(String sstr, Map replacement) {
        String ostr = sstr;
        for (Map.Entry entry : replacement.entrySet()) {
            String oldStr = (String)entry.getKey();
            String newStr = (String)entry.getValue();
            ostr = StringTool.replace(ostr, oldStr, newStr);
        }
        return ostr;
    }

    public static String trim(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    public static String concatKey(Map map) {
        return StringTool.concatKey(map, ",");
    }

    public static String concatKey(Map map, String compart1) {
        StringBuffer sb = new StringBuffer(128);
        Iterator it = map.keySet().iterator();
        if (it.hasNext()) {
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(compart1).append(it.next());
        }
        return sb.toString();
    }

    public static String join(String[] array, String sep) {
        StringBuffer sb = new StringBuffer(1024);
        int i = 0;
        while (i < array.length) {
            sb.append(sep);
            sb.append(array[i]);
            ++i;
        }
        if (sb.length() > 0) {
            return sb.substring(sep.length());
        }
        return sb.toString();
    }

    public static String join(int[] array, String sep) {
        StringBuffer sb = new StringBuffer(1024);
        int i = 0;
        while (i < array.length) {
            sb.append(sep);
            sb.append(array[i]);
            ++i;
        }
        if (sb.length() > 0) {
            return sb.substring(sep.length());
        }
        return sb.toString();
    }

    public static String concat(Object[] array) {
        return StringTool.concat(array, ",");
    }

    public static String concat(Object[] array, int start, int end) {
        return StringTool.concat(array, ",", start, end);
    }

    public static String concat(Object[] array, String s) {
        return StringTool.concat(array, s, 0, array.length);
    }

    public static String concat(Object[] array, String s, int start, int end) {
        StringBuffer r = new StringBuffer(array.length * 2);
        int i = start;
        while (i >= 0 && i < end && i < array.length) {
            r.append(s).append(array[i]);
            ++i;
        }
        if (r.length() >= s.length()) {
            return r.substring(s.length());
        }
        return "";
    }

    public static String concat(int[] array) {
        return StringTool.concat(array, ",");
    }

    public static String concat(int[] array, String s) {
        StringBuffer r = new StringBuffer(array.length * 2);
        int i = 0;
        while (i < array.length) {
            r.append(s).append(array[i]);
            ++i;
        }
        return r.substring(s.length());
    }

    public static String encryptStr2(String arg0, String arg1) {
        char[] charArray = arg1.toCharArray();
        StringBuffer sbf = new StringBuffer();
        int i = 0;
        while (i < 4) {
            sbf.append(String.valueOf(arg0.substring(i * (arg0.length() / 4), (i + 1) * (arg0.length() / 4))) + charArray[i]);
            ++i;
        }
        return StringTool.encryptStr(sbf.toString());
    }

    public static String encryptStr(String arg0) {
        byte[] digesta = null;
        try {
            MessageDigest alga = MessageDigest.getInstance("MD5");
            alga.update(arg0.getBytes());
            digesta = alga.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return StringTool.byte2hex(digesta);
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        int n = 0;
        while (n < b.length) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? String.valueOf(hs) + "0" + stmp : String.valueOf(hs) + stmp;
            ++n;
        }
        return hs.toUpperCase();
    }

    public static String match(String sstr, String regex) {
        try {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(sstr);
            if (m.find()) {
                return m.group(m.groupCount());
            }
            return "";
        }
        catch (Exception exp) {
            return "";
        }
    }

    public static String nullToStr(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String toJson(String sstr) {
        if (sstr == null) {
            return "";
        }
        String ostr = StringTool.replace(sstr, "\\", "\\\\\\\\");
        ostr = StringTool.replace(ostr, "\n\r", "\\\\n");
        ostr = StringTool.replace(ostr, "\r\n", "\\\\n");
        ostr = StringTool.replace(ostr, "\n", "\\\\n");
        ostr = StringTool.replace(ostr, "\r", "\\\\n");
        ostr = StringTool.replace(ostr, "\"", "\\\\\"");
        ostr = StringTool.replace(ostr, "</", "<\\\\/");
        return ostr;
    }

    public static String decodeUrlParam(String str, String charSet) {
        String value = "";
        try {
            value = URLDecoder.decode(str, charSet);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return value;
    }
}

