/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.tool;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.model.FileBean;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FileOperate {
    public static void browse(String path) throws IOException {
        StringBuffer sb = new StringBuffer(1024);
        if (path != null) {
            File file;
            if (path.startsWith("/")) {
                path = String.valueOf(Global.getPath()) + path;
            }
            Global.getContext().setContentType("text/html");
            TreeMap list = FileOperate.getModifySortFile(path);
            if (list.size() > 1) {
                for (Map.Entry entry : list.entrySet()) {
                    File file2 = (File)entry.getValue();
                    sb.append("\n<br>");
                    if (file2.isFile()) {
                        sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                    } else if (file2.isDirectory()) {
                        sb.append("DIR<>&nbsp;&nbsp;");
                    }
                    sb.append(DateTool.formatDate(new Date(file2.lastModified())));
                    sb.append("&nbsp;&nbsp;<a href='");
                    sb.append(Global.getName());
                    sb.append("/servlet/com.sdjxd.pms.platform.serviceBreak.Invoke?_c=com.sdjxd.pms.platform.tool.FileOperate.browse&_nr&_p0=\"");
                    sb.append("file.toURI().getPath().substring(1)");
                    sb.append("\"'>");
                    sb.append(file2.getName());
                    sb.append("</a>");
                }
                Global.getContext().write(sb.toString());
            } else if (list.size() == 1 && (file = (File)list.get(list.firstKey())).isFile()) {
                FileBean fileInfo = new FileBean();
                fileInfo.setContentType("application/octet-stream");
                fileInfo.setFileName(file.getName());
                fileInfo.setFileStream((FileInputStream)BeanFactory.getClass("FileInputStream", new File[]{file}));
                Global.getContext().writeFileToResponse(fileInfo);
            }
        }
    }

    public static boolean createFolder(String folderPath) throws IOException {
        boolean result = false;
        File f = (File)BeanFactory.getClass("File", new String[]{folderPath});
        result = f.mkdirs();
        return result;
    }

    public void emptyDirectory(File directory) {
        File[] entries = directory.listFiles();
        int i = 0;
        while (i < entries.length) {
            entries[i].delete();
            ++i;
        }
    }

    public static boolean makeFile(String filepath) throws IOException {
        boolean result = false;
        File file = (File)BeanFactory.getClass("File", new String[]{filepath});
        result = file.createNewFile();
        file = null;
        return result;
    }

    public static boolean isDel(String filepath) {
        boolean result = false;
        File file = (File)BeanFactory.getClass("File", new String[]{filepath});
        result = file.delete();
        file = null;
        return result;
    }

    public static boolean exists(String filepath) {
        boolean result = false;
        File file = (File)BeanFactory.getClass("File", new String[]{filepath});
        result = file.exists();
        file = null;
        return result;
    }

    public static boolean renamefile(String filepath, String destname) {
        boolean result = false;
        File f = (File)BeanFactory.getClass("File", new String[]{filepath});
        String fileParent = f.getParent();
        File rf = (File)BeanFactory.getClass("File", new String[]{String.valueOf(fileParent) + "//" + destname});
        if (f.renameTo(rf)) {
            result = true;
        }
        f = null;
        rf = null;
        return result;
    }

    public static void WriteFile(String filepath, String content) throws IOException {
        FileWriter filewriter = new FileWriter(filepath, false);
        PrintWriter printwriter = new PrintWriter(filewriter);
        printwriter.println(content);
        printwriter.flush();
        printwriter.close();
        filewriter.close();
    }

    public static void ReadFile(String filepath, StringBuffer content) throws Exception {
        String str;
        FileReader fileReader = new FileReader(filepath);
        BufferedReader bufferReader = new BufferedReader(fileReader);
        while ((str = bufferReader.readLine()) != null) {
            content.append(str);
            content.append("\n");
        }
        fileReader.close();
        bufferReader.close();
    }

    public static void logBak(String filePath, long baksize) throws IOException {
        File f = (File)BeanFactory.getClass("File", new String[]{filePath});
        long len = f.length();
        SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyyMMddHHmmss");
        String s = simpledateformat.format(new Date());
        String fileName = f.getName();
        int dot = fileName.indexOf(".");
        String bakName = String.valueOf(s) + fileName.substring(dot);
        System.out.println(bakName);
        if (len >= baksize) {
            FileOperate.renamefile(filePath, bakName);
            FileOperate.makeFile(filePath);
        }
        f = null;
    }

    public static List getFile(String dirPath, String ext) {
        ArrayList<File> allFile = new ArrayList<File>();
        File dir = (File)BeanFactory.getClass("File", new String[]{dirPath});
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    if (files[i].getName().endsWith(ext)) {
                        allFile.add(files[i]);
                    }
                } else if (files[i].isDirectory()) {
                    allFile.addAll(FileOperate.getFile(files[i].getPath(), ext));
                }
                ++i;
            }
        } else if (dir.exists() && dir.isFile()) {
            allFile.add(dir);
        }
        return allFile;
    }

    public static List getFile(String dirPath) {
        ArrayList<File> allFile = new ArrayList<File>();
        File dir = (File)BeanFactory.getClass("File", new String[]{dirPath});
        if (dir.exists()) {
            allFile.add(dir);
            if (dir.isDirectory()) {
                File[] files = dir.listFiles();
                int i = 0;
                while (i < files.length) {
                    allFile.add(files[i]);
                    ++i;
                }
            }
        }
        return allFile;
    }

    public static TreeMap getModifySortFile(String dirPath) {
        TreeMap<Date, File> allFile = new TreeMap<Date, File>();
        File dir = (File)BeanFactory.getClass("File", new String[]{dirPath});
        if (dir.exists()) {
            allFile.put(new Date(dir.lastModified()), dir);
            if (dir.isDirectory()) {
                File[] files = dir.listFiles();
                int i = 0;
                while (i < files.length) {
                    allFile.put(new Date(files[i].lastModified()), files[i]);
                    ++i;
                }
            }
        }
        return allFile;
    }

    public static TreeMap getNameSortFile(String dirPath) {
        TreeMap<String, File> allFile = new TreeMap<String, File>();
        File dir = (File)BeanFactory.getClass("File", new String[]{dirPath});
        if (dir.exists()) {
            allFile.put(dir.getName(), dir);
            if (dir.isDirectory()) {
                File[] files = dir.listFiles();
                int i = 0;
                while (i < files.length) {
                    allFile.put(files[i].getName(), files[i]);
                    ++i;
                }
            }
        }
        return allFile;
    }

    public static File copyBinary(URL sourceFile, String objectFilePath, String objectFileName) throws Exception {
        InputStream inputStream = sourceFile.openStream();
        File objectFile = (File)BeanFactory.getClass("File", new String[]{objectFilePath, objectFileName});
        if (objectFile == null) {
            objectFile = new File(objectFilePath, objectFileName);
        }
        if (!objectFile.exists()) {
            FileOutputStream outputStream = (FileOutputStream)BeanFactory.getClass("FileOutputStream", new File[]{objectFile});
            if (outputStream == null) {
                outputStream = new FileOutputStream(objectFile);
            }
            byte[] array = new byte[8192];
            int i = inputStream.read(array);
            while (i != -1) {
                outputStream.write(array, 0, i);
                i = inputStream.read(array);
            }
            outputStream.close();
        }
        inputStream.close();
        return objectFile;
    }

    public static File copyBinary(String sourceFileName, String objectFileName) throws Exception {
        File objectFile;
        FileInputStream inputStream = (FileInputStream)BeanFactory.getClass("FileInputStream", new String[]{sourceFileName});
        if (inputStream == null) {
            inputStream = new FileInputStream(sourceFileName);
        }
        if ((objectFile = (File)BeanFactory.getClass("File", new String[]{objectFileName})) == null) {
            objectFile = new File(objectFileName);
        }
        if (!objectFile.exists()) {
            FileOutputStream outputStream = (FileOutputStream)BeanFactory.getClass("FileOutputStream", new File[]{objectFile});
            if (outputStream == null) {
                outputStream = new FileOutputStream(objectFile);
            }
            byte[] array = new byte[8192];
            int i = ((InputStream)inputStream).read(array);
            while (i != -1) {
                outputStream.write(array, 0, i);
                i = ((InputStream)inputStream).read(array);
            }
            outputStream.close();
        }
        ((InputStream)inputStream).close();
        return objectFile;
    }
}

