/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.tool;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.RowSet;

public final class DataSet {
    private HashMap fields_ = new HashMap();
    private ArrayList fieldnames_ = new ArrayList();
    private ArrayList rows_ = new ArrayList();
    private int curRow_ = -1;
    private int rowCount_ = 0;

    public DataSet() {
    }

    public DataSet(RowSet rs) {
        this.copyWith(rs);
    }

    public DataSet(String[] fields, ArrayList rows) {
        this.copyWith(fields, rows);
    }

    public boolean copyWith(RowSet rs) {
        this.clear();
        if (rs == null) {
            return false;
        }
        try {
            ResultSetMetaData meta = rs.getMetaData();
            int colCount = meta.getColumnCount();
            int i = 1;
            while (i <= colCount) {
                this.fields_.put(meta.getColumnName(i).toLowerCase(), new Integer(i - 1));
                this.fieldnames_.add(meta.getColumnName(i));
                ++i;
            }
            this.rowCount_ = 0;
            while (rs.next()) {
                String[] row = new String[colCount];
                int i2 = 1;
                while (i2 <= colCount) {
                    row[i2 - 1] = rs.getString(i2);
                    ++i2;
                }
                this.rows_.add(row);
                ++this.rowCount_;
            }
            return true;
        }
        catch (SQLException e) {
            this.clear();
            return false;
        }
    }

    public boolean copyWith(String[] fields, ArrayList rows) {
        this.clear();
        if (fields == null || rows == null) {
            return false;
        }
        int i = 0;
        while (i < fields.length) {
            if (fields[i] == null) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < rows.size()) {
            Object obj = rows.get(i);
            if (!(obj instanceof String[]) || ((String[])obj).length != fields.length) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < fields.length) {
            this.fields_.put(fields[i].toLowerCase(), new Integer(i));
            this.fieldnames_.add(fields[i]);
            ++i;
        }
        this.rows_.addAll(rows);
        this.rowCount_ = rows.size();
        return true;
    }

    public String getString(String fieldName) {
        return this.getString(this.curRow_, fieldName);
    }

    public String getString(int rowIndex, String fieldName) {
        String[] row;
        String fn = fieldName.toLowerCase();
        Integer index = (Integer)this.fields_.get(fn);
        if (index != null && (row = this.getRow(rowIndex)) != null) {
            String value = row[index];
            if (value != null) {
                return value;
            }
            return "";
        }
        return "";
    }

    public String toJsonString() {
        StringBuffer json = new StringBuffer();
        json.append("{");
        int c = 0;
        while (c < this.fieldnames_.size()) {
            json.append("\"" + (String)this.fieldnames_.get(c) + "\":[");
            int r = 0;
            while (r < this.rowCount_) {
                json.append(String.valueOf(DataSet.string2Json(((String[])this.rows_.get(r))[c])) + ",");
                ++r;
            }
            if (this.rowCount_ > 0) {
                json.setCharAt(json.length() - 1, ']');
            } else {
                json.append("]");
            }
            json.append(",");
            ++c;
        }
        if (this.fieldnames_.size() > 0) {
            json.setCharAt(json.length() - 1, '}');
        } else {
            json.append("}");
        }
        return json.toString();
    }

    public String toMapFormatJsonString(String keyFieldName) {
        StringBuffer json = new StringBuffer();
        Integer keyIndex = (Integer)this.fields_.get(keyFieldName.toLowerCase());
        if (keyIndex == null) {
            return "{}";
        }
        int keyCol = keyIndex;
        json.append("{");
        int c = 0;
        while (c < this.fieldnames_.size()) {
            json.append("\"" + (String)this.fieldnames_.get(c) + "\":{");
            int r = 0;
            while (r < this.rowCount_) {
                json.append(String.valueOf(DataSet.string2Json(((String[])this.rows_.get(r))[keyCol])) + ":");
                json.append(String.valueOf(DataSet.string2Json(((String[])this.rows_.get(r))[c])) + ",");
                ++r;
            }
            if (this.rowCount_ > 0) {
                json.setCharAt(json.length() - 1, '}');
            } else {
                json.append("}");
            }
            json.append(",");
            ++c;
        }
        if (this.fieldnames_.size() > 0) {
            json.setCharAt(json.length() - 1, '}');
        } else {
            json.append("}");
        }
        return json.toString();
    }

    public void beforeFirst() {
        this.curRow_ = -1;
    }

    public boolean first() {
        if (this.rowCount_ > 0) {
            this.curRow_ = 0;
            return true;
        }
        return false;
    }

    public int getRow() {
        return this.curRow_;
    }

    public int getRowCount() {
        return this.rowCount_;
    }

    public boolean next() {
        if (this.curRow_ < this.rowCount_ - 1) {
            ++this.curRow_;
            return true;
        }
        return false;
    }

    private void clear() {
        this.curRow_ = -1;
        this.fields_.clear();
        this.fieldnames_.clear();
        this.rowCount_ = 0;
        this.rows_.clear();
    }

    private String[] getRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.rowCount_) {
            return (String[])this.rows_.get(rowIndex);
        }
        return null;
    }

    static String string2Json(String s) {
        if (s == null) {
            return "\"\"";
        }
        StringBuffer sb = new StringBuffer(s.length() + 20);
        sb.append('\"');
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '/': {
                    sb.append("\\/");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }
}

