/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.tool;

import com.sdjxd.pms.platform.cache.Cache;
import com.sdjxd.pms.platform.tool.AsyncMethodRunable;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.File;
import java.io.FileInputStream;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class BeanTool {
    private static Logger log = Logger.getLogger(BeanTool.class);

    public static Object getSingleInstance(String classPath) {
        Object instance = null;
        if (Cache.instance.containsKey(classPath)) {
            instance = Cache.instance.get(classPath);
        } else {
            instance = BeanTool.getInstance(classPath);
            Cache.instance.set(classPath, instance);
        }
        return instance;
    }

    public static Object getSingleInstance(Class define) {
        String classPath = BeanTool.getName(define);
        Object instance = null;
        if (Cache.instance.containsKey(classPath)) {
            instance = Cache.instance.get(classPath);
        } else {
            instance = BeanTool.getInstance(define);
            Cache.instance.set(classPath, instance);
        }
        return instance;
    }

    public static String getName(Class define) {
        if (define != null) {
            return define.getName();
        }
        return null;
    }

    public static Object getInstance(Class define) {
        return BeanTool.getInstance(define, null);
    }

    public static Object getInstance(String classPath) {
        return BeanTool.getInstance(classPath, null);
    }

    public static Object getInstance(String classPath, Object[] par) {
        Object o = null;
        if (classPath == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(classPath);
            o = BeanTool.getInstance(cls, par);
        }
        catch (ClassNotFoundException e) {
            System.out.println("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + e.getMessage());
            log.error((Object)("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + e.getMessage()));
        }
        catch (Exception e) {
            System.out.println("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + e.getMessage());
        }
        return o;
    }

    public static boolean isExist(String classPath) {
        boolean exist = false;
        if (classPath != null) {
            try {
                Class<?> cls = Class.forName(classPath);
                exist = true;
            }
            catch (ClassNotFoundException e) {
                exist = false;
            }
            catch (Exception e) {
                log.error((Object)("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + e.getMessage()));
            }
        }
        return exist;
    }

    public static Class getClassType(String classPath) {
        Class<?> cls = null;
        if (classPath == null) {
            return null;
        }
        try {
            cls = Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            System.out.println("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + e.getMessage());
            log.error((Object)("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + e.getMessage()));
        }
        catch (Exception e) {
            System.out.println("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + e.getMessage());
        }
        return cls;
    }

    public static Object getInstance(Class define, Object[] par) {
        String classPath = null;
        Object o = null;
        if (define == null) {
            return null;
        }
        try {
            classPath = BeanTool.getName(define);
            Class cls = define;
            Constructor<Object> con = null;
            if (par == null) {
                Constructor<?>[] constructors = cls.getDeclaredConstructors();
                int i = 0;
                while (i < constructors.length) {
                    con = constructors[i];
                    Class<?>[] parTypes = con.getParameterTypes();
                    if (parTypes != null && parTypes.length != 0) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                Class[] parTypes = new Class[par.length];
                int i = 0;
                while (i < par.length) {
                    parTypes[i] = par[i].getClass();
                    if (parTypes[i] == Integer.class) {
                        parTypes[i] = Integer.TYPE;
                    }
                    ++i;
                }
                con = cls.getDeclaredConstructor(parTypes);
            }
            if (con != null) {
                con.setAccessible(true);
                o = con.newInstance(par);
            }
        }
        catch (NoSuchMethodException exp) {
            System.out.println("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + exp.getMessage());
            log.debug((Object)("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + exp.getMessage()));
        }
        catch (Exception exp) {
            System.out.println("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + exp.getMessage());
            log.debug((Object)("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + exp.getMessage()));
        }
        return o;
    }

    public static final Object invokeMethod(String classPath, String methodName, Object[] args) throws Exception {
        Class<?> c = Class.forName(classPath);
        return BeanTool.invokeMethod(c, methodName, args);
    }

    public static final void invokeAsyncMethod(String classPath, String methodName, Object[] args) throws Exception {
        AsyncMethodRunable.invoke(classPath, methodName, args);
    }

    public static final Object invokeMethod(Class objClass, String methodName, Object[] args) throws Exception {
        return BeanTool.invokeMethod(objClass, methodName, args, null);
    }

    public static final Object invokeMethod(Object obj, String methodName, Object[] args) throws Exception {
        return BeanTool.invokeMethod(obj.getClass(), methodName, args, obj);
    }

    public static final Object invokeMethod(Class objClass, String methodName, Object[] args, Object obj) throws Exception {
        Method method;
        Object ret = null;
        if (objClass != null) {
            method = BeanTool.getMethod(objClass, methodName, args);
            if (method == null) {
                StringBuffer m = new StringBuffer(256);
                m.append("\u8c03\u7528\u4e86\u4e0d\u5b58\u5728\u7684\u65b9\u6cd5:");
                m.append(objClass);
                m.append(".").append(methodName);
                m.append("(");
                if (args != null && args.length > 0) {
                    int i = 0;
                    while (i < args.length) {
                        if (args[i] == null) {
                            m.append("null,");
                        } else {
                            m.append(args[i].getClass()).append(",");
                        }
                        ++i;
                    }
                    m.setLength(m.length() - 1);
                }
                m.append(")");
                throw new Exception(m.toString());
            }
        } else {
            throw new Exception("\u8c03\u7528\u4e86\u4e0d\u5b58\u5728\u7684\u7c7b\uff01");
        }
        ret = BeanTool.invokeMethod(method, args, obj);
        return ret;
    }

    public static final Object invokeMethod(Method method, Object[] args, Object obj) throws Exception {
        Object ret;
        if (method == null) {
            throw new Exception("\u8c03\u7528\u4e86\u4e0d\u5b58\u5728\u7684\u65b9\u6cd5\uff01");
        }
        try {
            method.setAccessible(true);
            int modifier = method.getModifiers();
            Object owner = null;
            if (!Modifier.isStatic(modifier)) {
                owner = obj;
            }
            ret = method.invoke(owner, args);
        }
        catch (Error exp) {
            if (method != null) {
                log.error((Object)("\u8c03\u7528\u8fc7\u7a0b\u51fa\u73b0\u9519\u8bef\u3002" + method.toString()), (Throwable)exp);
            } else {
                log.error((Object)("\u8c03\u7528\u8fc7\u7a0b\u51fa\u73b0\u9519\u8bef\u3002\u9519\u8bef\u540d\u79f0\u4e3a\uff1a" + exp.getMessage()), (Throwable)exp);
            }
            throw exp;
        }
        catch (InvocationTargetException exp) {
            log.error((Object)("\u8c03\u7528\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38!" + method.toString()), (Throwable)exp);
            Throwable e = exp.getTargetException();
            if (e instanceof Exception) {
                throw (Exception)exp.getTargetException();
            }
            throw new Exception(e);
        }
        catch (Exception exp) {
            if (method != null) {
                log.error((Object)("\u8c03\u7528\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\u3002" + method.toString()), (Throwable)exp);
            } else {
                log.error((Object)("\u8c03\u7528\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\u3002\u9519\u8bef\u540d\u79f0\u4e3a\uff1a" + exp.getMessage()), (Throwable)exp);
            }
            throw exp;
        }
        return ret;
    }

    public static final Method getMethod(Class objClass, String methodName, Object[] args) {
        if (objClass == null) {
            log.error((Object)"\u4f7f\u7528\u4e86\u4e0d\u5b58\u5728\u7684\u7c7b\uff01");
            return null;
        }
        Class[] argTypes = BeanTool.getType(args);
        Method method = null;
        method = BeanTool.getMethod(objClass, methodName, argTypes);
        if (method == null) {
            try {
                boolean isMatch = false;
                Method[] methodes = objClass.getDeclaredMethods();
                int i = 0;
                while (i < methodes.length) {
                    method = methodes[i];
                    if (method.getName().equals(methodName)) {
                        isMatch = true;
                        Class<?>[] types = method.getParameterTypes();
                        if (types.length == argTypes.length) {
                            int j = 0;
                            while (j < types.length) {
                                if (argTypes[j] != null && !types[j].equals(argTypes[j])) {
                                    isMatch = false;
                                    break;
                                }
                                ++j;
                            }
                            if (isMatch) break;
                        }
                    }
                    ++i;
                }
                if (!isMatch) {
                    method = null;
                }
            }
            catch (Exception exp1) {
                log.error((Object)("\u8c03\u7528\u8fc7\u7a0b\u51fa\u73b0\u9519\u8bef\u3002\u9519\u8bef\u540d\u79f0\u4e3a\uff1a" + exp1.getMessage()));
            }
        }
        if (method != null && !Modifier.isPrivate(method.getModifiers())) {
            return method;
        }
        return null;
    }

    public static final Method getMethod(Class objClass, String methodName, Class[] argTypes) {
        Method method = null;
        if (objClass != null) {
            Class parentType = objClass;
            do {
                try {
                    method = parentType.getDeclaredMethod(methodName, argTypes);
                }
                catch (Exception exp) {
                    List list = BeanTool.searchMethod(objClass, methodName, argTypes, 8);
                    if (list.size() > 0) {
                        method = (Method)list.get(0);
                        break;
                    }
                    parentType = parentType.getSuperclass();
                }
            } while (method == null && parentType != null);
        } else {
            log.error((Object)"\u4f7f\u7528\u4e86\u4e0d\u5b58\u5728\u7684\u7c7b\uff01");
        }
        return method;
    }

    public static final List searchMethod(Class objClass, String methodName, Class[] argTypes, int modifier) {
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methods = objClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (!(methodName != null && !method.getName().equals(methodName) || modifier >= 0 && (method.getModifiers() & modifier) == 0)) {
                boolean isMatch = true;
                if (argTypes != null) {
                    Class<?>[] types = method.getParameterTypes();
                    if (types.length == argTypes.length) {
                        int j = 0;
                        while (j < types.length) {
                            if (argTypes[j] != null && !types[j].isAssignableFrom(argTypes[j])) {
                                isMatch = false;
                                break;
                            }
                            ++j;
                        }
                    } else {
                        isMatch = false;
                    }
                }
                if (isMatch) {
                    list.add(method);
                }
            }
            ++i;
        }
        return list;
    }

    public static final List searchMethod(String classPath) throws Exception {
        Class<?> objClass = Class.forName(classPath);
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methods = objClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((method.getModifiers() & 8) != 0) {
                list.add(method);
            }
            ++i;
        }
        return list;
    }

    public static final List getMethodData(List methods) {
        ArrayList methodsData = new ArrayList();
        Iterator it = methods.iterator();
        int i = 0;
        while (it.hasNext()) {
            ArrayList<Object> methodData = new ArrayList<Object>();
            Method method = (Method)it.next();
            methodData.add(method.getName());
            methodData.add(method.getName());
            ArrayList parametersData = new ArrayList();
            Class<?>[] parameterTypes = method.getParameterTypes();
            int j = 0;
            while (j < parameterTypes.length) {
                ArrayList<String> parameterData = new ArrayList<String>();
                String parameterName = new StringBuffer().append("arg").append(j + 1).toString();
                parameterData.add(parameterName);
                parameterData.add(parameterName);
                if (parameterTypes[j].getName().equals("java.long.Integer") || parameterTypes[j].getName().equals("int")) {
                    parameterData.add("int");
                } else if (parameterTypes[j].getName().equals("java.long.Boolean") || parameterTypes[j].getName().equals("boolean")) {
                    parameterData.add("bool");
                } else {
                    parameterData.add("string");
                }
                parametersData.add(parameterData);
                ++j;
            }
            methodData.add(parametersData);
            methodsData.add(methodData);
            ++i;
        }
        return methodsData;
    }

    public static final Class[] getType(Object[] args) {
        if (args == null) {
            return new Class[0];
        }
        int len = args.length;
        Class[] parameterTypes = new Class[len];
        if (len > 0) {
            int i = 0;
            while (i < len) {
                if (args[i] == null) {
                    parameterTypes[i] = null;
                } else {
                    Class<?> classType = args[i].getClass();
                    parameterTypes[i] = BeanTool.getType(classType);
                }
                ++i;
            }
        }
        return parameterTypes;
    }

    public static final Class getType(Class pClassType) {
        Class<Constable> classType = pClassType == null ? null : (pClassType.equals(Integer.class) ? Integer.TYPE : (pClassType.equals(Byte.class) ? Byte.TYPE : (pClassType.equals(Short.class) ? Short.TYPE : (pClassType.equals(Float.class) ? Float.TYPE : (pClassType.equals(Double.class) ? Double.TYPE : (pClassType.equals(Character.class) ? Character.TYPE : (pClassType.equals(Long.class) ? Long.TYPE : (pClassType.equals(Boolean.class) ? Boolean.TYPE : pClassType))))))));
        return classType;
    }

    public static boolean isWrapClass(Class clz) {
        Package pack;
        boolean wrap;
        boolean bl = wrap = clz.isPrimitive() || clz.isArray();
        if (!wrap && (pack = clz.getPackage()) != null) {
            String packageName = pack.getName();
            wrap = packageName.equals("java.lang") || packageName.equals("java.util");
        }
        return wrap;
    }

    public static String toJson(Map map) {
        StringBuffer sb = new StringBuffer(128);
        for (Map.Entry entry : map.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\"").append(":").append(BeanTool.toJson(entry.getValue())).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.insert(0, "new java.util.HashMap({");
        sb.append("})");
        return sb.toString();
    }

    public static String toJson(Object obj) {
        Class<?> classType;
        if (obj == null) {
            return null;
        }
        if (BeanTool.isWrapClass(obj.getClass())) {
            return BeanTool.wrapToJson(obj);
        }
        try {
            Method method = BeanTool.getMethod(obj.getClass(), "toJson", null);
            if (method != null) {
                return (String)BeanTool.invokeMethod(method, null, obj);
            }
        }
        catch (Exception method) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append("{");
        Class<?> parentType = classType = obj.getClass();
        do {
            Field[] field = classType.getDeclaredFields();
            int index = 0;
            while (index < field.length) {
                sb.append(BeanTool.toJson(obj, field[index]));
                ++index;
            }
        } while ((classType = classType.getSuperclass()) != null && !classType.equals(parentType));
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String wrapToJson(Object obj) {
        StringBuffer sb = new StringBuffer(128);
        Class<?> classType = obj.getClass();
        if (classType.equals(String.class) || classType.equals(StringBuffer.class)) {
            String str = classType.equals(StringBuffer.class) ? ((StringBuffer)obj).toString() : (String)obj;
            sb.append("\"");
            sb.append(StringTool.toJson(str));
            sb.append("\"");
        } else if (classType.equals(Date.class)) {
            sb.append("Date.parse(\"");
            sb.append(DateTool.formatDateTime((Date)obj));
            sb.append("\")");
        } else if (classType.isArray()) {
            sb.append("[");
            int len = Array.getLength(obj);
            int index = 0;
            while (index < len) {
                sb.append(BeanTool.toJson(Array.get(obj, index))).append(",");
                ++index;
            }
            if (len > 0) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("]");
        } else if (obj instanceof List) {
            sb.append("[");
            List array = (List)obj;
            int index = 0;
            while (index < array.size()) {
                sb.append(BeanTool.toJson(array.get(index))).append(",");
                ++index;
            }
            if (array.size() > 0) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("]");
        } else if (obj instanceof Map) {
            sb.append(BeanTool.toJson((Map)obj));
        } else {
            sb.append(obj);
        }
        return sb.toString();
    }

    public static String toJson(Object obj, Field field) {
        StringBuffer sb = new StringBuffer(128);
        if (!Modifier.isStatic(field.getModifiers())) {
            sb.append(field.getName());
            sb.append(":");
            Object fieldValue = null;
            try {
                field.setAccessible(true);
                fieldValue = field.get(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fieldValue == null) {
                sb.append(fieldValue);
            } else {
                sb.append(BeanTool.toJson(fieldValue));
            }
            sb.append(",");
        }
        return sb.toString();
    }

    public static String toJsonObject(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (BeanTool.isWrapClass(obj.getClass())) {
            return BeanTool.wrapToJsonObject(obj);
        }
        Method method = BeanTool.getMethod(obj.getClass(), "toJsonObject", null);
        if (method != null) {
            try {
                return (String)BeanTool.invokeMethod(method, null, obj);
            }
            catch (Exception exp) {
                exp.printStackTrace();
                return "null";
            }
        }
        StringBuffer sb = new StringBuffer(128);
        Class<?> classType = null;
        Class<?> parentType = obj.getClass();
        while (parentType != null && !parentType.equals(classType)) {
            Field[] field = parentType.getDeclaredFields();
            int index = 0;
            while (index < field.length) {
                if (!Modifier.isStatic(field[index].getModifiers())) {
                    sb.append(BeanTool.toJsonObject(field[index].getName()));
                    sb.append(":");
                    Object fieldValue = null;
                    try {
                        field[index].setAccessible(true);
                        fieldValue = field[index].get(obj);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sb.append(BeanTool.toJsonObject(fieldValue));
                    sb.append(",");
                }
                ++index;
            }
            classType = parentType;
            parentType = classType.getSuperclass();
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        sb.insert(0, "JSClass.extend({");
        sb.append("}");
        sb.append(",").append(BeanTool.toJsonObject(obj.getClass().getName()));
        sb.append(")");
        return sb.toString();
    }

    private static String wrapToJsonObject(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class<?> classType = obj.getClass();
        StringBuffer sb = new StringBuffer(128);
        if (obj instanceof String) {
            sb.append("\"");
            sb.append(StringTool.toJson((String)obj));
            sb.append("\"");
        } else if (obj instanceof StringBuffer) {
            sb.append("\"");
            sb.append(StringTool.toJson(((StringBuffer)obj).toString()));
            sb.append("\"");
        } else if (obj instanceof Date) {
            sb.append("Date.parse(\"");
            sb.append(DateTool.formatDateTime((Date)obj));
            sb.append("\")");
        } else if (obj instanceof Calendar) {
            sb.append("Date.parse(\"");
            sb.append(DateTool.formatDateTime(((Calendar)obj).getTime()));
            sb.append("\")");
        } else if (classType.isArray()) {
            sb.append("[");
            int len = Array.getLength(obj);
            if (len > 0) {
                int index = 0;
                while (index < len) {
                    sb.append(BeanTool.toJsonObject(Array.get(obj, index))).append(",");
                    ++index;
                }
                sb.setLength(sb.length() - 1);
            }
            sb.append("]");
        } else if (obj instanceof List) {
            sb.append("JSClass.extend([");
            List array = (List)obj;
            int index = 0;
            while (index < array.size()) {
                sb.append(BeanTool.toJsonObject(array.get(index))).append(",");
                ++index;
            }
            if (array.size() > 0) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("],");
            sb.append(BeanTool.toJsonObject(classType.getName()));
            sb.append(")");
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            sb.append("JSClass.extend({");
            if (map.size() > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    if (key == null) continue;
                    sb.append(BeanTool.toJsonObject(key)).append(":").append(BeanTool.toJsonObject(entry.getValue())).append(",");
                }
                if (sb.charAt(sb.length() - 1) == ',') {
                    sb.setLength(sb.length() - 1);
                }
            }
            sb.append("},");
            sb.append(BeanTool.toJsonObject("java.util.HashMap"));
            sb.append(")");
        } else {
            sb.append(obj);
        }
        return sb.toString();
    }

    public static Object parseArray(JSONArray jsonArray, Class classType) {
        Object element;
        int i;
        int len = jsonArray.size();
        Class componentType = null;
        Object[] objArray = new Object[len];
        if (classType == null || classType.getComponentType() == null) {
            if (len > 0) {
                i = 0;
                while (i < len) {
                    objArray[i] = element = BeanTool.parse(jsonArray.get(i), classType);
                    if (element != null && !Object.class.equals(componentType)) {
                        if (componentType == null) {
                            componentType = element.getClass();
                        } else if (!componentType.equals(element.getClass())) {
                            componentType = Object.class;
                        }
                    }
                    ++i;
                }
            } else {
                componentType = Object.class;
            }
        } else {
            componentType = classType.getComponentType();
            i = 0;
            while (i < len) {
                objArray[i] = element = BeanTool.parse(jsonArray.get(i), componentType);
                ++i;
            }
        }
        Object array = Array.newInstance(componentType, len);
        i = 0;
        while (i < len) {
            Array.set(array, i, objArray[i]);
            ++i;
        }
        return array;
    }

    public static Object parseArray(JSONArray jsonArray) {
        return BeanTool.parse((JSON)jsonArray, null);
    }

    public static Object parse(JSON json, Class classType) {
        if (json == null) {
            return null;
        }
        if (json instanceof JSONArray && (classType == null || classType.isArray())) {
            return BeanTool.parseArray((JSONArray)json, classType);
        }
        if (json instanceof JSONArray && classType != null && classType.getName().equals("java.util.ArrayList")) {
            ArrayList<Object> list = new ArrayList<Object>();
            JSONArray jsonArray = (JSONArray)json;
            int len = jsonArray.size();
            int index = 0;
            while (index < len) {
                list.add(BeanTool.parse(jsonArray.get(index), null));
                ++index;
            }
            return list;
        }
        if (!(json instanceof JSONObject)) {
            return null;
        }
        JSONObject jsonObject = (JSONObject)json;
        if (jsonObject.isNullObject()) {
            return null;
        }
        Object obj = null;
        String classPath = classType != null && !jsonObject.containsKey((Object)"_c") ? classType.getName() : (jsonObject.containsKey((Object)"_c") ? jsonObject.getString("_c") : "java.util.HashMap");
        if (classType != null && StringTool.isEmpty(classPath)) {
            classPath = classType.getName();
        }
        if ("json".equals(classPath)) {
            obj = jsonObject;
        } else if ("java.util.ArrayList".equals(classPath)) {
            ArrayList<Object> list = new ArrayList<Object>();
            JSONArray jsonArray = jsonObject.getJSONArray("data");
            int len = jsonArray.size();
            int index = 0;
            while (index < len) {
                list.add(BeanTool.parse(jsonArray.get(index), null));
                ++index;
            }
            obj = list;
        } else if ("java.util.HashMap".equals(classPath)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.equals("_c")) continue;
                map.put(key, BeanTool.parse(jsonObject.get(key), null));
            }
            obj = map;
        } else {
            Class clz = classType == null ? BeanTool.getClassType(classPath) : classType;
            Method parseMethod = BeanTool.getMethod(clz, "parse", new Class[]{JSONObject.class});
            if (parseMethod != null) {
                try {
                    return BeanTool.invokeMethod(parseMethod, new Object[]{jsonObject}, null);
                }
                catch (Exception exp) {
                    log.error((Object)exp);
                    return null;
                }
            }
            Class fieldType = null;
            obj = BeanTool.getInstance(classPath);
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.equals("_c")) continue;
                fieldType = BeanTool.getFieldType(obj, key);
                BeanTool.setFieldValue(obj, key, BeanTool.parse(jsonObject.get(key), fieldType));
            }
        }
        return obj;
    }

    public static Object parse(JSON json) {
        return BeanTool.parse(json, null);
    }

    public static Object parse(Object json, Class classType) {
        if (json instanceof JSONObject && ((JSONObject)json).isNullObject()) {
            return null;
        }
        if (classType != null) {
            if (classType.isArray()) {
                return BeanTool.parseArray((JSONArray)json, classType);
            }
            if (json instanceof JSON) {
                return BeanTool.parse((JSON)json, classType);
            }
        } else {
            if (json instanceof JSONObject) {
                return BeanTool.parse((JSON)json, classType);
            }
            if (json instanceof JSONArray) {
                return BeanTool.parseArray((JSONArray)json, classType);
            }
            if (json instanceof JSONNull) {
                return null;
            }
        }
        return json;
    }

    public static Object parse(String source) {
        if (StringTool.isEmpty(source) || "null".equals(source)) {
            return null;
        }
        if (source.startsWith("[")) {
            return BeanTool.parseArray(JSONArray.fromObject((Object)source));
        }
        if (source.startsWith("{")) {
            return BeanTool.parse((JSON)JSONObject.fromObject((Object)source));
        }
        try {
            JSONObject json = JSONObject.fromObject((Object)("{_c:'wrap',value:" + source + "}"));
            return json.get("value");
        }
        catch (JSONException exp) {
            return source;
        }
    }

    public static String toString(Object obj) {
        StringBuffer sb = new StringBuffer(512);
        Field[] field = obj.getClass().getDeclaredFields();
        int index = 0;
        while (index < field.length) {
            sb.append(field[index].getName());
            sb.append("(");
            sb.append(field[index].getType().getName());
            sb.append("):");
            try {
                sb.append(field[index].get(obj));
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append("\n");
            ++index;
        }
        return sb.toString();
    }

    public static String toXml(Object obj) {
        StringBuffer sb = new StringBuffer(512);
        sb.append("<bean cname=\"");
        sb.append(obj.getClass().getName());
        sb.append("\">");
        Field[] field = obj.getClass().getDeclaredFields();
        int index = 0;
        while (index < field.length) {
            if (!Modifier.isStatic(field[index].getModifiers())) {
                sb.append("<field name=\"");
                sb.append(field[index].getName());
                sb.append("\">");
                Object fieldValue = null;
                try {
                    field[index].setAccessible(true);
                    fieldValue = field[index].get(obj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (BeanTool.isWrapClass(field[index].getType())) {
                    sb.append(fieldValue);
                } else {
                    sb.append(BeanTool.toXml(fieldValue));
                }
                sb.append("</field>");
            }
            ++index;
        }
        sb.append("</bean>");
        return sb.toString();
    }

    public static String getFieldValueString(Object obj, String name) {
        Object fieldValue = BeanTool.getFieldValue(obj, name);
        if (fieldValue == null) {
            return "";
        }
        if (fieldValue instanceof String) {
            return (String)fieldValue;
        }
        return fieldValue.toString();
    }

    public static final Class getFieldType(Object obj, String name) {
        if (obj == null) {
            return null;
        }
        for (Class<?> classType = obj.getClass(); classType != null; classType = classType.getSuperclass()) {
            try {
                Field field = classType.getDeclaredField(name);
                field.setAccessible(true);
                return field.getType();
            }
            catch (NoSuchFieldException exp1) {
                continue;
            }
            catch (Exception exp) {
                exp.printStackTrace();
                break;
            }
        }
        return null;
    }

    public static final Object getFieldValue(Object obj, String name) {
        if (obj == null) {
            return null;
        }
        for (Class<?> classType = obj.getClass(); classType != null; classType = classType.getSuperclass()) {
            try {
                Field field = classType.getDeclaredField(name);
                field.setAccessible(true);
                return field.get(obj);
            }
            catch (NoSuchFieldException exp1) {
                continue;
            }
            catch (Exception exp) {
                exp.printStackTrace();
                break;
            }
        }
        return null;
    }

    public static final Object getFieldValue(Class classType, String name) {
        if (classType == null || name == null) {
            return null;
        }
        try {
            Field field = classType.getDeclaredField(name);
            if (Modifier.isStatic(field.getModifiers())) {
                field.setAccessible(true);
                return field.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static final Object getFieldValue(String classPath, String name) {
        Class classType = BeanTool.getClassType(classPath);
        return BeanTool.getFieldValue(classType, name);
    }

    public static final void setFieldValue(Object obj, String name, Object value) {
        Class<?> classType = obj.getClass();
        Field field = null;
        do {
            try {
                field = classType.getDeclaredField(name);
                field.setAccessible(true);
                field.set(obj, value);
                break;
            }
            catch (NoSuchFieldException exp1) {
                classType = classType.getSuperclass();
            }
            catch (Exception exp) {
                exp.printStackTrace();
                break;
            }
        } while (classType != null);
    }

    public static List getClass(String packageName) throws Exception {
        String classPath = System.getProperty("java.class.path");
        String[] all = classPath.split(";");
        ArrayList classes = new ArrayList();
        int i = 0;
        while (i < all.length) {
            if (all[i].endsWith(".jar")) {
                BeanTool.getClassInJar(all[i], packageName, classes);
            } else {
                BeanTool.getClassInFile(all[i], packageName, classes);
            }
            ++i;
        }
        Collections.sort(classes, String.CASE_INSENSITIVE_ORDER);
        return classes;
    }

    public static void getClassInFile(String path, String packName, List list) throws Exception {
        String filePath = String.valueOf(path) + "\\" + packName.replace('.', '\\');
        File file = (File)BeanFactory.getClass("File", new String[]{filePath});
        if (file.exists() && file.isDirectory()) {
            File[] classes = file.listFiles();
            int i = 0;
            while (i < classes.length) {
                boolean isDirectory = classes[i].isDirectory();
                String className = String.valueOf(packName) + "." + classes[i].getName();
                if (isDirectory) {
                    BeanTool.getClassInFile(path, className, list);
                } else if (className.endsWith(".class")) {
                    className = className.substring(0, className.length() - 6).replace('$', '.');
                    list.add(className);
                }
                ++i;
            }
        }
    }

    public static void getClassInJar(String jar, String packName, List list) throws Exception {
        FileInputStream fin = (FileInputStream)BeanFactory.getClass("FileInputStream", new String[]{jar});
        ZipInputStream in = new ZipInputStream(fin);
        ZipEntry ze = null;
        while ((ze = in.getNextEntry()) != null) {
            String className = ze.getName().replace('/', '.');
            if (!className.startsWith(packName) || !className.endsWith(".class")) continue;
            className = className.substring(0, className.length() - 6).replace('$', '.');
            list.add(className);
        }
    }

    /*
     * Exception decompiling
     */
    public static String toPureJson(Object obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CATCHBLOCK]], but top level block is 2[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String map2PureJson(Map map) {
        StringBuffer sb = new StringBuffer(128);
        for (Map.Entry entry : map.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\"").append(":").append(BeanTool.toPureJson(entry.getValue())).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.insert(0, "{");
        sb.append("}");
        return sb.toString();
    }

    private static String wrap2PureJson(Object obj) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        StringBuffer sb = new StringBuffer(128);
        Class<?> classType = obj.getClass();
        if (classType.equals(String.class) || classType.equals(StringBuffer.class)) {
            String str = classType.equals(StringBuffer.class) ? ((StringBuffer)obj).toString() : (String)obj;
            sb.append("\"");
            sb.append(BeanTool.str2PureJson(str));
            sb.append("\"");
        } else if (classType.equals(Date.class)) {
            sb.append("\"");
            sb.append(DateTool.formatDateTime((Date)obj));
            sb.append("\"");
        } else if (classType.isArray()) {
            sb.append("[");
            int len = Array.getLength(obj);
            int index = 0;
            while (index < len) {
                sb.append(BeanTool.toPureJson(Array.get(obj, index))).append(",");
                ++index;
            }
            if (len > 0) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("]");
        } else if (obj instanceof List) {
            sb.append("[");
            List array = (List)obj;
            int index = 0;
            while (index < array.size()) {
                sb.append(BeanTool.toPureJson(array.get(index))).append(",");
                ++index;
            }
            if (array.size() > 0) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("]");
        } else if (obj instanceof Map) {
            sb.append(BeanTool.map2PureJson((Map)obj));
        } else {
            sb.append(obj);
        }
        return sb.toString();
    }

    private static String str2PureJson(String sstr) {
        if (sstr == null) {
            return "";
        }
        String ostr = StringTool.replace(sstr, "\\", "\\\\\\\\");
        ostr = StringTool.replace(ostr, "\r\n", "\\\\n");
        ostr = StringTool.replace(ostr, "\n", "\\\\n");
        ostr = StringTool.replace(ostr, "\"", "\\\\\"");
        ostr = StringTool.replace(ostr, "</", "<\\\\/");
        return ostr;
    }

    private static String toPureJson(Object obj, Field field) {
        StringBuffer sb = new StringBuffer(128);
        if (!Modifier.isStatic(field.getModifiers())) {
            sb.append("\"").append(field.getName()).append("\"");
            sb.append(":");
            Object fieldValue = null;
            try {
                field.setAccessible(true);
                fieldValue = field.get(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fieldValue == null) {
                sb.append(fieldValue);
            } else {
                sb.append(BeanTool.toPureJson(fieldValue));
            }
            sb.append(",");
        }
        return sb.toString();
    }
}

