/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.timeManager.service;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.timeManager.dao.TimerDAO;
import com.sdjxd.pms.platform.timeManager.po.TimerPO;
import com.sdjxd.pms.platform.tool.BeanTool;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class TimerService {
    private static Logger logger = Logger.getLogger(TimerService.class);
    private static String EXCETYPE_PLAN = "0";
    private static String EXCETYPE_NOPLAN = "1";

    public static boolean execTimer(String timerId) {
        TimerPO timer = TimerDAO.getTimerById(timerId);
        if (!TimerService.checkCanStart()) {
            TimerService.insertLog(timer, "\u672c\u673aIP\u4e0e\u914d\u7f6eIP\u4e0d\u4e00\u81f4\u4e0d\u5141\u8bb8\u542f\u52a8", EXCETYPE_NOPLAN);
            return false;
        }
        TimerService.insertTimerExt(timer);
        String startTime = null;
        String endTime = null;
        boolean success = true;
        Date dateStart = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        startTime = df.format(dateStart);
        String function = timer.getTimerFunction();
        if (!"".equals(function)) {
            int pos = function.lastIndexOf(46);
            String className = function.substring(0, pos);
            String methodName = function.substring(pos + 1);
            try {
                TimerService.setRunningStatus(timer);
                TimerService.insertLog(timer, "\u5b9a\u65f6\u5668\u5f00\u59cb\u6267\u884c", EXCETYPE_NOPLAN);
                BeanTool.invokeMethod(className, methodName, new Object[]{timer.getTimerId(), timer.getTimerName()});
                TimerService.insertLog(timer, "\u5b9a\u65f6\u5668\u6267\u884c\u7ed3\u675f", EXCETYPE_NOPLAN);
                TimerService.setUnrunningStatus(timer);
            }
            catch (Exception e) {
                success = false;
                TimerService.insertLog(timer, "\u5b9a\u65f6\u5668\u6267\u884c\u5f02\u5e38" + e.getMessage(), EXCETYPE_NOPLAN);
            }
        }
        Date dateEnd = new Date();
        endTime = df.format(dateEnd);
        return success;
    }

    private static void insertLog(TimerPO po, String mess, String execType) {
        TimerDAO.insertLog(po, mess, execType);
    }

    private static void setUnrunningStatus(TimerPO po) {
        TimerDAO.setUnrunningStatus(po);
    }

    private static void setRunningStatus(TimerPO po) {
        TimerDAO.setRunningStatus(po);
    }

    private static void insertTimerExt(TimerPO po) {
        TimerDAO.insertTimerExt(po);
    }

    public static boolean setDisableOrNot(String timerId) {
        return TimerDAO.setDisableOrNot(timerId);
    }

    public static String getIpAddress() {
        String ipAddress = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            ipAddress = "";
            logger.error((Object)(" \u83b7\u53d6\u672c\u673aIP\u5931\u8d25 " + e.getMessage()));
            e.printStackTrace();
        }
        return ipAddress;
    }

    public static boolean checkCanStart() {
        boolean retBoolean = true;
        String conIpAddress = Global.getConfig("timerIp");
        String ipAddress = TimerService.getIpAddress();
        if (conIpAddress != null && !"".equals(conIpAddress) && !ipAddress.equals(conIpAddress)) {
            retBoolean = false;
        }
        return retBoolean;
    }
}

