/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.table.service.mean;

import com.sdjxd.pms.platform.table.model.FieldMeanBean;
import com.sdjxd.pms.platform.table.service.mean.FieldMean;
import com.sdjxd.pms.platform.table.service.mean.IFieldMean;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class IDStringPicker
extends FieldMean
implements IFieldMean {
    private static final long serialVersionUID = 1L;
    private int type;
    private String url;
    private String idField;
    private String nameField;
    private String tableName;
    private String query;
    private String orderSql;
    private boolean editable;
    private boolean multiSelect;
    private boolean spellSearch;
    private boolean addBlank;
    private ListOrderedMap data;
    public static final int FILLMODE_LIST = 0;
    public static final int FILLMODE_DATABASE = 2;
    private Map idValueCache;
    private boolean needConvert = true;

    @Override
    public void init(FieldMeanBean bean) {
        super.init(bean);
        Object[] assitinfo = bean.getAssitinfo();
        String[] sub = (String[])assitinfo[1];
        this.type = Integer.parseInt((String)assitinfo[0]);
        if (this.type == 2) {
            this.tableName = sub[0];
            this.nameField = sub[1];
            this.idField = sub[2];
            this.query = sub[3];
            if (sub.length > 4) {
                this.orderSql = sub[4];
            }
            this.needConvert = this.idField != null && !this.idField.equals(this.nameField);
        } else if (this.type == 0) {
            this.data = new ListOrderedMap();
            int i = 0;
            while (i < sub.length) {
                String[] idAndName = sub[i].split(",");
                if (idAndName.length == 2) {
                    this.data.put((Object)idAndName[0], (Object)idAndName[1]);
                } else if (idAndName.length == 1) {
                    this.needConvert = false;
                }
                ++i;
            }
        }
    }

    @Override
    public String getText(String value) {
        StringBuffer textSb = new StringBuffer();
        if (this.needConvert) {
            String[] valueArr = value != null && value.indexOf(",") != -1 ? value.split(",") : new String[]{value};
            if (this.type == 2) {
                int i = 0;
                int len = valueArr.length;
                while (i < len) {
                    String text;
                    String valueTemp = valueArr[i];
                    if (this.idValueCache != null && this.idValueCache.containsKey(valueTemp)) {
                        text = (String)this.idValueCache.get(valueTemp);
                    } else {
                        text = dao.getNameById(this.dataSourceName, "", this.idField, this.nameField, this.tableName, this.query, valueTemp);
                        if (this.idValueCache != null) {
                            this.idValueCache.put(valueTemp, text);
                        }
                    }
                    if (textSb.length() > 0) {
                        textSb.append(",");
                    }
                    if (text != null) {
                        textSb.append(text);
                    }
                    ++i;
                }
            } else if (this.type == 0) {
                int i = 0;
                int len = valueArr.length;
                while (i < len) {
                    String valueTemp = valueArr[i];
                    String text = valueTemp == null ? (String)this.data.get((Object)"") : (String)this.data.get((Object)valueTemp);
                    if (textSb.length() > 0) {
                        textSb.append(",");
                    }
                    if (text != null) {
                        textSb.append(text);
                    }
                    ++i;
                }
            } else {
                String text = value;
                if (text != null) {
                    textSb.append(text);
                }
            }
        } else if (value != null) {
            textSb.append(value);
        }
        if (textSb.length() == 0) {
            return null;
        }
        return textSb.toString();
    }

    public boolean isAddBlank() {
        return this.addBlank;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getIdField() {
        return this.idField;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public String getNameField() {
        return this.nameField;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isSpellSearch() {
        return this.spellSearch;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void setCacheIdValue(boolean isCached) {
        this.idValueCache = isCached ? new HashMap() : null;
    }

    public ListOrderedMap getData() {
        ListOrderedMap data = this.type == 2 ? dao.getData(this.dataSourceName, "", this.idField, this.nameField, this.tableName, this.query, this.orderSql) : this.data;
        return data;
    }

    public String getOrderSql() {
        return this.orderSql;
    }
}

