/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.table.service.mean;

import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.table.dao.TableDao;
import com.sdjxd.pms.platform.table.model.FieldMeanBean;
import com.sdjxd.pms.platform.table.service.mean.IFieldMean;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldMean
extends BaseObject
implements IFieldMean {
    private static final long serialVersionUID = 1L;
    private static String packName;
    protected String dataSourceName;
    protected static TableDao dao;

    static {
        dao = (TableDao)BeanFactory.getSingleInstance("TableDao");
        packName = FieldMean.class.getPackage().getName();
    }

    public static IFieldMean getInstance(FieldMeanBean bean) {
        IFieldMean mean;
        String type = bean.getType();
        if ("UserDef".equals(type)) {
            String[] assitinfo = (String[])bean.getAssitinfo();
            mean = (IFieldMean)BeanTool.getInstance(assitinfo[0]);
        } else {
            mean = (IFieldMean)BeanTool.getInstance(String.valueOf(packName) + "." + type);
        }
        if (mean == null) {
            mean = new FieldMean();
        }
        mean.init(bean);
        return mean;
    }

    public static IFieldMean getInstance(String meanId) throws Exception {
        return FieldMean.getInstance(dao.getFieldMean(meanId));
    }

    public static IFieldMean[] getFieldMeans(String[] meansId) throws Exception {
        List list = dao.getFieldMeans(meansId);
        IFieldMean[] means = new FieldMean[list.size()];
        int len = list.size();
        int i = 0;
        while (i < len) {
            FieldMeanBean bean = (FieldMeanBean)list.get(i);
            means[i] = FieldMean.getInstance(bean);
            ++i;
        }
        return means;
    }

    public static FieldMeanBean[] getFieldMeansBean(String[] meansId) throws Exception {
        List list = dao.getFieldMeans(meansId);
        FieldMeanBean[] means = new FieldMeanBean[list.size()];
        int len = list.size();
        int i = 0;
        while (i < len) {
            means[i] = (FieldMeanBean)list.get(i);
            ++i;
        }
        return means;
    }

    public static Map getListFieldMean(String listStyleId) {
        List list = dao.getListFieldMean(listStyleId);
        HashMap<String, IFieldMean> means = new HashMap<String, IFieldMean>(list.size());
        int len = list.size();
        int i = 0;
        while (i < len) {
            FieldMeanBean bean = (FieldMeanBean)list.get(i);
            means.put(bean.getId(), FieldMean.getInstance(bean));
            ++i;
        }
        return means;
    }

    public static Map getListFieldMeanDb(String listStyleId) {
        List list = dao.getListFieldMean(listStyleId);
        HashMap<String, FieldMeanBean> means = new HashMap<String, FieldMeanBean>(list.size());
        int nCount = list.size();
        int i = 0;
        while (i < nCount) {
            FieldMeanBean bean = (FieldMeanBean)list.get(i);
            means.put(bean.getId(), bean);
            ++i;
        }
        return means;
    }

    @Override
    public void init(FieldMeanBean bean) {
        this.dataSourceName = bean.getDataSourceName();
        this.id = bean.getId();
        this.name = bean.getName();
    }

    @Override
    public String getText(String value) {
        return value;
    }

    @Override
    public void setCacheIdValue(boolean isCached) {
    }

    public String getJsName() {
        return "fm" + this.id.replaceAll("-", "");
    }
}

