/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.table.service;

import com.sdjxd.pms.platform.base.PlatformLogger;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.DbSession;
import com.sdjxd.pms.platform.table.dao.TableDao;
import com.sdjxd.pms.platform.table.model.TableBean;
import com.sdjxd.pms.platform.table.service.EditGrid;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class Table {
    private static Logger log = Logger.getLogger(Table.class);
    private static TableDao dao = (TableDao)BeanFactory.getSingleInstance("TableDao");
    private String tableName;
    private String tableId;
    private String pkCol;
    private int tableType;
    private String textTable;
    private String dataSourceName;
    private String dataUserName;

    public void init(TableBean bean) {
        this.tableName = bean.getTableName();
        this.textTable = String.valueOf(this.tableName) + "_TEXT";
        this.tableId = bean.getTableId();
        this.pkCol = bean.getPkCol();
        this.dataSourceName = bean.getDataSourceName();
        this.dataUserName = bean.getDataUserName();
        this.tableType = bean.getIsView();
    }

    public void initByName(String tableName) {
        try {
            TableBean bean = Table.getTableByName("defaultds", "[S].", tableName);
            this.init(bean);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initByName(String dataSourceName, String dataUserName, String tableName) {
        try {
            TableBean bean = Table.getTableByName(dataSourceName, dataUserName, tableName);
            this.init(bean);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initById(String m_tableId) {
        try {
            TableBean bean = dao.getTable(m_tableId);
            this.init(bean);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static TableBean getTableByName(String dataSourceName, String dataUserName, String tableName) throws SQLException {
        return TableBean.getTableByName(dataSourceName, dataUserName, tableName);
    }

    public static TableBean getTable(String tableId) throws SQLException {
        return TableBean.getTableById(tableId);
    }

    public static boolean changeOrder(String tableName, String pkCol, String dataId1, String dataId2) throws Exception {
        return dao.changeOrder("defaultds", "[S].", tableName, pkCol, dataId1, dataId2);
    }

    public static boolean changeOrder(String dataSourceName, String dataUserName, String tableName, String pkCol, String dataId1, String dataId2) throws Exception {
        return dao.changeOrder(dataSourceName, dataUserName, tableName, pkCol, dataId1, dataId2);
    }

    public boolean deleteData(String formId) throws Exception {
        boolean isSucc;
        try {
            if (this.getTableType() == 1 || this.getTableType() == 2) {
                StringBuffer fieldData = new StringBuffer();
                StringBuffer data = new StringBuffer();
                fieldData.append("\"").append(this.getPkCol()).append("\"");
                fieldData.append(":");
                fieldData.append("\"").append(formId).append("\"");
                data.append("\"{");
                data.append("\"type\":");
                data.append("\"delete\",");
                data.append("\"data\":");
                data.append("{\"_c\":\"java.util.HashMap\",");
                data.append(fieldData);
                data.append("}");
                data.append("}\"");
                String[] dataList = new String[]{data.toString()};
                isSucc = EditGrid.saveEditGridData(this.dataSourceName, this.dataUserName, this.tableName, this.getPkCol(), 1, dataList);
            } else {
                isSucc = dao.deleteData(this, formId);
            }
            PlatformLogger.log(this.tableName, formId, "\u8868\u6570\u636e", 3);
        }
        catch (Exception exp) {
            boolean isSucc2 = false;
            throw exp;
        }
        return isSucc;
    }

    public static boolean deleteData(String tableName, String formId) throws Exception {
        Table table = new Table();
        table.initByName("defaultds", "[S].", tableName);
        return table.deleteData(formId);
    }

    public static boolean deleteData(String dataSourceName, String dataUserName, String tableName, String formId) throws Exception {
        Table table = new Table();
        table.initByName(dataSourceName, dataUserName, tableName);
        return table.deleteData(formId);
    }

    public static boolean deleteDataWithFilter(String dataSourceName, String dataUserName, String tableName, String wh) throws Exception {
        return dao.deleteFilterData(dataSourceName, dataUserName, tableName, wh);
    }

    public static boolean deleteData(String tableName, String[] formId) throws Exception {
        return Table.deleteData("defaultds", "[S].", tableName, formId, false);
    }

    public static boolean deleteData(String dataSourceName, String dataUserName, String tableName, String[] formId) throws Exception {
        return Table.deleteData(dataSourceName, dataUserName, tableName, formId, false);
    }

    public static boolean deleteData(String dataSourceName, String dataUserName, String tableName, String[] formId, boolean deleteFlow) throws Exception {
        return Table.deleteData(dataSourceName, dataUserName, tableName, formId, deleteFlow, false);
    }

    public static boolean deleteData(String dataSourceName, String dataUserName, String tableName, String[] formId, boolean deleteFlow, boolean deleteChild) throws Exception {
        boolean success = false;
        Table table = new Table();
        table.initByName(dataSourceName, dataUserName, tableName);
        DbSession session = DbOper.openDb(dataSourceName);
        try {
            try {
                if (deleteFlow) {
                    int i = 0;
                    while (i < formId.length) {
                        table.deleteData(formId[i]);
                        FlowInstance.deleteByForm(formId[i]);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < formId.length) {
                        table.deleteData(formId[i]);
                        ++i;
                    }
                }
                if (deleteChild) {
                    dao.deleteChildData(dataSourceName, tableName, formId);
                }
                DbOper.commitDb(session);
                success = true;
            }
            catch (Exception exp) {
                DbOper.rollbackDb(session);
                throw exp;
            }
        }
        finally {
            DbOper.closeDb(session);
        }
        return success;
    }

    public static boolean isExistColumn(String dataSourceName, String dataUserName, String tableName, String columnName) {
        return dao.isExistColumn(dataSourceName, dataUserName, tableName, columnName);
    }

    public String getPkCol() {
        return this.pkCol;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getTableType() {
        return this.tableType;
    }

    public String getTextTable() {
        return this.textTable;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDataUserName() {
        return this.dataUserName == null ? "" : this.dataUserName;
    }

    public boolean hasData(String formId) throws Exception {
        return dao.hasData(this.dataSourceName, this.dataUserName, this.tableName, this.pkCol, formId);
    }
}

