/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.table.model;

import com.sdjxd.pms.platform.cache.Cache;
import com.sdjxd.pms.platform.form.model.Table;
import com.sdjxd.pms.platform.table.dao.TableDao;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.Serializable;
import java.sql.SQLException;

public class TableBean
extends Table
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static TableDao dao = (TableDao)BeanFactory.getSingleInstance("TableDao");
    private static String type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableBean getTableByName(String dataSourceName, String dataUserName, String tableName) throws SQLException {
        String key = String.valueOf(dataSourceName) + "_" + dataUserName + "_" + tableName;
        TableBean tableBean = Cache.getTableByNameCache(key);
        TableBean.setType("tableByName");
        if (tableBean == null) {
            Cache cache = Cache.instance;
            synchronized (cache) {
                tableBean = Cache.getTableByNameCache(key);
                if (tableBean == null) {
                    tableBean = dao.getTableByName(dataSourceName, dataUserName, tableName);
                    Cache.setTableByNameCache(key, tableBean);
                }
            }
        }
        return tableBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableBean getTableById(String tableId) throws SQLException {
        TableBean tableBean = Cache.getTableByIdCache(tableId);
        TableBean.setType("tableById");
        if (tableBean == null) {
            Cache cache = Cache.instance;
            synchronized (cache) {
                tableBean = Cache.getTableByIdCache(tableId);
                if (tableBean == null) {
                    tableBean = dao.getTable(tableId);
                    Cache.setTableByIdCache(tableId, tableBean);
                }
            }
        }
        return tableBean;
    }

    public static String getType() {
        return type;
    }

    public static void setType(String type) {
        TableBean.type = type;
    }
}

