/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.table.dao;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.service.cell.Upload;
import com.sdjxd.pms.platform.table.model.FieldMeanBean;
import com.sdjxd.pms.platform.table.model.TableBean;
import com.sdjxd.pms.platform.table.service.Table;
import com.sdjxd.pms.platform.table.sql.TableSql;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.log4j.Logger;

public class TableDao {
    private static Logger daoLogger = null;

    static {
        daoLogger = Logger.getLogger(TableDao.class);
    }

    public TableSql getSqlHelper(String m_dataSourceName) {
        return (TableSql)BeanFactory.getSqlInstance(TableDao.class, "TableSql", m_dataSourceName);
    }

    public List getListFieldMean(String listStyleId) {
        ArrayList<FieldMeanBean> list = new ArrayList<FieldMeanBean>();
        String sql2 = this.getSqlHelper("defaultds").getListFieldMean(listStyleId);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FieldMeanBean model = new FieldMeanBean();
                model.setId(rs.getString("MEANID"));
                model.setType(rs.getString("MEANTYPE"));
                model.setDataSourceName(rs.getString("DATASOURCENAME"));
                model.setName(rs.getString("MEANNAME"));
                model.setAssitinfo(StringTool.replaceKeyWord(rs.getString("ASSITINFO")));
                model.setModuleId(rs.getString("MODULEID"));
                model.setMulsel(rs.getString("ALLOWMULSEL"));
                list.add(model);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)"\u8bfb\u53d6\u5217\u8868\u663e\u793a\u65b9\u6848\u5bf9\u5e94\u7684\u5c5e\u6027\u542b\u4e49\u9519\u8bef");
        }
        return list;
    }

    public FieldMeanBean getFieldMean(String meanId) throws SQLException {
        FieldMeanBean model = new FieldMeanBean();
        String sql2 = this.getSqlHelper("defaultds").getFieldMean(meanId);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                model.setId(rs.getString("MEANID"));
                model.setType(rs.getString("MEANTYPE"));
                model.setDataSourceName(rs.getString("DATASOURCENAME"));
                model.setName(rs.getString("MEANNAME"));
                model.setAssitinfo(rs.getString("ASSITINFO"));
                model.setModuleId(rs.getString("MODULEID"));
                model.setMulsel(rs.getString("ALLOWMULSEL"));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)"\u8bfb\u53d6\u5c5e\u6027\u542b\u4e49\u9519\u8bef");
            throw e;
        }
        return model;
    }

    public List getFieldMeans(String[] meanIds) throws SQLException {
        ArrayList<FieldMeanBean> list = new ArrayList<FieldMeanBean>();
        String sql2 = this.getSqlHelper("defaultds").getFieldMeans(meanIds);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FieldMeanBean model = new FieldMeanBean();
                model.setId(rs.getString("MEANID"));
                model.setType(rs.getString("MEANTYPE"));
                model.setDataSourceName(rs.getString("DATASOURCENAME"));
                model.setName(rs.getString("MEANNAME"));
                model.setAssitinfo(rs.getString("ASSITINFO"));
                model.setModuleId(rs.getString("MODULEID"));
                model.setMulsel(rs.getString("ALLOWMULSEL"));
                list.add(model);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)"\u8bfb\u53d6\u5c5e\u6027\u542b\u4e49\u9519\u8bef");
            throw e;
        }
        return list;
    }

    public String getNameById(String dataSourceName, String dataUserName, String idField, String nameField, String tableName, String value) {
        return this.getNameById(dataSourceName, dataUserName, idField, nameField, tableName, null, value);
    }

    public String getNameById(String dataSourceName, String dataUserName, String idField, String nameField, String tableName, String query, String value) {
        String text;
        String sql2 = this.getSqlHelper(dataSourceName).getNameById(dataUserName, idField, nameField, tableName, query, value);
        sql2 = StringTool.replaceKeyWord(sql2);
        try {
            Object o = DbOper.executeQueryObject(dataSourceName, sql2);
            text = o == null ? null : String.valueOf(o);
            if (text == null) {
                text = "";
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)"\u6839\u636eid\u503c\u67e5\u8be2\u5bf9\u5e94\u7684\u540d\u79f0\u9519\u8bef");
            text = "";
        }
        return text;
    }

    public Map getData(String dataSourceName, String dataUserName, String idField, String nameField, String tableName, String query) {
        return this.getData(dataSourceName, dataUserName, idField, nameField, tableName, query, null);
    }

    public ListOrderedMap getData(String dataSourceName, String dataUserName, String idField, String nameField, String tableName, String query, String orderSql) {
        String sql2 = this.getSqlHelper(dataSourceName).getData(dataUserName, idField, nameField, tableName, query, orderSql);
        sql2 = StringTool.replaceKeyWord(sql2);
        ListOrderedMap data = new ListOrderedMap();
        try {
            RowSet rs = DbOper.executeQuery(dataSourceName, sql2);
            while (rs.next()) {
                data.put((Object)rs.getString("IDFIELD"), (Object)rs.getString("NAMEFIELD"));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)"\u8bfb\u53d6\u6570\u636e\u96c6\u9519\u8bef");
        }
        return data;
    }

    public TableBean getTable(String tableId) {
        String sql2 = this.getSqlHelper("defaultds").getTable(tableId);
        TableBean table = null;
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                table = new TableBean();
                table.setTableId(rs.getString("TABLEID"));
                table.setTableName(rs.getString("TABLENAME"));
                table.setDataSourceName(rs.getString("DATASOURCENAME"));
                table.setDataUserName(rs.getString("DATAUSERNAME"));
                table.setTableMsg(rs.getString("TABLEMSG"));
                table.setModuleId(rs.getString("MODULEID"));
                table.setTableType(rs.getInt("TABLETYPE"));
                table.setTableNotes(rs.getString("TABLENOTES"));
                table.setDataType(rs.getInt("DATATYPE"));
                table.setShowNameCol(rs.getString("SHOWNAMECOL"));
                table.setPkCol(rs.getString("PKCOL"));
                table.setPicPath(rs.getString("PICPATH"));
                table.setIsView(rs.getInt("ISVIEW"));
            } else {
                daoLogger.error((Object)("getTable(String tableId)\u62a5\u9519\uff1a\u672a\u627e\u5230\u6307\u5b9aid\u7684table:" + tableId));
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)("getTable(String tableId)\u62a5\u9519\uff1a" + e.getMessage()));
        }
        return table;
    }

    public TableBean getTableByName(String dataSourceName, String dataUserName, String tableName) throws SQLException {
        String sql2 = this.getSqlHelper("defaultds").getTableByName(dataSourceName, dataUserName, tableName);
        TableBean table = null;
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                table = new TableBean();
                table.setTableId(rs.getString("TABLEID"));
                table.setTableName(rs.getString("TABLENAME"));
                table.setDataSourceName(rs.getString("DATASOURCENAME"));
                table.setDataUserName(rs.getString("DATAUSERNAME"));
                table.setTableMsg(rs.getString("TABLEMSG"));
                table.setModuleId(rs.getString("MODULEID"));
                table.setTableType(rs.getInt("TABLETYPE"));
                table.setTableNotes(rs.getString("TABLENOTES"));
                table.setDataType(rs.getInt("DATATYPE"));
                table.setShowNameCol(rs.getString("SHOWNAMECOL"));
                table.setPkCol(rs.getString("PKCOL"));
                table.setPicPath(rs.getString("PICPATH"));
                table.setIsView(rs.getInt("ISVIEW"));
            } else {
                daoLogger.error((Object)("\u6839\u636e\u8868\u540d\u67e5\u627e\u8868\u57fa\u672c\u5c5e\u6027\u62a5\u9519\uff1a\u672a\u627e\u5230\u6307\u5b9a\u8868\u7684\u5c5e\u6027:" + tableName));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u6839\u636e\u8868\u540d\u67e5\u627e\u8868\u57fa\u672c\u5c5e\u6027\u62a5\u9519\uff1a" + e.getMessage()));
            throw e;
        }
        return table;
    }

    public boolean deleteData(Table table, String formId) throws SQLException {
        boolean isSuc = false;
        String pkCol = table.getPkCol();
        String textTable = table.getTextTable();
        this.deleteData(table.getDataSourceName(), table.getDataUserName(), table.getTableName(), pkCol, formId);
        if (this.isExist(table.getDataSourceName(), table.getDataUserName(), textTable)) {
            this.deleteData(table.getDataSourceName(), table.getDataUserName(), textTable, "SHEETID", formId);
        }
        Upload.deleteFile(formId);
        isSuc = true;
        return isSuc;
    }

    public boolean deleteFilterData(String dataSourceName, String dataUserName, String tableName, String wh) throws SQLException {
        boolean isSuc = false;
        String sql2 = this.getSqlHelper(dataSourceName).deleteFilterData(dataUserName, tableName, wh);
        try {
            DbOper.executeNonQuery(dataSourceName, sql2);
            isSuc = true;
        }
        catch (Exception e) {
            daoLogger.error((Object)e.getMessage());
        }
        return isSuc;
    }

    public boolean deleteData(String dataSourceName, String dataUserName, String tableName, String pkCol, String formId) throws SQLException {
        boolean isSuc = false;
        String sql2 = this.getSqlHelper(dataSourceName).deleteData(dataUserName, tableName, pkCol, formId);
        try {
            DbOper.executeNonQuery(dataSourceName, sql2);
            isSuc = true;
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5220\u9664\u8868\u5355\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage()));
            throw e;
        }
        return isSuc;
    }

    public boolean deleteChildData(String dataSourceName, String parentTableName, String[] formId) throws Exception {
        if (formId == null || formId.length == 0) {
            return true;
        }
        String sql2 = this.getSqlHelper("defaultds").getChildTable(parentTableName);
        String[] childTableIdSql = new String[1];
        String formIds = "(";
        if (formId.length == 1 && formId[0].startsWith("select ")) {
            formIds = String.valueOf(formIds) + formId[0];
        } else {
            int i = 0;
            while (i < formId.length) {
                if (i > 0) {
                    formIds = String.valueOf(formIds) + ",";
                }
                formIds = String.valueOf(formIds) + "'";
                formIds = String.valueOf(formIds) + formId[i];
                formIds = String.valueOf(formIds) + "'";
                ++i;
            }
        }
        formIds = String.valueOf(formIds) + ")";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                if (rs.getInt("ISVIEW") > 0) continue;
                String childTableName = rs.getString("TABLENAME");
                childTableIdSql[0] = "select " + rs.getString("PKCOL") + " from " + rs.getString("DATAUSERNAME") + childTableName + " where " + rs.getString("LINKCOLUMNID") + " in " + formIds;
                String countSql = "SELECT COUNT(1) FROM " + rs.getString("DATAUSERNAME") + childTableName + " WHERE " + rs.getString("LINKCOLUMNID") + " IN " + formIds;
                Object count = DbOper.executeQueryObject(rs.getString("DATASOURCENAME"), countSql);
                if (count instanceof Integer && (Integer)count > 0) {
                    this.deleteChildData(rs.getString("DATASOURCENAME"), childTableName, childTableIdSql);
                }
                try {
                    DbOper.executeNonQuery(rs.getString("DATASOURCENAME"), this.getSqlHelper(rs.getString("DATASOURCENAME")).deleteFilterData(rs.getString("DATAUSERNAME"), childTableName, String.valueOf(rs.getString("LINKCOLUMNID")) + " in " + formIds));
                }
                catch (SQLException e) {
                    daoLogger.error((Object)("sql\u8bed\u53e5\u6267\u884c\u5931\u8d25:" + e.getMessage()));
                    e.printStackTrace();
                    throw e;
                }
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("sql\u8bed\u53e5\u6267\u884c\u5931\u8d25\uff1a" + sql2));
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    public boolean isExist(String dataSourceName, String dataUserName, String tableName) {
        return DbOper.isExist(dataSourceName, dataUserName, tableName);
    }

    public boolean isExistColumn(String dataSourceName, String dataUserName, String tableName, String columnName) {
        String sql2 = this.getSqlHelper("defaultds").getColumnInfo(dataSourceName, dataUserName, tableName, columnName);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            return rs.next();
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return false;
        }
    }

    public boolean changeOrder(String tableName, String pkCol, String dataId1, String dataId2) throws Exception {
        return this.changeOrder("defaultds", "[S].", tableName, pkCol, dataId1, dataId2);
    }

    public boolean changeOrder(String dataSourceName, String dataUserName, String tableName, String pkCol, String dataId1, String dataId2) throws Exception {
        boolean isSuc = false;
        String sql2 = this.getSqlHelper(dataSourceName).getShowOrder(dataUserName, tableName, pkCol, dataId1, dataId2);
        int showOrder1 = -1;
        int showOrder2 = -1;
        try {
            RowSet rs = DbOper.executeQuery(dataSourceName, sql2);
            while (rs.next()) {
                if (rs.getString(pkCol).equals(dataId1)) {
                    showOrder1 = rs.getInt("SHOWORDER");
                    continue;
                }
                showOrder2 = rs.getInt("SHOWORDER");
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)"\u8bfb\u53d6\u6570\u636e\u7684\u663e\u793a\u987a\u5e8f\u5931\u8d25");
            throw e;
        }
        String[] sqlArray = new String[]{this.getSqlHelper(dataSourceName).updateData(dataUserName, tableName, pkCol, dataId1, "SHOWORDER", showOrder2), this.getSqlHelper(dataSourceName).updateData(dataUserName, tableName, pkCol, dataId2, "SHOWORDER", showOrder1)};
        try {
            DbOper.executeNonQuery(dataSourceName, sqlArray);
            isSuc = true;
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u6539\u53d8\u6570\u636e\u7684\u663e\u793a\u987a\u5e8f\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage()));
            throw e;
        }
        return isSuc;
    }

    public boolean hasData(String dataSourceName, String dataUserName, String tableName, String pkCol, String formId) throws Exception {
        boolean isSuc = false;
        String sql2 = this.getSqlHelper(dataSourceName).queryData(dataUserName, tableName, pkCol, formId);
        try {
            RowSet rowset = DbOper.executeQuery(dataSourceName, sql2);
            if (rowset.next()) {
                isSuc = true;
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u67e5\u8be2\u8868\u5355\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage()));
            throw e;
        }
        return isSuc;
    }
}

