/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.table.dao;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.model.Table;
import com.sdjxd.pms.platform.table.dao.EditGridRowDao;
import com.sdjxd.pms.platform.table.sql.EditGridSql;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class EditGridDao {
    private static Logger daoLogger = Logger.getLogger((String)"EditGridDao");
    private String tableName = "";
    private String dataSourceName = "";
    private String dataUserName = "";
    private String pkCol = "";
    private int isView = 0;
    private EditGridRowDao[] rowInfo;

    public EditGridDao() {
    }

    public EditGridSql getSqlHelper(String dataSourceName) {
        return (EditGridSql)BeanFactory.getSqlInstance(EditGridDao.class, "EditGridSql", dataSourceName);
    }

    public EditGridDao(String h_dataSourceName, String h_dataUserName, String h_tableName, String h_pkCol, int h_isView, String[] h_arrInfo) throws Exception {
        this();
        this.tableName = h_tableName;
        this.dataSourceName = h_dataSourceName;
        this.dataUserName = h_dataUserName;
        this.pkCol = h_pkCol;
        this.isView = h_isView;
        this.initRowInfo(h_arrInfo);
    }

    public boolean saveRowInfo() throws Exception {
        List arrSql = null;
        arrSql = 1 == this.isView ? this.getViewDataSql() : this.getTableDataSql();
        if (arrSql == null || arrSql.isEmpty()) {
            return false;
        }
        try {
            DbOper.executeNonQuery(this.dataSourceName, arrSql);
        }
        catch (SQLException e) {
            StringBuffer logError = new StringBuffer(256);
            logError.append("\u4fdd\u5b58\u53ef\u7f16\u8f91\u5217\u8868\u6570\u636e\u5931\u8d25, \u9519\u8bef\u4e3a:");
            logError.append(e.getMessage());
            daoLogger.error((Object)logError);
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    private boolean initRowInfo(String[] h_arrInfo) {
        int nCount = h_arrInfo.length;
        this.rowInfo = new EditGridRowDao[nCount];
        int i = 0;
        while (i < nCount) {
            String info = h_arrInfo[i];
            info = info.substring(2, info.length() - 1);
            String str = "{\"_c\":\"com.sdjxd.pms.platform.table.dao.EditGridRowDao\",";
            str = String.valueOf(str) + info;
            this.rowInfo[i] = (EditGridRowDao)BeanTool.parse(str);
            this.rowInfo[i].setPkCol(this.pkCol);
            this.rowInfo[i].setTableName(this.tableName);
            this.rowInfo[i].setDataSourceName(this.dataSourceName);
            this.rowInfo[i].setDataUserName(this.dataUserName);
            ++i;
        }
        return true;
    }

    public List getTableDataSql() {
        ArrayList<String> arrSql = null;
        TreeMap field = this.getTableFieldInfo(this.dataSourceName, this.dataUserName, this.tableName, null);
        if (field == null) {
            return null;
        }
        arrSql = new ArrayList<String>();
        int nCount = this.rowInfo.length;
        int i = 0;
        while (i < nCount) {
            arrSql.add(this.rowInfo[i].getTableDataSql(field));
            ++i;
        }
        return arrSql;
    }

    public List getViewDataSql() {
        ArrayList arrSql = null;
        Object[] jsonFieldInfo = null;
        String jsonCondition = "";
        TreeMap<String, Table> tableInfo = null;
        try {
            String sql2 = this.getSqlHelper("defaultds").getViewInfo(this.dataSourceName, this.dataUserName, this.tableName);
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs != null && rs.next()) {
                String fieldInfo = rs.getString("VIEWFIELDINFO");
                jsonCondition = rs.getString("VIEWCONDITION");
                jsonFieldInfo = StringTool.strToArray(fieldInfo);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
            return null;
        }
        if (jsonFieldInfo == null) {
            return null;
        }
        tableInfo = new TreeMap<String, Table>();
        int i = 0;
        while (i < jsonFieldInfo.length) {
            String oneTableId = (String)((Object[])jsonFieldInfo[i])[0];
            Table oneTaleInfo = this.getTableInfo(oneTableId);
            if (oneTaleInfo != null) {
                tableInfo.put(oneTableId, oneTaleInfo);
            }
            ++i;
        }
        arrSql = new ArrayList();
        int nCount = this.rowInfo.length;
        int i2 = 0;
        while (i2 < nCount) {
            List sqlItem = this.rowInfo[i2].getViewDataSql(jsonFieldInfo, jsonCondition, tableInfo);
            if (sqlItem != null && !sqlItem.isEmpty()) {
                int j = 0;
                while (j < sqlItem.size()) {
                    arrSql.add(sqlItem.get(j));
                    ++j;
                }
            }
            ++i2;
        }
        return arrSql;
    }

    public Table getTableInfo(String h_tableID) {
        Table oneTableInfo = new Table();
        TreeMap tableFieldInfo = this.getTableFieldInfo(null, null, "", h_tableID);
        if (tableFieldInfo == null) {
            return null;
        }
        oneTableInfo.setFields(tableFieldInfo);
        String sql2 = this.getSqlHelper("defaultds").getTableInfoSql(h_tableID);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                oneTableInfo.setTableId(h_tableID);
                oneTableInfo.setPkCol(rs.getString("PKCOL"));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u4fee\u6539\u53ef\u7f16\u8f91\u5217\u8868\u6570\u636e, \u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
            return null;
        }
        return oneTableInfo;
    }

    public TreeMap getTableFieldInfo(String h_dataSourceName, String h_dataUserName, String h_tableName, String h_tableID) {
        TreeMap<String, String> field = new TreeMap<String, String>();
        String sql2 = "";
        if (h_tableName != null && !"".equals(h_tableName)) {
            sql2 = this.getSqlHelper("defaultds").getFieldSqlWithTableName(h_dataSourceName, h_dataUserName, h_tableName);
        } else if (h_tableID != null && !"".equals(h_tableID)) {
            sql2 = this.getSqlHelper("defaultds").getFieldSqlWithTableId(h_tableID);
        } else {
            return null;
        }
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                String onefield = rs.getString("COLUMNID");
                String fieldType = rs.getString("COLUMNTYPE");
                String meanId = rs.getString("COLMEANID");
                fieldType = fieldType != null && (fieldType.equalsIgnoreCase("INTEGER") || fieldType.equalsIgnoreCase("int") || fieldType.equalsIgnoreCase("DECIMAL") || fieldType.equalsIgnoreCase("float") || fieldType.equalsIgnoreCase("double") || fieldType.equalsIgnoreCase("SMALLINT") || fieldType.equalsIgnoreCase("BIGINT")) ? "1" : "0";
                if (meanId != null && meanId.equals("679B51F7-46CB-4DE3-AFAA-DBEE665F135E")) {
                    fieldType = "2";
                }
                field.put(onefield, fieldType);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u4fee\u6539\u53ef\u7f16\u8f91\u5217\u8868\u6570\u636e, \u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
            return null;
        }
        return field;
    }

    public TreeMap getTableOneFieldInfo(String tableId, String columnId) {
        TreeMap<String, String> info = new TreeMap<String, String>();
        String sql2 = this.getSqlHelper("defaultds").getTableFieldInfoSql(tableId, columnId);
        try {
            RowSet rs = DbOper.executeQuery(sql2);
            if (rs.next()) {
                info.put("COLUMNNAME", rs.getString("COLUMNNAME"));
                info.put("COLUMNLENGTH", String.valueOf(rs.getInt("COLUMNLENGTH")));
                info.put("COLUMNTYPE", rs.getString("COLUMNTYPE"));
                info.put("ALLOWNULL", String.valueOf(rs.getInt("ALLOWNULL")));
                info.put("ISPRIMARY", String.valueOf(rs.getInt("ISPRIMARY")));
                info.put("COLUMNDEFAULT", rs.getString("COLUMNDEFAULT"));
                info.put("ISRESERVED", String.valueOf(rs.getInt("ISRESERVED")));
                info.put("DATASTATUS", String.valueOf(rs.getInt("DATASTATUS")));
                info.put("DATATYPE", String.valueOf(rs.getInt("DATATYPE")));
                info.put("COLMEANID", rs.getString("COLMEANID"));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            e.printStackTrace();
            return null;
        }
        return info;
    }
}

