/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.serviceBreak.dao;

import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.model.ActionBean;
import com.sdjxd.pms.platform.form.model.ActionParamBean;
import com.sdjxd.pms.platform.form.service.Action;
import com.sdjxd.pms.platform.form.service.ActionParam;
import com.sdjxd.pms.platform.serviceBreak.ScriptFile;
import com.sdjxd.pms.platform.serviceBreak.model.ScriptBean;
import com.sdjxd.pms.platform.serviceBreak.sql.ServiceBreakSql;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class ServiceBreakDao {
    private static Logger log = Logger.getLogger(ServiceBreakDao.class);
    private ServiceBreakSql sqlHelper;

    public ServiceBreakDao() {
        if (this.sqlHelper == null) {
            this.sqlHelper = (ServiceBreakSql)BeanFactory.getSqlInstance(this.getClass(), "ServiceBreakSql", "defaultds");
        }
    }

    public boolean saveDepend(ScriptFile file) throws SQLException {
        String[] sqlText = new String[2];
        sqlText[0] = this.sqlHelper.delDepends(file);
        StringBuffer dependsPath = new StringBuffer(256);
        Map depends = file.getDependsFile();
        if (depends.size() > 0) {
            for (String path : depends.keySet()) {
                dependsPath.append(",'").append(path).append("'");
            }
            sqlText[1] = this.sqlHelper.addDepends(file, dependsPath.substring(1));
        }
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
            return true;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
    }

    public Map getScriptFileList(String path) throws SQLException {
        String sqlText = this.sqlHelper.getScriptFileList(path);
        HashMap<String, ScriptBean> scriptFiles = new HashMap<String, ScriptBean>();
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sqlText);
            while (rs.next()) {
                ScriptBean bean = new ScriptBean();
                bean.setId(rs.getString("SID"));
                bean.setName(rs.getString("SNAME"));
                bean.setPath(rs.getString("FILEPATH"));
                bean.setPackageName(rs.getString("PACKAGENAME"));
                bean.setSortBy(rs.getInt("SORTBY"));
                bean.setModuleId(rs.getString("MODULEID"));
                bean.setDataStatusId(rs.getInt("DATASTATUSID"));
                scriptFiles.put(bean.getPath(), bean);
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
        return scriptFiles;
    }

    public boolean addScriptFile(ScriptFile model) throws SQLException {
        boolean isSuccess = false;
        String sqlText = this.sqlHelper.addScriptFile(model);
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
            isSuccess = true;
        }
        catch (SQLException e) {
            isSuccess = false;
            log.error((Object)e.getMessage());
            throw e;
        }
        return isSuccess;
    }

    public boolean updateScriptFile(ScriptFile model) throws SQLException {
        boolean isSuccess = false;
        String sqlText = this.sqlHelper.updateScriptFile(model);
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
            isSuccess = true;
        }
        catch (SQLException e) {
            isSuccess = false;
            log.error((Object)e.getMessage());
            throw e;
        }
        return isSuccess;
    }

    public boolean saveScriptFile(Map files) throws SQLException {
        boolean isSuccess = false;
        String[] sqls = new String[files.size()];
        int index = 0;
        for (Map.Entry entry : files.entrySet()) {
            ScriptFile file = (ScriptFile)entry.getValue();
            sqls[index++] = file.getModify().is(DataModify.SAVED) ? this.sqlHelper.updateScriptFile(file) : this.sqlHelper.addScriptFile(file);
        }
        try {
            DbOper.executeNonQuery("defaultds", sqls);
            isSuccess = true;
        }
        catch (SQLException e) {
            isSuccess = false;
            log.error((Object)e.getMessage());
            throw e;
        }
        return isSuccess;
    }

    public boolean isExist() {
        return true;
    }

    public Map getDepend(ScriptFile file) throws SQLException {
        HashMap<String, ScriptBean> depends = new HashMap<String, ScriptBean>();
        String sqlText = this.sqlHelper.getDepend(file);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sqlText);
            while (rs.next()) {
                ScriptBean bean = new ScriptBean();
                bean.setId(rs.getString("SID"));
                bean.setName(rs.getString("SNAME"));
                bean.setPath(rs.getString("FILEPATH"));
                bean.setPackageName(rs.getString("PACKAGENAME"));
                bean.setSortBy(rs.getInt("SORTBY"));
                bean.setModuleId(rs.getString("MODULEID"));
                bean.setDataStatusId(rs.getInt("DATASTATUSID"));
                depends.put(bean.getPath(), bean);
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
        return depends;
    }

    public Map getAction(ScriptFile file) throws SQLException {
        HashMap<String, ActionBean> actions = new HashMap<String, ActionBean>();
        String sqlText = this.sqlHelper.getActions(file);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sqlText);
            while (rs.next()) {
                ActionBean bean = new ActionBean();
                bean.setId(rs.getString("ACTIONID"));
                bean.setName(rs.getString("ACTIONNAME"));
                bean.setCode(rs.getString("ACTIONCODE"));
                bean.setDataStatusId(rs.getInt("DATASTATUSID"));
                bean.setDataType(rs.getInt("DATATYPE"));
                bean.setSid(rs.getString("SID"));
                actions.put(bean.getCode(), bean);
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
        return actions;
    }

    public void addAction(Action action) throws SQLException {
        String sqlText = this.sqlHelper.addAction(action);
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
    }

    public void updateAction(Action action) throws SQLException {
        String sqlText = this.sqlHelper.updateAction(action);
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
    }

    public List getParam(ScriptFile file) throws SQLException {
        ArrayList<ActionParamBean> params = new ArrayList<ActionParamBean>();
        String sqlText = this.sqlHelper.getParam(file);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sqlText);
            while (rs.next()) {
                ActionParamBean bean = new ActionParamBean();
                bean.setActionId(rs.getString("ACTIONID"));
                bean.setParamName(rs.getString("PARAMNAME"));
                bean.setParamType(rs.getInt("PARAMTYPEID"));
                bean.setParamOrder(rs.getInt("PARAMORDER"));
                bean.setDataType(rs.getInt("DATATYPE"));
                bean.setDescription(rs.getString("PARAMDESCRIPTION"));
                params.add(bean);
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
        return params;
    }

    public void delParam(ActionParam param) throws SQLException {
        String sqlText = this.sqlHelper.updateParam(param);
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
    }

    public void addParam(ActionParam param) throws SQLException {
        String sqlText = this.sqlHelper.addParam(param);
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
    }

    public void updateParam(ActionParam param) throws SQLException {
        String sqlText = this.sqlHelper.updateParam(param);
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
    }

    public String getModuleByPath(String path) throws SQLException {
        String moduleId;
        String sqlText = this.sqlHelper.getModuleByPath(path);
        try {
            moduleId = (String)DbOper.executeQueryObject("defaultds", sqlText);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
        return moduleId;
    }
}

