/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.serviceBreak;

import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.base.DataStatus;
import com.sdjxd.pms.platform.base.DataType;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.service.Action;
import com.sdjxd.pms.platform.form.service.ActionParam;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.serviceBreak.ScriptFile;
import com.sdjxd.pms.platform.serviceBreak.dao.ServiceBreakDao;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.FileOperate;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ScriptScan {
    private static ServiceBreakDao dao;
    private static Logger log;
    private Map deny = new HashMap();
    private String moduleId;
    private Map scriptFiles;
    private List fileList;

    static {
        log = Logger.getLogger(ScriptScan.class);
        dao = (ServiceBreakDao)BeanFactory.getSingleInstance("ServiceBreakDao");
    }

    public ScriptScan(String path) throws Exception {
        String[] denyArray = Global.getConfig("script.deny").split(";");
        int i = 0;
        while (i < denyArray.length) {
            this.deny.put(denyArray[i], denyArray[i]);
            ++i;
        }
        this.moduleId = dao.getModuleByPath(path);
        this.fileList = FileOperate.getFile(String.valueOf(Global.getPath()) + path, ".js");
        this.scriptFiles = ScriptFile.getScriptFileList(path);
    }

    public static boolean scanPath(String path) throws Exception {
        ScriptScan scan = new ScriptScan(path);
        scan.scan();
        return true;
    }

    public void scan() throws Exception {
        int j = 0;
        while (j < this.fileList.size()) {
            File file = (File)this.fileList.get(j);
            if (!this.deny.containsKey(file.getPath())) {
                this.scanFile(file);
            }
            ++j;
        }
        ScriptFile.save(this.scriptFiles);
    }

    private void scanFile(File file) throws Exception {
        ScriptFile scriptFile;
        String fileName = null;
        String filePath = file.getPath().substring(Global.getPath().length() - 1).replaceAll("\\\\", "/");
        if (this.scriptFiles.containsKey(filePath)) {
            scriptFile = (ScriptFile)this.scriptFiles.get(filePath);
        } else {
            scriptFile = new ScriptFile();
            scriptFile.setPath(filePath);
            scriptFile.setId(Guid.create());
            scriptFile.setCreateDate(DateTool.getNow());
            scriptFile.setCreateUserId(User.getCurrentUser().getId());
            scriptFile.setSortBy(-1);
            scriptFile.setModify(DataModify.NEW);
            scriptFile.setModuleId(this.moduleId);
            if (!filePath.startsWith("/pms")) {
                scriptFile.setDataType(DataType.NORMAL.getId());
            } else if (filePath.startsWith("/pms/platform")) {
                scriptFile.setDataType(DataType.SYSTEM.getId());
            } else {
                scriptFile.setDataType(DataType.BUSINESS.getId());
            }
            this.scriptFiles.put(filePath, scriptFile);
        }
        scriptFile.setDataStatusId(DataStatus.NORMAL.getId());
        Action action = null;
        int docStatus = 0;
        try {
            String str;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferReader = new BufferedReader(fileReader);
            while ((str = bufferReader.readLine()) != null) {
                String temp;
                if (str.trim().equals("/**")) {
                    docStatus = 1;
                    action = null;
                } else if (str.trim().equals("*/")) {
                    docStatus = 3;
                    if (action != null && action.getCode().length() != 0) {
                        scriptFile.addAction(action);
                        action = null;
                    }
                } else if (docStatus == 3) {
                    docStatus = 0;
                    if (docStatus == 0 && (temp = StringTool.match(str, "^[ \\t]*\\$import\\(\\\"(.*)\\\"\\)[; \\t]*$")).length() != 0) {
                        if (temp.indexOf("/") > 0) {
                            scriptFile.addDepend(temp);
                        } else if (temp.startsWith("com.sdjxd")) {
                            scriptFile.addDepend(String.valueOf(temp.substring("com.sdjxd".length()).replaceAll("\\.", "/")) + ".js");
                        }
                    }
                } else if (docStatus == 1) {
                    docStatus = 2;
                }
                if (docStatus != 2 || (temp = StringTool.match(str, "\\*[ \\t](.*)")).trim().length() == 0) continue;
                if (temp.startsWith("@class")) {
                    fileName = temp.substring(6).trim();
                    scriptFile.setName(fileName);
                    continue;
                }
                if (temp.startsWith("@method")) {
                    if (action == null) {
                        action = new Action();
                    }
                    action.setCode(temp.substring(7).trim());
                    continue;
                }
                if (temp.startsWith("@param")) {
                    if (action == null) {
                        action = new Action();
                    }
                    ActionParam param = new ActionParam();
                    temp = temp.substring(6).trim();
                    String[] keyValue = temp.split(" ");
                    if (!"".equals(temp = StringTool.match(keyValue[0].trim(), "\\{(.*)\\}"))) {
                        param.setType(ActionParam.getParamType(temp));
                        if (keyValue.length > 2) {
                            param.setName(keyValue[2].trim());
                        }
                    } else {
                        param.setType(ActionParam.getParamType(""));
                        if (keyValue.length > 1) {
                            param.setName(keyValue[1].trim());
                        }
                    }
                    param.setModify(DataModify.NEW);
                    action.addParam(param);
                    continue;
                }
                if (temp.startsWith("@")) continue;
                if (action == null) {
                    action = new Action();
                }
                action.setName(temp.trim());
            }
            fileReader.close();
            bufferReader.close();
        }
        catch (IOException exp) {
            log.error((Object)exp);
        }
    }
}

