/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.serviceBreak;

import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.base.DataStatus;
import com.sdjxd.pms.platform.base.DataType;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.DbSession;
import com.sdjxd.pms.platform.form.model.ActionBean;
import com.sdjxd.pms.platform.form.model.ActionParamBean;
import com.sdjxd.pms.platform.form.service.Action;
import com.sdjxd.pms.platform.form.service.ActionParam;
import com.sdjxd.pms.platform.serviceBreak.dao.ServiceBreakDao;
import com.sdjxd.pms.platform.serviceBreak.model.ScriptBean;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScriptFile {
    private static ServiceBreakDao dao = (ServiceBreakDao)BeanFactory.getSingleInstance("ServiceBreakDao");
    private String id;
    private String path;
    private String name;
    private Map dependsFile;
    private Map actions;
    private String packageName;
    private int sortBy;
    private String moduleId;
    private int dataStatusId = DataStatus.NORMAL.getId();
    private int dataType = DataType.NORMAL.getId();
    private DataModify modify = DataModify.SAVED;
    private String createDate;
    private String createUserId;

    public ScriptFile() {
        this.dependsFile = new HashMap();
        this.actions = new HashMap();
    }

    public static Map getScriptFileList(String path) throws Exception {
        Map models = dao.getScriptFileList(path);
        HashMap files = new HashMap();
        for (Map.Entry entry : models.entrySet()) {
            ScriptBean model = (ScriptBean)entry.getValue();
            ScriptFile file = new ScriptFile();
            file.init(model);
            file.setDataStatusId(DataStatus.DELETE.getId());
            files.put(entry.getKey(), file);
        }
        return files;
    }

    public void save() throws Exception {
        if (this.modify.is(DataModify.NEW)) {
            dao.addScriptFile(this);
        } else {
            dao.updateScriptFile(this);
        }
    }

    public void addDepend(ScriptFile file) {
        this.dependsFile.put(file.getPath(), file);
    }

    public void addDepend(String filePath) {
        ScriptFile file = new ScriptFile();
        file.setPath(filePath);
        this.addDepend(file);
    }

    public void addAction(Action action) {
        String code = action.getCode();
        if (!this.actions.containsKey(code)) {
            action.setModify(DataModify.NEW);
            action.setId(Guid.create());
            action.setSid(this.id);
            action.setDataType(DataType.getInstance(this.dataType));
            this.actions.put(code, action);
        } else {
            Action oldAction = (Action)this.actions.get(code);
            oldAction.setName(action.getName());
            action.setModify(DataModify.MODIFY);
        }
        action.setDataStatus(DataStatus.NORMAL);
    }

    public static boolean save(Map files) throws Exception {
        DbSession session = DbOper.openDb("defaultds");
        try {
            try {
                dao.saveScriptFile(files);
                for (Map.Entry entry2 : files.entrySet()) {
                    ScriptFile file = (ScriptFile)entry2.getValue();
                    if (!file.getModify().is(DataModify.NEW)) continue;
                    dao.saveDepend(file);
                    for (Map.Entry entry2 : file.getActions().entrySet()) {
                        Action action = (Action)entry2.getValue();
                        action.save();
                    }
                }
                DbOper.commitDb(session);
            }
            catch (Exception exp) {
                DbOper.rollbackDb(session);
                throw exp;
            }
        }
        finally {
            DbOper.closeDb(session);
        }
        return true;
    }

    public void init(ScriptBean model) throws SQLException {
        Action action;
        this.setId(model.getId());
        this.setName(model.getName());
        this.setCreateDate(model.getCreateDate());
        this.setCreateUserId(model.getCreateUserId());
        this.setDataStatusId(model.getDataStatusId());
        this.setDataType(model.getDataType());
        this.setModuleId(model.getModuleId());
        this.setPackageName(model.getPackageName());
        this.setPath(model.getPath());
        this.setSortBy(model.getSortBy());
        this.setModify(DataModify.SAVED);
        Map models = dao.getAction(this);
        for (Map.Entry entry : models.entrySet()) {
            ActionBean actoinModel = (ActionBean)entry.getValue();
            action = new Action();
            action.setData(actoinModel);
            action.setDataStatus(DataStatus.DELETE);
            this.actions.put(action.getCode(), action);
        }
        List paramModels = dao.getParam(this);
        for (ActionParamBean paramModel : paramModels) {
            ActionParam param = new ActionParam();
            param.setData(paramModel);
            param.setDataStatus(DataStatus.DELETE);
            action = (Action)this.actions.get(param.getActionId());
            if (action == null) continue;
            action.addParam(param);
        }
    }

    public Action getAction(String code) {
        Action action;
        if (this.actions.containsKey(code)) {
            action = (Action)this.actions.get(code);
        } else {
            action = new Action();
            action.setCode(code);
            action.setSid(this.id);
            this.actions.put(code, action);
        }
        return action;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getCreateUserId() {
        return this.createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public int getDataStatusId() {
        return this.dataStatusId;
    }

    public void setDataStatusId(int dataStatusId) {
        this.dataStatusId = dataStatusId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        if (this.packageName == null) {
            return "";
        }
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(int sortBy) {
        this.sortBy = sortBy;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public DataModify getModify() {
        return this.modify;
    }

    public void setModify(DataModify modify) {
        this.modify = modify;
    }

    public Map getActions() {
        return this.actions;
    }

    public Map getDependsFile() {
        return this.dependsFile;
    }
}

