/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.security.service;

import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.cache.Cache;
import com.sdjxd.pms.platform.cacheMonitor.service.CacheMonitor;
import com.sdjxd.pms.platform.security.dao.SecurityDao;
import com.sdjxd.pms.platform.security.model.WhitRuleList;
import com.sdjxd.pms.platform.security.model.WhiteBean;
import com.sdjxd.pms.platform.security.model.WhiteList;
import com.sdjxd.pms.platform.security.model.WhiteRuleBean;
import com.sdjxd.pms.platform.tool.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityService {
    protected static SecurityDao dao;
    private static Map<String, List<WhiteRuleBean>> whiteRuleMap;
    private static Map<String, List<WhiteBean>> whiteMap;

    static {
        whiteRuleMap = new HashMap<String, List<WhiteRuleBean>>();
        whiteMap = new HashMap<String, List<WhiteBean>>();
        try {
            dao = (SecurityDao)Factory.getDao(SecurityDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<WhiteBean> getWhiteByKey(String key) {
        List<Object> value = new ArrayList();
        if (!Global.isDebug()) {
            WhiteList whiteList = Cache.getWhiteListCache(key);
            if (whiteList == null) {
                Cache cache = Cache.instance;
                synchronized (cache) {
                    whiteList = Cache.getWhiteListCache(key);
                    if (whiteList == null) {
                        whiteList = new WhiteList();
                        value = dao.getWhiteByKey(key);
                        if (value != null && value.size() > 0) {
                            whiteList.setWhiteListCache(value);
                            Cache.setWhiteListCache(key, whiteList);
                        }
                    } else {
                        value = whiteList.getWhiteListCache();
                    }
                }
            } else {
                value = whiteList.getWhiteListCache();
            }
        } else {
            value = whiteMap.get(key);
            if (value == null && (value = dao.getWhiteByKey(key)) != null && value.size() > 0) {
                whiteMap.put(key, value);
            }
        }
        return value;
    }

    public static void removeWhiteByKey(String key) {
        if (!Global.isDebug()) {
            Cache.getWhiteListCache().clear();
            CacheMonitor.cacheDetailMap.remove("whiteList");
        } else {
            whiteMap.remove(key);
        }
    }

    public static void removeWhiteById(String sheetId) {
        WhiteBean bean = SecurityService.getWhiteById(sheetId);
        String key = bean.getKey();
        SecurityService.removeWhiteByKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<WhiteRuleBean> getWhiteRuleByKey(String key) {
        List<Object> value = new ArrayList();
        if (!Global.isDebug()) {
            WhitRuleList whiteRuleList = Cache.getWhiteRuleListCache(key);
            if (whiteRuleList == null) {
                Cache cache = Cache.instance;
                synchronized (cache) {
                    whiteRuleList = Cache.getWhiteRuleListCache(key);
                    if (whiteRuleList == null) {
                        whiteRuleList = new WhitRuleList();
                        value = dao.getWhiteRuleByKey(key);
                        if (value != null && value.size() > 0) {
                            whiteRuleList.setWhiteRuleListCache(value);
                            Cache.setWhiteRuleListCache(key, whiteRuleList);
                        }
                    } else {
                        value = whiteRuleList.getWhiteRuleListCache();
                    }
                }
            } else {
                value = whiteRuleList.getWhiteRuleListCache();
            }
        } else {
            value = whiteRuleMap.get(key);
            if (value == null && (value = dao.getWhiteRuleByKey(key)) != null && value.size() > 0) {
                whiteRuleMap.put(key, value);
            }
        }
        return value;
    }

    public static void removeWhiteRuleByKey(String key) {
        if (!Global.isDebug()) {
            Cache.getWhiteRuleListCache().clear();
            CacheMonitor.cacheDetailMap.remove("whiteRuleList");
        } else {
            whiteRuleMap.remove(key);
        }
    }

    public static void removeWhiteRuleById(String sheetId) {
        WhiteRuleBean whiteRuleBean = SecurityService.getWhiteRuleById(sheetId);
        String key = whiteRuleBean.getKey();
        SecurityService.removeWhiteRuleByKey(key);
    }

    public static String saveReqIns(String url, String paramName, String value, String otherParams) {
        return dao.saveReqIns(url, paramName, value, otherParams);
    }

    public static void saveWhiteLog(String url, String paramName, String value, String otherParams, String referer, String interceptInsRule, String interceptType) {
        dao.saveWhiteLog(url, paramName, value, otherParams, referer, interceptInsRule, interceptType);
    }

    public static String getOtherParam(Map<String, String> paramMap) {
        StringBuffer param = new StringBuffer(128);
        if (paramMap.size() > 0) {
            if (paramMap.get("_c") != null) {
                param.append(String.valueOf(paramMap.get("_c")) + ";");
            }
            if (paramMap.get("_m") != null) {
                param.append(String.valueOf(paramMap.get("_m")) + ";");
            }
            if (paramMap.get("_p=") != null) {
                param.append(String.valueOf(paramMap.get("_p=")) + ";");
            }
            if (paramMap.get("_f=") != null) {
                param.append(String.valueOf(paramMap.get("_f=")) + ";");
            }
        }
        return param.toString();
    }

    public static boolean deleteWhiteListOrRule(String sheetId, String patternId) {
        String tableName = "";
        if ("CF809F8C-E286-488A-98F3-DD9113639689".equals(patternId)) {
            tableName = "JXD7_UP_WHITELIST";
            SecurityService.removeWhiteById(sheetId);
        }
        if ("962DA7AF-8833-44F2-9AC1-D9628F8DEE1D".equals(patternId)) {
            tableName = "JXD7_UP_WHITELISTRULE";
            SecurityService.removeWhiteRuleById(sheetId);
        }
        return dao.deleteWhiteListOrRule(sheetId, tableName);
    }

    public static List<String> getObjectBySheetId(String sheetId, String type) {
        return dao.getObjectBySheetId(sheetId, type);
    }

    public static boolean updateWhiteList(String sheetId, String formInsId, String patternId, String type) {
        return dao.updateWhiteList(sheetId, formInsId, patternId, type);
    }

    public static boolean deleteWhiteListByRule(String sheetId) {
        return dao.deleteWhiteListByRule(sheetId);
    }

    public static boolean isExistsWhite(String url, String paramName, String value, String otherParams, String sheetId) {
        return dao.isExistsWhite(url, paramName, value, otherParams, sheetId);
    }

    public static boolean isExistsWhite(Object obj) {
        return dao.isExistsWhite(obj);
    }

    public static boolean isExistsWhiteRule(String url, String paramName, String value, String otherParams, String sheetId, String isJson) {
        if (!StringTool.isEmpty(value)) {
            return dao.isExistsWhiteRule(url, paramName, value, otherParams, sheetId);
        }
        return dao.isExistsWhiteRule(url, paramName, value, otherParams, sheetId, isJson);
    }

    public static boolean isExistsWhiteRule(Object obj) {
        boolean flag = false;
        Map map = (Map)obj;
        String type = (String)map.get("TYPE");
        String sheetId = (String)map.get("INSID");
        String tableName = "";
        if ("0".equals(type)) {
            tableName = "JXD7_UP_INTERCEPTINS";
        } else if ("1".equals(type)) {
            tableName = "JXD7_UP_WHITELIST";
        }
        flag = dao.isExistsWhiteRule(sheetId, tableName);
        boolean demp = false;
        if (!flag) {
            WhiteRuleBean ruleBean = new WhiteRuleBean();
            ruleBean.setOtherParams((String)map.get("OTHERPARAMS"));
            ruleBean.setParamName((String)map.get("PARAMNAME"));
            ruleBean.setUrl((String)map.get("URL"));
            ruleBean.setIsJSON((String)map.get("ISJSON"));
            String value = (String)map.get("PATTERNVALUE");
            ruleBean.setPatternValue(value.replace("'", "''"));
            demp = dao.isExistsRule(ruleBean, sheetId, tableName);
        }
        return flag ? flag : demp;
    }

    public static WhiteBean getWhiteById(String sheetId) {
        return dao.getWhiteById(sheetId);
    }

    public static WhiteRuleBean getWhiteRuleById(String sheetId) {
        return dao.getWhiteRuleById(sheetId);
    }

    public static void RemoveKeyOnEditPage(String sheetId, String patternId) {
        if ("CF809F8C-E286-488A-98F3-DD9113639689".equals(patternId)) {
            SecurityService.removeWhiteById(sheetId);
        }
        if ("962DA7AF-8833-44F2-9AC1-D9628F8DEE1D".equals(patternId)) {
            SecurityService.removeWhiteRuleById(sheetId);
        }
    }

    public static List<String> getRuleBySheetId(String sheetId) {
        ArrayList<String> list = new ArrayList<String>();
        WhiteRuleBean whiteRuleBean = dao.getWhiteRuleById(sheetId);
        list.add(whiteRuleBean.getUrl());
        list.add(whiteRuleBean.getParamName());
        list.add(whiteRuleBean.getOtherParams());
        list.add(whiteRuleBean.getPatternValue());
        return list;
    }

    public static String returnTypeByFormInsId(String formInsId) {
        String type = "0";
        if ("CF809F8C-E286-488A-98F3-DD9113639689".equals(formInsId)) {
            type = "1";
        }
        return type;
    }

    public static boolean afterSave(String sheetId, String formInsId, String patternId, String type) {
        if ("BBB7D4C9-F786-4F5E-BDBC-A9ACE925AF75".equals(patternId)) {
            SecurityService.removeWhiteById(formInsId);
        }
        if ("99BE7CFD-D3F7-4B3B-A0AE-DA4C40293E93".equals(patternId)) {
            SecurityService.removeWhiteRuleById(formInsId);
        }
        return SecurityService.updateWhiteList(sheetId, formInsId, patternId, type);
    }

    public static boolean cleanWhiteList(String sheetId) {
        return dao.cleanWhiteList(sheetId);
    }

    public static boolean cleanWhiteRule(String sheetid) {
        return dao.cleanWhiteRule(sheetid);
    }
}

