/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.organize.dao;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.organize.sql.UserRoleSql;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class UserRoleDao {
    private static Logger daoLogger = Logger.getLogger(UserRoleDao.class);
    private static UserRoleSql sqlHelper = new UserRoleSql();

    static boolean saveUserRole(String[] userRole) {
        if (userRole.length < 1) {
            return false;
        }
        String[] roleID = new String[userRole.length - 1];
        String[] sql2 = new String[userRole.length];
        String userID = userRole[0];
        int i = 1;
        while (i < userRole.length) {
            roleID[i - 1] = userRole[i];
            ++i;
        }
        String delUserRoleSql = sqlHelper.getUserRoleDeleteSql(userID);
        String[] addUserRoleSql = sqlHelper.getUserRoleAddSql(userID, roleID);
        sql2[0] = delUserRoleSql;
        i = 0;
        while (i < addUserRoleSql.length) {
            sql2[i + 1] = addUserRoleSql[i];
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", sql2);
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    static boolean saveRoleUser(String[] userRole) {
        if (userRole.length < 1) {
            return false;
        }
        String[] userID = new String[userRole.length - 1];
        String[] sql2 = new String[userRole.length];
        String roleID = userRole[0];
        int i = 1;
        while (i < userRole.length) {
            userID[i - 1] = userRole[i];
            ++i;
        }
        String delUserRoleSql = sqlHelper.getRoleUserDeleteSql(roleID);
        String[] addUserRoleSql = sqlHelper.getRoleUserAddSql(roleID, userID);
        sql2[0] = delUserRoleSql;
        i = 0;
        while (i < addUserRoleSql.length) {
            sql2[i + 1] = addUserRoleSql[i];
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", sql2);
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    static List getRole(String userID) {
        ArrayList<String> role = new ArrayList<String>();
        String sql2 = sqlHelper.getRoleSql(userID);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                role.add(rs.getString("ROLEID"));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return null;
        }
        return role;
    }

    static List getUser(String roleID) {
        ArrayList<String> user = new ArrayList<String>();
        String sql2 = sqlHelper.getUserSql(roleID);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                user.add(rs.getString("USERID"));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return null;
        }
        return user;
    }

    static boolean delRoleUser(String[] roleUser) {
        if (roleUser.length < 1) {
            return false;
        }
        String[] sql2 = new String[roleUser.length - 1];
        String roleID = roleUser[0];
        int i = 1;
        while (i < roleUser.length) {
            sql2[i - 1] = sqlHelper.getDeleteSql(roleUser[i], roleID);
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", sql2);
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    static boolean delUserRole(String[] roleUser) {
        if (roleUser.length < 1) {
            return false;
        }
        String[] sql2 = new String[roleUser.length - 1];
        String userID = roleUser[0];
        int i = 1;
        while (i < roleUser.length) {
            sql2[i - 1] = sqlHelper.getDeleteSql(userID, roleUser[i]);
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", sql2);
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return false;
        }
        return true;
    }
}

