/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.organize.dao;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.organize.dao.UserDao;
import com.sdjxd.pms.platform.organize.model.RoleBean;
import com.sdjxd.pms.platform.organize.sql.RoleSql;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class RoleDao {
    private static Logger daoLogger = Logger.getLogger(UserDao.class);
    private RoleSql sqlHelper = null;

    public RoleDao() {
        if (this.sqlHelper == null) {
            this.sqlHelper = (RoleSql)BeanFactory.getSqlInstance(this.getClass(), "RoleSql", "defaultds");
        }
    }

    public RoleBean getRole(String userId) throws Exception {
        String sql2 = this.sqlHelper.getRole(userId);
        return this.getRoleBySql(sql2);
    }

    public List getRoles(List roleIds) throws Exception {
        return this.getRoles(roleIds, null, null);
    }

    public List getRoles(List roleIds, String attachTable, String attachLimit) throws Exception {
        ArrayList<RoleBean> roles = new ArrayList<RoleBean>();
        RoleBean bean = new RoleBean();
        String sql2 = null;
        try {
            StringBuffer buffer = new StringBuffer(512);
            buffer.append("SELECT R.SHEETID,R.SHEETNAME,R.ORGANISEID,R.SHOWORDER FROM [S].JXD7_XT_ROLE R");
            if (!StringTool.isEmpty(attachTable)) {
                buffer.append(",");
                buffer.append(attachTable);
            }
            buffer.append(" WHERE ");
            buffer.append(DbOper.toIn1000Sql("R.SHEETID", roleIds));
            if (!StringTool.isEmpty(attachLimit)) {
                buffer.append(" AND (");
                buffer.append(attachLimit);
                buffer.append(")");
            }
            sql2 = buffer.toString();
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                bean = new RoleBean();
                bean.setRoleId(rs.getString("SHEETID"));
                bean.setRoleName(rs.getString("SHEETNAME"));
                bean.setOrganiseId(rs.getString("ORGANISEID"));
                bean.setShowOrder(rs.getInt("SHOWORDER"));
                roles.add(bean);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u83b7\u53d6\u89d2\u8272\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
            throw exp;
        }
        return roles;
    }

    private RoleBean getRoleBySql(String sql2) throws Exception {
        RoleBean bean = new RoleBean();
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                bean.setRoleId(rs.getString("SHEETID"));
                bean.setRoleName(rs.getString("SHEETNAME"));
                bean.setOrganiseId(rs.getString("ORGANISEID"));
                bean.setShowOrder(rs.getInt("SHOWORDER"));
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u83b7\u53d6\u89d2\u8272\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
            throw exp;
        }
        return bean;
    }

    public boolean isMember(String roleId, String userId) {
        boolean success = false;
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT 1 FROM [S].JXD7_XT_USERROLE R WHERE ");
        sql2.append(" R.USERID='").append(userId).append("' AND R.ROLEID='").append(roleId).append("'");
        try {
            success = DbOper.executeQueryObject("defaultds", sql2.toString()) != null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return success;
    }
}

