/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.organize.dao;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.organize.model.MenuBean;
import com.sdjxd.pms.platform.organize.sql.MenuSql;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class MenuDao {
    private static Logger daoLogger = Logger.getLogger(MenuDao.class);
    private static MenuSql sqlHelper = null;

    public MenuDao() {
        if (sqlHelper == null) {
            sqlHelper = (MenuSql)BeanFactory.getSqlInstance(this.getClass(), "MenuSql", "defaultds");
        }
    }

    public List getFirstMenu() {
        String sql2 = sqlHelper.getFirstMenu();
        ArrayList<MenuBean> list = new ArrayList<MenuBean>();
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                MenuBean bean = new MenuBean();
                bean.setId(rs.getString("MENUID"));
                bean.setName(rs.getString("MENUNAME"));
                bean.setParentId(rs.getString("PARENTMENUID"));
                bean.setOpenTypeId(rs.getInt("OPENTYPEID"));
                bean.setMenuLevel(rs.getString("MENULEVEL"));
                bean.setMenuTypeId(rs.getInt("MENUTYPEID"));
                bean.setFillContionType(rs.getInt("FILLCONTIONTYPE"));
                bean.setFillContion(rs.getString("FILLCONTION"));
                bean.setContion(rs.getString("CONTION"));
                bean.setOrdernum(rs.getInt("ORDERNUM"));
                bean.setArgument(rs.getString("ARGUMENT"));
                bean.setFunctionId(rs.getString("FUNCTIONID"));
                bean.setUrl(rs.getString("URL"));
                bean.setAppId(rs.getString("APPID"));
                bean.setPatternId(rs.getString("PATTERNID"));
                bean.setWorkflowId(rs.getString("WORKFLOWID"));
                list.add(bean);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u83b7\u53d6\u7b2c\u4e00\u7ea7\u83dc\u5355\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
        }
        return list;
    }

    public boolean isUserAllowEdit(String userId) {
        String sql2 = "select count(*) as cnt  from [S].jxd7_xt_functionmenu f  where (url = '/edit.do') and exists    (select 1      from        (select distinct r.menuid          from [S].jxd7_xt_rolemenu r inner join            [S].jxd7_xt_userrole ur on r.roleid = ur.roleid inner join            [S].jxd7_xt_user u on ur.userid = u.userid          where u.userid = '" + userId + "') t" + "      where f.menuid = t.menuid)";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next() && rs.getInt("cnt") > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public List getChildMenu(String parentmenuid) {
        String sql2 = sqlHelper.getChildMenu(parentmenuid);
        ArrayList menuList = new ArrayList();
        HashMap<String, String> map = null;
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs != null && rs.next()) {
                map = new HashMap<String, String>();
                map.put("menuid", rs.getString("MENUID"));
                map.put("menuname", rs.getString("MENUNAME"));
                map.put("contion", rs.getString("CONTION"));
                StringBuffer fullurl = new StringBuffer();
                String url = rs.getString("URL");
                String argument = rs.getString("ARGUMENT");
                String appid = rs.getString("APPID");
                String patternid = rs.getString("PATTERNID");
                String workflowid = rs.getString("WORKFLOWID");
                if (url != null && !"".equals(url)) {
                    fullurl.append(url);
                    fullurl.append("?");
                    if (argument != null && !"".equals(argument)) {
                        fullurl.append(argument).append("&");
                    }
                    if (appid != null && !"".equals(appid)) {
                        fullurl.append("appID=").append(appid).append("&");
                    }
                    if (patternid != null && !"".equals(patternid)) {
                        fullurl.append("p=").append(patternid).append("&");
                    }
                    if (workflowid != null && !"".equals(workflowid)) {
                        fullurl.append("f=").append(workflowid).append("&");
                    }
                    fullurl.deleteCharAt(fullurl.length() - 1);
                } else {
                    fullurl.append(argument);
                }
                if (!"".equals(fullurl.toString()) && !"null".equals(fullurl.toString())) {
                    map.put("url", fullurl.toString());
                    String target = "";
                    int opentypeid = rs.getInt("OPENTYPEID");
                    target = opentypeid == 2 ? "main" : (opentypeid == 3 ? "open" : (opentypeid == 4 ? "_blank" : (opentypeid == 5 ? "collapseWest" : (opentypeid == 6 ? "hideWest" : (opentypeid == 7 ? "_parent" : "tab")))));
                    map.put("target", target);
                }
                menuList.add(map);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return null;
        }
        return menuList;
    }

    public List getChildMenu(String[] parentmenuids) {
        String sql2 = sqlHelper.getChildMenu(parentmenuids);
        ArrayList menuList = new ArrayList();
        HashMap<String, String> map = null;
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs != null && rs.next()) {
                map = new HashMap<String, String>();
                map.put("menuid", rs.getString("MENUID"));
                map.put("menuname", rs.getString("MENUNAME"));
                map.put("contion", rs.getString("CONTION"));
                map.put("parentmenuid", rs.getString("PARENTMENUID"));
                StringBuffer fullurl = new StringBuffer();
                String url = rs.getString("URL");
                String argument = rs.getString("ARGUMENT");
                String appid = rs.getString("APPID");
                String patternid = rs.getString("PATTERNID");
                String workflowid = rs.getString("WORKFLOWID");
                if (url != null && !"".equals(url)) {
                    fullurl.append(url);
                    fullurl.append("?");
                    if (argument != null && !"".equals(argument)) {
                        fullurl.append(argument).append("&");
                    }
                    if (appid != null && !"".equals(appid)) {
                        fullurl.append("appID=").append(appid).append("&");
                    }
                    if (patternid != null && !"".equals(patternid)) {
                        fullurl.append("p=").append(patternid).append("&");
                    }
                    if (workflowid != null && !"".equals(workflowid)) {
                        fullurl.append("f=").append(workflowid).append("&");
                    }
                    fullurl.deleteCharAt(fullurl.length() - 1);
                } else {
                    fullurl.append(argument);
                }
                if (!"".equals(fullurl.toString()) && !"null".equals(fullurl.toString())) {
                    map.put("url", fullurl.toString());
                    String target = "";
                    int opentypeid = rs.getInt("OPENTYPEID");
                    target = opentypeid == 2 ? "main" : (opentypeid == 3 ? "open" : (opentypeid == 4 ? "_blank" : (opentypeid == 5 ? "collapseWest" : (opentypeid == 6 ? "hideWest" : (opentypeid == 7 ? "_parent" : "tab")))));
                    map.put("target", target);
                }
                menuList.add(map);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return null;
        }
        return menuList;
    }

    public boolean saveMenuInfo(Map menuInfo) {
        String sql2 = sqlHelper.saveMenuInfo(menuInfo);
        boolean bResult = true;
        try {
            DbOper.executeNonQuery("defaultds", sql2);
        }
        catch (SQLException e) {
            bResult = false;
            daoLogger.error((Object)sql2);
            e.printStackTrace();
        }
        return bResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getMenuInfo(String menuId) {
        String sql2 = sqlHelper.getMenuInfo(menuId);
        HashMap<String, Object> menuInfoMap = new HashMap<String, Object>();
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                menuInfoMap.put("MENUID", rs.getString("MENUID"));
                menuInfoMap.put("MENUNAME", rs.getString("MENUNAME"));
                menuInfoMap.put("OPENTYPEID", new Integer(rs.getInt("OPENTYPEID")));
                menuInfoMap.put("URL", rs.getString("URL"));
                menuInfoMap.put("PATTERNID", rs.getString("PATTERNID"));
                menuInfoMap.put("PATTERNNAME", rs.getString("PATTERNNAME"));
                menuInfoMap.put("WORKFLOWID", rs.getString("WORKFLOWID"));
                menuInfoMap.put("ARGUMENT", rs.getString("ARGUMENT"));
                menuInfoMap.put("ENABLETIME", rs.getString("ENABLETIME"));
                menuInfoMap.put("DISABLETIME", rs.getString("DISABLETIME"));
                menuInfoMap.put("NOTES", rs.getString("NOTES"));
                menuInfoMap.put("ISSHOWMENU", rs.getString("ISSHOWMENU"));
                menuInfoMap.put("CONTION", rs.getString("CONTION"));
                menuInfoMap.put("NEEDLOG", rs.getString("NEEDLOG"));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)sql2);
            e.printStackTrace();
            return null;
        }
        String workflowId = (String)menuInfoMap.get("WORKFLOWID");
        if (workflowId != null && !workflowId.equals("")) {
            sql2 = sqlHelper.getFlowName(menuInfoMap.get("WORKFLOWID").toString());
            try {
                RowSet rs = DbOper.executeQuery("defaultds", sql2);
                if (!rs.next()) return menuInfoMap;
                menuInfoMap.put("WORKFLOWNAME", rs.getString("FLOWNAME"));
                return menuInfoMap;
            }
            catch (SQLException e) {
                daoLogger.error((Object)sql2);
                e.printStackTrace();
                return null;
            }
        } else {
            menuInfoMap.put("WORKFLOWNAME", "");
        }
        return menuInfoMap;
    }

    public boolean isAllowed(String appID, String patternId, String flowId) {
        block5: {
            String sql2 = sqlHelper.getMenu(appID, patternId, flowId);
            try {
                RowSet rs = DbOper.executeQuery("defaultds", sql2);
                ArrayList<String> menus = new ArrayList<String>();
                while (rs.next()) {
                    menus.add(rs.getString("MENUID"));
                }
                if (menus.size() > 0) {
                    sql2 = sqlHelper.getLimitMenu(menus);
                    rs = DbOper.executeQuery("defaultds", sql2);
                    if (rs.next()) {
                        int num = rs.getInt("NUM");
                        return num > 0;
                    }
                    break block5;
                }
                return true;
            }
            catch (SQLException e) {
                daoLogger.error((Object)sql2);
                e.printStackTrace();
            }
        }
        return false;
    }
}

