/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.organize;

import com.sdjxd.pms.development.tools.UserTool;
import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.base.Context;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.base.PlatformLogger;
import com.sdjxd.pms.platform.base.SysConfig;
import com.sdjxd.pms.platform.organize.ChangePasswordException;
import com.sdjxd.pms.platform.organize.Sso;
import com.sdjxd.pms.platform.organize.dao.UserDao;
import com.sdjxd.pms.platform.organize.model.RoleBean;
import com.sdjxd.pms.platform.organize.model.UserBean;
import com.sdjxd.pms.platform.tool.Base64;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class User
extends BaseObject {
    private static final Logger log = Logger.getLogger(User.class);
    public static final String CUR_USER_SESSION_KEY = "_JXDPMSUSER";
    private static final long serialVersionUID = 2L;
    private static ThreadLocal currentUser = new ThreadLocal();
    private static UserDao dao = (UserDao)BeanFactory.getSingleInstance("UserDao");
    public static String icon = String.valueOf(Global.getName()) + "/pms/platform/image/user.gif";
    private String compName;
    private String deptName;
    private String compId;
    private String deptId;
    private String code;
    private String pass;
    private int showOrder;
    private ArrayList roles;
    private String strRoles;
    private String[] rolesName;
    private int dept1Type = -1;
    private String dept2Name = "";
    private String dept2Id = "";
    private int dept2Type = -1;
    private String randomNum = "";
    private Date m_passwordExpires;
    private int status;
    private String jobNumber;
    private static int STATUS_EXIT = 2;
    private static int m_curLoginCount = 0;
    private static Map m_userLoginCount = new HashMap();
    private static Map m_loginFailedMap = new HashMap();
    private static Map m_banTimeMap = new HashMap();

    public String getCode() {
        return this.code;
    }

    public String getCompId() {
        return this.compId;
    }

    public String getCompName() {
        return this.compName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public void init(String userId) {
        this.init(dao.getUser(userId));
    }

    public void init(UserBean bean) {
        if (bean != null) {
            this.code = bean.getUserCode();
            this.id = bean.getUserId();
            this.name = bean.getUserName();
            this.compId = bean.getCompId();
            this.deptId = bean.getDeptId();
            this.pass = bean.getPasswd();
            this.compName = bean.getCompName();
            this.deptName = bean.getDeptName();
            this.showOrder = bean.getShowOrder();
            this.m_passwordExpires = DateTool.parseDate(bean.getPasswordExpires());
            this.status = bean.getStatus();
            this.dept1Type = bean.getDept1Type();
            this.dept2Id = bean.getDept2Id();
            this.dept2Name = bean.getDept2Name();
            this.dept2Type = bean.getDept2Type();
            this.roles = bean.getRoles();
            this.jobNumber = bean.getJobNumber();
            this.randomNum = bean.getRandomNum();
        }
    }

    public void initByCode(String userCode) {
        this.init(dao.getUserByCode(userCode));
    }

    public boolean validatePass(String userPass) throws LoginException {
        boolean result = false;
        Date now = new Date();
        if (this.isBanUser(now)) {
            LoginException exp = new LoginException("\u591a\u6b21\u767b\u5f55\u5931\u8d25\u540e\u88ab\u7981\u7528\u3002");
            throw exp;
        }
        if (!StringTool.isEmpty(userPass)) {
            result = userPass.equalsIgnoreCase(this.pass);
            if (result) {
                this.resetUserFailedCount();
            } else {
                this.addUserFailedCount();
            }
        }
        return result;
    }

    public static boolean changePassword(String userCodeEnCode, String oldPassword, String newPassword, int newPasswordLen, int complex) throws ChangePasswordException, LoginException {
        String userCode = null;
        BASE64Decoder bd = new BASE64Decoder();
        try {
            byte[] bt = bd.decodeBuffer(userCodeEnCode);
            userCode = new String(bt);
        }
        catch (Exception e) {
            return false;
        }
        User user = User.getUserByCode(userCode);
        boolean result = false;
        String isMD5_2 = Global.getConfig("PasswordSecurityLevel");
        if (isMD5_2 != null && "true".equals(isMD5_2)) {
            oldPassword = StringTool.encryptStr2(oldPassword, user.getRandomNum());
        }
        if (user != null && user.validatePass(oldPassword) && User.checkPasswordPolicy(newPassword, oldPassword, newPasswordLen, complex)) {
            String expires = "2099-12-31 23:59:59";
            int pwExpires = SysConfig.getInstance().getInt("pwexpires");
            if (pwExpires > 0) {
                Date now = new Date();
                Calendar cal = Calendar.getInstance();
                cal.setTime(now);
                cal.add(5, pwExpires);
                expires = DateTool.dateToStr(cal.getTime(), null);
            }
            if (result = dao.changePassword(user.getId(), newPassword, expires)) {
                User newUser = User.getUser(user.getId());
                User.loginNoPass(newUser);
            }
        }
        return result;
    }

    public static void setCurrentUser(String userId) {
        if (StringTool.isEmpty(userId)) {
            currentUser.remove();
        } else {
            currentUser.set(userId);
        }
    }

    public static User getCurrentUser() {
        User user = null;
        Context context = Global.getContext();
        String userId = (String)currentUser.get();
        if (StringTool.isEmpty(userId)) {
            if (context != null) {
                user = (User)Global.getContext().getSession(CUR_USER_SESSION_KEY);
                if (!StringTool.isEmpty(context.getParameter("signalKey")) && !context.getParameter("signalKey").equals(Global.getContext().getSession("signalKey"))) {
                    try {
                        Sso.loginBySignalKey(context.getParameter("signalKey"));
                        Global.getContext().setSession("signalKey", context.getParameter("signalKey"));
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                    }
                    user = User.getCurrentUser();
                }
            } else {
                if (StringTool.isEmpty(userId)) {
                    userId = Global.getConfig("timeruser");
                }
                if (userId != null && userId.length() > 0) {
                    User timeruser;
                    user = timeruser = User.getUser(userId);
                } else {
                    Logger.getLogger(User.class).info((Object)"\u6ca1\u6709\u914d\u7f6etimeruser=========================================");
                }
            }
        } else {
            user = User.getUser(userId);
        }
        if (Global.getConfig("isIDP").equals("1") && context != null) {
            String userCode = context.getParameter("userName");
            if (!(user != null && (userCode == null || userCode.length() <= 0) || user != null && user.getCode().equals(userCode))) {
                user = User.getUserByCode(userCode);
                if (user == null || user.getId() == null || user.getId().equals("")) {
                    user = User.getUserByCode("admin");
                }
                Global.getContext().setSession(CUR_USER_SESSION_KEY, user);
            }
        }
        return user;
    }

    public static User getUser(String userId) {
        User user = new User();
        user.init(dao.getUser(userId));
        return user;
    }

    public ArrayList getRoles() {
        if (this.roles == null) {
            this.roles = dao.getUserRoles(this.id);
            this.rolesName = new String[this.roles.size()];
            int i = this.rolesName.length - 1;
            while (i >= 0) {
                this.rolesName[i] = ((RoleBean)this.roles.get(i)).getRoleName();
                --i;
            }
            this.strRoles = StringTool.concat(this.rolesName, ",");
        }
        return this.roles;
    }

    public static User getUserByCode(String userCode) {
        User user = new User();
        user.init(dao.getUserByCode(userCode));
        return user;
    }

    public static TreeMap getUserByDept(String[] depts, String limit) {
        return dao.getUserByDept(depts, limit);
    }

    public static TreeMap getUserByRole(String[] roles, String limit) {
        return dao.getUserByRole(roles, limit);
    }

    public static User getUserByGh(String gh) {
        User user = new User();
        user.init(dao.getUserByGh(gh));
        return user;
    }

    public static TreeMap getUser(String limit, String attachTable, String attachLimit) {
        return dao.getUser(limit, attachTable, attachLimit);
    }

    public static boolean isCurrent(String userId) {
        return User.isCurrent(User.getUser(userId));
    }

    public static boolean isCurrent(User user) {
        boolean isCurrent = false;
        User curUser = User.getCurrentUser();
        if (curUser != null && user != null) {
            isCurrent = curUser.getId().equals(user.getId());
        }
        return isCurrent;
    }

    public static String loginAndGetSession(String userCode, String userPass) throws Exception {
        boolean result = User.login(userCode, userPass);
        if (result) {
            Context context = Global.getContext();
            String sessionId = context.getSessionId();
            return sessionId;
        }
        return "false";
    }

    public static boolean login(String userCode, String userPass) throws LoginException {
        return User.login(userCode, userPass, false);
    }

    public static boolean login(String userCode, String userPass, boolean needMd5) throws LoginException {
        int i;
        String password = userPass;
        boolean result = false;
        if (password == null) {
            password = "";
        }
        String clientIp = Global.getContext().getRemoteAddr();
        String ipLimit = SysConfig.getInstance().getString("iplimit");
        String ipLimitDisable = SysConfig.getInstance().getString("iplimitdisable");
        boolean bLimit = false;
        if (ipLimitDisable.length() != 0) {
            String[] ipLimitDisableList = ipLimitDisable.split(",");
            bLimit = false;
            i = 0;
            while (i < ipLimitDisableList.length) {
                if (clientIp.startsWith(ipLimitDisableList[i])) {
                    bLimit = true;
                    break;
                }
                ++i;
            }
            if (bLimit) {
                PlatformLogger.log("", "", "", "\u7981\u6b62\u767b\u5f55(ip: " + clientIp + ")", 5);
                throw new LoginException("IP\u5730\u5740\u4e0d\u5728\u8bb8\u53ef\u767b\u5f55\u8303\u56f4\u5185\u3002");
            }
        }
        if (ipLimit.length() != 0) {
            String[] ipLimitList = ipLimit.split(",");
            bLimit = true;
            i = 0;
            while (i < ipLimitList.length) {
                if (clientIp.startsWith(ipLimitList[i])) {
                    bLimit = false;
                    break;
                }
                ++i;
            }
            if (bLimit) {
                PlatformLogger.log("", "", "", "\u7981\u6b62\u767b\u5f55(ip: " + clientIp + ")", 5);
                throw new LoginException("IP\u5730\u5740\u4e0d\u5728\u8bb8\u53ef\u767b\u5f55\u8303\u56f4\u5185\u3002");
            }
        }
        User oldUser = User.getCurrentUser();
        User user = User.getUserByCode(userCode);
        if (needMd5) {
            password = StringTool.encryptStr2(password, user.getRandomNum());
        }
        if (user != null) {
            if (user.id == null || user.id.length() == 0) {
                String error = Global.getMessage("permit.user.loginerror.username", userCode);
                PlatformLogger.log("", "", "", error, 5);
                throw new LoginException(error);
            }
            if (user.verifyLogin(password)) {
                Global.getContext().setRequest("jxd_cbgl_user_pass", password);
                User.loginNoPass(user);
                Context context = Global.getContext();
                String msg = context != null && Global.getConfig("recordmac").length() > 0 && !StringTool.isEmpty((String)context.getSession("loginMac")) ? "\u767b\u5f55\u6210\u529f\u3002" + clientIp + "_" + (String)context.getSession("loginMac") : "\u767b\u5f55\u6210\u529f\u3002\u767b\u9646ip\uff1a" + clientIp;
                PlatformLogger.log("", "", msg, 5);
                if (oldUser != null) {
                    --m_curLoginCount;
                    oldUser.decUserLoginCount();
                }
                result = true;
            }
        }
        return result;
    }

    public static boolean loginByEncode(String userCodeEnCode, String userPass) throws Exception {
        String isLogin = User.loginByEncode(userCodeEnCode, userPass, false);
        return "true".equals(isLogin);
    }

    public static String loginByEncode(String userCodeEnCode, String userPass, boolean remaind) throws Exception {
        try {
            boolean isLogin = false;
            isLogin = "true".equals(Global.getConfig("PasswordSecurityLevel")) ? User.login(Base64.decode(userCodeEnCode), userPass, true) : User.login(Base64.decode(userCodeEnCode), userPass, false);
            if (remaind && isLogin) {
                String jxd_cbgl_user_pass = (String)Global.getContext().getRequest("jxd_cbgl_user_pass");
                return jxd_cbgl_user_pass;
            }
            return isLogin ? "true" : "false";
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(User.class).error((Object)e.getMessage());
            return "false";
        }
    }

    public static boolean loginByEncode2(String userCodeEnCode, String userPass) throws Exception {
        return User.login(Base64.decode(userCodeEnCode), userPass, false);
    }

    public static boolean loginNoPass(String userCode) {
        if (!StringTool.isEmpty(userCode)) {
            User user = User.getUserByCode(userCode);
            return User.loginNoPass(user);
        }
        return false;
    }

    private static boolean loginNoPass(User user) {
        if (user != null && Global.getContext() != null) {
            String uuid = Guid.create();
            String ip = Global.getContext().getRemoteAddr();
            String clientInfo = Global.getContext().getHeader("user-agent");
            log.info((Object)("\u7528\u6237\u4f1a\u8bddid\uff1a" + uuid + "\n\u7528\u6237\u767b\u5f55:" + user.getName() + "\t\u4f1a\u8bdd\u6807\u793a:" + uuid + "\t\u8bbf\u95eeip\uff1a" + ip + "\tclientInfo:" + clientInfo));
            Global.getContext().setSession("USERUUID", uuid);
            Global.getContext().setSession(CUR_USER_SESSION_KEY, user);
            user.addUserLoginCount();
            ++m_curLoginCount;
            return true;
        }
        return false;
    }

    public static boolean login(String userCode, String userPass, String sessionId) throws LoginException {
        return User.login(userCode, userPass);
    }

    public static String getSessionId() {
        if (Global.getContext() != null) {
            return Global.getContext().getSessionId();
        }
        return "";
    }

    public static boolean loginByUserId(String userId, String userPass) throws LoginException {
        User user;
        String password = userPass;
        if (password == null) {
            password = "";
        }
        if ((user = User.getUser(userId)) != null && user.validatePass(password)) {
            User.loginNoPass(user);
            PlatformLogger.log("", "", "", 5);
            return true;
        }
        return false;
    }

    public static boolean logout(String sessionId) {
        User user = User.getCurrentUser();
        if (user != null) {
            --m_curLoginCount;
            user.decUserLoginCount();
        }
        PlatformLogger.log("", "", "", 6);
        if (Global.getContext() != null) {
            Global.getContext().setSession(CUR_USER_SESSION_KEY, null);
        }
        return true;
    }

    public boolean logout() {
        --m_curLoginCount;
        this.decUserLoginCount();
        PlatformLogger.log("", "", "", 6);
        return true;
    }

    public static boolean validatePass(String userCode, String userPass) throws LoginException {
        User user = User.getUserByCode(userCode);
        String password = userPass;
        if (password == null) {
            password = "";
        }
        return user.validatePass(password);
    }

    public static boolean validatePassByUserId(String userId, String userPass) throws LoginException {
        User user = User.getUser(userId);
        String password = userPass;
        if (password == null) {
            password = "";
        }
        return user.validatePass(password);
    }

    public static boolean signValidatePassByUserId(String userId, String userPass) throws LoginException {
        User user = User.getUser(userId);
        String password = userPass;
        boolean result = false;
        if (password == null) {
            password = "";
        }
        if (user != null) {
            Date now = new Date();
            result = user.validatePass(userPass);
            if (result) {
                PlatformLogger.log("", "", "\u7b7e\u540d\u3002\uff08IP: " + Global.getContext().getRemoteAddr() + "\uff09", 5);
            } else {
                PlatformLogger.log("", "", "\u7b7e\u540d: \u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002\uff08IP: " + Global.getContext().getRemoteAddr() + "\uff09", 5);
            }
        }
        return result;
    }

    public static ArrayList getUserRoles(String userId) {
        User user = User.getUser(userId);
        return user.getRoles();
    }

    public static ArrayList getUserRolesHasIndexPage(String userId) {
        return dao.getUserRolesHasIndexPage(userId);
    }

    public boolean equals(Object user) {
        return user != null && this.id.compareTo(((User)user).getId()) == 0;
    }

    public String getPass() {
        return this.pass;
    }

    @Override
    public int getShowOrder() {
        return this.showOrder;
    }

    private static boolean checkPasswordPolicy(String newPassword, String oldPassword, int newPasswordLen, int complex) throws ChangePasswordException {
        boolean result = true;
        ChangePasswordException exp = null;
        int passwordMinLen = SysConfig.getInstance().getInt("pwminlen");
        int passwordComplex = SysConfig.getInstance().getInt("pwcomplex");
        int passwordRepeatold = SysConfig.getInstance().getInt("pwrepeatold");
        if (passwordMinLen > 0 && newPasswordLen < passwordMinLen) {
            exp = new ChangePasswordException("\u65b0\u5bc6\u7801\u957f\u5ea6\u9700\u4e0d\u5c11\u4e8e" + passwordMinLen + "\u4f4d\u3002");
        } else if (complex < passwordComplex) {
            exp = new ChangePasswordException("\u65b0\u5bc6\u7801\u590d\u6742\u5ea6\u592a\u4f4e\uff0c\u9700\u542b\u6709\u5927\u5c0f\u5199\u5b57\u6bcd\u548c\u6570\u5b57\u3002");
        } else if (passwordRepeatold == 0 && newPassword.equals(oldPassword)) {
            exp = new ChangePasswordException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c\u3002");
        }
        if (exp != null) {
            throw exp;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserFailedCount() throws LoginException {
        StringBuilder errStr = new StringBuilder();
        int maxTryLogin = SysConfig.getInstance().getInt("pwmaxfail");
        int banMinute = SysConfig.getInstance().getInt("pwbanminute");
        if (maxTryLogin > 0 && banMinute > 0) {
            int result = 0;
            Integer count = null;
            Map map = m_loginFailedMap;
            synchronized (map) {
                if (m_loginFailedMap.containsKey(this.id)) {
                    count = (Integer)m_loginFailedMap.get(this.id);
                }
            }
            if (count != null) {
                result = count;
            }
            if (++result >= maxTryLogin) {
                errStr.append("\u5bc6\u7801\u8fde\u7eed\u9519\u8bef").append(maxTryLogin).append("\u6b21\uff0c\u8d26\u6237\u5df2\u9501\u5b9a\uff0c\u8bf7").append(banMinute).append("\u5206\u949f\u540e\u91cd\u8bd5\u3002");
            } else {
                errStr.append("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002\u8fde\u7eed\u9519\u8bef").append(maxTryLogin).append("\u6b21\uff0c\u8d26\u6237\u5c06\u9501\u5b9a\u3002\u60a8\u8fd8\u6709").append(maxTryLogin - result).append("\u6b21\u673a\u4f1a\u3002");
            }
            if (result >= maxTryLogin) {
                map = m_loginFailedMap;
                synchronized (map) {
                    Map map2 = m_banTimeMap;
                    synchronized (map2) {
                        m_loginFailedMap.remove(this.id);
                        Calendar cal = Calendar.getInstance();
                        cal.add(12, banMinute);
                        Date banTime = cal.getTime();
                        m_banTimeMap.put(this.id, banTime);
                    }
                }
            }
            map = m_loginFailedMap;
            synchronized (map) {
                m_loginFailedMap.put(this.id, new Integer(result));
            }
            LoginException exp = new LoginException(errStr.toString());
            throw exp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserLoginCount() {
        Integer count = new Integer(this.getUserLoginCount() + 1);
        Map map = m_userLoginCount;
        synchronized (map) {
            m_userLoginCount.put(this.id, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decUserLoginCount() {
        int curCount = this.getUserLoginCount();
        if (curCount > 1) {
            Map map = m_userLoginCount;
            synchronized (map) {
                m_userLoginCount.put(this.id, new Integer(curCount - 1));
            }
        }
        Map map = m_userLoginCount;
        synchronized (map) {
            m_userLoginCount.remove(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUserLoginCount() {
        int result = 0;
        Integer count = null;
        Map map = m_userLoginCount;
        synchronized (map) {
            if (m_userLoginCount.containsKey(this.id)) {
                count = (Integer)m_userLoginCount.get(this.id);
            }
        }
        if (count != null) {
            result = count;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBanUser(Date now) {
        boolean result = false;
        Map map = m_banTimeMap;
        synchronized (map) {
            if (m_banTimeMap.containsKey(this.id)) {
                Date banTime = (Date)m_banTimeMap.get(this.id);
                if (banTime != null && banTime.after(now)) {
                    result = true;
                } else {
                    m_banTimeMap.remove(this.id);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUserFailedCount() {
        Map map = m_loginFailedMap;
        synchronized (map) {
            m_loginFailedMap.remove(this.id);
        }
    }

    private boolean verifyLogin(String password) throws LoginException {
        Date now = new Date();
        boolean result = false;
        LoginException exp = null;
        int maxLoginCount = SysConfig.getInstance().getInt("usmaxsession");
        int userMaxLogin = SysConfig.getInstance().getInt("ususermaxsession");
        if (this.status == STATUS_EXIT) {
            exp = new LoginException("\u7528\u6237\u5df2\u79bb\u804c\u3002");
        } else if (maxLoginCount >= 0 && m_curLoginCount >= maxLoginCount) {
            exp = new LoginException("\u603b\u5728\u7ebf\u7528\u6237\u6570\u8d85\u8fc7\u4e0a\u9650\u3002");
        } else if (SysConfig.getInstance().getInt("pwexpires") > 0 && this.m_passwordExpires != null && now.after(this.m_passwordExpires)) {
            if (this.validatePass(password)) {
                result = true;
            } else {
                exp = new LoginException(Global.getMessage("permit.user.loginerror.pass", new Object[0]));
            }
        } else if (userMaxLogin >= 0 && this.getUserLoginCount() >= userMaxLogin) {
            exp = new LoginException("\u6b64\u7528\u6237\u6700\u5927\u4f1a\u8bdd\u6570\u5df2\u8d85\u8fc7\u4e0a\u9650\u3002");
        } else if (!this.validatePass(password)) {
            exp = new LoginException(Global.getMessage("permit.user.loginerror.pass", new Object[0]));
        } else {
            result = true;
        }
        if (!result) {
            if (exp == null) {
                exp = new LoginException("\u767b\u5f55\u5931\u8d25\u3002");
            }
            StringBuffer mess = new StringBuffer();
            mess.append(exp.getMessage()).append("\u767b\u5f55IP: ").append(Global.getContext().getRemoteAddr());
            PlatformLogger.log(this.id, "", "", mess.toString(), 5);
            throw exp;
        }
        return result;
    }

    public String getStrRoles() {
        this.getRoles();
        return this.strRoles;
    }

    public String toJson() {
        Class<?> classType;
        StringBuffer sb = new StringBuffer(128);
        sb.append("{");
        Class<?> parentType = classType = this.getClass();
        do {
            Field[] field = classType.getDeclaredFields();
            int index = 0;
            while (index < field.length) {
                if (!"pass".equals(field[index].getName())) {
                    sb.append(BeanTool.toJson(this, field[index]));
                }
                ++index;
            }
        } while ((classType = classType.getSuperclass()) != null && !classType.equals(parentType));
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public static void setLoginMac(String mac) {
        Context context = Global.getContext();
        if (context != null) {
            context.setSession("loginMac", mac);
        }
    }

    public int getDept1Type() {
        return this.dept1Type;
    }

    public String getDept2Id() {
        return this.dept2Id;
    }

    public String getDept2Name() {
        return this.dept2Name;
    }

    public int getDept2Type() {
        return this.dept2Type;
    }

    public String getJobNumber() {
        return this.jobNumber;
    }

    public void setJobNumber(String jobNumber) {
        this.jobNumber = jobNumber;
    }

    public String getRandomNum() {
        return this.randomNum;
    }

    public void setRandomNum(String randomNum) {
        this.randomNum = randomNum;
    }

    public static boolean userIsOnline(String userId) {
        return m_userLoginCount.get(userId) != null && (Integer)m_userLoginCount.get(userId) > 0;
    }

    public static Map getBanTimeMap() {
        return m_banTimeMap;
    }

    public static boolean unlimitUser(String userId) {
        Object obj = m_banTimeMap.remove(userId);
        return obj != null;
    }

    public static void setIcon(String appRoot) {
        icon = String.valueOf(appRoot) + "/pms/platform/image/user.gif";
    }

    public static boolean isPwdOutTime() {
        boolean PwdOutTime = false;
        Date now = new Date();
        UserBean bean = dao.getUser(UserTool.getCurUserId());
        Date pwdexpries = DateTool.parseDate(bean.getPasswordExpires());
        if (SysConfig.getInstance().getInt("pwexpires") > 0 && pwdexpries != null && now.after(pwdexpries)) {
            PwdOutTime = true;
        }
        return PwdOutTime;
    }
}

