/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.organize;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.organize.ISso;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.organize.dao.SsoDao;
import com.sdjxd.pms.platform.platWebServices.service.InvokeAplicate;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class Sso
implements ISso {
    private static SsoDao dao = SsoDao.createInstance();

    public static String getSignalKey() throws Exception {
        String key = Guid.create();
        User user = User.getCurrentUser();
        String userId = user.getCode();
        dao.createSignalKey(key, userId, Calendar.getInstance());
        return key;
    }

    public static void loginBySignalKey(String signalKey) throws Exception {
        String userCode = (String)InvokeAplicate.invokeNetWebServices(Global.getConfig("ssourl"), "getLoginUser", new String[]{"signalKey"}, new String[]{"string"}, new Object[]{signalKey}, 60000);
        if (!StringTool.isEmpty(userCode)) {
            User.loginNoPass(userCode);
        }
    }

    public static void invokeAddUser(String userId, String userCode, String userName, String deptId) throws Exception {
        ArrayList sys = null;
        sys = dao.getSystem();
        int i = 0;
        while (i < sys.size()) {
            try {
                HashMap sysInfo = (HashMap)sys.get(i);
                String serviceUrl = (String)sysInfo.get("SERVICEURL");
                if (!StringTool.isEmpty(serviceUrl)) {
                    InvokeAplicate.invokeNetWebServices(serviceUrl, "addUser", new String[]{"userId", "userCode", "userName", "deptId"}, new String[]{"string", "string", "string", "string"}, new Object[]{userId, userCode, userName, deptId}, 60000);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            ++i;
        }
    }

    public static void invokeModifyUser(String userId, String userCode, String userName, String deptId) throws Exception {
        ArrayList sys = null;
        sys = dao.getSystem();
        int i = 0;
        while (i < sys.size()) {
            try {
                HashMap sysInfo = (HashMap)sys.get(i);
                String serviceUrl = (String)sysInfo.get("SERVICEURL");
                if (!StringTool.isEmpty(serviceUrl)) {
                    InvokeAplicate.invokeNetWebServices(serviceUrl, "modifyUser", new String[]{"userId", "userCode", "userName", "deptId"}, new String[]{"string", "string", "string", "string"}, new Object[]{userId, userCode, userName, deptId}, 60000);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            ++i;
        }
    }

    public static void invokeDeleteUser(String userId) throws Exception {
        ArrayList sys = null;
        sys = dao.getSystem();
        int i = 0;
        while (i < sys.size()) {
            try {
                HashMap sysInfo = (HashMap)sys.get(i);
                String serviceUrl = (String)sysInfo.get("SERVICEURL");
                if (!StringTool.isEmpty(serviceUrl)) {
                    InvokeAplicate.invokeNetWebServices(serviceUrl, "deleteUser", new String[]{"userId"}, new String[]{"string"}, new Object[]{userId}, 60000);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            ++i;
        }
        dao.deleteUser(userId);
    }

    public static void invokeAddOrg(String orgId, String orgName, String preOrgId) throws Exception {
        ArrayList sys = null;
        sys = dao.getSystem();
        int i = 0;
        while (i < sys.size()) {
            try {
                HashMap sysInfo = (HashMap)sys.get(i);
                String serviceUrl = (String)sysInfo.get("SERVICEURL");
                if (!StringTool.isEmpty(serviceUrl)) {
                    InvokeAplicate.invokeNetWebServices(serviceUrl, "addOrg", new String[]{"orgId", "orgName", "preOrgId"}, new String[]{"string", "string", "string"}, new Object[]{orgId, orgName, preOrgId}, 60000);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            ++i;
        }
    }

    public static void invokeModifyOrg(String orgId, String orgName, String preOrgId) throws Exception {
        ArrayList sys = null;
        sys = dao.getSystem();
        int i = 0;
        while (i < sys.size()) {
            try {
                HashMap sysInfo = (HashMap)sys.get(i);
                String serviceUrl = (String)sysInfo.get("SERVICEURL");
                if (!StringTool.isEmpty(serviceUrl)) {
                    InvokeAplicate.invokeNetWebServices(serviceUrl, "modifyOrg", new String[]{"orgId", "orgName", "preOrgId"}, new String[]{"string", "string", "string"}, new Object[]{orgId, orgName, preOrgId}, 60000);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            ++i;
        }
    }

    public static void invokeDeleteOrg(String orgId) throws Exception {
        ArrayList sys = null;
        sys = dao.getSystem();
        int i = 0;
        while (i < sys.size()) {
            try {
                HashMap sysInfo = (HashMap)sys.get(i);
                String serviceUrl = (String)sysInfo.get("SERVICEURL");
                if (!StringTool.isEmpty(serviceUrl)) {
                    InvokeAplicate.invokeNetWebServices(serviceUrl, "deleteOrg", new String[]{"orgId"}, new String[]{"string"}, new Object[]{orgId}, 60000);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            ++i;
        }
    }

    @Override
    public String getLoginUser(String key) throws Exception {
        String userCode = null;
        Calendar time = Calendar.getInstance();
        time.add(12, -1);
        userCode = dao.getLoginUser(key, time);
        return userCode;
    }

    @Override
    public String getUsers() throws Exception {
        ArrayList users = null;
        users = dao.getUsers();
        StringBuffer buffer = new StringBuffer(128);
        if (users != null && users.size() > 0) {
            buffer.append("[");
            int len = users.size();
            int index = 0;
            while (index < len) {
                buffer.append("{");
                Map map = (Map)users.get(index);
                for (Map.Entry entry : map.entrySet()) {
                    buffer.append("\"").append(entry.getKey()).append("\"").append(":").append(BeanTool.toJson(entry.getValue())).append(",");
                }
                if (map.size() > 0) {
                    buffer.setLength(buffer.length() - 1);
                }
                buffer.append("},");
                ++index;
            }
            buffer.setLength(buffer.length() - 1);
            buffer.append("]");
        }
        return buffer.toString();
    }

    @Override
    public String getUsersOfOrg(String orgId) throws Exception {
        ArrayList users = null;
        users = dao.getUsers(orgId);
        StringBuffer buffer = new StringBuffer(128);
        if (users != null && users.size() > 0) {
            buffer.append("[");
            int len = users.size();
            int index = 0;
            while (index < len) {
                buffer.append("{");
                Map map = (Map)users.get(index);
                for (Map.Entry entry : map.entrySet()) {
                    buffer.append("\"").append(entry.getKey()).append("\"").append(":").append(BeanTool.toJson(entry.getValue())).append(",");
                }
                if (map.size() > 0) {
                    buffer.setLength(buffer.length() - 1);
                }
                buffer.append("},");
                ++index;
            }
            buffer.setLength(buffer.length() - 1);
            buffer.append("]");
        }
        return buffer.toString();
    }

    @Override
    public String getOrgs() throws Exception {
        ArrayList organs = null;
        organs = dao.getOrganizations();
        StringBuffer buffer = new StringBuffer(128);
        if (organs != null && organs.size() > 0) {
            buffer.append("[");
            int len = organs.size();
            int index = 0;
            while (index < len) {
                buffer.append("{");
                Map map = (Map)organs.get(index);
                for (Map.Entry entry : map.entrySet()) {
                    buffer.append("\"").append(entry.getKey()).append("\"").append(":").append(BeanTool.toJson(entry.getValue())).append(",");
                }
                if (map.size() > 0) {
                    buffer.setLength(buffer.length() - 1);
                }
                buffer.append("},");
                ++index;
            }
            buffer.setLength(buffer.length() - 1);
            buffer.append("]");
        }
        return buffer.toString();
    }

    @Override
    public String getOrgsOfOrg(String orgId) throws Exception {
        ArrayList organs = null;
        organs = dao.getOrganizations(orgId);
        StringBuffer buffer = new StringBuffer(128);
        if (organs != null && organs.size() > 0) {
            buffer.append("[");
            int len = organs.size();
            int index = 0;
            while (index < len) {
                buffer.append("{");
                Map map = (Map)organs.get(index);
                for (Map.Entry entry : map.entrySet()) {
                    buffer.append("\"").append(entry.getKey()).append("\"").append(":").append(BeanTool.toJson(entry.getValue())).append(",");
                }
                if (map.size() > 0) {
                    buffer.setLength(buffer.length() - 1);
                }
                buffer.append("},");
                ++index;
            }
            buffer.setLength(buffer.length() - 1);
            buffer.append("]");
        }
        return buffer.toString();
    }

    @Override
    public String getRoles() throws Exception {
        ArrayList organs = null;
        organs = dao.getRoles();
        StringBuffer buffer = new StringBuffer(128);
        if (organs != null && organs.size() > 0) {
            buffer.append("[");
            int len = organs.size();
            int index = 0;
            while (index < len) {
                buffer.append("{");
                Map map = (Map)organs.get(index);
                for (Map.Entry entry : map.entrySet()) {
                    buffer.append("\"").append(entry.getKey()).append("\"").append(":").append(BeanTool.toJson(entry.getValue())).append(",");
                }
                if (map.size() > 0) {
                    buffer.setLength(buffer.length() - 1);
                }
                buffer.append("},");
                ++index;
            }
            buffer.setLength(buffer.length() - 1);
            buffer.append("]");
        }
        return buffer.toString();
    }

    @Override
    public void addUser(String userId, String userCode, String userName, String deptId) throws Exception {
        dao.addUser(userId, userCode, userName, deptId, 0);
    }

    @Override
    public void modifyUser(String userId, String userCode, String userName, String deptId) throws Exception {
        dao.modifyUser(userId, userCode, userName, deptId, 0);
    }

    @Override
    public void deleteUser(String userId) throws Exception {
        dao.deleteUser(userId);
    }

    @Override
    public void addOrg(String orgId, String orgName, String preOrgId) throws Exception {
        dao.addOrg(orgId, orgName, preOrgId, 0);
    }

    @Override
    public void modifyOrg(String orgId, String orgName, String preOrgId) throws Exception {
        dao.modifyOrg(orgId, orgName, preOrgId, 0);
    }

    @Override
    public void deleteOrg(String orgId) throws Exception {
        dao.deleteOrg(orgId);
    }

    public static void loginBySignalKey(String httpPath, String signalKey) throws Exception {
        String userCode = (String)InvokeAplicate.invokeNetWebServices(httpPath, "getLoginUser", new String[]{"signalKey"}, new String[]{"string"}, new Object[]{signalKey}, 60000);
        if (!StringTool.isEmpty(userCode)) {
            User.loginNoPass(userCode);
        }
    }
}

