/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.organize;

import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.organize.dao.RoleDao;
import com.sdjxd.pms.platform.organize.model.RoleBean;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.util.ArrayList;
import java.util.List;

public class Role
extends BaseObject {
    private static final long serialVersionUID = 2L;
    private static RoleDao dao;
    String organiseId;
    public static String icon;
    public static final String CUR_USER_SESSION_KEY = "_JXDPMSUSER";

    static {
        icon = String.valueOf(Global.getName()) + "/pms/platform/image/role.gif";
        dao = (RoleDao)BeanFactory.getSingleInstance("RoleDao");
    }

    public static Role getRole(String roleId) throws Exception {
        Role role = new Role();
        role.init(dao.getRole(roleId));
        return role;
    }

    public static List getRoles(List roleIds) throws Exception {
        return Role.getRoles(roleIds, null, null);
    }

    public static List getRoles(List roleIds, String attachTable, String attachLimit) throws Exception {
        ArrayList<Role> list = new ArrayList<Role>();
        List roleBeans = dao.getRoles(roleIds, attachTable, attachLimit);
        int len = roleBeans.size();
        int i = 0;
        while (i < len) {
            Role role = new Role();
            role.init((RoleBean)roleBeans.get(i));
            list.add(role);
            ++i;
        }
        return list;
    }

    public void init(String roleId) throws Exception {
        this.init(dao.getRole(roleId));
    }

    public void init(RoleBean bean) throws Exception {
        if (bean != null) {
            this.id = bean.getRoleId();
            this.name = bean.getRoleName();
            this.organiseId = bean.getOrganiseId();
            this.showOrder = bean.getShowOrder();
        }
    }

    public static boolean isMember(String roleId, String userId) {
        return dao.isMember(roleId, userId);
    }

    public static void setIcon(String appRoot) {
        icon = String.valueOf(appRoot) + "/pms/platform/image/role.gif";
    }
}

