/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.organize;

import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.organ.bean.OrganBean;
import com.sdjxd.pms.platform.organ.dao.OrganDao;
import java.util.ArrayList;
import java.util.List;

public class Organize
extends BaseObject {
    private static final long serialVersionUID = 2L;
    private static OrganDao dao;
    private String organCode;
    public static String icon;

    static {
        icon = String.valueOf(Global.getName()) + "/pms/platform/image/organise.gif";
        dao = OrganDao.createInstance("defaultds");
    }

    public static Organize getOrganize(String organizeId) throws Exception {
        Organize organize = new Organize();
        organize.init(dao.getOrganInfo(organizeId));
        return organize;
    }

    public static List getOrganizes(List organizeIds) throws Exception {
        ArrayList<Organize> list = new ArrayList<Organize>();
        List organizeBeans = dao.getOrganInfos(organizeIds);
        int len = organizeBeans.size();
        int i = 0;
        while (i < len) {
            Organize organize = new Organize();
            organize.init((OrganBean)organizeBeans.get(i));
            list.add(organize);
            ++i;
        }
        return list;
    }

    public static List getOrganizes(List organizeIds, String attachTable, String attachLimit) throws Exception {
        ArrayList<Organize> list = new ArrayList<Organize>();
        List organizeBeans = dao.getOrganInfos(organizeIds, attachTable, attachLimit);
        int len = organizeBeans.size();
        int i = 0;
        while (i < len) {
            Organize organize = new Organize();
            organize.init((OrganBean)organizeBeans.get(i));
            list.add(organize);
            ++i;
        }
        return list;
    }

    public void init(String organizeId) throws Exception {
        this.init(dao.getOrganInfo(organizeId));
    }

    public void init(OrganBean bean) throws Exception {
        if (bean != null) {
            this.id = bean.getOrganId();
            this.name = bean.getOrganName();
            this.showOrder = bean.getShowOrder();
            this.organCode = bean.getOrganCode();
        }
    }

    public static boolean isMember(String organizeId, String userId) {
        return dao.isMember(organizeId, userId);
    }

    public String getOrganCode() {
        return this.organCode;
    }

    public void setOrganCode(String organCode) {
        this.organCode = organCode;
    }

    public static void setIcon(String appRoot) {
        icon = String.valueOf(appRoot) + "/pms/platform/image/organise.gif";
    }
}

