/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.organize;

import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.base.Constants;
import com.sdjxd.pms.platform.organize.JsMenu;
import com.sdjxd.pms.platform.organize.dao.MenuDao;
import com.sdjxd.pms.platform.organize.model.MenuBean;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.util.List;
import java.util.Map;

public class Menu
extends BaseObject {
    private static final long serialVersionUID = 2L;
    private static MenuDao dao = (MenuDao)BeanFactory.getSingleInstance("MenuDao");

    public static JsMenu[] getFirstMenu() {
        List list = dao.getFirstMenu();
        int len = list.size();
        JsMenu[] jsMenuList = new JsMenu[len];
        int i = 0;
        while (i < len) {
            MenuBean bean = (MenuBean)list.get(i);
            JsMenu menu = new JsMenu();
            menu.setId(bean.getId());
            menu.setText(bean.getName());
            menu.setTarget(bean.getOpenTypeId());
            menu.setFunctionId(bean.getFunctionId());
            menu.setLink(bean.getUrl(), bean.getPatternId(), bean.getAppId(), bean.getWorkflowId(), bean.getArgument());
            menu.setContion(bean.getContion());
            jsMenuList[i] = menu;
            ++i;
        }
        return jsMenuList;
    }

    public static boolean isUserAllowEdit(String userId) {
        return dao.isUserAllowEdit(userId);
    }

    public static List getChildMenu(String parentmenuid) {
        return dao.getChildMenu(parentmenuid);
    }

    public static List getChildMenu(String[] parentmenuids) {
        return dao.getChildMenu(parentmenuids);
    }

    public static String getDropDownMenuJS() {
        List firstMenuList = Menu.getChildMenu(Constants.rootOrganiseID);
        StringBuffer output = new StringBuffer();
        output.append("var tb = new Ext.Toolbar('menuItem');");
        output.append("tb.add(");
        int i = 0;
        while (i < firstMenuList.size()) {
            Map menu = (Map)firstMenuList.get(i);
            String menuid = menu.get("menuid").toString();
            String url = "";
            String target = "";
            if (menu.containsKey("url") && menu.get("url") != null) {
                url = menu.get("url").toString();
                target = menu.get("target").toString();
            }
            List childMenuList = Menu.getChildMenu(menuid);
            output.append("{");
            output.append("text:'").append(menu.get("menuname")).append("',");
            if (url.length() > 0) {
                output.append("link:'").append(url).append("',");
                output.append("target:'").append(target).append("',");
                output.append("handler: onItemCheck,");
            }
            output.append("menu:");
            if (childMenuList != null && childMenuList.size() > 0) {
                output.append("menu").append(menuid.replaceAll("-", ""));
            } else {
                output.append("''");
            }
            output.append("},");
            ++i;
        }
        output.deleteCharAt(output.length() - 1);
        output.append(");");
        return output.toString();
    }

    public static String getDropDownMenuDefine() {
        List firstMenuList = Menu.getChildMenu(Constants.rootOrganiseID);
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < firstMenuList.size()) {
            Map menu = (Map)firstMenuList.get(i);
            String menuid = menu.get("menuid").toString();
            List childMenuList = Menu.getChildMenu(menuid);
            if (childMenuList != null && childMenuList.size() > 0) {
                output.append("var menu").append(menuid.replaceAll("-", ""));
                output.append(" = new Ext.menu.Menu({");
                output.append("id: '").append(menuid.replaceAll("-", "")).append("',");
                output.append("items: [");
                Menu.getMenuItems(childMenuList, output);
                output.append("]");
                output.append("});");
            }
            ++i;
        }
        return output.toString();
    }

    private static void getMenuItems(List menuList, StringBuffer output) {
        int i = 0;
        while (i < menuList.size()) {
            List childMenuList;
            Map menu = (Map)menuList.get(i);
            String menuid = menu.get("menuid").toString();
            String menuname = menu.get("menuname").toString();
            String url = "";
            String target = "";
            if (menu.containsKey("url") && menu.get("url") != null) {
                url = menu.get("url").toString();
                target = menu.get("target").toString();
            }
            if ((childMenuList = Menu.getChildMenu(menuid)) != null && childMenuList.size() > 0) {
                output.append("{");
                output.append("text:'").append(menuname).append("',");
                output.append("link:'").append(url).append("',");
                output.append("target:'").append(target).append("',");
                output.append("group: 'theme',");
                output.append("cls: 'menuTitle',");
                output.append("handler: onItemCheck,");
                output.append("menu: {");
                output.append("items: [");
                Menu.getMenuItems(childMenuList, output);
                output.append("]");
                output.append("}");
                output.append("},");
            } else {
                output.append("new Ext.menu.CheckItem({");
                output.append("text:'").append(menuname).append("',");
                output.append("link:'").append(url).append("',");
                output.append("target:'").append(target).append("',");
                output.append("group: 'theme',");
                output.append("cls: 'menuTitle',");
                output.append("handler: onItemCheck");
                output.append("}),");
            }
            ++i;
        }
        if (output.charAt(output.length() - 1) == ',') {
            output.deleteCharAt(output.length() - 1);
        }
    }

    public static String saveMenuInfo(Map menuInfo) {
        if (dao.saveMenuInfo(menuInfo)) {
            return menuInfo.get("MENUID").toString();
        }
        return "";
    }

    public static Map getMenuInfo(String menuId) {
        return dao.getMenuInfo(menuId);
    }
}

