/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.organ.service;

import com.sdjxd.pms.platform.base.MaxID;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.DbSession;
import com.sdjxd.pms.platform.organ.bean.OrganBean;
import com.sdjxd.pms.platform.organ.bean.OrganParaBean;
import com.sdjxd.pms.platform.organ.dao.OrganDao;
import com.sdjxd.pms.platform.tool.BeanTool;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrganCtrl {
    public OrganBean getOrganInfo(String organId) {
        List arrLimitValue;
        OrganDao dao = new OrganDao();
        OrganBean bean = dao.getOrganInfo(organId);
        if (bean == null) {
            return null;
        }
        List arrParaValue = this.getOrganParaValue(organId, String.valueOf(bean.getOrganTypeCode()));
        if (arrParaValue != null) {
            int i = 0;
            while (i < arrParaValue.size()) {
                Map item = (Map)arrParaValue.get(i);
                bean.setParameter((String)item.get("id"), item.get("value"));
                ++i;
            }
        }
        if ((arrLimitValue = this.getOrganLimitValue(organId)) != null) {
            int i = 0;
            while (i < arrLimitValue.size()) {
                bean.setLimitInfo((String)arrLimitValue.get(i));
                ++i;
            }
        }
        return bean;
    }

    public List getOrganParaValue(String organId, String organTypeId) {
        OrganDao dao = new OrganDao();
        List arrPara = dao.getOrganPara(organTypeId);
        if (arrPara == null) {
            return null;
        }
        ArrayList arrValue = dao.getOrganParaValue(organId);
        if (arrValue == null) {
            arrValue = new ArrayList();
        }
        ArrayList arrParaValue = new ArrayList();
        int i = 0;
        while (i < arrPara.size()) {
            OrganParaBean bean = (OrganParaBean)arrPara.get(i);
            HashMap<String, String> item = new HashMap<String, String>();
            String paraId = bean.getParaId();
            item.put("id", paraId);
            item.put("name", bean.getParaName());
            String strValue = "";
            int j = 0;
            while (j < arrValue.size()) {
                OrganParaBean valueBean = (OrganParaBean)arrValue.get(j);
                if (paraId.equals(valueBean.getParaId())) {
                    strValue = valueBean.getParaValue();
                    break;
                }
                ++j;
            }
            item.put("value", strValue);
            arrParaValue.add(item);
            ++i;
        }
        if (arrParaValue.size() <= 0) {
            return null;
        }
        return arrParaValue;
    }

    public List getOrganLimitValue(String organId) {
        OrganDao dao = new OrganDao();
        return dao.getOrganLimit(organId);
    }

    public List getOrganSubOrganId(String organId) {
        OrganDao dao = new OrganDao();
        List arrSub = dao.getOrganSub(organId);
        if (arrSub == null) {
            return null;
        }
        ArrayList<String> arr = new ArrayList<String>();
        int i = 0;
        while (i < arrSub.size()) {
            OrganBean bean = (OrganBean)arrSub.get(i);
            arr.add(bean.getOrganId());
            ++i;
        }
        return arr;
    }

    public boolean saveOrganInfo(String organId, String[] baseData, String[] paraData, String[] limiData) {
        OrganDao dao = new OrganDao();
        boolean bRes = false;
        ArrayList<Map> arrBaseData = new ArrayList<Map>();
        int i = 0;
        while (i < baseData.length) {
            String str = baseData[i];
            Map item = (Map)BeanTool.parse(str.substring(1, str.length() - 1));
            arrBaseData.add(item);
            ++i;
        }
        OrganBean bean = dao.getOrganInfo(organId);
        if (bean != null) {
            bRes = dao.updateOrganBaseInfo(organId, arrBaseData);
        } else {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("fieldName", "SHOWORDER");
            item.put("fieldValue", String.valueOf(MaxID.getMaxID("JXD7_XT_ORGANISE", "SHOWORDER")));
            arrBaseData.add(item);
            bRes = dao.insertOrganBaseInfo(organId, arrBaseData);
        }
        if (!bRes) {
            return false;
        }
        ArrayList<Map> arrParaData = new ArrayList<Map>();
        int i2 = 1;
        while (i2 < paraData.length) {
            String str = paraData[i2];
            Map item = (Map)BeanTool.parse(str.substring(1, str.length() - 1));
            arrParaData.add(item);
            ++i2;
        }
        bRes = dao.updateOrganParaInfo(organId, arrParaData);
        ArrayList<String> arrLimitData = new ArrayList<String>();
        int i3 = 1;
        while (i3 < limiData.length) {
            String str = limiData[i3];
            arrLimitData.add(str);
            ++i3;
        }
        bRes = dao.updateOrganLimiInfo(organId, arrLimitData);
        return true;
    }

    public int deleteOrgan(String[] arrOrganId) {
        List arrChild;
        String organId;
        OrganDao dao = new OrganDao();
        int i = 0;
        while (i < arrOrganId.length) {
            organId = arrOrganId[i];
            arrChild = dao.getChildOrganInfo(organId);
            if (arrChild != null) {
                return 2;
            }
            ++i;
        }
        i = 0;
        while (i < arrOrganId.length) {
            organId = arrOrganId[i];
            arrChild = dao.getUserInfoByDeptId(organId);
            if (arrChild != null) {
                return 3;
            }
            ++i;
        }
        if (!dao.deleteOrgan(arrOrganId)) {
            return 1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int moveOrgan(String[] organId, String orgOrganId, String orgOrganType) {
        OrganDao dao = new OrganDao();
        if (orgOrganType.length() > 0) {
            int i = 0;
            while (i < organId.length) {
                if (!dao.isChildInOrganType(organId[i], orgOrganType)) {
                    return 2;
                }
                ++i;
            }
        }
        try {
            DbSession session = DbOper.openDb("defaultds");
            try {
                String[] befmethods = dao.isExistMethod("1", "0");
                if (befmethods != null) {
                    Object[] args = new Object[]{organId, orgOrganId, orgOrganType};
                    Object o = BeanTool.invokeMethod(befmethods[0], befmethods[1], args);
                    boolean pre = (Boolean)o;
                    if (pre) {
                        return 0;
                    }
                }
                if (!dao.moveOrgan(organId, orgOrganId)) {
                    DbOper.rollbackDb(session);
                    return 1;
                }
                String[] aftmethods = dao.isExistMethod("1", "1");
                if (aftmethods != null) {
                    Object[] args = new Object[]{organId, orgOrganId, orgOrganType};
                    BeanTool.invokeMethod(aftmethods[0], aftmethods[1], args);
                }
                DbOper.commitDb(session);
                return 0;
            }
            catch (Exception e1) {
                DbOper.rollbackDb(session);
                e1.printStackTrace();
                return 1;
            }
            finally {
                DbOper.closeDb(session);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return 0;
    }
}

