/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.organ.dao;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.base.dao.BaseDao;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.organ.bean.OrganBean;
import com.sdjxd.pms.platform.organ.bean.OrganParaBean;
import com.sdjxd.pms.platform.organ.bean.OrganTypeBean;
import com.sdjxd.pms.platform.organ.bean.UserBean;
import com.sdjxd.pms.platform.organ.bean.UserParaBean;
import com.sdjxd.pms.platform.organize.Maintain;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.SqlHelper;
import com.sdjxd.pms.platform.tool.StringTool;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class OrganDao
extends BaseDao {
    private static Logger log = Logger.getLogger(OrganDao.class);

    public static OrganDao createInstance(String dataSourceName) {
        return (OrganDao)OrganDao.createInstance(OrganDao.class, dataSourceName);
    }

    public OrganTypeBean getOrganTypeInfoWithCode(int typeCode) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select SHEETID, TYPEID, TYPENAME");
        sql2.append(" from [S].JXD7_XT_ORGANISETYPE");
        sql2.append(" where TYPEID = '" + typeCode + "'");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            if (rs.next()) {
                OrganTypeBean bean = new OrganTypeBean();
                bean.setSheetId(rs.getString("SHEETID"));
                bean.setOrganTypeCode(rs.getInt("TYPEID"));
                bean.setOrganTypeName(rs.getString("TYPENAME"));
                return bean;
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return null;
        }
        return null;
    }

    public boolean updateOrganTypeChild(String typeId, String[] cTypeId) {
        ArrayList<String> arrSql = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        sql2.setLength(0);
        sql2.append("delete from [S].JXD7_XT_ORGTYPERELA where TYPEID = ").append(typeId);
        arrSql.add(sql2.toString());
        int nCount = cTypeId.length;
        int i = 0;
        while (i < nCount) {
            String item = cTypeId[i];
            if (!"-1".equals(item)) {
                sql2.setLength(0);
                sql2.append("insert into [S].JXD7_XT_ORGTYPERELA (SHEETID, TYPEID, CHILDTYPEID) ");
                sql2.append("values ('{SHEETID}', {TYPEID}, {CHILDTYPEID})");
                SqlHelper sqlHelper = new SqlHelper(sql2.toString());
                sqlHelper.setValue("SHEETID", Guid.create());
                sqlHelper.setValue("TYPEID", typeId);
                sqlHelper.setValue("CHILDTYPEID", item);
                arrSql.add(sqlHelper.getString());
            }
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", arrSql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean deleteOrganType(String[] arrSheetId) {
        ArrayList<String> arrSql = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        int nCount = arrSheetId.length;
        int i = 0;
        while (i < nCount) {
            sql2.setLength(0);
            sql2.append("delete from [S].JXD7_XT_ORGTYPERELA");
            sql2.append(" where TYPEID in (");
            sql2.append("  select TYPEID");
            sql2.append("  from [S].JXD7_XT_ORGANISETYPE");
            sql2.append("  where SHEETID = '" + arrSheetId[i] + "'");
            sql2.append("  )");
            sql2.append(" or CHILDTYPEID in (");
            sql2.append("  select TYPEID");
            sql2.append("  from [S].JXD7_XT_ORGANISETYPE");
            sql2.append("  where SHEETID = '" + arrSheetId[i] + "'");
            sql2.append("  )");
            arrSql.add(sql2.toString());
            sql2.setLength(0);
            sql2.append("delete from [S].JXD7_XT_ORGANISETYPE");
            sql2.append(" where SHEETID = '" + arrSheetId[i] + "'");
            arrSql.add(sql2.toString());
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", arrSql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public OrganBean getOrganInfo(String organId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select ORGANISEID, ORGANISENAME, ORGANISEKINDID, ORGANISELEVEL, PREORGANISEID,");
        sql2.append(" SHOWORDER, ORGANISETYPE, STARTTIME, ENDTIME, SHORTNAME");
        sql2.append(" from [S].JXD7_XT_ORGANISE");
        sql2.append(" where ORGANISEID = '" + organId + "'");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            if (rs.next()) {
                OrganBean bean = new OrganBean();
                bean.setOrganId(organId);
                bean.setOrganCode(rs.getString("ORGANISELEVEL"));
                bean.setOrganName(rs.getString("ORGANISENAME"));
                bean.setOrganTypeCode(rs.getInt("ORGANISETYPE"));
                bean.setPreOrganId(rs.getString("PREORGANISEID"));
                bean.setShowOrder(rs.getInt("SHOWORDER"));
                bean.setValidityEnd(rs.getString("STARTTIME"));
                bean.setValidityEnd(rs.getString("ENDTIME"));
                return bean;
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return null;
        }
        return null;
    }

    public List getOrganInfos(List organIds) {
        ArrayList<OrganBean> organInfos = new ArrayList<OrganBean>();
        OrganBean bean = new OrganBean();
        String sql2 = null;
        try {
            StringBuffer buffer = new StringBuffer(512);
            buffer.append("SELECT ORGANISEID, ORGANISENAME, ORGANISEKINDID, ORGANISELEVEL, PREORGANISEID,SHOWORDER, ORGANISETYPE, STARTTIME, ENDTIME, SHORTNAME FROM [S].JXD7_XT_ORGANISE WHERE ");
            buffer.append(DbOper.toIn1000Sql("ORGANISEID", organIds));
            sql2 = buffer.toString();
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                bean = new OrganBean();
                bean.setOrganId(rs.getString("ORGANISEID"));
                bean.setOrganCode(rs.getString("ORGANISELEVEL"));
                bean.setOrganName(rs.getString("ORGANISENAME"));
                bean.setOrganTypeCode(rs.getInt("ORGANISETYPE"));
                bean.setPreOrganId(rs.getString("PREORGANISEID"));
                bean.setShowOrder(rs.getInt("SHOWORDER"));
                bean.setValidityEnd(rs.getString("STARTTIME"));
                bean.setValidityEnd(rs.getString("ENDTIME"));
                organInfos.add(bean);
            }
        }
        catch (SQLException exp) {
            log.error((Object)("\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
        }
        return organInfos;
    }

    public List getOrganInfos(List organIds, String attachTable, String attachLimit) {
        ArrayList<OrganBean> organInfos = new ArrayList<OrganBean>();
        OrganBean bean = new OrganBean();
        String sql2 = null;
        try {
            StringBuffer buffer = new StringBuffer(512);
            buffer.append("SELECT ORGANISEID, ORGANISENAME, ORGANISEKINDID, ORGANISELEVEL, PREORGANISEID,SHOWORDER, ORGANISETYPE, STARTTIME, ENDTIME, SHORTNAME FROM [S].JXD7_XT_ORGANISE ORG ");
            if (!StringTool.isEmpty(attachTable)) {
                buffer.append(",");
                buffer.append(attachTable);
            }
            buffer.append(" WHERE ");
            buffer.append(DbOper.toIn1000Sql("ORG.ORGANISEID", organIds));
            if (!StringTool.isEmpty(attachLimit)) {
                buffer.append(" AND (");
                buffer.append(attachLimit);
                buffer.append(")");
            }
            sql2 = buffer.toString();
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                bean = new OrganBean();
                bean.setOrganId(rs.getString("ORGANISEID"));
                bean.setOrganCode(rs.getString("ORGANISELEVEL"));
                bean.setOrganName(rs.getString("ORGANISENAME"));
                bean.setOrganTypeCode(rs.getInt("ORGANISETYPE"));
                bean.setPreOrganId(rs.getString("PREORGANISEID"));
                bean.setShowOrder(rs.getInt("SHOWORDER"));
                bean.setValidityEnd(rs.getString("STARTTIME"));
                bean.setValidityEnd(rs.getString("ENDTIME"));
                organInfos.add(bean);
            }
        }
        catch (SQLException exp) {
            log.error((Object)("\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
        }
        return organInfos;
    }

    public List getChildOrganInfo(String organId) {
        ArrayList<OrganBean> arrOrgan = new ArrayList<OrganBean>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select ORGANISEID, ORGANISENAME, ORGANISEKINDID, ORGANISELEVEL, PREORGANISEID,");
        sql2.append(" SHOWORDER, ORGANISETYPE, STARTTIME, ENDTIME, SHORTNAME");
        sql2.append(" from [S].JXD7_XT_ORGANISE");
        sql2.append(" where PREORGANISEID = '" + organId + "'");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            while (rs.next()) {
                OrganBean bean = new OrganBean();
                bean.setOrganId(organId);
                bean.setOrganCode(rs.getString("ORGANISELEVEL"));
                bean.setOrganName(rs.getString("ORGANISENAME"));
                bean.setOrganTypeCode(rs.getInt("ORGANISETYPE"));
                bean.setPreOrganId(rs.getString("PREORGANISEID"));
                bean.setShowOrder(rs.getInt("SHOWORDER"));
                bean.setValidityEnd(rs.getString("STARTTIME"));
                bean.setValidityEnd(rs.getString("ENDTIME"));
                arrOrgan.add(bean);
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return null;
        }
        if (arrOrgan.size() <= 0) {
            return null;
        }
        return arrOrgan;
    }

    public List getUserInfoByDeptId(String DeptId) {
        ArrayList<UserBean> arrUser = new ArrayList<UserBean>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select USERID, DEPTID, USERCODE, USERNAME, PASSWD,");
        sql2.append(" SHOWORDER, XB, STARTTIME, ENDTIME, MAXSESSION");
        sql2.append(" from [S].JXD7_XT_USER");
        sql2.append(" where DEPTID = '" + DeptId + "'");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            while (rs.next()) {
                UserBean bean = new UserBean();
                bean.setUserId(rs.getString("USERID"));
                bean.setUserCode(rs.getString("USERCODE"));
                bean.setUserName(rs.getString("USERNAME"));
                bean.setPassWord(rs.getString("PASSWD"));
                bean.setOrganId(rs.getString("DEPTID"));
                bean.setSexCode(rs.getString("XB"));
                bean.setShowOrder(rs.getInt("SHOWORDER"));
                bean.setValidityEnd(rs.getString("STARTTIME"));
                bean.setValidityEnd(rs.getString("ENDTIME"));
                bean.setMaxSession(rs.getInt("MAXSESSION"));
                arrUser.add(bean);
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return null;
        }
        if (arrUser.size() <= 0) {
            return null;
        }
        return arrUser;
    }

    public List getOrganPara(String organTypeId) {
        if (StringTool.isEmpty(organTypeId)) {
            return null;
        }
        ArrayList<OrganParaBean> arrPara = new ArrayList<OrganParaBean>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select A.PARAID, A.PARANAME, A.PARANODE, A.PARATYPE, A.ORGANTYPEID");
        sql2.append(" from [S].JXD7_XT_ORGANPARA A, [S].JXD7_XT_ORGANISETYPE B");
        sql2.append(" where A.ORGANTYPEID = B.SHEETID");
        sql2.append(" and B.TYPEID = ").append(organTypeId);
        sql2.append(" order by A.SHOWORDER");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            while (rs.next()) {
                OrganParaBean bean = new OrganParaBean();
                bean.setParaId(rs.getString("PARAID"));
                bean.setParaName(rs.getString("PARANAME"));
                bean.setParaType(rs.getString("PARATYPE"));
                bean.setParaNote(rs.getString("PARANODE"));
                arrPara.add(bean);
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return null;
        }
        if (arrPara.size() <= 0) {
            return null;
        }
        return arrPara;
    }

    public List getOrganParaValue(String organId) {
        ArrayList<OrganParaBean> arrPara = new ArrayList<OrganParaBean>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select A.PARAID, A.PARAVALUE, B.PARANAME, B.PARANODE, B.PARATYPE");
        sql2.append(" from [S].JXD7_XT_ORGANPARAV A, [S].JXD7_XT_ORGANPARA B");
        sql2.append(" where A.PARAID = B.PARAID");
        sql2.append(" and A.ORGANID = '" + organId + "'");
        sql2.append(" order by B.SHOWORDER");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            while (rs.next()) {
                OrganParaBean bean = new OrganParaBean();
                bean.setOrganId(organId);
                bean.setParaId(rs.getString("PARAID"));
                bean.setParaValue(rs.getString("PARAVALUE"));
                bean.setParaNote(rs.getString("PARANODE"));
                arrPara.add(bean);
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return null;
        }
        if (arrPara.size() <= 0) {
            return null;
        }
        return arrPara;
    }

    public List getOrganLimit(String organId) {
        ArrayList<String> arrLimit = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select ORGANID");
        sql2.append(" from [S].JXD7_XT_ORGANLIMIT ");
        sql2.append(" where OBJECTID = '" + organId + "'");
        sql2.append(" order by SHOWORDER");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            while (rs.next()) {
                arrLimit.add(rs.getString("ORGANID"));
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return null;
        }
        if (arrLimit.size() <= 0) {
            return null;
        }
        return arrLimit;
    }

    public List getOrganSub(String organId) {
        ArrayList<OrganBean> arr = new ArrayList<OrganBean>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select ORGANISEID, ORGANISEID, ORGANISENAME, ORGANISEKINDID, ORGANISELEVEL, PREORGANISEID,");
        sql2.append(" SHOWORDER, ORGANISETYPE, STARTTIME, ENDTIME, SHORTNAME");
        sql2.append(" from [S].JXD7_XT_ORGANISE");
        sql2.append(" where PREORGANISEID = '" + organId + "'");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            while (rs.next()) {
                OrganBean bean = new OrganBean();
                bean.setOrganId(rs.getString("ORGANISEID"));
                bean.setOrganCode(rs.getString("ORGANISELEVEL"));
                bean.setOrganName(rs.getString("ORGANISENAME"));
                bean.setOrganTypeCode(rs.getInt("ORGANISETYPE"));
                bean.setPreOrganId(rs.getString("PREORGANISEID"));
                bean.setShowOrder(rs.getInt("SHOWORDER"));
                bean.setValidityEnd(rs.getString("STARTTIME"));
                bean.setValidityEnd(rs.getString("ENDTIME"));
                arr.add(bean);
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return null;
        }
        if (arr.size() <= 0) {
            return null;
        }
        return arr;
    }

    public boolean insertOrganBaseInfo(String organId, List data) {
        StringBuffer sql2 = new StringBuffer();
        StringBuffer fieldValue = new StringBuffer();
        sql2.append("insert into [S].JXD7_XT_ORGANISE ");
        sql2.append("(ORGANISEID");
        fieldValue.append("('").append(organId).append("'");
        int i = 0;
        while (i < data.size()) {
            Map item = (Map)data.get(i);
            sql2.append(",");
            sql2.append((String)item.get("fieldName"));
            fieldValue.append(",'");
            fieldValue.append((String)item.get("fieldValue"));
            fieldValue.append("'");
            ++i;
        }
        sql2.append(", DATASTATUSID)");
        fieldValue.append(", 1)");
        sql2.append(" values ").append(fieldValue.toString());
        try {
            DbOper.executeNonQuery("defaultds", sql2.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean updateOrganBaseInfo(String organId, List data) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("update [S].JXD7_XT_ORGANISE set ");
        int i = 0;
        while (i < data.size()) {
            Map item = (Map)data.get(i);
            String fieldName = (String)item.get("fieldName");
            String fieldValue = (String)item.get("fieldValue");
            if (i > 0) {
                sql2.append(",");
            }
            sql2.append((String)item.get("fieldName"));
            if (StringTool.isEmpty(fieldValue)) {
                sql2.append(" = null ");
            } else {
                sql2.append(" = '");
                sql2.append((String)item.get("fieldValue"));
                sql2.append("'");
            }
            ++i;
        }
        sql2.append(" where ORGANISEID = '" + organId + "' ");
        try {
            DbOper.executeNonQuery("defaultds", sql2.toString());
        }
        catch (SQLException e) {
            log.error((Object)("sql\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + sql2));
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean updateOrganParaInfo(String organId, List data) {
        ArrayList<String> arrPara = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("delete from [S].JXD7_XT_ORGANPARAV ");
        sql2.append("where ORGANID = '" + organId + "' ");
        arrPara.add(sql2.toString());
        int i = 0;
        while (i < data.size()) {
            Map item = (Map)data.get(i);
            sql2.setLength(0);
            sql2.append("insert into [S].JXD7_XT_ORGANPARAV (ORGANID, PARAID, PARAVALUE) values ");
            sql2.append("(");
            sql2.append("'").append(organId).append("', ");
            sql2.append("'").append(item.get("id")).append("', ");
            sql2.append("'").append(item.get("value")).append("'");
            sql2.append(")");
            arrPara.add(sql2.toString());
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", arrPara);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean updateOrganLimiInfo(String organId, List data) {
        ArrayList<String> arrPara = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("delete from [S].JXD7_XT_ORGANLIMIT ");
        sql2.append("where OBJECTID = '" + organId + "' ");
        arrPara.add(sql2.toString());
        int i = 0;
        while (i < data.size()) {
            String str = (String)data.get(i);
            sql2.setLength(0);
            sql2.append("insert into [S].JXD7_XT_ORGANLIMIT (SHEETID, OBJECTID, ORGANID) values ");
            sql2.append("(");
            sql2.append("'").append(Guid.create()).append("', ");
            sql2.append("'").append(organId).append("', ");
            sql2.append("'").append(str).append("'");
            sql2.append(")");
            arrPara.add(sql2.toString());
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", arrPara);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean deleteOrgan(String[] arrOrganId) {
        ArrayList<String> arrPara = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        int i = 0;
        while (i < arrOrganId.length) {
            String organId = arrOrganId[i];
            sql2.setLength(0);
            sql2.append("delete from [S].JXD7_XT_ORGANISE ");
            sql2.append("where ORGANISEID = '" + organId + "' ");
            arrPara.add(sql2.toString());
            sql2.setLength(0);
            sql2.append("delete from [S].JXD7_XT_ORGANPARAV ");
            sql2.append("where ORGANID = '" + organId + "' ");
            arrPara.add(sql2.toString());
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", arrPara);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isChildInOrganType(String organId, String organType) {
        if (organType.length() <= 0) {
            return true;
        }
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select ORGANISEID from [S].JXD7_XT_ORGANISE ");
        sql2.append("where ORGANISEID = '" + organId + "' ");
        sql2.append("and ORGANISETYPE in ");
        sql2.append("(");
        sql2.append(" select CHILDTYPEID from [S].JXD7_XT_ORGTYPERELA ");
        sql2.append(" where TYPEID = ").append(organType);
        sql2.append(")");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            return rs.next();
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public boolean moveOrgan(String[] organId, String orgOrganId) {
        if (organId == null || organId.length == 0) {
            return true;
        }
        StringBuffer sql2 = new StringBuffer();
        sql2.append("update [S].JXD7_XT_ORGANISE ");
        sql2.append("set PREORGANISEID = '").append(orgOrganId).append("' ");
        sql2.append(" where ORGANISEID in (");
        int i = 0;
        while (i < organId.length) {
            if (i > 0) {
                sql2.append(",");
            }
            sql2.append("'").append(organId[i]).append("'");
            ++i;
        }
        sql2.append(")");
        try {
            DbOper.executeNonQuery("defaultds", sql2.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String[] isExistMethod(String methodtype, String exectime) {
        String[] methodpars;
        block4: {
            methodpars = new String[2];
            if (methodtype == null || exectime == null) {
                return null;
            }
            StringBuffer sql2 = new StringBuffer();
            sql2.append("SELECT * FROM [S].JXD7_XT_ORGANISEEXTEN ");
            sql2.append("WHERE METHODTYPE = '").append(methodtype).append("' ");
            sql2.append(" AND EXECTIME = '").append(exectime).append("'");
            try {
                RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
                if (rs.next()) {
                    methodpars[0] = rs.getString("CLASSNAME");
                    methodpars[1] = rs.getString("METHODNAME");
                    break block4;
                }
                return null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return methodpars;
    }

    public UserBean getUserInfo(String userId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select USERID, DEPTID, USERCODE, USERNAME, PASSWD,");
        sql2.append(" SHOWORDER, XB, STARTTIME, ENDTIME, MAXSESSION");
        sql2.append(" from [S].JXD7_XT_USER");
        sql2.append(" where USERID = '" + userId + "'");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            if (rs.next()) {
                UserBean bean = new UserBean();
                bean.setUserId(userId);
                bean.setUserCode(rs.getString("USERCODE"));
                bean.setUserName(rs.getString("USERNAME"));
                bean.setPassWord(rs.getString("PASSWD"));
                bean.setOrganId(rs.getString("DEPTID"));
                bean.setSexCode(rs.getString("XB"));
                bean.setShowOrder(rs.getInt("SHOWORDER"));
                bean.setValidityEnd(rs.getString("STARTTIME"));
                bean.setValidityEnd(rs.getString("ENDTIME"));
                bean.setMaxSession(rs.getInt("MAXSESSION"));
                return bean;
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return null;
        }
        return null;
    }

    public UserBean getUserInfoWithUserCode(String userCode) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select USERID, DEPTID, USERCODE, USERNAME, PASSWD,");
        sql2.append(" SHOWORDER, XB, STARTTIME, ENDTIME, MAXSESSION");
        sql2.append(" from [S].JXD7_XT_USER");
        sql2.append(" where USERCODE = '" + userCode + "'");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            if (rs.next()) {
                UserBean bean = new UserBean();
                bean.setUserId(rs.getString("USERID"));
                bean.setUserCode(userCode);
                bean.setUserName(rs.getString("USERNAME"));
                bean.setPassWord(rs.getString("PASSWD"));
                bean.setOrganId(rs.getString("DEPTID"));
                bean.setSexCode(rs.getString("XB"));
                bean.setShowOrder(rs.getInt("SHOWORDER"));
                bean.setValidityEnd(rs.getString("STARTTIME"));
                bean.setValidityEnd(rs.getString("ENDTIME"));
                bean.setMaxSession(rs.getInt("MAXSESSION"));
                return bean;
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return null;
        }
        return null;
    }

    public List getUserParaValue(String userId) {
        ArrayList<UserParaBean> arrPara = new ArrayList<UserParaBean>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select A.PARAID, A.PARAVALUE, B.PARANAME, B.PARANODE, B.PARATYPE");
        sql2.append(" from [S].JXD7_XT_USERPARAV A, [S].JXD7_XT_USERPARA B");
        sql2.append(" where A.PARAID = B.PARAID");
        sql2.append(" and A.USERID = '" + userId + "'");
        sql2.append(" order by B.SHOWORDER");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            while (rs.next()) {
                UserParaBean bean = new UserParaBean();
                bean.setUserId(userId);
                bean.setParaId(rs.getString("PARAID"));
                bean.setParaName(rs.getString("PARANAME"));
                bean.setParaType(rs.getString("PARATYPE"));
                bean.setParaValue(rs.getString("PARAVALUE"));
                bean.setParaNote(rs.getString("PARANODE"));
                arrPara.add(bean);
            }
        }
        catch (SQLException exp) {
            log.error((Object)("[error sql]\u2014\u2014\u6839\u636e\u7528\u6237\u552f\u4e00\u6807\u8bc6\u5f97\u5230\u7528\u6237\u8868\u4fe1\u606f " + sql2.toString()));
            return null;
        }
        if (arrPara.size() <= 0) {
            return null;
        }
        return arrPara;
    }

    public List getUserPara() {
        ArrayList<UserParaBean> arrPara = new ArrayList<UserParaBean>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select PARAID, PARANAME, PARATYPE, PARANODE");
        sql2.append(" from [S].JXD7_XT_USERPARA ");
        sql2.append(" order by SHOWORDER");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            while (rs.next()) {
                UserParaBean bean = new UserParaBean();
                bean.setParaId(rs.getString("PARAID"));
                bean.setParaName(rs.getString("PARANAME"));
                bean.setParaType(rs.getString("PARATYPE"));
                bean.setParaNote(rs.getString("PARANODE"));
                arrPara.add(bean);
            }
        }
        catch (SQLException exp) {
            log.error((Object)("[error sql]\u2014\u2014\u5f97\u5230\u7528\u6237\u81ea\u5b9a\u4e49\u53c2\u6570\u4fe1\u606f " + sql2.toString()));
            return null;
        }
        if (arrPara.size() <= 0) {
            return null;
        }
        return arrPara;
    }

    public List getUserLimit(String userId) {
        ArrayList<String> arrLimit = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select ORGANID");
        sql2.append(" from [S].JXD7_XT_ORGANLIMIT ");
        sql2.append(" where OBJECTID = '" + userId + "'");
        sql2.append(" order by SHOWORDER");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            while (rs.next()) {
                arrLimit.add(rs.getString("ORGANID"));
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return null;
        }
        if (arrLimit.size() <= 0) {
            return null;
        }
        return arrLimit;
    }

    public List getUserLimitHasParent(String userId) {
        ArrayList<String> arrLimit = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select ORGANID");
        sql2.append(" from [S].JXD7_XT_ORGANLIMIT ");
        sql2.append(" where OBJECTID = '" + userId + "'");
        sql2.append(" order by SHOWORDER");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            while (rs.next()) {
                arrLimit.add(rs.getString("ORGANID"));
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            return null;
        }
        int i = 0;
        while (i < 10) {
            sql2.setLength(0);
            sql2.append("select t1.ORGANISEID from [S].JXD7_XT_ORGANISE t1 where exists ");
            sql2.append("(select * from [S].JXD7_XT_ORGANISE t2 where t1.ORGANISEID=t2.PREORGANISEID and t2.ORGANISEID in (");
            int j = 0;
            while (j < arrLimit.size()) {
                if (j > 0) {
                    sql2.append(",");
                }
                sql2.append("'").append(arrLimit.get(j)).append("'");
                ++j;
            }
            sql2.append(")) and t1.ORGANISEID not in (");
            j = 0;
            while (j < arrLimit.size()) {
                if (j > 0) {
                    sql2.append(",");
                }
                sql2.append("'").append(arrLimit.get(j)).append("'");
                ++j;
            }
            sql2.append(")");
            try {
                RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
                while (rs.next()) {
                    arrLimit.add(rs.getString("ORGANISEID"));
                }
            }
            catch (SQLException exp) {
                exp.printStackTrace();
                return null;
            }
            ++i;
        }
        if (arrLimit.size() <= 0) {
            return null;
        }
        return arrLimit;
    }

    public boolean insertUserBaseInfo(String userId, List data) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("insert into [S].JXD7_XT_USER ");
        String MD5_2 = Global.getConfig("PasswordSecurityLevel");
        String pwd = "21218CCA77804D2BA1922C33E0151105";
        if (MD5_2 != null && "true".equals(MD5_2)) {
            String randomNum = "" + (int)(Math.random() * 9000.0 + 1000.0);
            pwd = StringTool.encryptStr2(pwd, randomNum);
            sql2.append("( USERID , DEPTID , USERCODE , USERNAME , SHOWORDER , XB , STARTTIME , ENDTIME, DATASTATUSID, PASSWD, RANDOMNUMBER) values ");
            sql2.append("('{USERID}','{DEPTID}','{USERCODE}','{USERNAME}',{SHOWORDER},'{XB}','{STARTTIME}','{ENDTIME}', 1, '").append(pwd).append("' ,'").append(randomNum).append("')");
        } else {
            sql2.append("( USERID , DEPTID , USERCODE , USERNAME , SHOWORDER , XB , STARTTIME , ENDTIME, DATASTATUSID, PASSWD) values ");
            sql2.append("('{USERID}','{DEPTID}','{USERCODE}','{USERNAME}',{SHOWORDER},'{XB}','{STARTTIME}','{ENDTIME}', 1, '").append(pwd).append("')");
        }
        SqlHelper sqlHelper = new SqlHelper(sql2.toString());
        sqlHelper.setValue("USERID", userId);
        int i = 0;
        while (i < data.size()) {
            Map item = (Map)data.get(i);
            sqlHelper.setValue((String)item.get("fieldName"), (String)item.get("fieldValue"));
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", sqlHelper.getString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean updateUserBaseInfo(String userId, List data) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("update [S].JXD7_XT_USER set ");
        sql2.append("USERCODE = '{USERCODE}', ");
        sql2.append("USERNAME = '{USERNAME}', ");
        sql2.append("XB = '{XB}', ");
        sql2.append("STARTTIME = '{STARTTIME}', ");
        sql2.append("ENDTIME = '{ENDTIME}' ");
        sql2.append("where USERID = '" + userId + "' ");
        SqlHelper sqlHelper = new SqlHelper(sql2.toString());
        int i = 0;
        while (i < data.size()) {
            Map item = (Map)data.get(i);
            sqlHelper.setValue((String)item.get("fieldName"), (String)item.get("fieldValue"));
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", sqlHelper.getString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean updateUserParaInfo(String userId, List data) {
        ArrayList<String> arrPara = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("delete [S].JXD7_XT_USERPARAV ");
        sql2.append("where USERID = '" + userId + "' ");
        arrPara.add(sql2.toString());
        int i = 0;
        while (i < data.size()) {
            Map item = (Map)data.get(i);
            sql2.setLength(0);
            sql2.append("insert into [S].JXD7_XT_USERPARAV (USERID, PARAID, PARAVALUE) values ");
            sql2.append("(");
            sql2.append("'").append(userId).append("', ");
            sql2.append("'").append(item.get("id")).append("', ");
            sql2.append("'").append(item.get("value")).append("'");
            sql2.append(")");
            arrPara.add(sql2.toString());
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", arrPara);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean updateUserLimiInfo(String userId, List data) {
        ArrayList<String> arrPara = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("delete [S].JXD7_XT_ORGANLIMIT ");
        sql2.append("where OBJECTID = '" + userId + "' ");
        arrPara.add(sql2.toString());
        int i = 0;
        while (i < data.size()) {
            String str = (String)data.get(i);
            sql2.setLength(0);
            sql2.append("insert into [S].JXD7_XT_ORGANLIMIT (SHEETID, OBJECTID, ORGANID) values ");
            sql2.append("(");
            sql2.append("'").append(Guid.create()).append("', ");
            sql2.append("'").append(userId).append("', ");
            sql2.append("'").append(str).append("'");
            sql2.append(")");
            arrPara.add(sql2.toString());
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", arrPara);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public List getUserFlowInfo(String[] arrUserId) {
        if (arrUserId == null || arrUserId.length == 0) {
            return null;
        }
        ArrayList<String> arrUser = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select distinct OPERATORNAME ");
        sql2.append("from [S].JXD7_WF_OPERATOR ");
        sql2.append("where (ENDTIME is null or ENDTIME='') ");
        sql2.append("and OPERATOR in('");
        int i = 0;
        while (i < arrUserId.length) {
            sql2.append(arrUserId[i]);
            sql2.append("'");
            if (i < arrUserId.length - 1) {
                sql2.append(",'");
            }
            ++i;
        }
        sql2.append(")");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            while (rs.next()) {
                arrUser.add(rs.getString("OPERATORNAME"));
            }
        }
        catch (SQLException exp) {
            log.error((Object)("[error sql]\u2014\u2014\u5f97\u5230\u7528\u6237\u6b63\u5728\u6267\u884c\u7684\u6d41\u7a0b " + sql2.toString()));
            return null;
        }
        if (arrUser.size() <= 0) {
            return null;
        }
        return arrUser;
    }

    public boolean deleteUser(String[] arrUserId) {
        ArrayList<String> arrPara = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        int i = 0;
        while (i < arrUserId.length) {
            String userId = arrUserId[i];
            sql2.setLength(0);
            sql2.append("delete [S].JXD7_XT_USER ");
            sql2.append("where USERID = '" + userId + "' ");
            arrPara.add(sql2.toString());
            sql2.setLength(0);
            sql2.append("delete [S].JXD7_XT_USERPARAV ");
            sql2.append("where USERID = '" + userId + "' ");
            arrPara.add(sql2.toString());
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", arrPara);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean moveUser(String[] arrUserId, String orgOrganId) {
        ArrayList<String> arrPara = new ArrayList<String>();
        StringBuffer sql2 = new StringBuffer();
        String compId = Maintain.getCompId(orgOrganId);
        int i = 0;
        while (i < arrUserId.length) {
            sql2.setLength(0);
            sql2.append("update [S].JXD7_XT_USER ");
            sql2.append("set DEPTID = '").append(orgOrganId).append("' ");
            sql2.append(",COMPID='").append(compId).append("' ");
            sql2.append("where USERID = '" + arrUserId[i] + "' ");
            arrPara.add(sql2.toString());
            ++i;
        }
        try {
            DbOper.executeNonQuery("defaultds", arrPara);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean updateUserPassWord(String userId, String password) {
        String MD5_2 = Global.getConfig("PasswordSecurityLevel");
        if (MD5_2 != null && "true".equals(MD5_2)) {
            String randomNumber = "1111";
            randomNumber = "" + (int)(Math.random() * 9000.0 + 1000.0);
            password = StringTool.encryptStr2(password, randomNumber);
        }
        StringBuffer sql2 = new StringBuffer();
        sql2.append("update [S].JXD7_XT_USER ");
        sql2.append("set PASSWD = '").append(password).append("' ");
        if (MD5_2 != null && "true".equals(MD5_2)) {
            String randomNumber = "1111";
            randomNumber = "" + (int)(Math.random() * 9000.0 + 1000.0);
            sql2.append(", RANDOMNUMBER = '" + randomNumber + "' ");
        }
        sql2.append("where USERID = '" + userId + "' ");
        try {
            DbOper.executeNonQuery("defaultds", sql2.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isMember(String organizeId, String userId) {
        boolean success = false;
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT 1 FROM [S].JXD7_XT_USER U,[S].JXD7_XT_ORGANISE O1,[S].JXD7_XT_ORGANISE O2 WHERE U.DEPTID=O1.ORGANISEID AND O1.ORGANISELEVEL LIKE O2.ORGANISELEVEL + '%'");
        sql2.append(" AND  U.USERID='").append(userId).append("' AND O2.ORGANISEID='").append(organizeId).append("'");
        try {
            success = DbOper.executeQueryObject("defaultds", sql2.toString()) != null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return success;
    }
}

