/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.message.dao;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.message.sql.MessageSql;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class MessageDao {
    private static Logger daoLogger = Logger.getLogger(MessageDao.class);

    private static MessageSql getSqlHelper(String m_dataSourceName) {
        return (MessageSql)BeanFactory.getSqlInstance(MessageDao.class, "MessageSql", m_dataSourceName);
    }

    public boolean saveUserMessage(String receiver, String contents, String url, String operationid) {
        String[] receivers = new String[]{receiver};
        return this.saveUserMessage(receivers, contents, url, operationid);
    }

    public boolean saveUserMessage(String[] receiver, String contents, String url, String operationid) {
        if (receiver == null || receiver.length < 1) {
            return true;
        }
        List sql2 = MessageDao.getSqlHelper("defaultds").getSaveMessageSql(receiver, contents, url, operationid);
        try {
            DbOper.executeNonQuery(sql2);
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveRoleMessage(String roleid, String contents, String url, String operationid) {
        String[] roles = new String[]{roleid};
        return this.saveRoleMessage(roles, contents, url, operationid);
    }

    public boolean saveRoleMessage(String[] roleid, String contents, String url, String operationid) {
        if (roleid == null || roleid.length < 1) {
            return true;
        }
        TreeMap user = User.getUserByRole(roleid, "");
        return this.saveUserMessage(user, contents, url, operationid);
    }

    public boolean saveOrganMessage(String organiseid, String contents, String url, String operationid) {
        String[] depts = new String[]{organiseid};
        return this.saveOrganMessage(depts, contents, url, operationid);
    }

    public boolean saveOrganMessage(String[] organiseid, String contents, String url, String operationid) {
        if (organiseid == null || organiseid.length < 1) {
            return true;
        }
        TreeMap user = User.getUserByDept(organiseid, "");
        return this.saveUserMessage(user, contents, url, operationid);
    }

    public boolean saveUserMessage(TreeMap user, String contents, String url, String operationid) {
        ArrayList<String> users = new ArrayList<String>();
        Iterator it = user.entrySet().iterator();
        while (it.hasNext()) {
            String userid = it.next().getKey().toString();
            users.add(userid);
        }
        List sql2 = MessageDao.getSqlHelper("defaultds").getSaveMessageSql((String[])users.toArray(), contents, url, operationid);
        try {
            DbOper.executeNonQuery(sql2);
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean delMessageByUReceiver(String userid) {
        String[] users = new String[]{userid};
        return this.delMessageByUReceiver(users);
    }

    public boolean delMessageByUReceiver(String[] userid) {
        List sql2 = MessageDao.getSqlHelper("defaultds").getDelMessageByReceiverSql(userid);
        try {
            DbOper.executeNonQuery(sql2);
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean delMessageByRReceiver(String[] roleid) {
        if (roleid == null || roleid.length < 1) {
            return true;
        }
        ArrayList<String> users = new ArrayList<String>();
        TreeMap user = User.getUserByRole(roleid, "");
        Iterator it = user.entrySet().iterator();
        while (it.hasNext()) {
            String userid = it.next().getKey().toString();
            users.add(userid);
        }
        return this.delMessageByUReceiver(users.toArray(new String[users.size()]));
    }

    public boolean delMessageByRReceiver(String roleid) {
        String[] roles = new String[]{roleid};
        return this.delMessageByRReceiver(roles);
    }

    public boolean delMessageByOReceiver(String[] organiseid) {
        if (organiseid == null || organiseid.length < 1) {
            return true;
        }
        TreeMap user = User.getUserByDept(organiseid, "");
        ArrayList<String> users = new ArrayList<String>();
        Iterator it = user.entrySet().iterator();
        while (it.hasNext()) {
            String userid = it.next().getKey().toString();
            users.add(userid);
        }
        return this.delMessageByUReceiver(users.toArray(new String[users.size()]));
    }

    public boolean delMessageByOReceiver(String organiseid) {
        String[] organs = new String[]{organiseid};
        return this.delMessageByOReceiver(organs);
    }

    public boolean delMessageById(String id) {
        String[] ids = new String[]{id};
        return this.delMessageById(ids);
    }

    public boolean delMessageById(String[] id) {
        if (id == null || id.length < 1) {
            return true;
        }
        List sql2 = MessageDao.getSqlHelper("defaultds").getDelMessageByIdSql(id);
        try {
            DbOper.executeNonQuery(sql2);
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean delMessageByOperatID(String operationid) {
        String[] operationids = new String[]{operationid};
        return this.delMessageByOperatID(operationids);
    }

    public boolean delMessageByOperatID(String[] operationid) {
        if (operationid == null || operationid.length < 1) {
            return true;
        }
        List sql2 = MessageDao.getSqlHelper("defaultds").getDelMessageByOperatIDSql(operationid);
        try {
            DbOper.executeNonQuery(sql2);
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean delMessage(String filt) {
        String sql2 = MessageDao.getSqlHelper("defaultds").getDelMessageSql(filt);
        try {
            DbOper.executeNonQuery(sql2);
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

