/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.freechart.chart;

import com.sdjxd.pms.platform.data.DataRow;
import com.sdjxd.pms.platform.data.DataTable;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.freechart.chart.ChartRequest;
import com.sdjxd.pms.platform.freechart.util.DatasetUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Rotation;
import org.jfree.util.TableOrder;

public abstract class MyChartFactory {
    private static final String NULL_TITLE_VALUE_TEXT = "\u7a7a\u503c";
    private static final double NULL_STAT_VALUE_TEXT = 0.0;
    private static final Font DEFAULT_LABEL_FONT = new Font("\u9ed1\u4f53", 0, 12);

    public static JFreeChart createPieChart(ChartRequest paramChartRequest) {
        if (paramChartRequest.getColumnHeadField() == null) {
            return MyChartFactory.createSinglePieChart(paramChartRequest);
        }
        return MyChartFactory.createMultiplePieChart(paramChartRequest);
    }

    public static JFreeChart createSinglePieChart(ChartRequest paramChartRequest) {
        PieDataset localPieDataset = MyChartFactory.createPieDataset(paramChartRequest);
        String str = paramChartRequest.getTitle();
        JFreeChart localJFreeChart = ChartFactory.createPieChart3D((String)str, (PieDataset)localPieDataset, (boolean)true, (boolean)false, (boolean)false);
        localJFreeChart.getLegend().setItemFont(DEFAULT_LABEL_FONT);
        PiePlot3D localPiePlot3D = (PiePlot3D)localJFreeChart.getPlot();
        localPiePlot3D.setStartAngle(290.0);
        localPiePlot3D.setDirection(Rotation.CLOCKWISE);
        localPiePlot3D.setForegroundAlpha(0.8f);
        localPiePlot3D.setNoDataMessage("\u6570\u636e\u96c6\u4e3a\u7a7a\u3002");
        localPiePlot3D.setLabelFont(DEFAULT_LABEL_FONT);
        localPiePlot3D.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}={2}"));
        localPiePlot3D.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}", NumberFormat.getNumberInstance(), (NumberFormat)new DecimalFormat("0.00%")));
        localPiePlot3D.setCircular(true);
        return localJFreeChart;
    }

    private static PieDataset createPieDataset(ChartRequest paramChartRequest) {
        Object localObject1;
        DataTable localDataTable;
        DefaultPieDataset localDefaultPieDataset = new DefaultPieDataset();
        String dataSourceName = paramChartRequest.getDataSourceName();
        String str1 = paramChartRequest.getSql();
        String str2 = paramChartRequest.getDisplayField();
        String str3 = paramChartRequest.getValueField();
        ArrayList<String> localArrayList = null;
        String str4 = paramChartRequest.getColumnHeadSql();
        if (str4 != null) {
            localDataTable = MyChartFactory.executeQuery(dataSourceName, str4);
            localArrayList = new ArrayList<String>();
            for (DataRow localDataRow : localDataTable.getRows()) {
                localObject1 = localDataRow.getValue(0);
                if (localObject1 != null) {
                    localArrayList.add(localObject1.toString());
                    continue;
                }
                localArrayList.add(NULL_TITLE_VALUE_TEXT);
            }
        }
        localDataTable = MyChartFactory.executeQuery(dataSourceName, str1);
        for (DataRow localDataRow : localDataTable.getRows()) {
            localObject1 = localDataRow.getValue(str2);
            Object localObject2 = localDataRow.getValue(str3);
            String str5 = localObject1 == null ? NULL_TITLE_VALUE_TEXT : String.valueOf(localObject1);
            double d = localObject2 == null ? 0.0 : Double.parseDouble(localObject2.toString());
            localDefaultPieDataset.setValue((Comparable)((Object)str5), d);
        }
        if (localArrayList != null) {
            DatasetUtil.sortPieDataset(localDefaultPieDataset, localArrayList);
        }
        return localDefaultPieDataset;
    }

    public static JFreeChart createMultiplePieChart(ChartRequest paramChartRequest) {
        CategoryDataset localCategoryDataset = MyChartFactory.createCategoryDataset(paramChartRequest);
        if (localCategoryDataset.getRowCount() == 1) {
            paramChartRequest.setDisplayField(paramChartRequest.getColumnHeadField());
            return MyChartFactory.createSinglePieChart(paramChartRequest);
        }
        JFreeChart localJFreeChart1 = ChartFactory.createMultiplePieChart3D((String)paramChartRequest.getTitle(), (CategoryDataset)localCategoryDataset, (TableOrder)TableOrder.BY_COLUMN, (boolean)true, (boolean)false, (boolean)false);
        localJFreeChart1.getLegend().setItemFont(DEFAULT_LABEL_FONT);
        MultiplePiePlot localMultiplePiePlot = (MultiplePiePlot)localJFreeChart1.getPlot();
        localMultiplePiePlot.setBackgroundPaint((Paint)Color.white);
        localMultiplePiePlot.setOutlineStroke((Stroke)new BasicStroke(1.0f));
        JFreeChart localJFreeChart2 = localMultiplePiePlot.getPieChart();
        PiePlot localPiePlot = (PiePlot)localJFreeChart2.getPlot();
        localPiePlot.setBackgroundPaint(null);
        localPiePlot.setOutlineStroke(null);
        localPiePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} ({2})", NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance()));
        localPiePlot.setMaximumLabelWidth(0.2);
        localPiePlot.setLabelFont(DEFAULT_LABEL_FONT);
        localPiePlot.setCircular(true);
        return localJFreeChart1;
    }

    private static CategoryDataset createCategoryDataset(ChartRequest paramChartRequest) {
        Object localObject3;
        DataTable localDataTable;
        DefaultCategoryDataset localDefaultCategoryDataset = new DefaultCategoryDataset();
        String dataSourceName = paramChartRequest.getDataSourceName();
        String str1 = paramChartRequest.getSql();
        String str2 = paramChartRequest.getDisplayField();
        String str3 = paramChartRequest.getColumnHeadField();
        String str4 = paramChartRequest.getValueField();
        ArrayList<String> localArrayList = null;
        String str5 = paramChartRequest.getColumnHeadSql();
        if (str5 != null) {
            localDataTable = MyChartFactory.executeQuery(dataSourceName, str5);
            localArrayList = new ArrayList<String>();
            for (Cloneable localObject2 : localDataTable.getRows()) {
                localObject3 = ((DataRow)localObject2).getValue(0);
                if (localObject3 != null) {
                    localArrayList.add(localObject3.toString());
                    continue;
                }
                localArrayList.add(NULL_TITLE_VALUE_TEXT);
            }
        }
        localDataTable = MyChartFactory.executeQuery(dataSourceName, str1);
        if (str3 == null) {
            for (Cloneable localObject2 : localDataTable.getRows()) {
                localObject3 = ((DataRow)localObject2).getValue(str2);
                Object localObject4 = ((DataRow)localObject2).getValue(str4);
                String localObject5 = localObject3 == null ? NULL_TITLE_VALUE_TEXT : String.valueOf(localObject3);
                double d1 = localObject4 == null ? 0.0 : Double.parseDouble(localObject4.toString());
                localDefaultCategoryDataset.setValue(d1, (Comparable)((Object)localObject5), (Comparable)((Object)NULL_TITLE_VALUE_TEXT));
            }
            if (localArrayList != null) {
                DatasetUtil.sortCategoryDataset(localDefaultCategoryDataset, localArrayList, 2);
            }
        } else {
            Object localObject6;
            for (Cloneable localObject2 : localDataTable.getRows()) {
                localObject3 = ((DataRow)localObject2).getValue(str2);
                Iterator localObject4 = ((DataRow)localObject2).getValue(str3);
                Object localObject5 = ((DataRow)localObject2).getValue(str4);
                localObject6 = localObject3 == null ? NULL_TITLE_VALUE_TEXT : String.valueOf(localObject3);
                String str6 = localObject4 == null ? NULL_TITLE_VALUE_TEXT : String.valueOf(localObject4);
                double d2 = localObject5 == null ? 0.0 : Double.parseDouble(localObject5.toString());
                localDefaultCategoryDataset.setValue(d2, (Comparable)localObject6, (Comparable)((Object)str6));
            }
            if (localArrayList != null) {
                String localObject1 = paramChartRequest.getRowHeadSql();
                if (localObject1 != null) {
                    Cloneable localObject2;
                    localObject2 = new ArrayList();
                    localObject3 = MyChartFactory.executeQuery(dataSourceName, localObject1);
                    for (Object localObject5 : ((DataTable)localObject3).getRows()) {
                        localObject6 = ((DataRow)localObject5).getValue(0);
                        if (localObject6 != null) {
                            ((ArrayList)localObject2).add(localObject6.toString());
                            continue;
                        }
                        ((ArrayList)localObject2).add(NULL_TITLE_VALUE_TEXT);
                    }
                    if (((ArrayList)localObject2).size() > 0) {
                        DatasetUtil.sortCategoryDataset(localDefaultCategoryDataset, localArrayList, (ArrayList)localObject2);
                    }
                } else {
                    DatasetUtil.sortCategoryDataset(localDefaultCategoryDataset, localArrayList, 1);
                }
            }
        }
        return localDefaultCategoryDataset;
    }

    public static JFreeChart createBarChart(ChartRequest paramChartRequest) {
        String localObject;
        CategoryDataset localCategoryDataset = MyChartFactory.createCategoryDataset(paramChartRequest);
        if (localCategoryDataset.getRowCount() == 1 && (localObject = paramChartRequest.getColumnHeadField()) != null) {
            paramChartRequest.setDisplayField(localObject);
            paramChartRequest.setColumnHeadField(null);
            localCategoryDataset = MyChartFactory.createCategoryDataset(paramChartRequest);
        }
        localObject = ChartFactory.createBarChart3D((String)paramChartRequest.getTitle(), null, null, (CategoryDataset)localCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        ((JFreeChart)localObject).getLegend().setItemFont(DEFAULT_LABEL_FONT);
        CategoryPlot localCategoryPlot = (CategoryPlot)((JFreeChart)localObject).getPlot();
        localCategoryPlot.setDomainGridlinesVisible(true);
        CategoryAxis localCategoryAxis = localCategoryPlot.getDomainAxis();
        if (paramChartRequest.getColumnHeadField() == null) {
            localCategoryAxis.setVisible(false);
        } else {
            localCategoryAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.39269908169872414));
            localCategoryAxis.setCategoryMargin(0.0);
        }
        BarRenderer3D localBarRenderer3D = new BarRenderer3D();
        localBarRenderer3D.setDrawBarOutline(false);
        localBarRenderer3D.setMaximumBarWidth(0.1);
        localBarRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        localBarRenderer3D.setBaseItemLabelsVisible(true);
        localBarRenderer3D.setItemLabelAnchorOffset(1.0);
        localBarRenderer3D.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_LEFT));
        localCategoryPlot.setRenderer((CategoryItemRenderer)localBarRenderer3D);
        return (JFreeChart)localObject;
    }

    public static JFreeChart createLineChart(ChartRequest paramChartRequest) {
        if (paramChartRequest.getColumnHeadField() == null) {
            return MyChartFactory.createSingleLineChart(paramChartRequest);
        }
        return MyChartFactory.createMultipleLineChart(paramChartRequest);
    }

    public static JFreeChart createSingleLineChart(ChartRequest paramChartRequest) {
        String[] arrayOfString = paramChartRequest.getValueField().split(",");
        boolean bool = arrayOfString.length > 1;
        JFreeChart localJFreeChart = ChartFactory.createLineChart((String)paramChartRequest.getTitle(), null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)bool, (boolean)true, (boolean)false);
        if (bool) {
            localJFreeChart.getLegend().setItemFont(DEFAULT_LABEL_FONT);
        }
        CategoryPlot localCategoryPlot = (CategoryPlot)localJFreeChart.getPlot();
        DataTable localDataTable = MyChartFactory.executeQuery(paramChartRequest.getDataSourceName(), paramChartRequest.getSql());
        int i = 0;
        while (i < arrayOfString.length) {
            Object localObject2;
            DataRow localObject12;
            DefaultCategoryDataset localDefaultCategoryDataset = new DefaultCategoryDataset();
            for (DataRow localObject12 : localDataTable.getRows()) {
                localObject2 = localObject12.getValue(arrayOfString[i]);
                double d = localObject2 == null ? 0.0 : Double.valueOf(localObject2.toString());
                Object localObject3 = localObject12.getValue(paramChartRequest.getDisplayField());
                String str = localObject3 == null ? NULL_TITLE_VALUE_TEXT : localObject3.toString();
                localDefaultCategoryDataset.addValue(d, (Comparable)((Object)arrayOfString[i]), (Comparable)((Object)str));
            }
            localCategoryPlot.setDataset(i, (CategoryDataset)localDefaultCategoryDataset);
            localObject12 = new NumberAxis(null);
            ((NumberAxis)localObject12).setLabelFont(DEFAULT_LABEL_FONT);
            ((NumberAxis)localObject12).setUpperMargin(0.1);
            localCategoryPlot.setRangeAxis(i, (ValueAxis)localObject12);
            localCategoryPlot.mapDatasetToRangeAxis(i, i);
            localObject2 = localCategoryPlot.getDomainAxis();
            ((CategoryAxis)localObject2).setLowerMargin(0.05);
            ((CategoryAxis)localObject2).setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            ((CategoryAxis)localObject2).setLabelFont(DEFAULT_LABEL_FONT);
            LineAndShapeRenderer localLineAndShapeRenderer = new LineAndShapeRenderer();
            localLineAndShapeRenderer.setBaseShapesVisible(true);
            localLineAndShapeRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
            localLineAndShapeRenderer.setBaseItemLabelsVisible(true);
            localCategoryPlot.setRenderer(i, (CategoryItemRenderer)localLineAndShapeRenderer);
            if (i > 2) {
                ((NumberAxis)localObject12).setVisible(false);
            }
            ++i;
        }
        return localJFreeChart;
    }

    public static JFreeChart createMultipleLineChart(ChartRequest paramChartRequest) {
        Object localObject5;
        Object localObject4;
        Object localObject3;
        DataRow localObject22;
        DefaultCategoryDataset localDefaultCategoryDataset = new DefaultCategoryDataset();
        String dataSourceName = paramChartRequest.getDataSourceName();
        String str1 = paramChartRequest.getSql();
        String str2 = paramChartRequest.getDisplayField();
        String str3 = paramChartRequest.getColumnHeadField();
        String str4 = paramChartRequest.getValueField();
        DataTable localDataTable = MyChartFactory.executeQuery(dataSourceName, str1);
        for (DataRow localObject22 : localDataTable.getRows()) {
            localObject3 = localObject22.getValue(str2);
            localObject4 = localObject22.getValue(str3);
            localObject5 = localObject22.getValue(str4);
            String str5 = localObject3 == null ? NULL_TITLE_VALUE_TEXT : String.valueOf(localObject3);
            String str6 = localObject4 == null ? NULL_TITLE_VALUE_TEXT : String.valueOf(localObject4);
            double d = localObject5 == null ? 0.0 : Double.parseDouble(localObject5.toString());
            localDefaultCategoryDataset.setValue(d, (Comparable)((Object)str6), (Comparable)((Object)str5));
        }
        JFreeChart localObject1 = ChartFactory.createLineChart3D((String)paramChartRequest.getTitle(), null, null, (CategoryDataset)localDefaultCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        localObject22 = (CategoryPlot)localObject1.getPlot();
        localObject3 = ((CategoryPlot)localObject22).getDomainAxis();
        ((CategoryAxis)localObject3).setLowerMargin(0.05);
        ((CategoryAxis)localObject3).setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        ((CategoryAxis)localObject3).setLabelFont(DEFAULT_LABEL_FONT);
        localObject4 = new LineAndShapeRenderer();
        ((LineAndShapeRenderer)localObject4).setBaseShapesVisible(true);
        ((LineAndShapeRenderer)localObject4).setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        ((LineAndShapeRenderer)localObject4).setBaseItemLabelsVisible(true);
        ((CategoryPlot)localObject22).setRenderer((CategoryItemRenderer)localObject4);
        localObject5 = localObject1.getLegend();
        if (localObject5 != null) {
            ((LegendTitle)localObject5).setItemFont(DEFAULT_LABEL_FONT);
        }
        return localObject1;
    }

    private static DataTable executeQuery(String dataSourceName, String paramString) {
        return DbOper.executeDataTable(dataSourceName, paramString);
    }
}

