/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.freechart.chart;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.freechart.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class ChartRequest {
    private static final String PARAM_KEY_SQL = "sql";
    private static final String PARAM_KEY_TITLE = "title";
    private static final String PARAM_KEY_GRAPH_TYPE = "graphType";
    private static final String PARAM_KEY_DISPLAY_FIELD = "displayField";
    private static final String PARAM_KEY_VALUE_FIELD = "valueField";
    private static final String PARAM_KEY_WIDTH = "width";
    private static final String PARAM_KEY_HEIGHT = "height";
    private static final String PARAM_KEY_COLUMN_HEAD_SQL = "columnHeadSql";
    private static final String PARAM_KEY_ROW_HEAD_SQL = "rowHeadSql";
    private String sql;
    private String dataSourceName;
    private String title;
    private String graphType;
    private String valueField;
    private String displayField;
    private String columnHeadField;
    private int width;
    private int height;
    private String columnHeadSql;
    private String rowHeadSql;

    public static ChartRequest parse() {
        try {
            Global.getContext().setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ChartRequest localChartRequest = new ChartRequest();
        localChartRequest.setSql(Global.getContext().getParameter(PARAM_KEY_SQL));
        localChartRequest.setDataSourceName(Global.getContext().getParameter("dataSourceName"));
        localChartRequest.setTitle(Global.getContext().getParameter(PARAM_KEY_TITLE));
        localChartRequest.setGraphType(Global.getContext().getParameter(PARAM_KEY_GRAPH_TYPE));
        localChartRequest.setDisplayField(Global.getContext().getParameter(PARAM_KEY_DISPLAY_FIELD));
        localChartRequest.setValueField(Global.getContext().getParameter(PARAM_KEY_VALUE_FIELD));
        localChartRequest.setWidth(Integer.parseInt(Global.getContext().getParameter(PARAM_KEY_WIDTH)));
        localChartRequest.setHeight(Integer.parseInt(Global.getContext().getParameter(PARAM_KEY_HEIGHT)));
        localChartRequest.setColumnHeadSql(Global.getContext().getParameter(PARAM_KEY_COLUMN_HEAD_SQL));
        localChartRequest.setRowHeadSql(Global.getContext().getParameter(PARAM_KEY_ROW_HEAD_SQL));
        return localChartRequest;
    }

    private void printInfo() {
        StringBuffer localStringBuffer = new StringBuffer();
        localStringBuffer.append(PARAM_KEY_SQL).append(":").append(this.getSql()).append("\n");
        localStringBuffer.append(PARAM_KEY_TITLE).append(":").append(this.getTitle()).append("\n");
        localStringBuffer.append(PARAM_KEY_GRAPH_TYPE).append(":").append(this.graphType).append("\n");
        localStringBuffer.append(PARAM_KEY_DISPLAY_FIELD).append(":").append(this.displayField).append("\n");
        localStringBuffer.append(PARAM_KEY_VALUE_FIELD).append(":").append(this.valueField).append("\n");
        localStringBuffer.append(PARAM_KEY_COLUMN_HEAD_SQL).append(":").append(this.columnHeadSql).append("\n");
        localStringBuffer.append(PARAM_KEY_ROW_HEAD_SQL).append(":").append(this.rowHeadSql).append("\n");
        System.out.println(localStringBuffer.toString());
    }

    public String generateKey() {
        String str = String.valueOf(this.sql) + this.graphType + this.valueField + this.displayField + this.width + this.height + this.columnHeadSql + this.rowHeadSql;
        return String.valueOf(Math.abs(str.hashCode()));
    }

    public String getSql() {
        return this.sql;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setSql(String paramString) {
        this.sql = paramString;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String paramString) {
        this.title = "null".equals(paramString) ? null : paramString;
    }

    public String getGraphType() {
        return this.graphType;
    }

    public void setGraphType(String paramString) {
        this.graphType = paramString;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setValueField(String paramString) {
        this.valueField = paramString;
    }

    public String getDisplayField() {
        return this.displayField;
    }

    public void setDisplayField(String paramString) {
        if (paramString == null) {
            this.displayField = paramString;
        } else if (paramString.indexOf(",") != -1) {
            List localList = StringUtil.split(paramString, ',');
            if (localList.size() > 1) {
                this.displayField = (String)localList.get(0);
                this.setColumnHeadField((String)localList.get(1));
            } else {
                this.displayField = (String)localList.get(0);
            }
        } else {
            this.displayField = paramString;
        }
    }

    public String getColumnHeadField() {
        return this.columnHeadField;
    }

    public void setColumnHeadField(String paramString) {
        this.columnHeadField = paramString;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int paramInt) {
        this.width = paramInt;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int paramInt) {
        this.height = paramInt;
    }

    public String getColumnHeadSql() {
        return this.columnHeadSql;
    }

    public void setColumnHeadSql(String paramString) {
        this.columnHeadSql = paramString;
    }

    public String getRowHeadSql() {
        return this.rowHeadSql;
    }

    public void setRowHeadSql(String paramString) {
        this.rowHeadSql = paramString;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }
}

