/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.freechart.chart;

import com.sdjxd.pms.platform.freechart.chart.CachedChart;
import com.sdjxd.pms.platform.freechart.chart.CachedChartType;
import com.sdjxd.pms.platform.freechart.chart.ChartCacheManager;
import com.sdjxd.pms.platform.freechart.chart.ChartRequest;
import com.sdjxd.pms.platform.freechart.chart.MyChartFactory;
import com.sdjxd.pms.platform.freechart.chart.SizedJFreeChart;
import java.awt.image.BufferedImage;
import org.jfree.chart.JFreeChart;

public class ChartManager {
    private static final CachedChartType DEFAULT_CACHED_CHART_TYPE = CachedChartType.BUFFEREDIMAGE;
    private static ChartManager instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChartManager getInstance() {
        if (instance != null) return instance;
        Class<ChartManager> clazz = ChartManager.class;
        synchronized (ChartManager.class) {
            if (instance != null) return instance;
            instance = new ChartManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public CachedChart getChartById(String paramString) {
        return ChartCacheManager.getInstance().get(paramString);
    }

    public CachedChart getChart(ChartRequest paramChartRequest) {
        String str = paramChartRequest.generateKey();
        CachedChart localCachedChart = ChartCacheManager.getInstance().get(str);
        if (localCachedChart == null) {
            localCachedChart = new CachedChart(str);
            localCachedChart.setChartType(DEFAULT_CACHED_CHART_TYPE);
            JFreeChart localJFreeChart = this.createChart(paramChartRequest);
            switch (DEFAULT_CACHED_CHART_TYPE.getValue()) {
                case 1: {
                    SizedJFreeChart localSizedJFreeChart = new SizedJFreeChart(localJFreeChart, paramChartRequest.getWidth(), paramChartRequest.getHeight());
                    localCachedChart.setChart(localSizedJFreeChart);
                    break;
                }
                case 2: {
                    BufferedImage localBufferedImage = localJFreeChart.createBufferedImage(paramChartRequest.getWidth(), paramChartRequest.getHeight());
                    localCachedChart.setChart(localBufferedImage);
                }
            }
            ChartCacheManager.getInstance().set(str, localCachedChart);
        }
        return localCachedChart;
    }

    private JFreeChart createChart(ChartRequest paramChartRequest) {
        String str = paramChartRequest.getGraphType();
        if ("0".equals(str)) {
            return MyChartFactory.createPieChart(paramChartRequest);
        }
        if ("1".equals(str)) {
            return MyChartFactory.createBarChart(paramChartRequest);
        }
        if ("2".equals(str)) {
            return MyChartFactory.createLineChart(paramChartRequest);
        }
        return null;
    }
}

