/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.sql.oracle;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.service.CellIndex;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FormDataSql
extends com.sdjxd.pms.platform.form.sql.FormDataSql {
    @Override
    public void saveFormIndex(FormInstance form, List list) throws Exception {
        StringBuffer sql2 = new StringBuffer(512);
        StringBuffer sqlColumnValue = new StringBuffer(256);
        Form pattern = form.getPattern();
        String dbUser = pattern.getDataUserName();
        sql2.append("INSERT INTO ");
        sql2.append(dbUser);
        sql2.append(pattern.getIndexTable());
        sql2.append("(");
        TreeMap indexType = pattern.getCellIndex();
        for (Map.Entry entry : form.getIndex().entrySet()) {
            String columnName = (String)entry.getKey();
            String columnValue = (String)entry.getValue();
            if (indexType.get(columnName) == null) {
                throw new Exception("\u672a\u627e\u5230\u5b57\u6bb5:" + columnName);
            }
            String columnType = ((CellIndex)indexType.get((Object)columnName)).type;
            if (columnType.equalsIgnoreCase("blob") || columnType.equalsIgnoreCase("clob")) continue;
            sql2.append(columnName);
            sql2.append(",");
            if (columnType.equalsIgnoreCase("INTEGER") || columnType.equalsIgnoreCase("int") || columnType.equalsIgnoreCase("DECIMAL") || columnType.equalsIgnoreCase("float") || columnType.equalsIgnoreCase("double") || columnType.equalsIgnoreCase("SMALLINT") || columnType.equalsIgnoreCase("BIGINT")) {
                sqlColumnValue.append(",");
                if (columnValue == null || columnValue.trim().length() == 0) {
                    sqlColumnValue.append("NULL");
                    continue;
                }
                sqlColumnValue.append(columnValue);
                continue;
            }
            sqlColumnValue.append(",");
            sqlColumnValue.append("'");
            if (columnValue != null) {
                sqlColumnValue.append(DbOper.toDb(columnValue));
            }
            sqlColumnValue.append("'");
        }
        if (sqlColumnValue.length() > 0) {
            sql2.setLength(sql2.length() - 1);
            sql2.append(") VALUES(");
            sql2.append(sqlColumnValue.substring(1));
            sql2.append(")");
            list.add(sql2.toString());
        }
    }

    @Override
    public void modifyFormIndex(FormInstance form, List list) {
        Form pattern = form.getPattern();
        String pkColumn = pattern.getIndexTablePkCol();
        if (pkColumn == null || pkColumn.equals("")) {
            pkColumn = "SHEETID";
        }
        StringBuffer sql2 = new StringBuffer(512);
        sql2.append("UPDATE ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getIndexTable());
        sql2.append(" SET ");
        TreeMap indexType = pattern.getCellIndex();
        for (Map.Entry entry : form.getIndex().entrySet()) {
            String columnName = (String)entry.getKey();
            String columnValue = (String)entry.getValue();
            CellIndex cellIndex = (CellIndex)indexType.get(columnName);
            if (cellIndex == null) {
                System.out.print("\u6a21\u677f\u5bf9\u5e94\u8868\u7f3a\u5c11\u5b57\u6bb5\uff1a");
                System.out.println(columnName);
                continue;
            }
            String columnType = cellIndex.type;
            if (columnType.equalsIgnoreCase("blob") || columnType.equalsIgnoreCase("clob")) continue;
            sql2.append(columnName);
            sql2.append("=");
            if (columnType.equalsIgnoreCase("INTEGER") || columnType.equalsIgnoreCase("int") || columnType.equalsIgnoreCase("DECIMAL") || columnType.equalsIgnoreCase("float") || columnType.equalsIgnoreCase("double") || columnType.equalsIgnoreCase("SMALLINT") || columnType.equalsIgnoreCase("BIGINT")) {
                sql2.append(columnValue != null && columnValue.length() != 0 ? columnValue : "NULL");
            } else {
                sql2.append("'");
                if (columnValue != null) {
                    sql2.append(DbOper.toDb(columnValue));
                }
                sql2.append("'");
            }
            sql2.append(",");
        }
        sql2.setLength(sql2.length() - 1);
        sql2.append(" WHERE ");
        sql2.append(pkColumn);
        sql2.append("='");
        sql2.append(form.getId());
        sql2.append("'");
        list.add(sql2.toString());
    }

    @Override
    public void saveFormIndexBlob(FormInstance form, List sqlList, List inputStreamList, List lenList) throws Exception {
        Form pattern = form.getPattern();
        String dbUser = pattern.getDataUserName();
        StringBuffer blobSql = new StringBuffer();
        TreeMap indexType = pattern.getCellIndex();
        for (Map.Entry entry : form.getIndex().entrySet()) {
            String columnType;
            String columnName = (String)entry.getKey();
            String columnValue = (String)entry.getValue();
            if (indexType.get(columnName) == null) {
                throw new Exception("\u672a\u627e\u5230\u5b57\u6bb5:" + columnName);
            }
            if (StringTool.isEmpty(columnValue) || !(columnType = ((CellIndex)indexType.get((Object)columnName)).type).equalsIgnoreCase("blob") && !columnType.equalsIgnoreCase("clob")) continue;
            blobSql.append("update ");
            blobSql.append(dbUser);
            blobSql.append(pattern.getIndexTable());
            blobSql.append(" set ");
            blobSql.append(columnName);
            blobSql.append(" = ? where ");
            blobSql.append(pattern.getIndexTablePkCol());
            blobSql.append(" = '");
            blobSql.append(form.getId());
            blobSql.append("'");
            sqlList.add(blobSql.toString());
            byte[] columnValueArr = columnValue.getBytes("GBK");
            ByteArrayInputStream is = new ByteArrayInputStream(columnValueArr);
            inputStreamList.add(is);
            lenList.add(new Integer(columnValueArr.length));
        }
    }

    @Override
    public void saveFormHistoryIndex(FormInstance form, List list) throws Exception {
        StringBuffer sql2 = new StringBuffer(512);
        StringBuffer sqlColumnValue = new StringBuffer(256);
        Form pattern = form.getPattern();
        String dbUser = pattern.getDataUserName();
        sql2.append("INSERT INTO ");
        sql2.append(dbUser);
        sql2.append(pattern.getHistoryTable());
        sql2.append("(");
        TreeMap indexType = pattern.getHistoryIndex();
        for (Map.Entry entry : form.getHistoryindex().entrySet()) {
            String columnName = (String)entry.getKey();
            System.out.println("columnName = " + columnName);
            String columnValue = (String)entry.getValue();
            if (indexType.get(columnName) == null) {
                throw new Exception("\u672a\u627e\u5230\u5b57\u6bb5:" + columnName);
            }
            String columnType = ((CellIndex)indexType.get((Object)columnName)).type;
            if (columnType.equalsIgnoreCase("blob") || columnType.equalsIgnoreCase("clob")) continue;
            sql2.append(columnName);
            sql2.append(",");
            if (columnType.equalsIgnoreCase("INTEGER") || columnType.equalsIgnoreCase("int") || columnType.equalsIgnoreCase("DECIMAL") || columnType.equalsIgnoreCase("float") || columnType.equalsIgnoreCase("double") || columnType.equalsIgnoreCase("SMALLINT") || columnType.equalsIgnoreCase("BIGINT")) {
                sqlColumnValue.append(",");
                if (columnValue == null || columnValue.trim().length() == 0) {
                    sqlColumnValue.append(-1);
                    continue;
                }
                sqlColumnValue.append(columnValue);
                continue;
            }
            sqlColumnValue.append(",");
            sqlColumnValue.append("'");
            if (columnValue != null) {
                sqlColumnValue.append(DbOper.toDb(columnValue));
            }
            sqlColumnValue.append("'");
        }
        if (sqlColumnValue.length() > 0) {
            sql2.setLength(sql2.length() - 1);
            sql2.append(") VALUES(");
            sql2.append(sqlColumnValue.substring(1));
            sql2.append(")");
            list.add(sql2.toString());
        }
    }

    @Override
    public void modifyFormHistoryIndex(FormInstance form, List list) {
        Form pattern = form.getPattern();
        String pkColumn = "SHEETID";
        StringBuffer sql2 = new StringBuffer(512);
        sql2.append("UPDATE ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getHistoryTable());
        sql2.append(" SET ");
        TreeMap indexType = pattern.getHistoryIndex();
        for (Map.Entry entry : form.getHistoryindex().entrySet()) {
            String columnName = (String)entry.getKey();
            String columnValue = (String)entry.getValue();
            CellIndex cellIndex = (CellIndex)indexType.get(columnName);
            if (cellIndex == null) {
                System.out.print("\u6a21\u677f\u5bf9\u5e94\u8868\u7f3a\u5c11\u5b57\u6bb5\uff1a");
                System.out.println(columnName);
                continue;
            }
            String columnType = cellIndex.type;
            if (columnType.equalsIgnoreCase("blob") || columnType.equalsIgnoreCase("clob")) continue;
            sql2.append(columnName);
            sql2.append("=");
            if (columnType.equalsIgnoreCase("INTEGER") || columnType.equalsIgnoreCase("int") || columnType.equalsIgnoreCase("DECIMAL") || columnType.equalsIgnoreCase("float") || columnType.equalsIgnoreCase("double") || columnType.equalsIgnoreCase("SMALLINT") || columnType.equalsIgnoreCase("BIGINT")) {
                sql2.append(columnValue != null && columnValue.length() != 0 ? columnValue : "NULL");
            } else {
                sql2.append("'");
                if (columnValue != null) {
                    sql2.append(DbOper.toDb(columnValue));
                }
                sql2.append("'");
            }
            sql2.append(",");
        }
        sql2.setLength(sql2.length() - 1);
        sql2.append(" WHERE ");
        sql2.append(pkColumn);
        sql2.append("='");
        sql2.append(form.getHistorysheetid());
        sql2.append("'");
        list.add(sql2.toString());
    }
}

