/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.sql;

import com.sdjxd.pms.platform.base.Constants;
import com.sdjxd.pms.platform.base.DataStatus;
import com.sdjxd.pms.platform.base.MaxID;
import com.sdjxd.pms.platform.data.DataSource;
import com.sdjxd.pms.platform.form.model.InfoShowColumn;
import com.sdjxd.pms.platform.form.model.InfoShowTable;
import com.sdjxd.pms.platform.form.model.LinkApp;
import com.sdjxd.pms.platform.form.model.LinkAppTable;
import com.sdjxd.pms.platform.form.service.CellIndex;
import com.sdjxd.pms.platform.form.service.FieldValue;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.cell.ListStyle;
import com.sdjxd.pms.platform.form.service.cell.easyui.ListExtend;
import com.sdjxd.pms.platform.table.service.Table;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.fileupload.FileItem;

public class PatternSql {
    public String getCommonData(String tableName, String columnName, String condition, String orderSql) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT ");
        sql2.append(columnName);
        sql2.append(" FROM ");
        sql2.append(tableName);
        DataSource dataSource = DataSource.getDataSource();
        if ("sql".equalsIgnoreCase(dataSource.getDbType().getName())) {
            sql2.append(" WITH(NOLOCK) ");
        }
        sql2.append(" ");
        sql2.append(condition);
        if (orderSql != null) {
            sql2.append(" ").append(orderSql);
        }
        return sql2.toString();
    }

    public String getCssSql() {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT STYLECODE,STYLENAME,STYLETEXT FROM ");
        sql2.append("[S].JXD7_PM_STYLE ORDER BY STYLECODE");
        return sql2.toString();
    }

    public String getPatternArea(String patternId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT AREAID,AREATYPE,AREASTYLE");
        sql2.append(",AREANAME,X1,Y1,AREAWIDTH,AREAHEIGHT");
        sql2.append(",DWTYPE,ISQUERY,CELLDWTYPE,NEEDSCROLL, WIDTHSCALE, HEIGHTSCALE,ALIGNSTYLE,AREACELL,ZINDEX,AREARSTYLE FROM ");
        sql2.append("[S].JXD7_PM_AREAINFO WHERE PATTERNID='");
        sql2.append(patternId);
        sql2.append("' ORDER BY AREACELL,Y1,X1,AREAID");
        return sql2.toString();
    }

    public String getPatternCell(String patternId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT CELLID,CELLTYPEID,CELLEXTENDTYPEID,USERCELLTYPEID,FONTID2,AREAID,CELLNAME,MAXSIZE");
        sql2.append(",CELLLABEL,X1,Y1,WIDTH,HEIGHT,TEXTCOLORSTYLE,BORDERCOLOR");
        sql2.append(",READBKCOLORSTYLE,BKCOLORSTYLE,ALIGNSTYLE,FONTSTYLE");
        sql2.append(",ISPRINT,COMMWORDTYPE,CELLGROUPINFO,CHECKCONDITION");
        sql2.append(",DTEXTNUM,VALUEFIELD,TEXTFIELD,SLAVESIGNCELLS,ASSITINFO,USERDEFINFO,MEANID");
        sql2.append(",(select ASSITINFO from [S].JXD7_XT_ATTRIMEAN A");
        sql2.append(" where a.MEANID = P.MEANID) as MEANINFO");
        sql2.append(",(select MEANTYPE from [S].JXD7_XT_ATTRIMEAN A");
        sql2.append(" where a.MEANID = P.MEANID) as MEANTYPE");
        sql2.append(",(select DATASOURCENAME from [S].JXD7_XT_ATTRIMEAN A");
        sql2.append(" where a.MEANID = P.MEANID) as MEANDATASOURCENAME");
        sql2.append(",COMPARETEXT,COMPARETYPEID,LINEWIDTH,CREATEDATE,LIMIT,READONLY, WIDTHSCALE, HEIGHTSCALE, ISNEEDSAVE, TABLELINKID, LIMITINFO,ZINDEX,DEFAULTVALUETIME");
        sql2.append(",VERIFYMEAN,ENTITYATTRIBUTEID ");
        sql2.append(" FROM [S].JXD7_PM_PATTERNCELL P WHERE PATTERNID='");
        sql2.append(patternId);
        sql2.append("'");
        sql2.append(" ORDER BY Y1,X1,CELLID");
        return sql2.toString();
    }

    public String getPatternParameter(String patternId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT PARAMETERID, PARAMETERNAME, PARAMETERTYPE, PARAMETERVALUE ");
        sql2.append("FROM [S].JXD7_PM_PATTERNPARAMETER ");
        sql2.append("WHERE PATTERNID='");
        sql2.append(patternId);
        sql2.append("' ");
        sql2.append("ORDER BY PARAMETERID");
        return sql2.toString();
    }

    public String getPatternCondition(String patternId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT CONDITIONID,CONDITIONNAME,OPERATORONE");
        sql2.append(",OPERATORTWO,CONDITIONTYPE,COMPARETYPE FROM [S].JXD7_PM_CONDITION WHERE PATTERNID='");
        sql2.append(patternId);
        sql2.append("' ORDER BY CONDITIONID");
        return sql2.toString();
    }

    public String getPatternData(String patternId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT DIRECTORYID,MODULEID,PATTERNNAME,PATTERNTYPE");
        sql2.append(",SHEETSIZE,PATTERNWIDTH,PATTERNHEIGHT,PATTERNDIRECT");
        sql2.append(",BKCOLOR,PAGECOUNT,TABLENAME,SHEETPATTERNID");
        sql2.append(",ATTACHPATTERNID,DEVTYPE,CREATEDATE,ISAUTOCENTER");
        sql2.append(",WIDTHSCALE,HEIGHTSCALE,FORM_EVENTS,LIMITINFO,LINKVIEWID,DATASOURCENAME,DATAUSERNAME");
        sql2.append(",ISABSOLUTE,SCREENMODE,SJFS,USEDLIMITGROUPIDS");
        sql2.append(" FROM [S].JXD7_PM_PATTERN ");
        sql2.append(" WHERE PATTERNID='").append(patternId).append("'");
        sql2.append(" AND DATASTATUSID=").append(DataStatus.NORMAL);
        return sql2.toString();
    }

    public String getPatternEvent(String patternId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT C.CELLID,C.EVENTID,C.ACTIONID,C.PARAMID,C.PARAMNAME");
        sql2.append(",C.PARAMVALUE,C.ACTIONORDER,P.PARAMORDER,E.EVENTCODE");
        sql2.append(",A.ACTIONCODE,A.ACTIONNAME,A.JSORJAVA,A.PARAMETER");
        sql2.append(",ISNEGLECT,CANBACK ,P.PARAMTYPEID,P.DEFAULTVALUE,P.PARAMDESCRIPTION FROM [S].JXD7_PM_CELLACTION C");
        sql2.append(" INNER JOIN [S].JXD7_PM_ACTION A ON C.ACTIONID=A.ACTIONID");
        sql2.append(" INNER JOIN [S].JXD7_PM_EVENT E ON C.EVENTID=E.EVENTID");
        sql2.append(" LEFT OUTER JOIN [S].JXD7_PM_ACTIONPARAM P ON P.PARAMID=C.PARAMID");
        sql2.append(" AND P.ACTIONID=A.ACTIONID");
        sql2.append(" WHERE C.PATTERNID='");
        sql2.append(patternId);
        sql2.append("' ORDER BY C.CELLID,ACTIONORDER,P.PARAMORDER");
        return sql2.toString();
    }

    public String getGridEvent(String actionId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT C.ACTIONID,C.PARAMID,C.PARAMNAME,C.PARAMORDER,A.ACTIONCODE,A.ACTIONNAME,A.JSORJAVA");
        sql2.append(",A.PARAMETER,ISNEGLECT,CANBACK ,C.PARAMTYPEID,C.DEFAULTVALUE,C.PARAMDESCRIPTION ");
        sql2.append(" FROM JXD7_PM_ACTIONPARAM C INNER JOIN JXD7_PM_ACTION A ON C.ACTIONID=A.ACTIONID");
        sql2.append(" WHERE A.ACTIONID='").append(actionId).append("'");
        sql2.append(" ORDER BY C.PARAMORDER");
        return sql2.toString();
    }

    public String getPatternScript(String patternId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT DISTINCT * FROM (");
        sql2.append("SELECT S.SID,S.PACKAGENAME,S.SNAME,S.FILEPATH,S.SCRIPTTYPE,S.SORTBY FROM ");
        sql2.append("[S].JXD7_PM_SCRIPTPATTERN P,");
        sql2.append("[S].JXD7_PM_SCRIPT S WHERE S.SID=P.SID");
        sql2.append(" AND P.PATTERNID='{pId}'");
        sql2.append(" union ");
        sql2.append("SELECT S.SID,S.PACKAGENAME,S.SNAME,S.FILEPATH,S.SCRIPTTYPE,S.SORTBY FROM ");
        sql2.append("[S].JXD7_PM_SCRIPTCELL SC, [S].JXD7_PM_SCRIPT S, ");
        sql2.append("(SELECT distinct CELLTYPEID FROM [S].JXD7_PM_PATTERNCELL WHERE PATTERNID='{pId}') P ");
        sql2.append("WHERE SC.DEPENDSID=S.SID and SC.CELLTYPE=P.CELLTYPEID");
        sql2.append(" union ");
        sql2.append("SELECT S.SID,S.PACKAGENAME,S.SNAME,S.FILEPATH,S.SCRIPTTYPE,S.SORTBY FROM ");
        sql2.append("[S].JXD7_PM_SCRIPTCELL SC, [S].JXD7_PM_SCRIPT S, ");
        sql2.append("(SELECT distinct 51 as CELLTYPEID FROM [S].JXD7_PM_AREAINFO WHERE PATTERNID='{pId}') P ");
        sql2.append("WHERE SC.DEPENDSID=S.SID and SC.CELLTYPE=P.CELLTYPEID");
        sql2.append(" union ");
        sql2.append("SELECT S.SID,S.PACKAGENAME,S.SNAME,S.FILEPATH,S.SCRIPTTYPE,S.SORTBY FROM ");
        sql2.append("[S].JXD7_PM_PATTERNCELL P,[S].JXD7_PM_USERCELLTYPEACTION CA,[S].JXD7_PM_ACTION A,[S].JXD7_PM_SCRIPT S ");
        sql2.append("WHERE PATTERNID='{pId}' and P.USERCELLTYPEID is not null and P.USERCELLTYPEID <> '' ");
        sql2.append("and S.SID=A.SID and A.ACTIONID=CA.ACTIONID and CA.USERCELLTYPEID=P.USERCELLTYPEID");
        sql2.append(") T ORDER BY SORTBY");
        String sqlString = sql2.toString();
        sqlString = StringTool.replace(sqlString, "{pId}", String.valueOf(patternId));
        sqlString = StringTool.replace(sqlString, "{useId}", "" + DataStatus.NORMAL);
        return sqlString;
    }

    public String getPatternLinkedCss(String patternId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT FILEPATH FROM [S].JXD7_PM_PATTERNCSS WHERE PATTERNID='").append(patternId).append("'");
        String sqlString = sql2.toString();
        return sqlString;
    }

    public String getScriptPattern(String scriptId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT P.PATTERNID,P.SID");
        sql2.append(" FROM [S].JXD7_PM_SCRIPTPATTERN P");
        sql2.append(" WHERE P.SID='{sId}'");
        sql2.append(" ORDER BY P.PATTERNID");
        String sqlString = sql2.toString();
        sqlString = StringTool.replace(sqlString, "{sId}", String.valueOf(scriptId));
        return sqlString;
    }

    public String getTableColumn(String dataUserName, String tableName) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT * FROM ");
        if (tableName.length() > 0 && tableName.indexOf(",") == -1) {
            sql2.append(dataUserName == null ? "[S]." : dataUserName);
        }
        sql2.append(tableName);
        sql2.append(" WHERE 1=2");
        return sql2.toString();
    }

    public String modifyFormIndex(Form pattern, TreeMap index) {
        StringBuffer sql2 = new StringBuffer(512);
        sql2.append("UPDATE ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getIndexTable());
        sql2.append(" SET ");
        TreeMap indexType = pattern.getCellIndex();
        for (Map.Entry entry : index.entrySet()) {
            String columnName = (String)entry.getKey();
            String columnValue = (String)entry.getValue();
            sql2.append(columnName);
            sql2.append("=");
            String columnType = ((CellIndex)indexType.get((Object)columnName)).type;
            if (columnType.equals("int") || columnType.equals("INTEGER")) {
                sql2.append(columnValue != null ? columnValue : "-1");
            } else {
                sql2.append("'");
                if (columnValue != null) {
                    sql2.append(columnValue);
                }
                sql2.append("'");
            }
            sql2.append(",");
        }
        sql2.setLength(sql2.length() - 1);
        String pkCol = pattern.getIndexTablePkCol();
        if (StringTool.isEmpty(pkCol)) {
            pkCol = "SHEETID";
        }
        sql2.append(" WHERE ").append(pkCol).append("='");
        sql2.append(index.get(pkCol)).append("'");
        return sql2.toString();
    }

    public String getInfoShowTableByStyleIdSQL(String styleId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT T.TABLEID, T.TABLENAME, T.TABLEMSG, J.PROJECTID, J.PROJECTNAME, J.TITLEWIDTH, J.ROWHEIGHT, J.ISTWOCOLUMN, J.PROJECTTYPE, J.ISDEFAULT, J.ATTPROJECTID,T.DATASOURCENAME,T.DATAUSERNAME FROM ");
        sql2.append("[S].JXD7_XT_JMPROJECT J,");
        sql2.append("[S].JXD7_XT_SYSTABLEINFO T");
        sql2.append(" WHERE J.TABLEID=T.TABLEID AND J.PROJECTID='").append(styleId).append("'");
        return sql2.toString();
    }

    public String getInfoShowColumnSql(String tableId, String styleId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT C.TABLEID, C.COLUMNID, C.COLUMNNAME, C.COLUMNTYPE, C.COLUMNLENGTH, C.ALLOWNULL, C.COLUMNLENGTH, C.COLMEANID, PC.ISREADONLY, AM.MEANNAME, AM.ASSITINFO, AM.MEANTYPE, AM.ALLOWMULSEL,PC.ALLOWNULL AS PALLOWNULL, PC.SHOWNAME , PC.ROWHEIGHT , PC.ISVISIBLE, PC.SHOWORDER, PC.ISWHOLEROW, PC.DEFAULTVALUE,AM.DATASOURCENAME FROM ");
        sql2.append("[S].JXD7_XT_COLUMNS C left outer join ");
        sql2.append("[S].JXD7_XT_ATTRIMEAN AM on C.COLMEANID = AM.MEANID,");
        sql2.append("[S].JXD7_XT_JMPROJECT JM,");
        sql2.append("[S].JXD7_XT_PROJECTCOLUMNS PC");
        sql2.append(" WHERE  JM.PROJECTID = PC.PROJECTID AND JM.TABLEID=C.TABLEID AND PC.COLUMNID = C.COLUMNID AND PC.ISVISIBLE<>0  ");
        sql2.append(" AND JM.PROJECTID='").append(styleId).append("'");
        sql2.append(" AND JM.TABLEID='").append(tableId).append("'");
        sql2.append(" ORDER BY PC.SHOWORDER ");
        return sql2.toString();
    }

    public String getSaveInfoShowSql(InfoShowTable table) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("");
        StringBuffer values = new StringBuffer(128);
        StringBuffer propertys = new StringBuffer(128);
        FieldValue[] data = table.getData();
        int editType = table.getEditType();
        String pkColValue = table.getKeyValue();
        String pkColId = table.getPkCol();
        String tableName = table.getTableName();
        String dataSourceName = table.getDataSourceName();
        String dataUserName = table.getDataUserName();
        List columns = table.getColumns();
        if (editType == 0) {
            int i = 0;
            while (i < columns.size()) {
                InfoShowColumn col = (InfoShowColumn)columns.get(i);
                String columnId = col.getColumnId();
                if (!columnId.toUpperCase().equals("SHOWORDER")) {
                    int j = 0;
                    while (j < data.length) {
                        if (data[j].getField().equals(columnId)) {
                            String columnValue = data[j].getValue();
                            if (columnId.equals(pkColId)) {
                                columnValue = pkColValue;
                            }
                            if (columnValue == null || columnValue.length() == 0) {
                                values.append(",NULL");
                            } else if (columnValue.equals(Constants.resources_blankRootNodeId)) {
                                values.append(",NULL");
                            } else {
                                if (columnValue.equals("empty_blob()")) break;
                                values.append(",'").append(columnValue.replaceAll("'", "''")).append("'");
                            }
                            propertys.append(",").append(columnId);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (Table.isExistColumn(dataSourceName, dataUserName, tableName, "SHOWORDER")) {
                propertys.append(",").append("SHOWORDER");
                values.append(",").append(MaxID.getMaxID(tableName, "SHOWORDER", 3));
            }
            sql2.append("INSERT INTO ").append(dataUserName).append(tableName);
            sql2.append("(" + propertys.substring(1) + ") ");
            sql2.append("VALUES(" + values.substring(1) + ")");
        } else if (editType == 1) {
            StringBuffer setSql = new StringBuffer(128);
            int i = 0;
            while (i < columns.size()) {
                InfoShowColumn col = (InfoShowColumn)columns.get(i);
                String columnId = col.getColumnId();
                if (!columnId.toUpperCase().equals(pkColId)) {
                    int j = 0;
                    while (j < data.length) {
                        if (data[j].getField().equals(columnId)) {
                            String columnValue = data[j].getValue();
                            if (columnValue == null || columnValue.length() == 0) {
                                setSql.append(",").append(columnId).append("=NULL");
                                break;
                            }
                            if (columnValue.equals("empty_blob()")) break;
                            setSql.append(",").append(columnId).append("='").append(columnValue.trim().replaceAll("'", "''")).append("'");
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            sql2.append("UPDATE ").append(dataUserName).append(tableName);
            sql2.append(" SET ").append(setSql.substring(1));
            sql2.append(" WHERE ").append(pkColId).append("='").append(pkColValue).append("'");
        }
        return sql2.toString();
    }

    public String getColumnValueSQL(String dataUserName, String tableName, String sheetId, String keyColumnName) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT * FROM ");
        sql2.append(dataUserName).append(tableName);
        sql2.append(" WHERE ").append(keyColumnName).append("='").append(sheetId).append("'");
        return sql2.toString();
    }

    public String getColumnValueSQL(String dataUserName, String tableName, String sheetId, String columns, String keyColId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT " + columns + " FROM ");
        sql2.append(dataUserName).append(tableName);
        sql2.append(" WHERE " + keyColId + "='").append(sheetId).append("'");
        return sql2.toString();
    }

    public String getColumnInfoSql(String tableId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT COLUMNID, COLUMNNAME, COLUMNTYPE, ALLOWNULL FROM [S].JXD7_XT_COLUMNS");
        sql2.append(" WHERE TABLEID='").append(tableId).append("'");
        return sql2.toString();
    }

    public String getInfoShowStyleSql(String styleId) {
        StringBuffer sb = new StringBuffer();
        sb.append("select * from [S].JXD7_XT_JMPROJECT");
        sb.append(" where projectid='").append(styleId).append("'");
        return sb.toString();
    }

    public String getInfoShowStyleDefaultSql(String tableId) {
        StringBuffer sb = new StringBuffer();
        sb.append("select * from [S].JXD7_XT_JMPROJECT");
        sb.append(" where TABLEID='").append(tableId).append("' AND ISDEFAULT=1");
        return sb.toString();
    }

    public String getNameByIdSQL(String dataUserName, String tableName, String nameCol, String idCol, String idValue) {
        StringBuffer sb = new StringBuffer();
        sb.append("select " + nameCol + " from ");
        sb.append(dataUserName).append(tableName);
        sb.append(" where " + idCol + "='").append(idValue).append("'");
        return sb.toString();
    }

    public String getLinkAppRootNodeSQL(LinkApp linkApp) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT T.").append(linkApp.getKeyColumn()).append(" AS SHEETID ");
        if (linkApp.getAttField() != null && linkApp.getAttField().length() != 0) {
            sb.append("," + linkApp.getAttField());
        }
        sb.append(" FROM ").append(linkApp.getDataUserName()).append(linkApp.getTableName()).append(" T ");
        if (linkApp.getAttTable() != null && linkApp.getAttTable().length() != 0) {
            sb.append("," + linkApp.getAttTable());
        }
        if (linkApp.getFilter() != null && linkApp.getFilter().length() != 0) {
            sb.append(" WHERE ").append(linkApp.getFilter());
        }
        if (linkApp.getFilterOfLimit() != null && linkApp.getFilterOfLimit().length() != 0) {
            sb.append(" AND (").append(linkApp.getFilterOfLimit()).append(")");
        }
        if (linkApp.getOrderBy() != null && linkApp.getOrderBy().length() != 0) {
            sb.append(" ORDER BY ").append(linkApp.getOrderBy());
        }
        return sb.toString();
    }

    public String getLinkAppTableNodeSQL(LinkAppTable lat, String sheetId, String isGroup, String gId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT T.").append(lat.getKeyColumn()).append(" AS SHEETID ");
        if (lat.getAttField() != null && lat.getAttField().length() != 0) {
            sb.append("," + lat.getAttField());
        }
        sb.append(" FROM ").append(lat.getDataUserName()).append(lat.getTableName()).append(" T ");
        if (lat.getAttTable() != null && lat.getAttTable().length() != 0) {
            sb.append("," + lat.getAttTable());
        }
        sb.append(" WHERE ").append(" (T.").append(lat.getLinkColumn()).append(")='").append(sheetId.trim()).append("'");
        if ("1".equals(isGroup) && (gId == null || !gId.startsWith("\u9644\u52a0\u5206\u7ec4"))) {
            sb.append(" AND T.").append(lat.getGroupColumn());
            if (gId.length() == 0) {
                sb.append(" is NULL");
            } else {
                sb.append(" ='").append(gId).append("'");
            }
        }
        if (lat.getAllFilter() != null && lat.getAllFilter().length() != 0) {
            sb.append(" AND ").append(lat.getAllFilter());
        }
        if (lat.getOrderBy() != null && lat.getOrderBy().length() != 0) {
            sb.append(" ORDER BY ").append(lat.getOrderBy());
        }
        return sb.toString();
    }

    public String getSimpleLinkAppTableNodeSQL(LinkAppTable lat, String parentDataUserName, String parentTableName, String parentLinkColumn, String parentPKColumn, String parentSheetId) {
        StringBuffer sb = new StringBuffer();
        if (parentTableName == null) {
            sb.append(" SELECT DISTINCT T.").append(lat.getLinkColumn()).append(" AS SHEETID ");
            sb.append(" FROM ").append(lat.getDataUserName()).append(lat.getTableName()).append(" T ");
            if (lat.getAttTable() != null && lat.getAttTable().length() != 0) {
                sb.append("," + lat.getAttTable());
            }
            if (lat.getAllFilter() != null && lat.getAllFilter().length() != 0) {
                sb.append(" WHERE ").append(lat.getAllFilter());
            }
        } else {
            sb.append(" SELECT DISTINCT T.").append(lat.getLinkColumn()).append(" AS SHEETID ");
            sb.append(" FROM ").append(lat.getDataUserName()).append(lat.getTableName()).append(" T ");
            if (lat.getAttTable() != null && lat.getAttTable().length() != 0) {
                sb.append("," + lat.getAttTable());
            }
            sb.append(", ").append(parentDataUserName).append(parentTableName);
            sb.append(" WHERE T.").append(lat.getLinkColumn()).append("=").append(parentDataUserName).append(parentTableName).append(".").append(parentPKColumn);
            if (parentLinkColumn != null) {
                sb.append(" and ").append(parentDataUserName).append(parentTableName).append(".").append(parentLinkColumn).append("='").append(parentSheetId).append("'");
            }
            if (lat.getAllFilter() != null && lat.getAllFilter().length() != 0) {
                sb.append(" and ").append(lat.getAllFilter());
            }
        }
        return sb.toString();
    }

    public String getLinkAppTableSQL(String appId, String tableId) {
        StringBuffer sb = new StringBuffer();
        sb.append("select LAT.*,TI.TABLENAME,TI.TABLEMSG,LI.LINKCOLUMNID,TI.DATAUSERNAME from ");
        sb.append("[S].JXD7_XT_LINKINFO LI, ");
        sb.append("[S].JXD7_XT_LINKAPPLINK LAL, ");
        sb.append("[S].JXD7_XT_SYSTABLEINFO TI, ");
        sb.append("[S].JXD7_XT_LINKAPPTABLE LAT ");
        sb.append(" where LAT.APPID='").append(appId).append("' ");
        sb.append(" and LAL.APPID='").append(appId).append("'");
        sb.append(" and LAL.SHOWTYPE in (").append(2).append(",");
        sb.append(3).append(",");
        sb.append(4).append(")");
        sb.append(" and LI.PTABLEID='").append(tableId).append("'");
        sb.append(" and LI.LINKID=LAL.LINKID and LI.CTABLEID=LAT.TABLEID and LAL.LINKID=LAT.LINKID and TI.TABLEID=LAT.TABLEID");
        sb.append(" order by LAL.SHOWORDER");
        return sb.toString();
    }

    public String getLinkAppTableGroupNodeSQL(LinkAppTable lat, String sheetId) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT T.").append(lat.getGroupColumn()).append(" AS GROUPNAME ");
        sb.append(" FROM ").append(lat.getDataUserName()).append(lat.getTableName()).append(" T ");
        sb.append(" WHERE T.").append(lat.getLinkColumn()).append(" ='").append(sheetId).append("'");
        if (lat.getAllFilter() != null && lat.getAllFilter().length() != 0) {
            sb.append(" AND ").append(lat.getAllFilter());
        }
        sb.append(" GROUP BY T.").append(lat.getGroupColumn());
        sb.append(" ORDER BY T.").append(lat.getGroupColumn()).append(" ").append(lat.getGroupOrderby());
        return sb.toString();
    }

    public String getColumnPropertyInfo(String tableId, String columnName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.MEANTYPE, A.ASSITINFO,A.DATASOURCENAME  FROM ");
        sb.append("[S].JXD7_XT_COLUMNS C ,");
        sb.append("[S].JXD7_XT_ATTRIMEAN A ");
        sb.append(" WHERE A.MEANID=C.COLMEANID AND C.TABLEID='").append(tableId).append("' AND  C.COLUMNID='").append(columnName).append("'");
        return sb.toString();
    }

    public String getListStyle(String styleId) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT STYLEID,STYLENAME,TABLEID,ORDERFIELD,FILTERSQL,HEADERSORT,PAGEDATASIZE,ALLOWPAGE,ISLOADDATA,LINKVIEWID,ISAUTOHEIGHT");
        sb.append(" FROM [S].JXD7_PM_LISTSTYLE WHERE STYLEID=");
        sb.append("'").append(styleId).append("'");
        return sb.toString();
    }

    public String getListStyleColumn(String styleId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT C.STYLEID, C.COLUMNID, C.SHOWNAME, C.SHOWORDER, C.MEANID,");
        sb.append("   C.COLUMNWIDTH, C.COLUMNTYPE, C.HALIGN, C.CELLSTYLE, C.EVENTINFO,");
        sb.append("   C.EVENTARG, C.ASSITINFO,C.VERIFYMEAN ");
        sb.append(" FROM [S].JXD7_PM_LISTSTYLECOLUMN C ");
        sb.append(" WHERE STYLEID='").append(styleId).append("'");
        sb.append(" ORDER BY SHOWORDER");
        return sb.toString();
    }

    public String getViewInfo(String tableId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT VIEWFIELDINFO, VIEWCONDITION ");
        sql2.append("FROM [S].JXD7_XT_SYSVIEWINFO ");
        sql2.append("WHERE VIEWID = '").append(tableId).append("'");
        return sql2.toString();
    }

    public String getDataCount(String dataUserName, String tableName, String query) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT COUNT(1) FROM ");
        if (tableName != null && !tableName.substring(0, 1).equals("(")) {
            sb.append(dataUserName);
        }
        sb.append(tableName);
        sb.append(" WHERE ").append(StringTool.replaceKeyWord(query));
        return sb.toString();
    }

    public String getPageListData(ListStyle style) {
        StringBuffer sb = new StringBuffer(128);
        String field = style.getField();
        String tableName = style.getTableName();
        String pk = style.getPkCol();
        String query = style.getQuery();
        String order = style.getOrderField();
        int pageDataSize = style.getPageDataSize();
        int pageIndex = style.getPageIndex();
        int start = (pageIndex - 1) * pageDataSize;
        sb.append("SELECT TOP ").append(pageDataSize).append(" ").append(field);
        sb.append(" FROM ");
        if (tableName != null && !tableName.substring(0, 1).equals("(")) {
            sb.append(style.getDataUserName());
        }
        sb.append(tableName);
        sb.append(" WHERE (").append(query);
        sb.append(")");
        if (start > 0) {
            sb.append(" AND ").append(pk).append(" NOT IN (").append("select ").append(pk).append(" from (");
            sb.append("SELECT TOP ").append(start).append(" ").append(field);
            sb.append(" FROM ");
            if (tableName != null && !tableName.substring(0, 1).equals("(")) {
                sb.append(style.getDataUserName());
            }
            sb.append(tableName);
            sb.append(" WHERE ").append(query);
            sb.append(" ORDER BY ").append(order);
            sb.append(")temp20151009)");
        }
        sb.append(" ORDER BY ").append(order);
        return sb.toString();
    }

    public String getAllListData(ListStyle style) {
        StringBuffer sb = new StringBuffer(128);
        String field = style.getField();
        String tableName = style.getTableName();
        String query = style.getQuery();
        String order = style.getOrderField();
        sb.append("SELECT ").append(" ").append(field).append(" FROM ");
        if (tableName != null && !tableName.substring(0, 1).equals("(")) {
            sb.append(style.getDataUserName());
        }
        sb.append(tableName).append(" WHERE ").append(query);
        sb.append(" ORDER BY ").append(order);
        return sb.toString();
    }

    public String getAllListData(ListStyle style, Map param) {
        StringBuffer sb = new StringBuffer(128);
        String field = style.getField();
        String tableName = style.getTableName();
        String query = style.getQuery(null, param);
        String order = style.getOrderField();
        sb.append("SELECT ").append(" ").append(field).append(" FROM ");
        if (tableName != null && !tableName.substring(0, 1).equals("(")) {
            sb.append(style.getDataUserName());
        }
        sb.append(tableName).append(" WHERE ").append(query);
        sb.append(" ORDER BY ").append(order);
        return sb.toString();
    }

    public String getEvent() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT EVENTID,EVENTNAME,EVENTCODE");
        sb.append(" FROM [S].JXD7_PM_EVENT ORDER BY EVENTID");
        return sb.toString();
    }

    public String deleteData(String dataUserName, String tableName, String pkCol, String formId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("DELETE FROM ");
        sql2.append(dataUserName);
        sql2.append(tableName);
        sql2.append(" WHERE ");
        sql2.append(pkCol);
        sql2.append("='");
        sql2.append(formId);
        sql2.append("'");
        return sql2.toString();
    }

    public String saveCommonsFileSql(String fileId, String fileType, String userid, FileItem fileItem, String sheetid, String filePath) {
        return this.saveCommonsFileSql(fileId, fileType, userid, fileItem, sheetid, filePath, null);
    }

    public String saveCommonsFileSql(String fileId, String fileType, String userid, FileItem fileItem, String sheetid, String filePath, String fileNames) {
        String fName;
        String fileName = null;
        int begin = fileItem.getName().lastIndexOf("\\");
        fileName = fName = fileItem.getName().substring(begin + 1, fileItem.getName().length());
        return this.saveDiskFileSql(fileId, fileName, fileItem.getContentType(), userid, fileItem.getSize(), sheetid, filePath, fileNames);
    }

    public String saveCommonsFileToDbSql(String fileId, String fileType, String userid, FileItem fileItem, String sheetid) {
        String fName;
        String fileName = null;
        int begin = fileItem.getName().lastIndexOf("\\");
        fileName = fName = fileItem.getName().substring(begin + 1, fileItem.getName().length());
        return this.saveDbFileSql(fileId, fileName, fileItem.getContentType(), userid, fileItem.getSize(), sheetid);
    }

    public String saveDbFileSql(String fileId, String localFileName, String contentType, String createUserId, long fileSize, String formInstanceId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("INSERT INTO [SFILE].JXD7_PM_FILE");
        sql2.append("(ID,FILENAME,CONTENTTYPE,FILESIZE,");
        sql2.append("CREATEUSERID,CREATEDATE,FILETYPE, STARTDATA, ENDDATA,SHEETID,FILEDATA)");
        sql2.append(" VALUES('").append(fileId).append("'");
        sql2.append(",'").append(localFileName).append("'");
        sql2.append(",'").append(contentType).append("'");
        sql2.append(",-1");
        sql2.append(",'").append(createUserId).append("'");
        sql2.append(",'").append(DateTool.getNow()).append("'");
        sql2.append(",NULL");
        sql2.append(",0,").append(fileSize).append(",'" + StringTool.nullToStr(formInstanceId) + "',?)");
        return sql2.toString();
    }

    public String saveDiskFileSql(String fileId, String localFileName, String contentType, String createUserId, long streamSize, String formInstanceId, String savePath, String saveFileName) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("INSERT INTO [SFILE].JXD7_PM_FILE");
        sql2.append("(ID,FILENAME,CONTENTTYPE,FILESIZE,");
        sql2.append("CREATEUSERID,CREATEDATE,FILETYPE, STARTDATA, ENDDATA,SHEETID,PATH,REALFILENAME,NEEDDEL)");
        sql2.append(" VALUES('").append(fileId).append("'");
        sql2.append(",'").append(localFileName).append("'");
        sql2.append(",'").append(contentType).append("'");
        sql2.append(",-1");
        sql2.append(",'").append(createUserId).append("'");
        sql2.append(",'").append(DateTool.getNow()).append("'");
        sql2.append(",NULL");
        sql2.append(",0,").append(streamSize).append(",'" + StringTool.nullToStr(formInstanceId) + "'");
        sql2.append(",'").append(savePath).append("'");
        if (!StringTool.isEmpty(saveFileName)) {
            sql2.append(",'").append(saveFileName).append("'");
        } else {
            sql2.append(",'").append(localFileName).append("'");
        }
        sql2.append(",'needDel')");
        return sql2.toString();
    }

    public String delCommonsFileSql(String fileId) {
        StringBuffer sql2 = new StringBuffer(128);
        sql2.append("DELETE FROM [SFILE].JXD7_PM_FILE");
        sql2.append(" WHERE ID='");
        sql2.append(fileId);
        sql2.append("'");
        return sql2.toString();
    }

    public String getFile(String fileId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT FILENAME,CONTENTTYPE,FILEDATA FROM [SFILE].JXD7_PM_FILE");
        sql2.append(" WHERE ID='").append(fileId).append("'");
        return sql2.toString();
    }

    public String getCellIdByPatternField(String patternId, String field) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT CELLID,TEXTFIELD,VALUEFIELD FROM [S].JXD7_PM_PATTERNCELL");
        sql2.append(" WHERE PATTERNID='");
        sql2.append(patternId);
        sql2.append("' AND (TEXTFIELD='");
        sql2.append(field);
        sql2.append("' OR VALUEFIELD='");
        sql2.append(field);
        sql2.append("')");
        return sql2.toString();
    }

    public String getPatternCellAttributes(String patternId, String cellId) {
        StringBuffer sql2 = new StringBuffer().append("select ATTRIBUTEID,ATTRIBUTEVALUE  from [S].JXD7_PM_CELLATTRIBUTE").append(" where patternid= '").append(patternId).append("'").append(" and cellid = '").append(cellId).append("'");
        return sql2.toString();
    }

    public String getPatternCellExtAttrs(String patternId) {
        StringBuffer sql2 = new StringBuffer().append("SELECT CELLID, ATTRIBUTEID,ATTRIBUTEVALUE  FROM [S].JXD7_PM_CELLATTRIBUTE").append(" WHERE PATTERNID= '").append(patternId).append("' ORDER BY CELLID ASC");
        return sql2.toString();
    }

    public String getListExtend(String styleId) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT STYLEID,STYLENAME,TABLEID,NEWLINE,PKFIELD,ALLOWPAGE,PAGESIZE,OPTIONALPAGE,MUTICOLSORT,SORTWAY,SQLINFO, ISLOADDATA, SERVERSORT");
        sb.append(" FROM [S].JXD7_PM_LISTEXTEND WHERE STYLEID=");
        sb.append("'").append(styleId).append("'");
        return sb.toString();
    }

    public String getListExtendColumn(String styleId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT STYLEID, COLUMNID, COLUMNTITLE, COLUMNTYPE, FREEZEN, OPTIONTYPE, VERIFYMEAN,");
        sb.append("   DATAALIGN, TITLEALIGN, COLUMNWIDTH, EDITOPTION ");
        sb.append(" FROM [S].JXD7_PM_EXTENDCOLUMN  ");
        sb.append(" WHERE STYLEID='").append(styleId).append("'");
        sb.append(" ORDER BY SHOWORDER");
        return sb.toString();
    }

    public String getExtendPageListData(ListExtend style) {
        String sqlInfo = style.getSqlInfo();
        String query = style.getQuery();
        if (sqlInfo == null || sqlInfo.trim().equals("")) {
            StringBuffer sb = new StringBuffer(128);
            String field = style.getField();
            String tableName = style.getTableName();
            String pk = style.getPkCol();
            String[] pks = (String[])style.getStyleData().getPkField();
            int i = 0;
            while (i < pks.length && pks.length >= 2) {
                pk = i == 0 ? "cast(" + pks[i] + " as varchar)" : String.valueOf(pk) + "+ cast(" + pks[i] + " as varchar)";
                ++i;
            }
            String order = style.getOrderField();
            int pageDataSize = style.getPageDataSize();
            int pageIndex = style.getPageIndex();
            int start = (pageIndex - 1) * pageDataSize;
            sb.append("SELECT TOP ").append(pageDataSize).append(" ").append(field);
            sb.append(" FROM ");
            if (tableName != null && !tableName.substring(0, 1).equals("(")) {
                sb.append(style.getDataUserName());
            }
            sb.append(tableName);
            sb.append(" WHERE (").append(query);
            sb.append(")");
            if (start > 0) {
                sb.append(" AND ").append(pk).append(" NOT IN (");
                sb.append("SELECT TOP ").append(start).append(" ").append(pk);
                sb.append(" FROM ");
                if (tableName != null && !tableName.substring(0, 1).equals("(")) {
                    sb.append(style.getDataUserName());
                }
                sb.append(tableName);
                sb.append(" WHERE ").append(query);
                sb.append(" ORDER BY ").append(order);
                sb.append(")");
            }
            sb.append(" ORDER BY ").append(order);
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer(128);
        String order = style.getOrderField();
        String pk = style.getPkCol();
        int pageDataSize = style.getPageDataSize();
        int pageIndex = style.getPageIndex();
        int start = (pageIndex - 1) * pageDataSize;
        sb.append("SELECT TOP ").append(pageDataSize).append(" _t.* FROM (").append(sqlInfo).append(") _t ");
        sb.append(" WHERE (").append(query);
        sb.append(")");
        if (start > 0) {
            sb.append(" AND _t.");
            sb.append(pk).append(" NOT IN (");
            sb.append("SELECT TOP ").append(start).append(" _m.").append(pk);
            sb.append(" FROM (").append(sqlInfo).append(") _m");
            sb.append(" WHERE (").append(query);
            sb.append(")");
            if (order != null && !order.trim().equals("")) {
                sb.append(" ORDER BY ").append(order);
            }
            sb.append(" )");
        }
        if (order != null && !order.trim().equals("")) {
            sb.append(" ORDER BY ").append(order);
        }
        return sb.toString();
    }

    public String getExtendAllListData(ListExtend style) {
        String sqlInfo = style.getSqlInfo();
        if (sqlInfo == null || sqlInfo.trim().equals("")) {
            StringBuffer sb = new StringBuffer(128);
            String field = style.getField();
            String tableName = style.getTableName();
            String query = style.getQuery();
            String order = style.getOrderField();
            sb.append("SELECT ").append(" ").append(field).append(" FROM ");
            if (tableName != null && !tableName.substring(0, 1).equals("(")) {
                sb.append(style.getDataUserName());
            }
            sb.append(tableName).append(" WHERE ").append(query);
            sb.append(" ORDER BY ").append(order);
            return sb.toString();
        }
        return sqlInfo;
    }
}

