/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.sql;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.permit72.service.support.PermitCtrl;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.model.FormInstanceBean;
import com.sdjxd.pms.platform.form.service.CellIndex;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.FormParameterData;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.cell.ins.UploadImgIns;
import com.sdjxd.pms.platform.form.service.cell.ins.UploadIns;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FormDataSql {
    public String getFormIndex(FormInstance form) {
        return this.getFormIndex(form.getPattern(), form.getId());
    }

    public String getFormIndex(Form pattern, String formId) {
        User user;
        String pkColumn = pattern.getIndexTablePkCol();
        if (pkColumn == null || pkColumn.equals("")) {
            pkColumn = "SHEETID";
        }
        StringBuffer sql2 = new StringBuffer();
        List cons = pattern.getControls();
        sql2.append("SELECT * FROM ");
        if (pattern.isViewIndexTable() == 2) {
            sql2.append("(");
            sql2.append(pattern.getViewSql());
            sql2.append(") T");
            sql2.append(" WHERE A0_").append(pkColumn).append("='");
        } else {
            sql2.append(pattern.getDataUserName());
            sql2.append(pattern.getIndexTable());
            sql2.append(" WHERE ").append(pkColumn).append("='");
        }
        sql2.append(formId);
        sql2.append("'");
        if ("1".equals(Global.getConfig("isDataLimitControl")) && (user = User.getCurrentUser()) != null) {
            String table = pattern.getIndexTable();
            String userId = user.getId();
            HashSet<String> cols = new HashSet<String>();
            int i = 0;
            int length = cons.size();
            while (i < length) {
                ICell con = (ICell)cons.get(i);
                String v = con.getValueField();
                String t = con.getTextField();
                if (!StringTool.isEmpty(v)) {
                    cols.add(v);
                }
                if (!StringTool.isEmpty(t)) {
                    cols.add(t);
                }
                ++i;
            }
            ArrayList<String> colNames = new ArrayList<String>();
            Iterator it = cols.iterator();
            while (it.hasNext()) {
                colNames.add((String)it.next());
            }
            PermitCtrl permit = new PermitCtrl();
            String limitSql = permit.getLimitSql(userId, table, Const.TABLEOPER.SELECT, colNames);
            if (!StringTool.isEmpty(limitSql)) {
                limitSql = StringTool.replaceKeyWord(limitSql);
                sql2.append(" and ").append(limitSql);
            }
        }
        return sql2.toString();
    }

    public String getHistoryIndex(Form pattern, String formId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT * FROM ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getHistoryTable());
        sql2.append(" WHERE SHEETID ='");
        sql2.append(formId);
        sql2.append("'");
        return sql2.toString();
    }

    public String getFormInstanceBeanSql(String formInstanceId) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT SHEETID,SHEETNAME,SHOWORDER,PATTERNID,DATASTATUSID,LASTOPENTIME,OPENER,OPENERID,LASTSAVETIME,EDITUSER,EDITUSERID,CREATEDATE,CREATEDEPT,CREATEDEPTID,CREATEORG,CREATEORGID,CREATEUSER,CREATEUSERID,FLOWID,FLOWOBJECTID,FLOWNODEID,FLOWNODENAME,SHEETSTATUSID,SHEETSTATUSNAME FROM ");
        sql2.append("[S].");
        sql2.append("JXD7_PM_INDEX WHERE SHEETID='");
        sql2.append(formInstanceId);
        sql2.append("'");
        return sql2.toString();
    }

    public String delFormInstanceBean(FormInstanceBean bean) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("DELETE FROM ");
        sql2.append("[S].");
        sql2.append("JXD7_PM_INDEX WHERE SHEETID = '").append(bean.getSheetId()).append("'");
        return sql2.toString();
    }

    public String createFormInstanceBean(FormInstanceBean bean) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("INSERT INTO ");
        sql2.append("[S].");
        sql2.append("JXD7_PM_INDEX (SHEETID,SHEETNAME,SHOWORDER,PATTERNID,DATASTATUSID,LASTOPENTIME,OPENER,OPENERID,LASTSAVETIME,EDITUSER,EDITUSERID,CREATEDATE,CREATEDEPT,CREATEDEPTID,CREATEORG,CREATEORGID,CREATEUSER,CREATEUSERID,FLOWID,FLOWOBJECTID,FLOWNODEID,FLOWNODENAME,SHEETSTATUSID,SHEETSTATUSNAME) ");
        sql2.append("VALUES");
        sql2.append("(");
        sql2.append("'").append(bean.getSheetId()).append("', ");
        sql2.append("'").append(bean.getSheetName()).append("', ");
        sql2.append(bean.getShowOrder()).append(",");
        sql2.append("'").append(bean.getPatternId()).append("', ");
        sql2.append(bean.getDataStatusId()).append(",");
        sql2.append("'").append(DateTool.formatDateTime(bean.getLastopentime())).append("', ");
        sql2.append("'").append(bean.getOpener()).append("', ");
        sql2.append("'").append(bean.getOpenerid()).append("', ");
        sql2.append("'").append(DateTool.formatDateTime(bean.getLastsavetime())).append("', ");
        sql2.append("'").append(bean.getSaver()).append("', ");
        sql2.append("'").append(bean.getSaverid()).append("', ");
        sql2.append("'").append(DateTool.formatDateTime(bean.getCreatedate())).append("', ");
        sql2.append("'").append(bean.getCreatedept()).append("', ");
        sql2.append("'").append(bean.getCreatedeptid()).append("', ");
        sql2.append("'").append(bean.getCreateorg()).append("', ");
        sql2.append("'").append(bean.getCreateorgid()).append("', ");
        sql2.append("'").append(bean.getCreateuser()).append("', ");
        sql2.append("'").append(bean.getCreateuserid()).append("', ");
        sql2.append("'").append(bean.getFlowid()).append("', ");
        sql2.append("'").append(bean.getFlowobjectid()).append("', ");
        sql2.append("'").append(bean.getFlownodeid()).append("', ");
        sql2.append("'").append(bean.getFlownodename()).append("', ");
        sql2.append("'").append(bean.getSheetstatusid()).append("', ");
        sql2.append("'").append(bean.getSheetstatusname()).append("')");
        return sql2.toString();
    }

    public String modifyFormInstanceBean(FormInstanceBean bean) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("UPDATE ");
        sql2.append("[S].");
        sql2.append("JXD7_PM_INDEX SET ");
        sql2.append("SHEETNAME='").append(bean.getSheetName()).append("', ");
        sql2.append("SHOWORDER=").append(bean.getShowOrder()).append(",");
        sql2.append("PATTERNID='").append(bean.getPatternId()).append("', ");
        sql2.append("DATASTATUSID=").append(bean.getDataStatusId()).append(",");
        sql2.append("LASTOPENTIME='").append(DateTool.formatDateTime(bean.getLastopentime())).append("', ");
        sql2.append("OPENER='").append(bean.getOpener()).append("', ");
        sql2.append("OPENERID='").append(bean.getOpenerid()).append("', ");
        sql2.append("LASTSAVETIME='").append(DateTool.formatDateTime(bean.getLastsavetime())).append("', ");
        sql2.append("EDITUSER='").append(bean.getSaver()).append("', ");
        sql2.append("EDITUSERID='").append(bean.getSaverid()).append("', ");
        sql2.append("CREATEDATE='").append(DateTool.formatDateTime(bean.getCreatedate())).append("', ");
        sql2.append("CREATEDEPT='").append(bean.getCreatedept()).append("', ");
        sql2.append("CREATEDEPTID='").append(bean.getCreatedeptid()).append("', ");
        sql2.append("CREATEORG='").append(bean.getCreateorg()).append("', ");
        sql2.append("CREATEORGID='").append(bean.getCreateorgid()).append("', ");
        sql2.append("CREATEUSER='").append(bean.getCreateuser()).append("', ");
        sql2.append("CREATEUSERID='").append(bean.getCreateuserid()).append("', ");
        sql2.append("FLOWID='").append(bean.getFlowid()).append("', ");
        sql2.append("FLOWOBJECTID='").append(bean.getFlowobjectid()).append("', ");
        sql2.append("FLOWNODEID='").append(bean.getFlownodeid()).append("', ");
        sql2.append("FLOWNODENAME='").append(bean.getFlownodename()).append("', ");
        sql2.append("SHEETSTATUSID='").append(bean.getSheetstatusid()).append("', ");
        sql2.append("SHEETSTATUSNAME='").append(bean.getSheetstatusname()).append("'");
        sql2.append("WHERE SHEETID='").append(bean.getSheetId()).append("'");
        return sql2.toString();
    }

    public String getFormText(FormInstance form) {
        StringBuffer sql2 = new StringBuffer();
        Form pattern = form.getPattern();
        sql2.append("SELECT P.CELLID,SORTID,CELLVALUE,CELLTEXT FROM ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getTextTable()).append(" T, ");
        sql2.append("  JXD7_PM_PATTERNCELL P ");
        sql2.append(" WHERE T.CELLID=P.ENTITYATTRIBUTEID AND P.PATTERNID='").append(form.getPatternId()).append("' AND T.SHEETID='");
        sql2.append(form.getId());
        sql2.append("' ORDER BY T.CELLID,T.SORTID ");
        return sql2.toString();
    }

    public String getHistoryText(FormInstance form) {
        StringBuffer sql2 = new StringBuffer();
        Form pattern = form.getPattern();
        sql2.append("SELECT CELLID,SORTID,CELLVALUE,CELLTEXT FROM ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getTextHistoryTable());
        sql2.append(" WHERE SHEETID='");
        sql2.append(form.getId());
        sql2.append("' ORDER BY CELLID,SORTID");
        return sql2.toString();
    }

    public String getFormParameter(FormInstance form) {
        StringBuffer sql2 = new StringBuffer();
        Form pattern = form.getPattern();
        sql2.append("SELECT SHEETID, PARAMETERID, PARAMETERVALUE, SRCSHEETID, SRCTABLENAME, SRCPARAMETERID FROM ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getParameterTable());
        sql2.append(" WHERE SHEETID='");
        sql2.append(form.getId());
        sql2.append("' ORDER BY PARAMETERID");
        return sql2.toString();
    }

    public String deleteFormIndex(FormInstance form) {
        String pkColumn = form.getPattern().getIndexTablePkCol();
        if (pkColumn == null || pkColumn.equals("")) {
            pkColumn = "SHEETID";
        }
        Form pattern = form.getPattern();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("DELETE FROM ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getIndexTable());
        sql2.append(" WHERE ");
        sql2.append(pkColumn);
        sql2.append("='");
        sql2.append(form.getId());
        sql2.append("'");
        return sql2.toString();
    }

    public String getPataDataDeleteSql(FormInstance form) {
        StringBuffer sql2 = new StringBuffer();
        Form pattern = form.getPattern();
        sql2.append("DELETE FROM ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getParameterTable());
        sql2.append(" WHERE SHEETID='");
        sql2.append(form.getId());
        sql2.append("'");
        return sql2.toString();
    }

    public String getPataDataInsertSql(FormInstance form, FormParameterData dataItem) {
        StringBuffer sql2 = new StringBuffer();
        Form pattern = form.getPattern();
        String dbUser = pattern.getDataUserName();
        sql2.append("INSERT INTO ");
        sql2.append(dbUser).append(pattern.getParameterTable());
        sql2.append(" (SHEETID, PARAMETERID, PARAMETERVALUE, SRCTABLENAME, SRCSHEETID, SRCPARAMETERID) ");
        sql2.append("VALUES");
        sql2.append("(");
        sql2.append("'").append(form.getId()).append("', ");
        sql2.append(dataItem.getParaID()).append(", ");
        if (dataItem.getObjValue() == null) {
            sql2.append("'").append("").append("', ");
        } else {
            sql2.append("'").append(DbOper.toDb(dataItem.getObjValue())).append("', ");
        }
        sql2.append("'").append(dataItem.getObjSrcTableName()).append("', ");
        sql2.append("'").append(dataItem.getObjSrcSheetID()).append("', ");
        sql2.append(dataItem.getObjSrcParaID());
        sql2.append(")");
        return sql2.toString();
    }

    public void saveFormIndex(FormInstance form, List list) throws Exception {
        StringBuffer sql2 = new StringBuffer(512);
        StringBuffer sqlColumnValue = new StringBuffer(256);
        Form pattern = form.getPattern();
        String dbUser = pattern.getDataUserName();
        sql2.append("INSERT INTO ");
        sql2.append(dbUser);
        sql2.append(pattern.getIndexTable());
        sql2.append("(");
        TreeMap indexType = pattern.getCellIndex();
        for (Map.Entry entry : form.getIndex().entrySet()) {
            String columnName = (String)entry.getKey();
            String columnValue = (String)entry.getValue();
            if (indexType.get(columnName) == null) {
                throw new Exception("\u672a\u627e\u5230\u5b57\u6bb5:" + columnName);
            }
            String columnType = ((CellIndex)indexType.get((Object)columnName)).type;
            if (columnType.equalsIgnoreCase("image")) continue;
            sql2.append(columnName);
            sql2.append(",");
            if (columnType.equalsIgnoreCase("INTEGER") || columnType.equalsIgnoreCase("int") || columnType.equalsIgnoreCase("DECIMAL") || columnType.equalsIgnoreCase("float") || columnType.equalsIgnoreCase("double") || columnType.equalsIgnoreCase("SMALLINT") || columnType.equalsIgnoreCase("BIGINT")) {
                sqlColumnValue.append(",");
                if (columnValue == null || columnValue.trim().length() == 0) {
                    sqlColumnValue.append("NULL");
                    continue;
                }
                sqlColumnValue.append(columnValue);
                continue;
            }
            sqlColumnValue.append(",");
            sqlColumnValue.append("'");
            if (columnValue != null) {
                sqlColumnValue.append(DbOper.toDb(columnValue));
            }
            sqlColumnValue.append("'");
        }
        if (sqlColumnValue.length() > 0) {
            sql2.setLength(sql2.length() - 1);
            sql2.append(") VALUES(");
            sql2.append(sqlColumnValue.substring(1));
            sql2.append(")");
            list.add(sql2.toString());
        }
    }

    public void modifyFormIndex(FormInstance form, List list) {
        Form pattern = form.getPattern();
        String pkColumn = pattern.getIndexTablePkCol();
        if (pkColumn == null || pkColumn.equals("")) {
            pkColumn = "SHEETID";
        }
        StringBuffer sql2 = new StringBuffer(512);
        sql2.append("UPDATE ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getIndexTable());
        sql2.append(" SET ");
        TreeMap indexType = pattern.getCellIndex();
        for (Map.Entry entry : form.getIndex().entrySet()) {
            String columnName = (String)entry.getKey();
            String columnValue = (String)entry.getValue();
            CellIndex cellIndex = (CellIndex)indexType.get(columnName);
            if (cellIndex == null) {
                System.out.print("\u6a21\u677f\u5bf9\u5e94\u8868\u7f3a\u5c11\u5b57\u6bb5\uff1a");
                System.out.println(columnName);
                continue;
            }
            String columnType = cellIndex.type;
            if (columnType.equalsIgnoreCase("image")) continue;
            sql2.append(columnName);
            sql2.append("=");
            if (columnType.equalsIgnoreCase("INTEGER") || columnType.equalsIgnoreCase("int") || columnType.equalsIgnoreCase("DECIMAL") || columnType.equalsIgnoreCase("float") || columnType.equalsIgnoreCase("double") || columnType.equalsIgnoreCase("SMALLINT") || columnType.equalsIgnoreCase("BIGINT")) {
                sql2.append(columnValue != null && columnValue.length() != 0 ? columnValue : "NULL");
            } else {
                sql2.append("'");
                if (columnValue != null) {
                    sql2.append(DbOper.toDb(columnValue));
                }
                sql2.append("'");
            }
            sql2.append(",");
        }
        sql2.setLength(sql2.length() - 1);
        sql2.append(" WHERE ");
        sql2.append(pkColumn);
        sql2.append("='");
        sql2.append(form.getId());
        sql2.append("'");
        list.add(sql2.toString());
    }

    public void saveFormIndexBlob(FormInstance form, List sqlList, List inputStreamList, List lenList) throws Exception {
        Form pattern = form.getPattern();
        String dbUser = pattern.getDataUserName();
        StringBuffer blobSql = new StringBuffer();
        TreeMap indexType = pattern.getCellIndex();
        for (Map.Entry entry : form.getIndex().entrySet()) {
            String columnName = (String)entry.getKey();
            String columnValue = (String)entry.getValue();
            if (indexType.get(columnName) == null) {
                throw new Exception("\u672a\u627e\u5230\u5b57\u6bb5:" + columnName);
            }
            String columnType = ((CellIndex)indexType.get((Object)columnName)).type;
            if (!columnType.equalsIgnoreCase("image")) continue;
            blobSql.append("update ");
            blobSql.append(dbUser);
            blobSql.append(pattern.getIndexTable());
            blobSql.append(" set ");
            blobSql.append(columnName);
            blobSql.append(" = ? where ");
            blobSql.append(pattern.getIndexTablePkCol());
            blobSql.append(" = '");
            blobSql.append(form.getId());
            blobSql.append("'");
            sqlList.add(blobSql.toString());
            byte[] columnValueArr = columnValue.getBytes("GBK");
            ByteArrayInputStream is = new ByteArrayInputStream(columnValueArr);
            inputStreamList.add(is);
            lenList.add(new Integer(columnValueArr.length));
        }
    }

    public String deleteFormText(FormInstance form) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("DELETE FROM ");
        Form pattern = form.getPattern();
        String tableName = String.valueOf(pattern.getDataUserName()) + pattern.getTextTable();
        sql2.append(tableName);
        sql2.append(" WHERE SHEETID='");
        sql2.append(form.getId());
        sql2.append("'");
        return sql2.toString();
    }

    public String getOpener(Form pattern, int formId) {
        String pkColumn = pattern.getIndexTablePkCol();
        if (pkColumn == null || pkColumn.equals("")) {
            pkColumn = "SHEETID";
        }
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT OPENER,OPENERID,LASTOPENTIME FROM ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getIndexTable());
        sql2.append(" WHERE ");
        sql2.append(pkColumn);
        sql2.append("='");
        sql2.append(formId);
        sql2.append("'");
        return sql2.toString();
    }

    public String[] updateOpener(FormInstance form, boolean isOpen) {
        String[] sqls = new String[2];
        Form pattern = form.getPattern();
        TreeMap cellIndex = pattern.getCellIndex();
        StringBuffer sql2 = new StringBuffer();
        if (cellIndex != null && cellIndex.containsKey("OPENERID")) {
            String pkColumn = pattern.getIndexTablePkCol();
            if (pkColumn == null || pkColumn.equals("")) {
                pkColumn = "SHEETID";
            }
            sql2.append("UPDATE ");
            sql2.append(pattern.getDataUserName()).append(pattern.getIndexTable());
            if (isOpen) {
                sql2.append(" SET OPENER='");
                sql2.append(User.getCurrentUser().getName());
                sql2.append("',OPENERID='");
                sql2.append(User.getCurrentUser().getId());
                sql2.append("', LASTOPENTIME='").append(DateTool.getNow());
                sql2.append("'");
            } else {
                sql2.append(" SET OPENER=''");
                sql2.append(",OPENERID=''");
            }
            sql2.append(" WHERE ");
            sql2.append(pkColumn);
            sql2.append("='");
            sql2.append(form.getId());
            sql2.append("'");
            sqls[0] = sql2.toString();
        }
        sql2.setLength(0);
        sql2.append("UPDATE ").append("[S].").append("JXD7_PM_INDEX SET ");
        if (isOpen) {
            sql2.append("OPENER='").append(User.getCurrentUser().getName()).append("'");
            sql2.append(",OPENERID='").append(User.getCurrentUser().getId()).append("'");
            sql2.append(", LASTOPENTIME='").append(DateTool.getNow()).append("'");
        } else {
            sql2.append("OPENER='',OPENERID='', LASTOPENTIME=''");
        }
        sql2.append(" WHERE SHEETID='").append(form.getId()).append("'");
        sqls[1] = sql2.toString();
        return sqls;
    }

    public String getSheetOrderSql(String dataUserName, String tablename) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select MAX(SHEETORDER)+1 as NEWORDER from ");
        sql2.append(dataUserName).append(tablename);
        return sql2.toString();
    }

    public String getSheetParaValueSql(String dataUserName, String tableName, String sheetID, int paraID) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select PARAMETERVALUE from ");
        sql2.append(dataUserName).append(tableName);
        sql2.append(" where SHEETID = '").append(sheetID).append("' ");
        sql2.append(" and PARAMETERID =").append(String.valueOf(paraID));
        return sql2.toString();
    }

    public String getTableOfForm() {
        StringBuffer sb = new StringBuffer(512);
        sb.append("SELECT TABLENAME,DATASOURCENAME,DATAUSERNAME FROM [S].JXD7_PM_PATTERN");
        return sb.toString();
    }

    public String getPatternById(String patternid) {
        StringBuffer sb = new StringBuffer(512);
        sb.append("SELECT * FROM [S].JXD7_PM_PATTERN WHERE PATTERNID='").append(patternid).append("'");
        return sb.toString();
    }

    public String updateOpener(String[] tableInfo) {
        if (tableInfo != null && tableInfo[0] != null && tableInfo[0].length() > 0) {
            StringBuffer sb = new StringBuffer(512);
            sb.append("UPDATE ").append(tableInfo[2]).append(tableInfo[0]).append(" SET OPENERID='',OPENER='',LASTOPENTIME='' WHERE (OPENERID IS NOT NULL or OPENERID<>'') OR (OPENER IS NOT NULL or OPENER<>'')");
            return sb.toString();
        }
        return "";
    }

    public String getHistorySql(String tablename, String hsheetid) {
        StringBuffer sb = new StringBuffer();
        sb.append("select * from ").append(tablename).append(" where hsheetid='");
        sb.append(hsheetid).append("' order by edittime desc");
        return sb.toString();
    }

    public String setHistoryReleaseSql(String tablename, String sheetid) {
        StringBuffer sb = new StringBuffer();
        sb.append("update ").append(tablename).append(" set ISRELEASE=1 where sheetid='");
        sb.append(sheetid).append("'");
        return sb.toString();
    }

    public String deleteFormHistoryIndex(FormInstance form) {
        String pkColumn = form.getPattern().getIndexTablePkCol();
        if (pkColumn == null || pkColumn.equals("")) {
            pkColumn = "SHEETID";
        }
        Form pattern = form.getPattern();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("DELETE FROM ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getHistoryTable());
        sql2.append(" WHERE ");
        sql2.append(pkColumn);
        sql2.append("='");
        sql2.append(form.getId());
        sql2.append("'");
        return sql2.toString();
    }

    public void saveFormHistoryIndex(FormInstance form, List list) throws Exception {
        StringBuffer sql2 = new StringBuffer(512);
        StringBuffer sqlColumnValue = new StringBuffer(256);
        Form pattern = form.getPattern();
        String dbUser = pattern.getDataUserName();
        sql2.append("INSERT INTO ");
        sql2.append(dbUser);
        sql2.append(pattern.getHistoryTable());
        sql2.append("(");
        TreeMap indexType = pattern.getHistoryIndex();
        for (Map.Entry entry : form.getHistoryindex().entrySet()) {
            String columnName = (String)entry.getKey();
            System.out.println("columnName = " + columnName);
            String columnValue = (String)entry.getValue();
            if (indexType.get(columnName) == null) {
                throw new Exception("\u672a\u627e\u5230\u5b57\u6bb5:" + columnName);
            }
            String columnType = ((CellIndex)indexType.get((Object)columnName)).type;
            if (columnType.equalsIgnoreCase("image")) continue;
            sql2.append(columnName);
            sql2.append(",");
            if (columnType.equalsIgnoreCase("INTEGER") || columnType.equalsIgnoreCase("int") || columnType.equalsIgnoreCase("DECIMAL") || columnType.equalsIgnoreCase("float") || columnType.equalsIgnoreCase("double") || columnType.equalsIgnoreCase("SMALLINT") || columnType.equalsIgnoreCase("BIGINT")) {
                sqlColumnValue.append(",");
                if (columnValue == null || columnValue.trim().length() == 0) {
                    sqlColumnValue.append(-1);
                    continue;
                }
                sqlColumnValue.append(columnValue);
                continue;
            }
            sqlColumnValue.append(",");
            sqlColumnValue.append("'");
            if (columnValue != null) {
                sqlColumnValue.append(DbOper.toDb(columnValue));
            }
            sqlColumnValue.append("'");
        }
        if (sqlColumnValue.length() > 0) {
            sql2.setLength(sql2.length() - 1);
            sql2.append(") VALUES(");
            sql2.append(sqlColumnValue.substring(1));
            sql2.append(")");
            list.add(sql2.toString());
        }
    }

    public void modifyFormHistoryIndex(FormInstance form, List list) {
        Form pattern = form.getPattern();
        String pkColumn = "SHEETID";
        StringBuffer sql2 = new StringBuffer(512);
        sql2.append("UPDATE ");
        sql2.append(pattern.getDataUserName());
        sql2.append(pattern.getHistoryTable());
        sql2.append(" SET ");
        TreeMap indexType = pattern.getHistoryIndex();
        for (Map.Entry entry : form.getHistoryindex().entrySet()) {
            String columnName = (String)entry.getKey();
            String columnValue = (String)entry.getValue();
            CellIndex cellIndex = (CellIndex)indexType.get(columnName);
            if (cellIndex == null) {
                System.out.print("\u6a21\u677f\u5bf9\u5e94\u8868\u7f3a\u5c11\u5b57\u6bb5\uff1a");
                System.out.println(columnName);
                continue;
            }
            String columnType = cellIndex.type;
            if (columnType.equalsIgnoreCase("image")) continue;
            sql2.append(columnName);
            sql2.append("=");
            if (columnType.equalsIgnoreCase("INTEGER") || columnType.equalsIgnoreCase("int") || columnType.equalsIgnoreCase("DECIMAL") || columnType.equalsIgnoreCase("float") || columnType.equalsIgnoreCase("double") || columnType.equalsIgnoreCase("SMALLINT") || columnType.equalsIgnoreCase("BIGINT")) {
                sql2.append(columnValue != null && columnValue.length() != 0 ? columnValue : "NULL");
            } else {
                sql2.append("'");
                if (columnValue != null) {
                    sql2.append(DbOper.toDb(columnValue));
                }
                sql2.append("'");
            }
            sql2.append(",");
        }
        sql2.setLength(sql2.length() - 1);
        sql2.append(" WHERE ");
        sql2.append(pkColumn);
        sql2.append("='");
        sql2.append(form.getHistorysheetid());
        sql2.append("'");
        list.add(sql2.toString());
    }

    public String getHisttroyText(String sheetid, String tablename) {
        StringBuffer sb = new StringBuffer(512);
        sb.append("SELECT HT.SHEETID,HT.CELLID,HT.CELLVALUE,HT.CELLTEXT,PC.TEXTFIELD,PC.VALUEFIELD FROM [S].");
        sb.append(tablename).append("_H H,[S].").append(tablename).append("_HTXT HT,[S].JXD7_PM_PATTERNCELL PC WHERE H.SHEETID='");
        sb.append(sheetid).append("' AND PC.PATTERNID = H.PATTERNID AND HT.CELLID=PC.CELLID AND HT.SHEETID=H.SHEETID");
        return sb.toString();
    }

    public String getCellHistoryByCellIdSql(String sheetid1, String sheetid2, String cellid, String tablename) {
        StringBuffer sb = new StringBuffer(512);
        sb.append("SELECT Z.EDITTIME,Z.EDITUSER,Z.EDITUSERID,T.CELLTEXT,T.CELLVALUE,T.CELLID,P.TEXTFIELD,P.VALUEFIELD FROM ");
        sb.append(tablename).append("_H Z, ").append(tablename).append("_HTXT T, JXD7_PM_PATTERNCELL P ");
        sb.append("WHERE T.SHEETID = Z.SHEETID AND P.PATTERNID = Z.PATTERNID AND T.CELLID=P.CELLID  ");
        sb.append("AND P.CELLID=").append(cellid).append(" AND Z.EDITTIME >= (SELECT EDITTIME FROM ");
        sb.append(tablename).append("_H  ").append("WHERE SHEETID ='").append(sheetid2);
        sb.append("') AND Z.EDITTIME <= (SELECT EDITTIME FROM  ");
        sb.append(tablename).append("_H WHERE SHEETID ='").append(sheetid1).append("') ORDER BY Z.EDITTIME ");
        return sb.toString();
    }

    public String getCellHistoryByFieldIdSql(String sheetid1, String sheetid2, String fieldid, String tablename) {
        StringBuffer sb = new StringBuffer(512);
        sb.append("SELECT Z.EDITTIME,Z.EDITUSER,Z.EDITUSERID,T.CELLTEXT,T.CELLVALUE,T.CELLID,P.TEXTFIELD,P.VALUEFIELD FROM ");
        sb.append(tablename).append("_H Z, ").append(tablename).append("_HTXT T, JXD7_PM_PATTERNCELL P ");
        sb.append("WHERE T.SHEETID = Z.SHEETID AND P.PATTERNID = Z.PATTERNID AND T.CELLID=P.CELLID  ");
        sb.append("AND P.TEXTFIELD=").append(fieldid).append(" AND Z.EDITTIME >= (SELECT EDITTIME FROM ");
        sb.append(tablename).append("_H  ").append("WHERE SHEETID ='").append(sheetid2);
        sb.append("') AND Z.EDITTIME <= (SELECT EDITTIME FROM  ");
        sb.append(tablename).append("_H WHERE SHEETID ='").append(sheetid1).append("') ORDER BY Z.EDITTIME ");
        return sb.toString();
    }

    public String getUpdateFileDelTypeSql(FormInstance form) {
        String ids = "";
        StringBuffer sb = new StringBuffer(512);
        FormCell[] cells = form.getCell();
        int i = 0;
        while (i < cells.length) {
            if (cells[i] instanceof UploadIns || cells[i] instanceof UploadImgIns) {
                ids = String.valueOf(ids) + "'" + cells[i].getValue() + "',";
            }
            ++i;
        }
        if (ids.length() > 0) {
            ids = ids.substring(0, ids.length() - 1);
            sb.append("UPDATE JXD7_PM_FILE SET NEEDDEL = '").append("").append("' WHERE ID IN (").append(ids).append(")");
        }
        return sb.toString();
    }
}

