/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.word;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import com.sdjxd.pms.platform.form.service.word.TableData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class JavaToWPS {
    private boolean saveOnExit = false;
    private Dispatch doc = null;
    private ActiveXComponent wps = null;
    private Dispatch documents;
    private static Object appLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaToWPS() {
        if (this.wps == null) {
            Object object = appLock;
            synchronized (object) {
                if (this.wps == null) {
                    this.wps = new ActiveXComponent("Wps.Application");
                }
            }
        }
        this.wps.setProperty("Visible", new Variant(false));
        this.documents = this.wps.getProperty("Documents").toDispatch();
    }

    public void setSaveOnExit(boolean saveOnExit) {
        this.saveOnExit = saveOnExit;
    }

    public boolean getSaveOnExit() {
        return this.saveOnExit;
    }

    public Dispatch open(String inputDoc) {
        this.doc = Dispatch.call((Dispatch)this.documents, (String)"Open", (Object[])new Object[]{inputDoc}).toDispatch();
        return this.doc;
    }

    public Dispatch select() {
        return this.wps.getProperty("Selection").toDispatch();
    }

    public void moveUp(Dispatch selection, int count) {
        int i = 0;
        while (i < count) {
            Dispatch.call((Dispatch)selection, (String)"MoveUp");
            ++i;
        }
    }

    public void moveDown(Dispatch selection, int count) {
        int i = 0;
        while (i < count) {
            Dispatch.call((Dispatch)selection, (String)"MoveDown");
            ++i;
        }
    }

    public void moveLeft(Dispatch selection, int count) {
        int i = 0;
        while (i < count) {
            Dispatch.call((Dispatch)selection, (String)"MoveLeft");
            ++i;
        }
    }

    public void moveRight(Dispatch selection, int count) {
        int i = 0;
        while (i < count) {
            Dispatch.call((Dispatch)selection, (String)"MoveRight");
            ++i;
        }
    }

    public void moveStart(Dispatch selection) {
        Dispatch.call((Dispatch)selection, (String)"HomeKey", (Object[])new Object[]{new Variant(6)});
    }

    public boolean find(Dispatch selection, String toFindText) {
        this.moveStart(selection);
        Dispatch find = Dispatch.call((Dispatch)selection, (String)"Find").toDispatch();
        Dispatch.put((Dispatch)find, (String)"Text", (Object)toFindText);
        Dispatch.put((Dispatch)find, (String)"Forward", (Object)"True");
        Dispatch.put((Dispatch)find, (String)"Format", (Object)"True");
        Dispatch.put((Dispatch)find, (String)"MatchCase", (Object)"True");
        Dispatch.put((Dispatch)find, (String)"MatchWholeWord", (Object)"True");
        Dispatch.put((Dispatch)find, (String)"Wrap", (Object)new Integer(1));
        return Dispatch.call((Dispatch)find, (String)"Execute").getBoolean();
    }

    public void replace(Dispatch selection, String newText) {
        Dispatch.put((Dispatch)selection, (String)"Text", (Object)newText);
    }

    public void replaceAll(Dispatch selection, String oldText, Object replaceObj) throws Exception {
        this.moveStart(selection);
        if (oldText.startsWith("table") && replaceObj instanceof TableData) {
            this.replaceTable(selection, oldText, (TableData)replaceObj);
        } else {
            String newText = (String)replaceObj;
            if (oldText.indexOf("image") != -1 || newText.lastIndexOf(".bmp") != -1 || newText.lastIndexOf(".jpg") != -1 || newText.lastIndexOf(".gif") != -1) {
                while (this.find(selection, oldText)) {
                    this.replaceImage(selection, newText);
                    Dispatch.call((Dispatch)selection, (String)"MoveRight");
                }
            } else {
                boolean found = false;
                while (this.find(selection, oldText)) {
                    found = true;
                    this.replace(selection, newText);
                    Dispatch.call((Dispatch)selection, (String)"MoveRight");
                }
                if (!found) {
                    this.replaceShape(oldText, newText);
                }
            }
        }
    }

    public void replaceAll(String oldText, Object replaceObj) throws Exception {
        this.replaceAll(this.select(), oldText, replaceObj);
    }

    public void replaceImage(Dispatch selection, String imagePath) {
        Dispatch.call((Dispatch)Dispatch.get((Dispatch)selection, (String)"InLineShapes").toDispatch(), (String)"AddPicture", (Object[])new Object[]{imagePath});
    }

    public void replaceShape(String key, String value) throws Exception {
        Dispatch shapes = Dispatch.get((Dispatch)this.doc, (String)"Shapes").toDispatch();
        String count = Dispatch.get((Dispatch)shapes, (String)"Count").toString();
        int counts = Integer.parseInt(count);
        int i = 1;
        while (i <= counts) {
            Dispatch shape = Dispatch.call((Dispatch)shapes, (String)"Item", (Object[])new Object[]{new Variant(i)}).toDispatch();
            Dispatch textframe = Dispatch.get((Dispatch)shape, (String)"TextFrame").toDispatch();
            boolean hasText = Dispatch.call((Dispatch)textframe, (String)"HasText").toBoolean();
            if (hasText) {
                Dispatch TextRange = Dispatch.get((Dispatch)textframe, (String)"TextRange").toDispatch();
                Dispatch.get((Dispatch)TextRange, (String)"Text").toString();
                String keytemp = key;
                Dispatch find = Dispatch.call((Dispatch)TextRange, (String)"Find").toDispatch();
                Dispatch.put((Dispatch)find, (String)"Text", (Object)keytemp);
                Dispatch.put((Dispatch)find, (String)"forward", (Object)"False");
                Dispatch.put((Dispatch)find, (String)"MatchWholeWord", (Object)"True");
                if (Dispatch.call((Dispatch)find, (String)"Execute").getBoolean()) {
                    Dispatch.put((Dispatch)TextRange, (String)"Text", (Object)value);
                }
            }
            ++i;
        }
    }

    public List<Integer> getTableIndex(Dispatch selection, String tableName) {
        int iTableIndex = -1;
        ArrayList<Integer> dataList = new ArrayList<Integer>();
        Dispatch tables = Dispatch.get((Dispatch)this.doc, (String)"Tables").toDispatch();
        int tablesCount = Dispatch.get((Dispatch)tables, (String)"Count").toInt();
        int i = 1;
        while (i <= tablesCount) {
            Dispatch table = Dispatch.call((Dispatch)tables, (String)"Item", (Object[])new Object[]{new Variant(i)}).toDispatch();
            Dispatch rows = Dispatch.call((Dispatch)table, (String)"Rows").toDispatch();
            Dispatch columns = Dispatch.call((Dispatch)table, (String)"Columns").toDispatch();
            int rowsCount = Dispatch.get((Dispatch)rows, (String)"Count").toInt();
            int columnsCount = Dispatch.get((Dispatch)columns, (String)"Count").toInt();
            int j = 1;
            while (j <= rowsCount) {
                int k = 1;
                while (k <= columnsCount) {
                    try {
                        Dispatch cell = Dispatch.call((Dispatch)table, (String)"Cell", (Object[])new Object[]{j, k}).toDispatch();
                        Dispatch Range = Dispatch.get((Dispatch)cell, (String)"Range").toDispatch();
                        System.out.println(Dispatch.get((Dispatch)Range, (String)"Text").toString());
                        Dispatch.call((Dispatch)cell, (String)"Select");
                        String ret = "";
                        ret = Dispatch.get((Dispatch)selection, (String)"Text").toString();
                        ret = ret.substring(0, ret.length() - 2);
                        if (ret.endsWith(tableName)) {
                            dataList.add(i);
                            dataList.add(j);
                            dataList.add(k);
                            return dataList;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        dataList.add(-1);
        dataList.add(-1);
        dataList.add(-1);
        return dataList;
    }

    public void FillTableData(Dispatch selection, String tableName, TableData tableData) throws Exception {
        if (tableData.getDataList().size() <= 1) {
            System.out.println("Empty table!");
            return;
        }
        List<List<String>> dataList = tableData.getDataList();
        String[] conf = tableName.split(",");
        String tbIndex = conf[1];
        int fromRow = Integer.parseInt(conf[2]);
        int fromCol = Integer.parseInt(conf[3]);
        Dispatch tables = Dispatch.get((Dispatch)this.doc, (String)"Tables").toDispatch();
        Dispatch table = Dispatch.call((Dispatch)tables, (String)"Item", (Object[])new Object[]{new Variant((Object)tbIndex)}).toDispatch();
        int iAddRow = 1;
        while (iAddRow < dataList.size()) {
            Dispatch cell = Dispatch.call((Dispatch)table, (String)"Cell", (Object[])new Object[]{fromRow, fromCol}).toDispatch();
            Dispatch.call((Dispatch)cell, (String)"Select");
            Dispatch.call((Dispatch)selection, (String)"InsertRowsBelow", (Object[])new Object[]{new Variant(1)});
            ++iAddRow;
        }
        int i = 0;
        while (i < dataList.size()) {
            List<String> rowData = dataList.get(i);
            int j = 0;
            while (j < rowData.size()) {
                Dispatch cell = Dispatch.call((Dispatch)table, (String)"Cell", (Object[])new Object[]{fromRow + i, fromCol + j}).toDispatch();
                Dispatch.call((Dispatch)cell, (String)"Select");
                Dispatch.put((Dispatch)selection, (String)"Text", (Object)rowData.get(j));
                ++j;
            }
            ++i;
        }
    }

    public void replaceTable(Dispatch selection, String tableName, TableData tableData) throws Exception {
        if (tableData.getDataList().size() <= 1) {
            System.out.println("Empty table!");
            return;
        }
        List<List<String>> dataList = tableData.getDataList();
        int rowCount = dataList.size();
        int colCount = dataList.get(0).size();
        String[] conf = tableName.split(",");
        String tbIndex = conf[1];
        int fromRow = Integer.parseInt(conf[2]);
        int fromCol = Integer.parseInt(conf[3]);
        Dispatch tables = Dispatch.get((Dispatch)this.doc, (String)"Tables").toDispatch();
        Dispatch table = Dispatch.call((Dispatch)tables, (String)"Item", (Object[])new Object[]{new Variant((Object)tbIndex)}).toDispatch();
        this.splitCell(table, fromRow, fromCol, rowCount, colCount);
        table = Dispatch.call((Dispatch)tables, (String)"Item", (Object[])new Object[]{new Variant((Object)tbIndex)}).toDispatch();
        this.setWidthAndHeight(table, tableData);
        int i = 0;
        while (i < dataList.size()) {
            List<String> rowData = dataList.get(i);
            HashMap<String, String> rowFont = null;
            rowFont = i == 0 ? tableData.getRowFont()[0] : tableData.getRowFont()[1];
            int j = 0;
            while (j < rowData.size()) {
                String alignStyle = null;
                alignStyle = i == 0 ? ((alignStyle = tableData.getAlign()[0]) == null ? tableData.getAlign()[j + 1] : alignStyle) : tableData.getAlign()[j + 1];
                alignStyle = alignStyle == null ? TableData.ALIGN_CENTER : alignStyle;
                Dispatch cell = Dispatch.call((Dispatch)table, (String)"Cell", (Object[])new Object[]{fromRow + i, fromCol + j}).toDispatch();
                Dispatch.call((Dispatch)cell, (String)"Select");
                Dispatch align = Dispatch.get((Dispatch)selection, (String)"ParagraphFormat").toDispatch();
                Dispatch.put((Dispatch)align, (String)"Alignment", (Object)alignStyle);
                Dispatch font = Dispatch.get((Dispatch)selection, (String)"Font").toDispatch();
                Dispatch.put((Dispatch)selection, (String)"Text", (Object)rowData.get(j));
                ++j;
            }
            ++i;
        }
    }

    private void applyStyle(Dispatch dp, HashMap<String, String> style) {
        if (dp == null || style.size() == 0) {
            return;
        }
        Set<String> keys = style.keySet();
        for (String key : keys) {
            Dispatch.put((Dispatch)dp, (String)key, (Object)style.get(key));
        }
    }

    private void setWidthAndHeight(Dispatch table, TableData tableData) {
        Dispatch cols = Dispatch.get((Dispatch)table, (String)"columns").toDispatch();
        int colCount = Dispatch.get((Dispatch)cols, (String)"count").getInt();
        String[] widthArr = tableData.getWidth();
        String[] heightArr = tableData.getHeight();
        Dispatch col = Dispatch.call((Dispatch)cols, (String)"Item", (Object[])new Object[]{new Variant(1)}).toDispatch();
        Dispatch.put((Dispatch)col, (String)"Width", (Object)new Variant((Object)(widthArr[0] == null ? tableData.getDefaultWidth() : widthArr[0])));
        int i = 2;
        while (i <= colCount) {
            col = Dispatch.call((Dispatch)cols, (String)"Item", (Object[])new Object[]{new Variant(i)}).toDispatch();
            String colW = widthArr[i - 1] == null ? tableData.getDefaultWidth() : widthArr[i - 1];
            Dispatch.put((Dispatch)col, (String)"Width", (Object)new Variant((Object)colW));
            ++i;
        }
        Dispatch rows = Dispatch.get((Dispatch)table, (String)"rows").toDispatch();
        int rowCount = Dispatch.get((Dispatch)rows, (String)"count").getInt();
        Dispatch row = Dispatch.call((Dispatch)rows, (String)"Item", (Object[])new Object[]{new Variant(1)}).toDispatch();
        Dispatch.put((Dispatch)row, (String)"Height", (Object)new Variant((Object)(heightArr[0] == null ? tableData.getDefaultHeight() : heightArr[0])));
        int i2 = 2;
        while (i2 <= rowCount) {
            row = Dispatch.call((Dispatch)rows, (String)"Item", (Object[])new Object[]{new Variant(i2)}).toDispatch();
            String rowH = heightArr[i2 - 1] == null ? tableData.getDefaultHeight() : heightArr[i2 - 1];
            Dispatch.put((Dispatch)row, (String)"Height", (Object)new Variant((Object)rowH));
            ++i2;
        }
    }

    public void save(String outputPath) {
        Dispatch.call((Dispatch)this.doc, (String)"SaveAS", (Object[])new Object[]{outputPath});
    }

    public void closeApp() {
        if (this.doc != null) {
            Dispatch.call((Dispatch)this.doc, (String)"Close", (Object[])new Object[]{new Variant(false)});
        }
        Dispatch.call((Dispatch)this.wps, (String)"Quit");
        this.wps = null;
        this.doc = null;
    }

    public void quit() {
        this.wps.invoke("Quit", new Variant[0]);
        ComThread.Release();
    }

    private void splitCell(Dispatch table, int xCell, int yCell, int iRow, int iCol) throws Exception {
        Dispatch cell = Dispatch.call((Dispatch)table, (String)"Cell", (Object[])new Object[]{String.valueOf(xCell), String.valueOf(yCell)}).toDispatch();
        Dispatch.call((Dispatch)cell, (String)"Split", (Object[])new Object[]{String.valueOf(iRow), String.valueOf(iCol)});
    }
}

