/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.dao.TreeDao;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.LinkApp;
import com.sdjxd.pms.platform.form.model.TreeNodeBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniDom;
import com.sdjxd.pms.platform.form.service.minicell.ins.MiniTreeIns;
import com.sdjxd.pms.platform.tool.StringTool;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;

public class MiniTree
extends MiniCell
implements ICell {
    private static final long serialVersionUID = 1L;
    private boolean showCheckBox;
    private boolean autoCheckParent = false;
    private boolean checkRecursive = true;
    private String expandOnLoad;
    private boolean createAllNode;
    private boolean showTreeIcon = true;
    private boolean showTreeLines = true;
    private boolean showExpandButtons = true;
    private boolean expandOnDblClick = false;
    private boolean expandOnNodeClick = false;
    private String treeLoadUrl;
    private String dataLoadType = "inter";
    private TreeDao treeDao = null;
    private boolean addRootNode = false;
    private String rootNodeName;
    private String appId;

    public MiniTree(Form pattern) {
        super(pattern);
    }

    @Override
    protected String renderHtml(FormInstance form) throws Exception {
        MiniTreeIns formCell = (MiniTreeIns)form.getCell(this.id);
        String expandOnLoad = formCell.getOpenLevelCount();
        boolean showCheckBox = formCell.isShowCheckBox();
        boolean autoCheckParent = formCell.isAutoCheckParent();
        boolean checkRecursive = formCell.isCheckRecursive();
        MiniDom treeDom = new MiniDom("ul");
        treeDom.add("id", this.getCellId());
        treeDom.add("class", "mini-tree");
        treeDom.add("showTreeIcon", String.valueOf(this.showTreeIcon));
        treeDom.add("showTreeLines", String.valueOf(this.showTreeLines));
        treeDom.add("showExpandButtons", String.valueOf(this.showExpandButtons));
        treeDom.add("expandOnDblClick", String.valueOf(this.expandOnDblClick));
        treeDom.add("expandOnNodeClick", String.valueOf(this.expandOnNodeClick));
        treeDom.add("checkRecursive", String.valueOf(checkRecursive));
        treeDom.add("autoCheckParent", String.valueOf(autoCheckParent));
        treeDom.add("expandOnLoad", expandOnLoad);
        treeDom.add("showCheckBox", String.valueOf(showCheckBox));
        if (showCheckBox) {
            treeDom.add("allowSelect", "false");
        } else {
            treeDom.add("allowSelect", "true");
        }
        treeDom.add(this.getCellLimits(form));
        treeDom.addStyle(this.getCellPositions(form));
        treeDom.addStyle(this.getCellSizes(form));
        treeDom.addStyle(this.getStyleOfTree());
        if (this.dataLoadType.equals("inter")) {
            treeDom.add("textField", "text");
            treeDom.add("idField", "id");
            treeDom.add("parentField", "parentId");
            treeDom.add("nodesField", "childs");
            treeDom.add("imgField", "miniIconSrc");
        }
        StringBuffer buffer = new StringBuffer(1024);
        treeDom.render(buffer);
        return buffer.toString();
    }

    @Override
    protected String renderScriptObject(FormInstance formIns) throws Exception {
        MiniTreeIns formCell = (MiniTreeIns)formIns.getCell(this.id);
        String appId = formCell.getAppId();
        String expandOnLoad = formCell.getOpenLevelCount();
        boolean showCheckBox = formCell.isShowCheckBox();
        boolean createAllNode = formCell.isCreateAllNode();
        boolean autoCheckParent = formCell.isAutoCheckParent();
        boolean checkRecursive = formCell.isCheckRecursive();
        boolean addRootNode = formCell.isAddRootNode();
        String rootNodeName = formCell.getRootNodeName();
        LinkApp linkApp = formCell.getLinkApp();
        JSONArray jsonArray = this.dataLoadType.equals("url") ? new JSONArray() : (linkApp != null ? JSONArray.fromObject((Object)this.getNodeData(linkApp, createAllNode, addRootNode, rootNodeName)) : new JSONArray());
        StringBuffer script = new StringBuffer();
        script.append(" var miniTree_").append(this.id);
        script.append(" = new com.sdjxd.pms.platform.form.miniCell.Tree({");
        script.append("id:\"").append(this.id).append("\",");
        script.append("miniid:\"").append(this.getCellId()).append("\",");
        script.append("_appId:\"").append(appId).append("\",");
        script.append("_showCheckBox:\"").append(showCheckBox).append("\",");
        script.append("_checkParent:\"").append(autoCheckParent).append("\",");
        script.append("_checkChildren:\"").append(checkRecursive).append("\",");
        script.append("_createAllNode:").append(createAllNode).append(",");
        script.append("_dataLoadType:\"").append(this.dataLoadType).append("\"");
        script.append("},").append(jsonArray.toString()).append(");\r\n");
        script.append("defaultForm.addChild(miniTree_").append(this.id).append(");\r\n ");
        if (jsonArray.size() > 0 && Integer.parseInt(expandOnLoad) > 0) {
            script.append("miniTree_").append(this.id).append(".openNode(" + expandOnLoad + ");\r\n ");
        }
        if (this.data.lineWidth > 0) {
            script.append("document.getElementById(\"").append(this.getCellId()).append("\").style.borderWidth=\"").append(this.data.lineWidth).append("px\" ;\r\n");
        }
        script.append(this.getEventScript(formIns));
        if (this.dataLoadType.equals("url")) {
            script.append("defaultForm.getCellById(" + this.getId() + ").getDom().load(\"" + this.treeLoadUrl + "\");\r\n");
        }
        return script.toString();
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.readAttributesExt();
        this.showTreeIcon = !((String)this.dataExt.get("8D116732-52EB-4F4C-9382-6055B7DB6927")).equals("0");
        this.showTreeLines = !((String)this.dataExt.get("26EEF71A-316D-4C9B-B102-1FC547E1B6AF")).equals("0");
        this.showExpandButtons = !((String)this.dataExt.get("B364D645-3862-4024-B24F-BAC346F441AE")).equals("0");
        this.expandOnDblClick = ((String)this.dataExt.get("2BE6274B-C23D-43DB-AB04-78947D460B1D")).equals("1");
        this.expandOnNodeClick = ((String)this.dataExt.get("0C39BCAB-1373-4BAD-B4DC-1AF0C1BD3FB1")).equals("1");
        this.treeLoadUrl = (String)this.dataExt.get("1C4E1AEB-69A3-4D8D-8C57-E5AF1610B918");
        this.dataLoadType = this.treeLoadUrl != null && this.treeLoadUrl.trim().length() > 0 ? "url" : "inter";
        String[] tmp = (String[])StringTool.strToArray(this.data.assitInfo);
        this.showCheckBox = tmp[0].equals("1");
        this.createAllNode = tmp[2].equals("1");
        int tag = tmp[5].indexOf(":");
        this.appId = tmp[5].substring(tag + 1, tmp[5].length());
        String string = this.expandOnLoad = tmp.length > 8 ? tmp[8] : "0";
        if (this.expandOnLoad.equals("-1")) {
            this.expandOnLoad = "0";
        }
        if (tmp.length > 10 && tmp[10].equals("1")) {
            this.autoCheckParent = true;
        }
        if (tmp.length > 11 && tmp[11].equals("0")) {
            this.checkRecursive = false;
        }
        if (tmp[1].equals("1")) {
            this.addRootNode = true;
            this.rootNodeName = tmp[4].length() != 0 ? tmp[4] : "\u589e\u52a0\u6839\u8282\u70b9";
        }
    }

    private Map<String, String> getStyleOfTree() {
        String[] dataArr;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getBorderStyle());
        if (this.data.lineWidth > 0) {
            resultMap.put("border-style", "solid");
            if (sb.toString().indexOf("border-width") < 0 && sb.toString().indexOf("border:") < 0) {
                resultMap.put("border-width", String.valueOf(this.data.lineWidth) + "px");
            }
            if (sb.toString().indexOf("border-color") < 0 && sb.toString().indexOf("border:") < 0) {
                resultMap.put("border-color", "#a5acb5");
            }
        }
        sb.append(this.getFontStyle());
        if (this.data.bkColorStyle != null) {
            sb.append(this.getTreeStyle(this.data.bkColorStyle));
        }
        if (this.data.textColorStyle != null) {
            sb.append(this.getTreeStyle(this.data.textColorStyle));
        }
        String[] stringArray = dataArr = sb.toString().split(";");
        int n = dataArr.length;
        int n2 = 0;
        while (n2 < n) {
            String sub = stringArray[n2];
            if (sub != null && sub.trim().length() > 0) {
                String[] subArr = sub.split(":");
                resultMap.put(subArr[0], subArr[1]);
            }
            ++n2;
        }
        return resultMap;
    }

    private String getTreeStyle(String StyleData) {
        try {
            return this.getStyleTextById(StyleData);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private TreeNodeBean[] getNodeData(LinkApp linkApp, boolean createAllNode, boolean addRootNode, String rootNodeName) {
        TreeNodeBean[] nodeArr = this.treeDao.getLinkAppRootNodeArray(linkApp, createAllNode, null, false);
        if (addRootNode) {
            TreeNodeBean rootNode = new TreeNodeBean();
            rootNode.setId("rootNode");
            rootNode.setObjectId("TreeRootNodeIdNull");
            rootNode.setText(rootNodeName);
            rootNode.setChilds(nodeArr);
            TreeNodeBean[] nodeBeanArr = new TreeNodeBean[]{rootNode};
            return nodeBeanArr;
        }
        return nodeArr;
    }

    public static TreeNodeBean[] getChildNodeList(String appid, String treeid, String objectId, String isGroup, String parentObjectId, String tableId, String id, String linkId) {
        TreeDao treeDao = new TreeDao(appid);
        LinkApp treeLinkApp = treeDao.getLinkApp();
        String objId = objectId;
        String gid = "";
        if (isGroup != null && "1".equals(isGroup)) {
            gid = objectId;
            objId = parentObjectId;
        }
        return treeDao.getLinkAppTableNodeArray(appid, treeLinkApp.getDataSourceName(), tableId, linkId, objId, Integer.parseInt(treeid), isGroup, gid, null, null, id, false);
    }

    public static TreeNodeBean[] getRootNodeList(String appId, boolean createAllNode) {
        TreeDao treeDao = new TreeDao(appId);
        LinkApp treeLinkApp = treeDao.getLinkApp();
        return treeDao.getLinkAppRootNodeArray(treeLinkApp, createAllNode, null, false);
    }

    @Override
    public FormCell createCellInstance() {
        return new MiniTreeIns();
    }

    @Override
    public void renderInstanceValue(FormInstance form) {
        MiniTreeIns formCell = (MiniTreeIns)form.getCell(this.id);
        String appId_Real = this.appId;
        if (Global.getContext().getParameter("appID") != null && Global.getContext().getParameter("appID").trim().length() > 0) {
            appId_Real = Global.getContext().getParameter("appID");
        }
        if (appId_Real != null && appId_Real.length() != 0) {
            this.treeDao = new TreeDao(appId_Real);
            LinkApp linkApp = this.treeDao.getLinkApp();
            if (linkApp != null) {
                String filter = linkApp.getFilter();
                if (filter == null) {
                    filter = "";
                }
                if (Global.getContext().getParameter("treeRootNodeFilter") != null && Global.getContext().getParameter("treeRootNodeFilter").length() != 0) {
                    if (filter != null && filter.length() != 0) {
                        filter = String.valueOf(filter) + " and ";
                    }
                    filter = String.valueOf(filter) + " (";
                    filter = String.valueOf(filter) + Global.getContext().getParameter("treeRootNodeFilter");
                    filter = String.valueOf(filter) + ")";
                }
                linkApp.setFilter(StringTool.replaceKeyWord(filter));
                formCell.setLinkApp(linkApp);
            }
        }
        formCell.setAppId(appId_Real);
        String openLevelCount_Real = this.expandOnLoad;
        if (Global.getContext().getParameter("h_treeNodeOpenLevel") != null && Global.getContext().getParameter("h_treeNodeOpenLevel").length() != 0) {
            openLevelCount_Real = Global.getContext().getParameter("h_treeNodeOpenLevel");
            formCell.setOpenLevelCount(openLevelCount_Real);
        }
        formCell.setOpenLevelCount(openLevelCount_Real);
        boolean showCheckBox_Real = this.showCheckBox;
        if (Global.getContext().getParameter("h_treeShowCheckBox") != null && Global.getContext().getParameter("h_treeShowCheckBox").length() != 0) {
            showCheckBox_Real = Global.getContext().getParameter("h_treeShowCheckBox").equals("1");
        }
        formCell.setShowCheckBox(showCheckBox_Real);
        boolean createAllNode_Real = this.createAllNode;
        if (Global.getContext().getParameter("h_createAllNode") != null && Global.getContext().getParameter("h_createAllNode").length() != 0) {
            createAllNode_Real = Global.getContext().getParameter("h_createAllNode").equals("1");
        }
        formCell.setCreateAllNode(createAllNode_Real);
        boolean autoCheckParent_Real = this.autoCheckParent;
        if (Global.getContext().getParameter("h_checkParent") != null && Global.getContext().getParameter("h_checkParent").length() != 0) {
            autoCheckParent_Real = Global.getContext().getParameter("h_checkParent").equals("1");
        }
        formCell.setAutoCheckParent(autoCheckParent_Real);
        boolean checkRecursive_Real = this.checkRecursive;
        if (Global.getContext().getParameter("h_checkRecursive") != null && Global.getContext().getParameter("h_checkRecursive").length() != 0) {
            checkRecursive_Real = Global.getContext().getParameter("h_checkRecursive").equals("1");
        }
        formCell.setCheckRecursive(checkRecursive_Real);
        boolean addRootNode_Real = this.addRootNode;
        if (Global.getContext().getParameter("h_addRootNode") != null && Global.getContext().getParameter("h_addRootNode").length() != 0) {
            addRootNode_Real = Global.getContext().getParameter("h_addRootNode").equals("1");
        }
        formCell.setAddRootNode(addRootNode_Real);
        String rootNodeName_Real = this.rootNodeName;
        if (Global.getContext().getParameter("h_rootNodeName") != null && Global.getContext().getParameter("h_rootNodeName").length() != 0) {
            rootNodeName_Real = Global.getContext().getParameter("h_rootNodeName");
        }
        formCell.setRootNodeName(rootNodeName_Real);
    }
}

