/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniDom;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;

public class MiniTimeSpinner
extends MiniCell {
    private static final long serialVersionUID = 1L;
    protected String fieldMeanValue;
    private String label;

    public MiniTimeSpinner(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        String[] mean = (String[])StringTool.strToArray(this.data.fieldMeanValue);
        this.fieldMeanValue = mean != null && mean.length > 0 ? mean[0] : "HH:mm:ss";
    }

    @Override
    protected String renderHtml(FormInstance form) throws Exception {
        MiniDom timeSpinnerDom = new MiniDom("input");
        timeSpinnerDom.add("id", this.getCellId());
        timeSpinnerDom.add("class", "mini-timespinner");
        timeSpinnerDom.add("borderStyle", this.getBorderStyle());
        String str = String.valueOf(this.getBKStyle()) + this.getTAStyle() + this.getFontStyle();
        timeSpinnerDom.add("inputStyle", str);
        timeSpinnerDom.add("height", this.getHeight());
        timeSpinnerDom.add("width", this.getWidth());
        timeSpinnerDom.add("format", this.fieldMeanValue);
        String defaultValue = DateTool.formatDate(form.getCell()[this.id].getValue(), this.fieldMeanValue);
        timeSpinnerDom.add("value", defaultValue);
        if (this.data.limit == 2) {
            timeSpinnerDom.add("required", "true");
        } else {
            timeSpinnerDom.add("required", "false");
        }
        timeSpinnerDom.add(this.getCellLimits(form));
        timeSpinnerDom.addStyle(this.getCellPositions(form));
        StringBuffer buffer = new StringBuffer(1024);
        timeSpinnerDom.render(buffer);
        return buffer.toString();
    }

    @Override
    protected String renderScriptObject(FormInstance formIns) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (this.fieldMeanValue != null && this.fieldMeanValue.length() != 0) {
            sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.miniCell.TimeSpinner({id:");
            sb.append(this.id);
            sb.append(",miniid:'").append(this.getCellId()).append("'");
            sb.append(",tagId:");
            sb.append("document.getElementById(\"cellId" + this.id).append("\")");
            sb.append(",divId:").append(this.data.areaId);
            sb.append(",userDefinfo:");
            sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
            sb.append(",format:\"");
            sb.append(this.fieldMeanValue);
            if (Form.FOrmType.equals("0")) {
                sb.append("\",needSave:");
                sb.append(this.isNeedSave());
                sb.append(",needPrint:");
                sb.append(formIns.getCell()[this.id].isPrint());
                sb.append(",bgColorStyle:'").append(this.data.bkColorStyle).append("'");
                sb.append(",readOnlyBgColorStyle:'").append(this.data.readBkColorStyle).append("'");
                sb.append(",showName:\"" + this.cellName + "\"");
                sb.append(",label:\"" + StringTool.toJson(this.label) + "\"");
            }
            if (formIns.getCell() != null && this.id < formIns.getCell().length && formIns.getCell()[this.id] != null) {
                sb.append(",limit:");
                sb.append(formIns.getCell()[this.id].getLimit());
            }
            sb.append(",value:\"").append(formIns.getCell()[this.id].getValue()).append("\"");
            sb.append("}));\r\n");
            String backgroundColor = this.getBKColor();
            if (backgroundColor != null) {
                sb.append("document.getElementById(\"").append(this.getCellId()).append("$text\").parentNode.style.backgroundColor = \"").append(backgroundColor).append("\";\r\n ");
            }
            sb.append(this.getEventScript(formIns));
        }
        return sb.toString();
    }

    @Override
    public void setDefault(FormInstance form) {
        super.setDefault(form);
        FormCell formCell = form.getCell()[this.id];
        String defaultValue = formCell.getText();
        defaultValue = StringTool.replaceKeyWord(defaultValue, form);
        defaultValue = FormInstance.replaceParaValue(defaultValue, form);
        int i = 0;
        while (i < this.controls.size()) {
            ((ICell)this.controls.get(i)).setDefault(form);
            ++i;
        }
        if (!StringTool.isEmpty(defaultValue)) {
            formCell.setValue(defaultValue);
            formCell.setText(DateTool.formatDate(formCell.getText(), this.fieldMeanValue));
        }
    }

    private boolean isAllowInput() {
        return this.data.readonly == 1;
    }
}

