/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniDom;
import com.sdjxd.pms.platform.table.service.mean.FieldMean;
import com.sdjxd.pms.platform.table.service.mean.Text;
import com.sdjxd.pms.platform.tool.StringTool;
import java.util.HashMap;
import java.util.Map;

public class MiniTextbox
extends MiniCell {
    private String tagInfo = "mini-textbox";
    private String bqInfo = "input";
    private String hg = "";

    public MiniTextbox(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.readAttributesExt();
    }

    @Override
    protected String renderHtml(FormInstance formIns) throws Exception {
        MiniDom textboxDom = new MiniDom(this.bqInfo);
        textboxDom.add("id", this.getCellId());
        textboxDom.add("class", this.tagInfo);
        String str = String.valueOf(this.getas()) + this.getBk() + this.getFontStyle() + this.getHg();
        if (this.getas().contains("vertical-align:middle")) {
            str = String.valueOf(str) + "line-height:" + this.getHeight() + ";";
        }
        textboxDom.add("inputStyle", str);
        textboxDom.add("borderStyle", this.getBorderStyle());
        String value = formIns.getCell()[this.id].getText();
        value = StringTool.replaceHTML(value);
        textboxDom.add("value", value);
        textboxDom.add("width", this.getWidth());
        textboxDom.add("height", this.getHeight());
        if (this.data.limit == 2) {
            textboxDom.add("required", "true");
        } else {
            textboxDom.add("required", "false");
        }
        if (this.data.maxSize != 0) {
            textboxDom.add("maxLength", String.valueOf(this.data.maxSize));
        }
        if (this.dataExt.get("CEE48D6A-10BA-4BB3-84EA-1B50C015082A") != "" && this.dataExt.get("CEE48D6A-10BA-4BB3-84EA-1B50C015082A") != null) {
            textboxDom.add("emptyText", (String)this.dataExt.get("CEE48D6A-10BA-4BB3-84EA-1B50C015082A"));
        }
        if (this.dataExt.get("EDA38C69-4B64-47CA-BFD8-249B8763644E") != "" && this.dataExt.get("EDA38C69-4B64-47CA-BFD8-249B8763644E") != null) {
            textboxDom.add("errorMode", this.getErrorInfo((String)this.dataExt.get("EDA38C69-4B64-47CA-BFD8-249B8763644E")));
        }
        textboxDom.add(this.getVerifyMeans());
        textboxDom.add(this.getCellLimits(formIns));
        textboxDom.addStyle(this.getCellPositions(formIns));
        StringBuffer buffer = new StringBuffer(1024);
        textboxDom.render(buffer);
        return buffer.toString();
    }

    @Override
    protected String renderScriptObject(FormInstance formIns) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.miniCell.Textbox({id:");
        sb.append(this.id);
        sb.append(",miniid:'").append(this.getCellId()).append("'");
        sb.append(",valueField:'").append(this.data.valueField).append("'");
        sb.append(",textField:'").append(this.data.textField).append("'");
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'").append(",limit:").append(formIns.getCell()[this.id].getLimit());
        if (Form.FOrmType.equals("0")) {
            sb.append(",needSave:");
            sb.append(this.isNeedSave());
            sb.append(",needPrint:");
            sb.append(formIns.getCell()[this.id].isPrint());
            sb.append(",showName:\"" + this.cellName + "\"");
        }
        sb.append("}));\r\n");
        String backgroundColor = this.getBKColor();
        if (backgroundColor != null) {
            sb.append("document.getElementById(\"").append(this.getCellId()).append("$text\").parentNode.style.backgroundColor = \"").append(backgroundColor).append("\";\r\n ");
        }
        sb.append(this.getEventScript(formIns));
        return sb.toString();
    }

    private String getBk() {
        String bk = this.getStyleTextById(this.data.bkColorStyle);
        return bk;
    }

    @Override
    public String getBorderStyle() {
        StringBuffer s = new StringBuffer();
        try {
            if (this.data.borderStyle != null) {
                s.append(this.getStyleTextById(this.data.borderStyle));
            }
            if (this.data.lineWidth > 0) {
                s.append("border-width:").append("1").append("px");
            } else {
                s.append("border-width:").append("0").append("px");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s.toString();
    }

    private String getas() {
        String as = this.getStyleTextById(this.data.alignStyle);
        return as;
    }

    private String getErrorInfo(String key) {
        if ("1".equals(key)) {
            return "icon";
        }
        if ("2".equals(key)) {
            return "border";
        }
        if ("3".equals(key)) {
            return "none";
        }
        return "";
    }

    private Map getVerifyMeans() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String vType = "";
        int length = this.data.verifyMeans == null ? 0 : this.data.verifyMeans.length;
        int i = 0;
        while (i < length) {
            try {
                String temp = ((Text)FieldMean.getInstance(this.data.verifyMeans[i])).getRegex();
                String type = temp.substring(3, temp.length()).split("\",\"")[0];
                String info = temp.split("\",\"")[1].split("\"")[0];
                if (info != null && !"".equals(info)) {
                    retMap.put(String.valueOf(type.split(":")[0]) + "ErrorText", info);
                }
                vType = String.valueOf(vType) + type + ";";
            }
            catch (Exception e) {
                e.printStackTrace();
                return retMap;
            }
            ++i;
        }
        if (vType != null && !"".equals(vType)) {
            retMap.put("vtype", vType);
        }
        return retMap;
    }

    public String getTagInfo() {
        return this.tagInfo;
    }

    public void setTagInfo(String tagInfo) {
        this.tagInfo = tagInfo;
    }

    public String getBQInfo() {
        return this.bqInfo;
    }

    public void setBQInfo(String bqInfo) {
        this.bqInfo = bqInfo;
    }

    public String getHg() {
        return this.hg;
    }

    public void setHg(String hg) {
        this.hg = hg;
    }
}

