/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.TabPage;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniDom;
import com.sdjxd.pms.platform.tool.StringTool;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MiniTabs
extends MiniCell
implements ICell {
    private static Logger log = Logger.getLogger(MiniTabs.class);
    private static final long serialVersionUID = 1L;
    private String assitInfo;
    private ArrayList tabPages;
    private String jsName;
    private int defaultPageIndex = 0;
    private boolean isTitleHorizontal = true;
    private int startPos = 0;
    private String arrowPosition = "side";
    private String showNavMenu = "false";
    private StringBuffer useDefineCssCls = new StringBuffer(100);

    public MiniTabs(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.readAttributesExt();
        this.setArrowPosition((String)this.dataExt.get("1C91D78E-94FD-4F7F-ABB0-FA5AF640E4F7"));
        this.setShowNavMenu((String)this.dataExt.get("860F5528-428C-488B-A499-79E9F8924352"));
        this.id = model.cellId;
        this.assitInfo = model.assitInfo;
        Object[] infos = StringTool.strToArray(model.assitInfo);
        this.tabPages = new ArrayList();
        if (infos != null) {
            int i = 0;
            while (i < infos.length) {
                String[] tmp = (String[])infos[i];
                if (tmp != null && tmp.length > 0 && tmp.length < 3) {
                    if (tmp.length > 0 && tmp[0].equals("1")) {
                        this.isTitleHorizontal = false;
                    }
                    if (tmp.length > 1 && !tmp[1].equals("")) {
                        this.startPos = Integer.parseInt(tmp[1]);
                    }
                }
                if (tmp != null && tmp.length > 4) {
                    TabPage tabPage = new TabPage();
                    tabPage.setTitle(tmp[2]);
                    String url = tmp[4];
                    tabPage.setUrl(url);
                    tabPage.setEnableScroll(tmp[1].equals("1"));
                    tabPage.setLoadNow(tmp[0].equals("1"));
                    tabPage.setDefault(tmp[3].equals("1"));
                    if (tmp[3].equals("1")) {
                        this.defaultPageIndex = i;
                    }
                    this.tabPages.add(tabPage);
                }
                ++i;
            }
        }
        this.jsName = "TabPage_" + this.id;
    }

    @Override
    protected String renderHtml(FormInstance form) throws Exception {
        MiniDom tabDom = new MiniDom("div");
        tabDom.add("id", this.getCellId());
        tabDom.add("class", "mini-tabs");
        tabDom.add("arrowPosition", this.arrowPosition);
        tabDom.add("showNavMenu", this.showNavMenu);
        tabDom.add("borderStyle", this.getBorderStyle());
        tabDom.add("bodyStyle", this.getbkColorStyle());
        tabDom.add("height", this.getHeight());
        tabDom.add("width", this.getWidth());
        tabDom.add(this.getCellLimits(form));
        tabDom.addStyle(this.getCellPositions(form));
        if (this.data.textColorStyle != null && this.data.textColorStyle.length() != 0) {
            tabDom.addClass("text", this.data.textColorStyle);
            this.addUseDefineCssCls(this.data.textColorStyle);
        }
        if (this.data.alignStyle != null && this.data.alignStyle.length() != 0) {
            tabDom.addClass("align", this.data.alignStyle);
            this.addUseDefineCssCls(this.data.alignStyle);
        }
        if (this.data.fontStyle != null && this.data.fontStyle.length() != 0) {
            tabDom.addClass("font", this.data.fontStyle);
            this.addUseDefineCssCls(this.data.fontStyle);
        }
        if (this.data.bkColorStyle != null && this.data.bkColorStyle.length() != 0) {
            tabDom.addClass("bgColorStyle", this.data.bkColorStyle);
            this.addUseDefineCssCls(this.data.bkColorStyle);
        }
        String cellValue = null;
        FormCell[] formCell = form.getCell();
        if (this.id < formCell.length && formCell[this.id] != null && (cellValue = formCell[this.id].getValue()) != null && cellValue.length() != 0) {
            tabDom.add("value", cellValue);
        }
        StringBuffer buffer = new StringBuffer(1024);
        tabDom.render(buffer);
        return buffer.toString();
    }

    @Override
    protected String renderScriptObject(FormInstance form) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("var " + this.jsName + " = new com.sdjxd.pms.platform.form.miniCell.Tabs({");
        sb.append("id:").append(this.id);
        sb.append(",typeName:'TabControl'");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",isTitleHorizontal:").append(this.isTitleHorizontal);
        sb.append(",tagId:\"").append(this.getCellId()).append("\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:").append("'" + StringTool.toJson(this.userDefinfo) + "'");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:").append(form.getCell()[this.id].getLimit());
        }
        sb.append(",needSave:false");
        sb.append(",miniid:");
        sb.append("'" + this.getCellId() + "'");
        sb.append(",defaultPageIndex:").append(this.defaultPageIndex);
        sb.append("});\n");
        int topTab = 0;
        int i = 0;
        while (i < this.tabPages.size()) {
            TabPage tabPage = (TabPage)this.tabPages.get(i);
            String title = tabPage.getTitle();
            String scroll = "auto";
            if (!tabPage.isEnableScroll()) {
                scroll = "no";
            }
            String url = tabPage.getUrl();
            if (tabPage.isDefault()) {
                topTab = i;
                url = tabPage.getUrl();
            }
            url = url.indexOf("?") != -1 ? String.valueOf(url) + "&TABID=" + i : String.valueOf(url) + "?TABID=" + i;
            url = StringTool.replaceKeyWord(url, form);
            sb.append(String.valueOf(this.jsName) + ".addTab(\"" + title + "\",\"" + Global.getName() + "/pms/platform/image/Tab_header1.gif\",\"" + url + "\",\"" + (tabPage.isLoadNow() ? "1" : "0") + "\",\"" + scroll + "\");\n");
            ++i;
        }
        sb.append(String.valueOf(this.jsName) + ".setDefault();\n");
        sb.append("defaultForm.addChild(").append(this.jsName).append(");");
        sb.append(this.getEventScript(form));
        return sb.toString();
    }

    public void addUseDefineCssCls(String useDefineCssCls) {
        if (this.useDefineCssCls.length() > 0) {
            this.useDefineCssCls.append(" ");
        }
        this.useDefineCssCls.append(useDefineCssCls);
    }

    public String getbkColorStyle() {
        try {
            if (this.data.bkColorStyle != null) {
                return this.getStyleTextById(this.data.bkColorStyle);
            }
        }
        catch (Exception e) {
            log.info((Object)"\u8bfb\u53d6\u5143\u4ef6\u8fb9\u6846\u6837\u5f0f\u5931\u8d25\uff01", (Throwable)e);
        }
        return "";
    }

    public String getArrowPosition() {
        return this.arrowPosition;
    }

    public void setArrowPosition(String arrowPosition) {
        this.arrowPosition = "1".equals(arrowPosition) ? "right" : "side";
    }

    public String getShowNavMenu() {
        return this.showNavMenu;
    }

    public void setShowNavMenu(String showNavMenu) {
        this.showNavMenu = "1".equals(showNavMenu) ? "true" : "false";
    }
}

