/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.cell.Area;
import com.sdjxd.pms.platform.form.service.cell.Cell;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import java.io.PrintWriter;
import java.util.Map;

public class MiniSplitter
extends MiniCell {
    private static final long serialVersionUID = 1L;
    private boolean vertical = false;
    private boolean allowResize = false;
    private boolean firstShowCollapseButton = true;
    private boolean secondShowCollapseButton = true;
    private boolean firstExpanded = false;
    private boolean secondExpanded = false;
    private String size = "100px";

    public MiniSplitter(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        ICell cell2;
        ICell cell1;
        super.setData(model);
        this.readAttributesExt();
        this.allowResize = !((String)this.dataExt.get("3B85D1EE-90A6-40A5-AC5E-D04CE0B8F0C2")).equals("0");
        this.firstExpanded = !((String)this.dataExt.get("C401E302-7D56-4B34-A8F8-036863E1C138")).equals("0");
        this.firstShowCollapseButton = !((String)this.dataExt.get("7A4FBBD8-9B7C-4C44-9AAF-06CF72EEB703")).equals("0");
        this.secondExpanded = !((String)this.dataExt.get("421E2145-F030-4104-A38F-D8A5E4B246A9")).equals("0");
        this.secondShowCollapseButton = !((String)this.dataExt.get("455F411D-8E25-4938-B133-A75A2DE67660")).equals("0");
        String[] temps = this.data.assitInfo.split("@");
        this.vertical = temps[0].equals("0");
        ICell[] cells = this.pattern.getCells();
        if (temps[1] != null && temps[1].trim().length() > 0 && (cell1 = cells[Integer.parseInt(temps[1])]) instanceof Area) {
            Area firstCell = (Area)cell1;
            firstCell.getAttributes().put("expanded", this.firstExpanded);
            firstCell.getAttributes().put("showCollapseButton", this.firstShowCollapseButton);
            if (this.vertical) {
                firstCell.getAttributes().put("size", firstCell.getStyle().get("height"));
            } else {
                Object mobileRate = Global.getContext().getSession("weChatAdaptRate");
                if (mobileRate != null) {
                    String wid = (String)firstCell.getStyle().get("width");
                    if (wid.indexOf("%") > -1) {
                        firstCell.getAttributes().put("size", firstCell.getStyle().get("width"));
                    } else {
                        wid = wid.substring(0, wid.indexOf("px"));
                        double widAct = Double.parseDouble(wid.trim()) * Double.parseDouble(mobileRate.toString().trim());
                        int widActInt = (int)Math.round(widAct);
                        firstCell.getAttributes().put("size", String.valueOf(widActInt) + "px");
                    }
                } else {
                    firstCell.getAttributes().put("size", firstCell.getStyle().get("width"));
                }
            }
            firstCell.setParentControls(this);
        }
        if (temps[2] != null && temps[2].trim().length() > 0 && (cell2 = cells[Integer.parseInt(temps[2])]) instanceof Cell) {
            Area secondCell = (Area)cell2;
            secondCell.getAttributes().put("expanded", this.secondExpanded);
            secondCell.getAttributes().put("showCollapseButton", this.secondShowCollapseButton);
            secondCell.setParentControls(this);
        }
    }

    @Override
    public void render(FormInstance formIns) throws Exception {
        PrintWriter out = formIns.getRenderHtml();
        out.write(this.renderStartHtml(formIns));
        if (this.controls != null) {
            for (ICell child : this.controls) {
                if (!(child instanceof Area)) continue;
                Area area = (Area)child;
                area.getStyle().clear();
                child.render(formIns);
            }
        }
        out.write(this.renderEndHtml(formIns));
        formIns.addScript("form_obj_cell_" + this.id, this.renderScriptObject(formIns));
    }

    protected String renderStartHtml(FormInstance formIns) throws Exception {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("<div id=\"").append(this.getCellId()).append("\" class=\"mini-splitter\" ");
        buffer.append("allowResize=\"").append(String.valueOf(this.allowResize)).append("\" ");
        buffer.append("vertical=\"").append(String.valueOf(this.vertical)).append("\" ");
        Map cellSizeMap = this.getCellSizes(formIns);
        if (this.vertical) {
            buffer.append("handlerSize=\"").append(this.height).append("px\" ");
            buffer.append("Style=\"").append("width:").append((String)cellSizeMap.get("width")).append(";height:100%;");
        } else {
            Object mobileRate = Global.getContext().getSession("weChatAdaptRate");
            if (mobileRate != null) {
                buffer.append("handlerSize=\"").append((double)this.width * Double.parseDouble(mobileRate.toString().trim())).append("px\" ");
            } else {
                buffer.append("handlerSize=\"").append(this.width).append("px\" ");
            }
            buffer.append("Style=\"").append("height:").append((String)cellSizeMap.get("height")).append(";width:100%;");
        }
        buffer.append("\">");
        return buffer.toString();
    }

    protected String renderEndHtml(FormInstance formIns) throws Exception {
        return "</div>";
    }

    @Override
    protected String renderHtml(FormInstance formIns) throws Exception {
        return "";
    }

    @Override
    protected String renderScriptObject(FormInstance formIns) throws Exception {
        StringBuffer script = new StringBuffer();
        script.append(" var miniSplitter_").append(this.id);
        script.append(" = new com.sdjxd.pms.platform.form.miniCell.Splitter({");
        script.append("id:\"").append(this.id).append("\",");
        script.append("miniid:\"").append(this.getCellId()).append("\"");
        script.append("}").append(");\r\n");
        script.append("defaultForm.addChild(miniSplitter_").append(this.id).append(");\r\n ");
        script.append(this.getEventScript(formIns));
        return script.toString();
    }
}

