/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.dao.TreeDao;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.LinkApp;
import com.sdjxd.pms.platform.form.model.TreeNodeBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniDom;
import com.sdjxd.pms.platform.form.service.minicell.ins.MiniPopTreeIns;
import com.sdjxd.pms.platform.tool.StringTool;
import java.util.Map;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;

public class MiniPopTree
extends MiniCell {
    private static final long serialVersionUID = 1L;
    private String popTitle = "\u5f39\u51fa\u6811";
    private int popHeight = 366;
    private int popWidth = 322;
    private boolean popShowCheckBox;
    private TreeDao treeDao = null;
    private String cellHight;
    private String appId;
    private String popOpenType;
    private String popTableId;
    private String tableName;
    private String tableId;
    private String expandOnLoad;
    private StringBuffer useDefineCssCls = new StringBuffer(100);

    public MiniPopTree(Form pattern) {
        super(pattern);
    }

    @Override
    protected String renderHtml(FormInstance formIns) throws Exception {
        MiniDom popTreeDom = new MiniDom("input");
        popTreeDom.add("id", this.getCellId());
        popTreeDom.add("class", "mini-buttonedit");
        popTreeDom.add("allowInput", "false");
        popTreeDom.add("validateOnChanged", "true");
        popTreeDom.add("validateOnLeave", "false");
        FormCell[] formCells = formIns.getCell();
        FormCell formCell = formCells[this.getId()];
        popTreeDom.add("value", this.getValue(formCell));
        popTreeDom.add("text", this.getText(formCell));
        popTreeDom.add(this.getCellLimits(formIns));
        popTreeDom.addStyle(this.getCellPositions(formIns));
        popTreeDom.addStyle(this.dualCellHeightFun(formIns));
        popTreeDom.addStyle("borderStyle", this.getBorderStyle());
        String str = String.valueOf(this.getBKStyle()) + this.getTAStyle() + this.getFontStyle();
        popTreeDom.add("inputStyle", str);
        if (this.data.alignStyle != null && this.data.alignStyle.length() != 0) {
            popTreeDom.addClass("align", this.data.alignStyle);
            this.addUseDefineCssCls(this.data.alignStyle);
        }
        if (this.data.bkColorStyle != null && this.data.bkColorStyle.length() != 0) {
            popTreeDom.addClass("bgColorStyle", this.data.bkColorStyle);
            this.addUseDefineCssCls(this.data.bkColorStyle);
        }
        StringBuffer buffer = new StringBuffer(1024);
        popTreeDom.render(buffer);
        return buffer.toString();
    }

    @Override
    protected String renderScriptObject(FormInstance formIns) throws Exception {
        MiniPopTreeIns formCell = (MiniPopTreeIns)formIns.getCell(this.id);
        String appId = formCell.getAppId();
        String expandOnLoad = formCell.getOpenLevelCount();
        boolean popShowCheckBox = formCell.isShowCheckBox();
        String popTableId = formCell.getPopTableId();
        String treeRootNodeFilter = "";
        if (Global.getContext().getParameter("treeRootNodeFilter") != null && Global.getContext().getParameter("treeRootNodeFilter").length() != 0) {
            treeRootNodeFilter = Global.getContext().getParameter("treeRootNodeFilter");
        }
        LinkApp linkApp = formCell.getLinkApp();
        JSONArray jsonArray = new JSONArray();
        if (this.popOpenType.equals("self")) {
            jsonArray = JSONArray.fromObject((Object)this.getNodeData(linkApp));
        }
        StringBuffer script = new StringBuffer();
        script.append(" var miniPopTree_").append(this.id);
        script.append(" = new com.sdjxd.pms.platform.form.miniCell.PopTree({");
        script.append("id:\"").append(this.id).append("\",");
        script.append("miniid:\"").append(this.getCellId()).append("\",");
        script.append("valueField:\"").append(this.data.valueField).append("\",");
        script.append("textField:\"").append(this.data.textField).append("\",");
        script.append("_popTitle:\"").append(this.popTitle).append("\",");
        script.append("_popHeight:\"").append(this.popHeight).append("\",");
        script.append("_popWidth:\"").append(this.popWidth).append("\",");
        script.append("_popShowCheckBox:\"").append(popShowCheckBox).append("\",");
        script.append("_popTableID:\"").append(popTableId).append("\",");
        script.append("_popOpenType:\"").append(this.popOpenType).append("\",");
        script.append("_popExpandOnLoad:\"").append(expandOnLoad).append("\",");
        script.append("_popTreeRootNodeFilter:\"").append(treeRootNodeFilter).append("\",");
        script.append("_appID:\"").append(appId).append("\"");
        if (formIns.getCell() != null && this.id < formIns.getCell().length && formIns.getCell()[this.id] != null) {
            script.append(",limit:");
            script.append(formIns.getCell()[this.id].getLimit());
        }
        script.append(",showName:\"" + this.cellName + "\"");
        script.append(",needSave:");
        script.append(this.isNeedSave());
        script.append(",needPrint:");
        script.append(formIns.getCell()[this.id].isPrint());
        script.append(",userDefCls:");
        script.append("'" + this.useDefineCssCls + "'");
        script.append(",divId:").append(this.data.areaId);
        script.append("},").append(jsonArray.toString()).append(");\r\n");
        script.append("defaultForm.addChild(miniPopTree_").append(this.id).append(");\r\n ");
        script.append("document.getElementById(\"").append(this.getCellId()).append("$text\").parentNode.style.height =\"" + this.cellHight + "\";\r\n ");
        script.append("document.getElementById(\"").append(this.getCellId()).append("$text\").style.height =\"" + this.cellHight + "\";\r\n ");
        String backgroundColor = this.getBKColor();
        if (backgroundColor != null) {
            script.append("document.getElementById(\"").append(this.getCellId()).append("$text\").parentNode.style.backgroundColor = \"").append(backgroundColor).append("\";\r\n ");
        }
        script.append(this.getEventScript(formIns));
        return script.toString();
    }

    @Override
    public void setData(CellBean model) throws Exception {
        String[] tmp;
        String widthTemp;
        String heightTemp;
        super.setData(model);
        this.readAttributesExt();
        String titleTemp = (String)this.dataExt.get("A6B7B257-09F0-446C-80D2-0858B3A1D505");
        if (!StringUtils.isEmpty((String)titleTemp)) {
            this.popTitle = titleTemp;
        }
        if (!StringUtils.isEmpty((String)(heightTemp = (String)this.dataExt.get("2FA671C0-68E4-49AF-8322-3144E4B30541")))) {
            try {
                this.popHeight = Integer.parseInt(heightTemp.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)(widthTemp = (String)this.dataExt.get("CE2A8E5C-193D-423F-8C6F-13C56AAAA53D")))) {
            try {
                this.popWidth = Integer.parseInt(widthTemp.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.popShowCheckBox = (tmp = (String[])StringTool.strToArray(this.data.assitInfo))[0].equals("1");
        int tag = tmp[5].indexOf(":");
        this.appId = tmp[5].substring(tag + 1, tmp[5].length());
        String string = this.expandOnLoad = tmp.length > 8 ? tmp[8] : "0";
        if (this.expandOnLoad.equals("-1")) {
            this.expandOnLoad = "0";
        }
        String string2 = this.popOpenType = ((String)this.dataExt.get("91438B41-3B64-4138-8C8A-119584F6823A")).equals("0") ? "self" : "newWindow";
        if (tmp.length > 12) {
            String string3 = this.popTableId = tmp[12] == null ? null : tmp[12].trim();
        }
        if (tmp.length > 13) {
            String string4 = this.tableId = tmp[13] == null ? null : tmp[13].trim();
        }
        if (tmp.length > 14) {
            this.tableName = tmp[14] == null ? null : tmp[14].trim();
        }
    }

    @Override
    public void setDefault(FormInstance form) {
        super.setDefault(form);
        FormCell formCell = form.getCell()[this.id];
        String defaultValue = formCell.getText();
        defaultValue = StringTool.replaceKeyWord(defaultValue, form);
        defaultValue = FormInstance.replaceParaValue(defaultValue, form);
        String defaultText = this.getDefaultText(defaultValue);
        int i = 0;
        while (i < this.controls.size()) {
            ((ICell)this.controls.get(i)).setDefault(form);
            ++i;
        }
        if (!HussarString.isEmpty((String)defaultValue) && !HussarString.isEmpty((String)defaultText)) {
            form.getCell()[this.id].setValue(defaultValue);
            form.getCell()[this.id].setText(defaultText);
        } else {
            form.getCell()[this.id].setValue("");
            form.getCell()[this.id].setText("");
        }
    }

    private String getDefaultText(String defaultValue) {
        String defaultText = "";
        if (HussarString.isEmpty((String)this.popTableId) || HussarString.isEmpty((String)this.tableId) || HussarString.isEmpty((String)this.tableName)) {
            return "";
        }
        StringBuffer sBuffer = new StringBuffer(64);
        try {
            sBuffer.append("SELECT TABLENAME FROM dbo.JXD7_XT_SYSTABLEINFO WHERE TABLEID = '").append(this.popTableId).append("'");
            Object popTableName = DbOper.executeQueryObject(sBuffer.toString());
            sBuffer.setLength(0);
            sBuffer.append("SELECT TOP 1 ").append(this.tableName).append(" FROM ").append(popTableName).append(" WHERE ").append(this.tableId).append("='").append(defaultValue).append("'");
            popTableName = DbOper.executeQueryObject(sBuffer.toString());
            if (popTableName != null) {
                defaultText = String.valueOf(popTableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return defaultText;
    }

    private TreeNodeBean[] getNodeData(LinkApp linkApp) {
        if (linkApp != null) {
            TreeNodeBean[] nodeArr = this.treeDao.getLinkAppRootNodeArray(linkApp, true, null, false);
            return nodeArr;
        }
        TreeNodeBean rootNode = new TreeNodeBean();
        rootNode.setId("rootNode");
        rootNode.setText("\u754c\u9762\u65b9\u6848\u914d\u7f6e\u9519\u8bef");
        rootNode.setChilds(null);
        TreeNodeBean[] nodeBeanArr = new TreeNodeBean[]{rootNode};
        return nodeBeanArr;
    }

    private String getBk() {
        try {
            return this.getStyleTextById(this.data.bkColorStyle);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private Map<String, String> dualCellHeightFun(FormInstance formIns) {
        String[] hightTempArr;
        Map cellSizeMap = this.getCellSizes(formIns);
        String hightTemp = (String)cellSizeMap.get("height");
        int tempSpanHeight = 0;
        if (hightTemp.indexOf("%") > 0 && (hightTempArr = hightTemp.split("%"))[0].trim().matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$")) {
            tempSpanHeight = Integer.parseInt(hightTempArr[0].trim());
            if (tempSpanHeight > 98) {
                this.cellHight = String.valueOf(tempSpanHeight - 2) + "%";
            } else {
                this.cellHight = String.valueOf(tempSpanHeight) + "%";
                tempSpanHeight += 2;
            }
            cellSizeMap.put("height", String.valueOf(tempSpanHeight) + "%");
        }
        if (tempSpanHeight == 0) {
            this.cellHight = String.valueOf(this.height) + "px";
            tempSpanHeight = this.height + 2;
            cellSizeMap.put("height", String.valueOf(tempSpanHeight) + "px");
        }
        return cellSizeMap;
    }

    public void addUseDefineCssCls(String useDefineCssCls) {
        if (this.useDefineCssCls.length() > 0) {
            this.useDefineCssCls.append(" ");
        }
        this.useDefineCssCls.append(useDefineCssCls);
    }

    @Override
    public FormCell createCellInstance() {
        return new MiniPopTreeIns();
    }

    @Override
    public void renderInstanceValue(FormInstance form) {
        MiniPopTreeIns formCell = (MiniPopTreeIns)form.getCell(this.id);
        String appId_Real = this.appId;
        if (Global.getContext().getParameter("appID") != null && Global.getContext().getParameter("appID").trim().length() > 0) {
            appId_Real = Global.getContext().getParameter("appID");
        }
        if (appId_Real != null && appId_Real.length() != 0) {
            this.treeDao = new TreeDao(appId_Real);
            LinkApp linkApp = this.treeDao.getLinkApp();
            if (linkApp != null) {
                String filter = linkApp.getFilter();
                if (filter == null) {
                    filter = "";
                }
                if (Global.getContext().getParameter("treeRootNodeFilter") != null && Global.getContext().getParameter("treeRootNodeFilter").length() != 0) {
                    if (filter != null && filter.length() != 0) {
                        filter = String.valueOf(filter) + " and ";
                    }
                    filter = String.valueOf(filter) + " (";
                    filter = String.valueOf(filter) + Global.getContext().getParameter("treeRootNodeFilter");
                    filter = String.valueOf(filter) + ")";
                }
                linkApp.setFilter(StringTool.replaceKeyWord(filter));
                formCell.setLinkApp(linkApp);
            }
        }
        formCell.setAppId(appId_Real);
        String openLevelCount_Real = this.expandOnLoad;
        if (Global.getContext().getParameter("h_treeNodeOpenLevel") != null && Global.getContext().getParameter("h_treeNodeOpenLevel").length() != 0) {
            openLevelCount_Real = Global.getContext().getParameter("h_treeNodeOpenLevel");
        }
        formCell.setOpenLevelCount(openLevelCount_Real);
        boolean showCheckBox_Real = this.popShowCheckBox;
        if (Global.getContext().getParameter("h_treeShowCheckBox") != null && Global.getContext().getParameter("h_treeShowCheckBox").length() != 0) {
            showCheckBox_Real = Global.getContext().getParameter("h_treeShowCheckBox").equals("1");
        }
        formCell.setShowCheckBox(showCheckBox_Real);
        String popTableId_Real = this.popTableId;
        if (!(popTableId_Real != null && popTableId_Real.length() != 0 || (popTableId_Real = Global.getContext().getParameter("tableID")) != null && popTableId_Real.length() != 0)) {
            popTableId_Real = "";
        }
        formCell.setPopTableId(popTableId_Real);
    }
}

