/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.ComboBoxColumnMeanBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniDom;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class MiniListBox
extends MiniCell {
    private static Logger log = Logger.getLogger(MiniListBox.class);
    private ComboBoxColumnMeanBean columnMean;
    private boolean showDefault = true;
    private boolean ismultiSelect = false;

    public MiniListBox(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        Object[] temp;
        super.setData(model);
        this.columnMean = new ComboBoxColumnMeanBean(model.meanDataSourceName, model.assitInfo, this.getLimitInfoArray());
        if (this.data.fieldMeanValue != null && "1".equals((temp = StringTool.strToArray(this.data.fieldMeanValue))[3])) {
            this.ismultiSelect = true;
        }
        this.readAttributesExt();
    }

    @Override
    public void setDefault(FormInstance form) {
        this.showDefault = true;
    }

    @Override
    protected String renderHtml(FormInstance formIns) {
        StringBuffer html = new StringBuffer();
        MiniDom dom = new MiniDom("div");
        dom.add("textField", "optionText");
        dom.add("valueField", "optionValue");
        dom.add("id", this.getCellId());
        dom.add("showName", this.getCellName());
        dom.add("showClose", String.valueOf(this.isShowClose()));
        dom.add("class", "mini-listbox");
        dom.add("borderStyle", this.getBorderStyle());
        dom.add("height", this.getHeight());
        dom.add("width", this.getWidth());
        dom.add("allowInput", String.valueOf(this.isAllowInput()));
        dom.add("showNullItem", String.valueOf(this.showNullItem()));
        dom.add("multiSelect", String.valueOf(this.isMultiSelect()));
        FormCell formCell = formIns.getCell()[this.getId()];
        dom.add("value", this.getValue(formCell));
        if (this.data.maxSize != 0) {
            dom.add("maxLength", String.valueOf(this.data.maxSize));
        }
        dom.add("limit", String.valueOf(this.limit));
        dom.add(this.getCellLimits(formIns));
        dom.addStyle(this.getStyleMap(formIns));
        if (this.ismultiSelect) {
            dom.add("multiSelect", "true");
        }
        dom.render(html);
        return html.toString();
    }

    @Override
    protected String renderScriptObject(FormInstance formIns) {
        StringBuffer sb = new StringBuffer();
        List cellData = this.getOptionData(formIns);
        JSONArray jsonArray = cellData == null ? null : JSONArray.fromObject((Object)cellData);
        sb.append("var cellData_").append(this.getId()).append(" = ").append(jsonArray == null ? null : jsonArray.toString()).append(";\r\n");
        ComboBoxColumnMeanBean bean = new ComboBoxColumnMeanBean(this.data.meanDataSourceName, this.data.fieldMeanValue, this.getLimitInfoArray());
        sb.append("var cmbMean" + this.id);
        sb.append(" = new com.sdjxd.pms.platform.form.cell.ComboBoxColumnMean({");
        if (!"".equals(bean.assistInfo)) {
            sb.append("assistInfo:").append(bean.assistInfo);
        }
        if (!"".equals(bean.dataSourceName)) {
            sb.append(",dataSourceName:\"").append(bean.dataSourceName).append("\"");
        }
        if (bean.fillMode != 0) {
            sb.append(",fillMode:").append(bean.fillMode);
        }
        if (!"".equals(bean.id)) {
            sb.append(",id:\"").append(bean.id).append("\"");
        }
        if (!"".equals(bean.moduleName)) {
            sb.append(",moduleName:\"").append(bean.moduleName).append("\"");
        }
        if (!"".equals(bean.name)) {
            sb.append(",name:\"").append(bean.name).append("\"");
        }
        sb.append("});\r\n");
        JSONObject jsonObj = JSONObject.fromObject((Object)this.getMiniOptionMap(formIns));
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.miniCell.ListBox(").append(jsonObj.toString()).append(",cmbMean").append(this.getId()).append(",").append("cellData_").append(this.getId()).append("));\r\n");
        sb.append(this.getEventScript(formIns));
        return sb.toString();
    }

    private List getOptionData(FormInstance formIns) {
        String assitInfo = this.data.fieldMeanValue;
        assitInfo = StringTool.replaceKeyWord(assitInfo);
        assitInfo = FormInstance.replaceParaValue(assitInfo, formIns);
        PatternDao dao = (PatternDao)BeanFactory.getSingleInstance("PatternDao");
        List options = dao.getdropDownOption(this.data.meanDataSourceName, assitInfo, this.getLimitInfoArray());
        return options;
    }

    private Map getMiniOptionMap(FormInstance formIns) {
        HashMap<String, Object> optionMap = new HashMap<String, Object>();
        optionMap.put("id", String.valueOf(this.getId()));
        optionMap.put("miniid", this.getCellId());
        optionMap.put("tagId", this.getCellId());
        optionMap.put("needSave", this.isNeedSave());
        optionMap.put("showName", this.getCellName());
        FormCell[] cells = formIns.getCell();
        FormCell cell = cells[this.getId()];
        optionMap.put("limit", cell.getLimit());
        String defaultValue = this.getDefaultValue(formIns);
        optionMap.put("value", defaultValue);
        optionMap.put("needPrint", cell.isPrint());
        optionMap.put("divId", this.data.areaId);
        optionMap.put("valueField", this.data.valueField);
        optionMap.put("textField", this.data.textField);
        return optionMap;
    }

    private String getDefaultValue(FormInstance formIns) {
        if (!this.showDefault) {
            return "";
        }
        String defaultValue = "";
        if (formIns.getCell() != null && this.id < formIns.getCell().length && formIns.getCell()[this.id] != null) {
            FormCell formCell = formIns.getCell()[this.getId()];
            defaultValue = this.getValue(formCell);
        }
        return defaultValue;
    }

    private boolean isShowClose() {
        String isShowClose = (String)this.dataExt.get("AC18BB0B-72C8-44F9-9855-064181EF3621");
        return "1".equals(isShowClose);
    }

    private boolean isAllowInput() {
        return this.data.readonly == 1;
    }

    private boolean isMultiSelect() {
        return this.columnMean.allowMultiSelect;
    }

    private boolean showNullItem() {
        return this.columnMean.appendEmptyItem;
    }

    private Map getStyleMap(FormInstance formIns) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.putAll(this.getCellPositions(formIns));
        retMap.put("background-color", this.getBk());
        retMap.put("color", this.getFC());
        return retMap;
    }

    private String getBk() {
        try {
            String str = this.getStyleTextById(this.data.bkColorStyle);
            return str.split(":").length == 2 ? str.split(":")[1] : "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getFC() {
        try {
            String str = this.getStyleTextById(this.data.textColorStyle);
            return str.split(":").length == 2 ? str.split(":")[1] : "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

