/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniDom;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class MiniDatePicker
extends MiniCell {
    private static final long serialVersionUID = 1L;
    protected String fieldMeanValue;
    private String label;
    private String showTodayButton = "true";
    private String showOkButton = "false";
    private String showClearButton = "true";
    private String allowInput = "false";
    private String valueType = "String";
    private String minDate;
    private String maxDate;
    private String viewDate;

    public MiniDatePicker(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        String[] mean = (String[])StringTool.strToArray(this.data.fieldMeanValue);
        this.fieldMeanValue = mean != null && mean.length > 0 ? mean[0] : "yyyy-MM-dd HH:mm:ss";
        this.readAttributesExt();
        this.setShowOkButton((String)this.dataExt.get("33D1A3F1-8EAE-4627-B12B-9BAB73423BC6"));
        this.setShowClearButton((String)this.dataExt.get("CFA0E38F-435E-4845-ADBF-A0926B74D4CB"));
        this.setMinDate(StringTool.replaceKeyWord((String)this.dataExt.get("30BC6A5F-43AB-45B0-8B06-25DAFE03C58F")));
        this.setMaxDate(StringTool.replaceKeyWord((String)this.dataExt.get("505BA97C-2411-4ACE-90E0-A66E1AE57D9B")));
        this.setViewDate(StringTool.replaceKeyWord((String)this.dataExt.get("DBF5C03C-5BD2-4BD5-87FA-28DC32684DD6")));
        this.setShowTodayButton((String)this.dataExt.get("09538624-171A-4BD5-A6E8-61A616C59DB8"));
    }

    @Override
    protected String renderHtml(FormInstance form) throws Exception {
        MiniDom datePickerDom = new MiniDom("div");
        datePickerDom.add("id", this.getCellId());
        datePickerDom.add("class", "mini-datepicker");
        datePickerDom.add("borderStyle", this.getBorderStyle());
        String str = String.valueOf(this.getBKStyle()) + this.getTAStyle() + this.getFontStyle();
        datePickerDom.add("inputStyle", "vertical-align:middle;line-height:" + this.getHeight() + ";" + str);
        datePickerDom.add("height", this.getHeight());
        datePickerDom.add("width", this.getWidth());
        datePickerDom.add("format", this.fieldMeanValue);
        if (this.fieldMeanValue.length() > 11) {
            datePickerDom.add("showTime", "true");
            datePickerDom.add("timeFormat", this.fieldMeanValue.substring(11, this.fieldMeanValue.length()));
        }
        datePickerDom.add("valueType", this.valueType);
        datePickerDom.add("showOkButton", this.showOkButton);
        datePickerDom.add("showClearButton", this.showClearButton);
        datePickerDom.add("showTodayButton", this.showTodayButton);
        datePickerDom.add("allowInput", this.allowInput);
        datePickerDom.add("minDate", this.minDate);
        datePickerDom.add("maxDate", this.maxDate);
        datePickerDom.add("viewDate", this.viewDate);
        String defaultValue = DateTool.formatDate(form.getCell()[this.id].getValue(), this.fieldMeanValue);
        datePickerDom.add("value", defaultValue);
        if (this.data.limit == 2) {
            datePickerDom.add("required", "true");
        } else {
            datePickerDom.add("required", "false");
        }
        if (this.dataExt.get("CEE48D6A-10BA-4BB3-84EA-1B50C015082A") != "" && this.dataExt.get("CEE48D6A-10BA-4BB3-84EA-1B50C015082A") != null) {
            datePickerDom.add("emptyText", (String)this.dataExt.get("CEE48D6A-10BA-4BB3-84EA-1B50C015082A"));
        }
        datePickerDom.add(this.getCellLimits(form));
        datePickerDom.addStyle(this.getCellPositions(form));
        StringBuffer buffer = new StringBuffer(1024);
        datePickerDom.render(buffer);
        return buffer.toString();
    }

    @Override
    protected String renderScriptObject(FormInstance formIns) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (this.fieldMeanValue != null && this.fieldMeanValue.length() != 0) {
            sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.miniCell.DatePicker({id:");
            sb.append(this.id);
            sb.append(",miniid:'").append(this.getCellId()).append("'");
            sb.append(",valueField:'").append(this.data.valueField).append("'");
            sb.append(",textField:'").append(this.data.textField).append("'");
            sb.append(",tagId:");
            sb.append("document.getElementById(\"cellId" + this.id).append("\")");
            sb.append(",divId:").append(this.data.areaId);
            sb.append(",userDefinfo:");
            sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
            sb.append(",format:\"");
            sb.append(this.fieldMeanValue);
            if (Form.FOrmType.equals("0")) {
                sb.append("\",needSave:");
                sb.append(this.isNeedSave());
                sb.append(",needPrint:");
                sb.append(formIns.getCell()[this.id].isPrint());
                sb.append(",bgColorStyle:'").append(this.data.bkColorStyle).append("'");
                sb.append(",readOnlyBgColorStyle:'").append(this.data.readBkColorStyle).append("'");
                sb.append(",showName:\"" + this.cellName + "\"");
                sb.append(",label:\"" + StringTool.toJson(this.label) + "\"");
            }
            if (formIns.getCell() != null && this.id < formIns.getCell().length && formIns.getCell()[this.id] != null) {
                sb.append(",limit:");
                sb.append(formIns.getCell()[this.id].getLimit());
            }
            sb.append(",value:\"").append(formIns.getCell()[this.id].getValue()).append("\"");
            sb.append("}));\r\n");
            String backgroundColor = this.getBKColor();
            if (backgroundColor != null) {
                sb.append("document.getElementById(\"").append(this.getCellId()).append("$text\").parentNode.style.backgroundColor = \"").append(backgroundColor).append("\";\r\n ");
            }
            sb.append(this.getEventScript(formIns));
        }
        return sb.toString();
    }

    @Override
    public void setDefault(FormInstance form) {
        super.setDefault(form);
        FormCell formCell = form.getCell()[this.id];
        String defaultValue = formCell.getText();
        defaultValue = StringTool.replaceKeyWord(defaultValue, form);
        defaultValue = FormInstance.replaceParaValue(defaultValue, form);
        int i = 0;
        while (i < this.controls.size()) {
            ((ICell)this.controls.get(i)).setDefault(form);
            ++i;
        }
        if (!StringTool.isEmpty(defaultValue)) {
            formCell.setValue(defaultValue);
            formCell.setText(DateTool.formatDate(formCell.getText(), this.fieldMeanValue));
        }
    }

    private boolean isDate(String date) {
        if (date.indexOf("\u6708") != -1) {
            date = date.replaceAll("\u5e74", "-");
        }
        if (date.indexOf("\u65e5") != -1) {
            date = date.replaceAll("\u6708", "-");
        }
        date = date.replaceAll("\u65e5", "");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            format.setLenient(false);
            format.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public String getShowTodayButton() {
        return this.showTodayButton;
    }

    public void setShowTodayButton(String showTodayButton) {
        if ("1".equals(showTodayButton)) {
            String curTime = DateTool.getCurrentDate("yyyy-MM-dd");
            this.showTodayButton = this.getMinDate().compareTo(curTime) > 0 || curTime.compareTo(this.getMaxDate()) > 0 ? "false" : "true";
        } else {
            this.showTodayButton = "false";
        }
    }

    public String getShowOkButton() {
        return this.showOkButton;
    }

    public void setShowOkButton(String showOkButton) {
        this.showOkButton = "1".equals(showOkButton) ? "true" : "false";
    }

    public String getShowClearButton() {
        return this.showClearButton;
    }

    public void setShowClearButton(String showClearButton) {
        this.showClearButton = "1".equals(showClearButton) ? "true" : "false";
    }

    public String getMinDate() {
        return this.minDate;
    }

    public void setMinDate(String minDate) throws Exception {
        if (HussarString.isEmpty((String)minDate)) {
            this.minDate = "";
        } else if (this.isDate(minDate)) {
            this.minDate = minDate;
        } else {
            throw new Exception("\u6700\u5c0f\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
    }

    public String getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(String maxDate) throws Exception {
        if (HussarString.isEmpty((String)maxDate)) {
            this.maxDate = "";
        } else if (this.isDate(maxDate)) {
            this.maxDate = maxDate;
        } else {
            throw new Exception("\u6700\u5927\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
    }

    public String getViewDate() {
        return this.viewDate;
    }

    public void setViewDate(String viewDate) throws Exception {
        if (HussarString.isEmpty((String)viewDate)) {
            this.viewDate = "";
        } else if (this.isDate(viewDate)) {
            this.viewDate = viewDate;
        } else {
            throw new Exception("\u4e0b\u62c9\u9ed8\u8ba4\u663e\u793a\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
    }
}

