/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.base72.GlobalSql;
import com.sdjxd.hussar.core.permit72.service.support.PermitCtrl;
import com.sdjxd.hussar.core.utils.HussarJson;
import com.sdjxd.pms.development.form.CustomListData;
import com.sdjxd.pms.platform.base.Context;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.ListMap;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.DropDownOptionBean;
import com.sdjxd.pms.platform.form.model.ListStyleColumnData;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.cell.ListStyle;
import com.sdjxd.pms.platform.form.service.minicell.CellEvents;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniDom;
import com.sdjxd.pms.platform.form.service.minicell.ins.MiniDataGridIns;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.table.model.FieldMeanBean;
import com.sdjxd.pms.platform.table.service.mean.FieldMean;
import com.sdjxd.pms.platform.table.sql.EditGridSql;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.CheckClient;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class MiniDataGrid
extends MiniCell {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(MiniDataGrid.class);
    private String styleId = "";
    private String cellId;
    private StringBuilder fieldMeanData;
    private StringBuilder fieldMeanObj;
    private String strClassName;
    private String sizeList;
    private String tableLinkId;
    private Map<String, String> tableLinkInfo;
    private String listType;
    private boolean allowInput = true;
    private String customUrl;
    private Map<String, Object> curtomData;

    public MiniDataGrid(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.tableLinkId = model.tableLinkId;
        this.readAttributesExt();
        this.cellId = this.getCellId();
        if (model.readonly == 0) {
            this.allowInput = false;
        }
        this.sizeList = (String)this.dataExt.get("A8FC4129-52E0-44C0-AA1C-04A6AD3D1C6D");
        if (this.sizeList == null || "".equals(this.sizeList)) {
            this.sizeList = "[10,20,50,100]";
        } else if (!this.sizeList.startsWith("[") && !this.sizeList.endsWith("]")) {
            this.sizeList = "[" + this.sizeList + "]";
        }
        this.customUrl = (String)this.dataExt.get("E34A1B32-0A38-485C-B16E-7EFD04420ED5");
        if (this.customUrl == null) {
            this.customUrl = "";
        }
        this.listType = (String)this.dataExt.get("E72EB389-4505-476C-9F41-3D865B0BAFE2");
    }

    @Override
    protected String renderHtml(FormInstance form) throws Exception {
        MiniDom dataGridDom = new MiniDom("div");
        dataGridDom.add("id", this.cellId);
        dataGridDom.add("class", "mini-datagrid");
        dataGridDom.add("showColumns", "true");
        dataGridDom.add("showHGridLines", "true");
        dataGridDom.add("showVGridLines", "true");
        dataGridDom.add("sizeList", this.sizeList);
        dataGridDom.add("pageIndex", "0");
        dataGridDom.add("allowAlternating", "true");
        dataGridDom.add("allowCellValid", "true");
        dataGridDom.addStyle(this.getCellPositions(form));
        dataGridDom.addStyle(this.getCellSizes(form));
        dataGridDom.add(this.getCellLimits(form));
        dataGridDom.add("enabled", "true");
        MiniDom columns = new MiniDom("div");
        columns.add("property", "columns");
        MiniDataGridIns formCell = (MiniDataGridIns)form.getCell()[this.getId()];
        this.dealListstyle(columns, dataGridDom, formCell);
        CellEvents cellEvent = this.getCellEvent();
        if (cellEvent != null) {
            columns = cellEvent.afterRenderHtml(this, columns);
        }
        dataGridDom.appendChild(columns);
        StringBuffer buffer = new StringBuffer(1024);
        dataGridDom.render(buffer);
        return buffer.toString();
    }

    public MiniDom dealColumnGroup(MiniDom columns, String str) {
        try {
            ArrayList<MiniDom> columnList = columns.controls;
            JSONArray groupDatas = JSONArray.fromObject((Object)str);
            int i = 0;
            int leni = groupDatas.size();
            while (i < leni) {
                JSONArray groupData = (JSONArray)groupDatas.get(i);
                int index = 0;
                ArrayList<MiniDom> columnListTemp = new ArrayList<MiniDom>();
                int j = 0;
                int lenj = groupData.size();
                while (j < lenj) {
                    JSONObject group = (JSONObject)groupData.get(j);
                    Iterator it = group.keys();
                    if (it.hasNext()) {
                        String key = (String)it.next();
                        String value = (String)group.get(key);
                        String[] keyArr = key.split(",");
                        int beginIndex = Integer.parseInt(keyArr[0]);
                        int endIndex = Integer.parseInt(keyArr[1]);
                        while (index < beginIndex) {
                            columnListTemp.add((MiniDom)columnList.get(index));
                            ++index;
                        }
                        MiniDom head = new MiniDom("div");
                        head.add("header", value);
                        head.add("headerAlign", "center");
                        MiniDom cols = new MiniDom("div");
                        cols.add("property", "columns");
                        head.appendChild(cols);
                        while (index <= endIndex) {
                            cols.appendChild((MiniDom)columnList.get(index));
                            ++index;
                        }
                        columnListTemp.add(head);
                    }
                    ++j;
                }
                int len = columnList.size();
                while (index < len) {
                    columnListTemp.add((MiniDom)columnList.get(index));
                    ++index;
                }
                columnList = columnListTemp;
                ++i;
            }
            MiniDom columnsReturn = new MiniDom("div");
            columnsReturn.add("property", "columns");
            columnsReturn.controls = columnList;
            return columnsReturn;
        }
        catch (Exception e) {
            log.error((Object)"\u590d\u6742\u8868\u5934\u5904\u7406\u5f02\u5e38", (Throwable)e);
            return columns;
        }
    }

    @Override
    protected String renderScriptObject(FormInstance form) throws Exception {
        MiniDataGridIns formCell = (MiniDataGridIns)form.getCell(this.id);
        String styleId = formCell.getStyleId();
        ListStyle listStyle = formCell.getListStyle();
        StringBuffer scriptObj = new StringBuffer(1024);
        this.dealTableLink(form);
        scriptObj.append("\tvar " + this.cellId + " = new ").append(this.strClassName).append("({");
        scriptObj.append("id:").append("").append(this.id).append(",");
        scriptObj.append("miniid:").append("\"").append(this.cellId).append("\",");
        scriptObj.append("listType:").append(this.listType).append(",");
        scriptObj.append("needSave:").append(this.isNeedSave()).append(",");
        scriptObj.append("limit:").append(this.limit).append(",");
        scriptObj.append("divId:").append(this.data.areaId).append(",");
        scriptObj.append("isAutoHeight:").append(listStyle.getIsAutoHeight()).append(",");
        scriptObj.append("isAllowPage:").append(listStyle.isAllowPage()).append(",");
        scriptObj.append("tagId:document.getElementById(\"").append(this.cellId).append("_divAll").append("\"),");
        scriptObj.append("userDefinfo:").append("\"").append(StringTool.toJson(this.userDefinfo)).append("\"").append(",");
        scriptObj.append("cellReadOnlyCss:\"").append(this.data.readBkColorStyle).append("\",");
        scriptObj.append("listStyleId:\"").append(styleId).append("\",");
        scriptObj.append("order:").append(this.getOrderSql(listStyle)).append(",");
        scriptObj.append("orderStr:\"").append(listStyle.getOrderField()).append("\",");
        scriptObj.append("tableLinkInfo:").append(HussarJson.gson_toJson(this.tableLinkInfo)).append(",");
        scriptObj.append("gridData:").append(this.installGridData(listStyle)).append(",");
        if (this.curtomData != null) {
            scriptObj.append("pageSize:").append(this.curtomData.get("pageSize")).append(",");
            scriptObj.append("listStyle:").append(HussarJson.toPureJson(this.curtomData));
        } else {
            scriptObj.append("pageSize:").append(listStyle.getPageDataSize()).append(",");
            scriptObj.append("listStyle:").append(HussarJson.toPureJson((Object)listStyle));
        }
        scriptObj.append("}); \n");
        scriptObj.append("defaultForm.addChild(").append(this.cellId).append("); \n");
        scriptObj.append(this.getEventScript(form)).append("\n");
        scriptObj.append((CharSequence)this.fieldMeanData).append("\n");
        scriptObj.append((CharSequence)this.fieldMeanObj).append("\n");
        if (listStyle.isLoadData()) {
            scriptObj.append(String.valueOf(this.cellId) + ".setGridData()").append("\n");
        }
        return scriptObj.toString();
    }

    private void dealListstyle(MiniDom pdom, MiniDom dataGridDom, MiniDataGridIns formCell) throws Exception {
        int celllimit = formCell.getLimit();
        if ("1".equals(this.listType) && this.customUrl.equals("") && celllimit >= 2) {
            this.dealListstyleEdit(pdom, dataGridDom, formCell);
        } else {
            this.dealListstyleReadOnly(pdom, dataGridDom, formCell);
        }
    }

    private void dealListstyleEdit(MiniDom pdom, MiniDom dataGridDom, MiniDataGridIns formCell) throws Exception {
        HashMap keys = formCell.getKeys();
        String styleId = formCell.getStyleId();
        ListStyle listStyle = formCell.getListStyle();
        HashMap<String, String> colLimitMap = new HashMap<String, String>();
        if (keys != null) {
            Iterator it = keys.entrySet().iterator();
            String currentStyleId = styleId;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String[] info = (String[])entry.getKey();
                if (info == null || info.length <= 2) continue;
                int columnLimit = Integer.parseInt((String)entry.getValue());
                String columnOfStyleId = info[2];
                String columnId = info[3];
                if (columnLimit != 1 || columnOfStyleId != null && !columnOfStyleId.equals(currentStyleId)) continue;
                colLimitMap.put(columnId, columnId);
            }
        }
        this.strClassName = "com.sdjxd.pms.platform.form.miniCell.MiniEditGrid";
        this.fieldMeanData = new StringBuilder(256);
        this.fieldMeanObj = new StringBuilder(256);
        Map listFieldMean = FieldMean.getListFieldMeanDb(styleId);
        dataGridDom.add("idField", listStyle.getPkCol());
        if (this.allowInput) {
            dataGridDom.add("allowCellEdit", "true");
        }
        dataGridDom.add("allowCellSelect", "true");
        dataGridDom.add("allowCellValid", "true");
        if (!listStyle.isAllowPage()) {
            dataGridDom.add("showPager", "false");
        }
        List list = listStyle.getColumnData();
        MiniDom dom = null;
        ListStyleColumnData colunmObj = null;
        MiniDom fieldMean = null;
        FieldMeanBean fieldMeanBean = null;
        int i = 0;
        int len = list.size();
        while (i < len) {
            boolean config = true;
            colunmObj = (ListStyleColumnData)list.get(i);
            dom = new MiniDom("div");
            if (listStyle.isHeaderSort()) {
                dom.add("allowSort", "true");
            }
            dom.add("width", colunmObj.getColumnWidth());
            if (1 == colunmObj.getDataLimit()) {
                dom.add("vtype", "required");
            }
            if (colunmObj.getCellStyle() == 0) {
                dataGridDom.add("allowCellWrap", "true");
            }
            int columnType = colunmObj.getColumnType();
            switch (columnType) {
                case 0: {
                    break;
                }
                case 1: {
                    dom.add("renderer", "com.sdjxd.pms.platform.form.miniCell.MiniDataGrid.formatEventStr");
                    dom.add("data-options", "{_gridId:" + this.getId() + ",eventStr:'" + colunmObj.getEventArg().replace("'", "\\'") + "'}");
                    break;
                }
                case 2: {
                    dom.add("renderer", "com.sdjxd.pms.platform.form.miniCell.MiniDataGrid.formatStatic");
                    break;
                }
                case 4: {
                    dataGridDom.add("multiSelect", "true");
                    dom.add("type", "checkcolumn");
                    pdom.appendChild(dom);
                    config = false;
                    break;
                }
                case 5: {
                    dom.add("type", "indexcolumn");
                    if (Integer.parseInt(colunmObj.getColumnWidth()) >= 0) {
                        dom.setCellBody(colunmObj.getShowName());
                        dom.add("align", colunmObj.getHAlign());
                        dom.add("headerAlign", "center");
                    }
                    pdom.appendChild(dom);
                    config = false;
                    break;
                }
                case 6: {
                    config = false;
                    break;
                }
                case 7: {
                    dom.add("renderer", "com.sdjxd.pms.platform.form.miniCell.MiniDataGrid.formatImage");
                    dom.add("data-options", "{_gridId:" + this.getId() + ",srcStr:'" + colunmObj.getAssitInfo().replace("\"", "\\'") + "'}");
                    break;
                }
                case 9: {
                    break;
                }
            }
            if (config) {
                dom.add("field", colunmObj.getAsName());
                dom.add("name", colunmObj.getAsName());
                dom.setCellBody(colunmObj.getShowName());
                dom.add("align", colunmObj.getHAlign());
                dom.add("headerAlign", "center");
                if (9 != columnType && 1 != columnType && 2 != columnType && 7 != columnType && colLimitMap.get(colunmObj.getColumnId()) == null) {
                    fieldMean = new MiniDom("input");
                    fieldMean.add("property", "editor");
                    fieldMean.addStyle("width", "100%");
                    if (1 == colunmObj.getDataLimit()) {
                        fieldMean.add("required", "true");
                    }
                    fieldMean.add("minHeight", "24");
                    fieldMeanBean = (FieldMeanBean)listFieldMean.get(colunmObj.getMeanId());
                    if (fieldMeanBean != null) {
                        Object[] assitinfo = fieldMeanBean.getAssitinfo();
                        if ("IDStringPicker".equals(fieldMeanBean.getType())) {
                            fieldMean.add("class", "mini-combobox");
                            fieldMean.add("data", String.valueOf(this.getCellId()) + colunmObj.getColumnId());
                            this.dealDorpDonData(assitinfo, colunmObj.getColumnId(), fieldMeanBean.getDataSourceName());
                            if (assitinfo.length >= 4 && "1".equals(assitinfo[3])) {
                                fieldMean.add("multiSelect", "true");
                            }
                            if (assitinfo.length >= 6 && "1".equals(assitinfo[5])) {
                                fieldMean.add("showNullItem", "true");
                            }
                        } else if ("DateTime".equals(fieldMeanBean.getType())) {
                            String dateFromate = (String)assitinfo[0];
                            fieldMean.add("class", "mini-datepicker");
                            fieldMean.add("format", dateFromate);
                            fieldMean.add("showTime", "true");
                            dom.add("dateFormat", dateFromate);
                        } else if (!"Password".equals(fieldMeanBean.getType())) {
                            if ("LongText".equals(fieldMeanBean.getType())) {
                                fieldMean.add("class", "mini-textarea");
                                fieldMean.add("minHeight", "70");
                                this.initFieldMean(assitinfo, colunmObj, dom, fieldMean);
                            } else if ("Text".equals(fieldMeanBean.getType())) {
                                fieldMean.add("class", "mini-textarea");
                                this.initFieldMean(assitinfo, colunmObj, dom, fieldMean);
                            } else if ("ID_Selector".equals(fieldMeanBean.getType()) || "MIUI_Selector".equals(fieldMeanBean.getType())) {
                                fieldMean.add("class", "mini-buttonedit");
                                dom.add("displayField", colunmObj.getColumnId());
                                this.dealIDselectMean(fieldMean, assitinfo, colunmObj.getColumnId());
                                fieldMean.add("onbuttonclick", "com.sdjxd.pms.platform.form.miniCell.MiniEditGrid.ID_Selector");
                                fieldMean.add("allowInput", "false");
                            }
                        }
                    } else {
                        fieldMean.add("class", "mini-textbox");
                    }
                    dom.appendChild(fieldMean);
                }
                pdom.appendChild(dom);
            }
            ++i;
        }
    }

    private void dealIDselectMean(MiniDom fieldMean, Object[] assitinfo, String colId) {
        String[] temp;
        StringBuffer sb = new StringBuffer(50);
        sb.append("{url:'").append(assitinfo[0].toString().replace("\\", "\\\\")).append("',idfield:'").append(assitinfo[1]).append("',");
        sb.append("fieldName:'").append(assitinfo[2]).append("',").append("tableName:'").append(assitinfo[3]).append("',");
        String[] stringArray = temp = assitinfo[4].toString().toUpperCase().split(";");
        int n = temp.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.indexOf("DIALOGHEIGHT") != -1) {
                str = str.replace("DIALOGHEIGHT", "").replace("=", "").replace(":", "").replace("PX", "");
                sb.append("dHeight:").append(str).append(",");
            } else if (str.indexOf("DIALOGWIDTH") != -1) {
                str = str.replace("DIALOGWIDTH", "").replace("=", "").replace(":", "").replace("PX", "");
                sb.append("dWidth:").append(str).append(",");
            } else if (str.indexOf("RESIZABLE") != -1) {
                str = str.replace("RESIZABLE", "").replace("=", "").replace(":", "").replace("PX", "");
                sb.append("resizable:'").append(str.toLowerCase()).append("',");
            }
            ++n2;
        }
        sb.append("colId:'").append(colId).append("',");
        sb.append("colName:'").append(colId).append("__T',");
        sb.append("cellId:'").append(this.getCellId()).append("',");
        sb.append("canEdit:").append(assitinfo[5]).append("}");
        fieldMean.add("data-options", sb.toString());
    }

    private void initFieldMean(Object[] assitinfo, ListStyleColumnData colName, MiniDom dom, MiniDom fieldMean) {
        Object[] mean;
        String meanStr;
        if (assitinfo != null && assitinfo.length != 0 && !(meanStr = (mean = (Object[])assitinfo[0])[0].toString()).startsWith("/")) {
            if (1 == colName.getDataLimit()) {
                dom.add("vtype", String.valueOf(meanStr) + ";required");
            } else {
                dom.add("vtype", meanStr);
            }
            fieldMean.add("vtype", meanStr);
        }
    }

    private void dealDorpDonData(Object[] assitinfo, String colName, String dataSourceName) {
        this.fieldMeanData.append(" var  ").append(this.getCellId()).append(colName);
        this.fieldMeanData.append(" = [");
        String ass = StringTool.arrayToStr(assitinfo);
        PatternDao dao = (PatternDao)BeanFactory.getSingleInstance("PatternDao");
        List options = dao.getdropDownOption(dataSourceName, ass, this.getLimitInfoArray());
        if (options != null) {
            int i = 0;
            int len = options.size();
            while (i < len) {
                if (i != len - 1) {
                    this.fieldMeanData.append("{id:\"").append(((DropDownOptionBean)options.get(i)).getOptionValue()).append("\",text:\"").append(((DropDownOptionBean)options.get(i)).getOptionText()).append("\"},");
                } else {
                    this.fieldMeanData.append("{id:\"").append(((DropDownOptionBean)options.get(i)).getOptionValue()).append("\",text:\"").append(((DropDownOptionBean)options.get(i)).getOptionText()).append("\"}");
                }
                ++i;
            }
        }
        this.fieldMeanData.append("];\n");
    }

    private void dealListstyleReadOnly(MiniDom pdom, MiniDom dataGridDom, MiniDataGridIns formCell) throws Exception {
        String styleId = formCell.getStyleId();
        ListStyle listStyle = formCell.getListStyle();
        this.strClassName = "com.sdjxd.pms.platform.form.miniCell.MiniDataGrid";
        Map listFieldMean = FieldMean.getListFieldMeanDb(styleId);
        FieldMeanBean fieldMeanBean = null;
        dataGridDom.add("idField", listStyle.getPkCol());
        if (!listStyle.isAllowPage()) {
            dataGridDom.add("showPager", "false");
        }
        List list = listStyle.getColumnData();
        MiniDom dom = null;
        ListStyleColumnData colunmObj = null;
        int i = 0;
        int len = list.size();
        while (i < len) {
            boolean b = true;
            colunmObj = (ListStyleColumnData)list.get(i);
            dom = new MiniDom("div");
            if (listStyle.isHeaderSort()) {
                dom.add("allowSort", "true");
            }
            dom.add("width", colunmObj.getColumnWidth());
            if (colunmObj.getCellStyle() == 0) {
                dataGridDom.add("allowCellWrap", "true");
            }
            switch (colunmObj.getColumnType()) {
                case 0: {
                    break;
                }
                case 1: {
                    dom.add("renderer", "com.sdjxd.pms.platform.form.miniCell.MiniDataGrid.formatEventStr");
                    dom.add("data-options", "{_gridId:" + this.getId() + ",eventStr:'" + colunmObj.getEventArg().replace("'", "\\'") + "'}");
                    break;
                }
                case 2: {
                    dom.add("renderer", "com.sdjxd.pms.platform.form.miniCell.MiniDataGrid.formatStatic");
                    break;
                }
                case 4: {
                    dataGridDom.add("multiSelect", "true");
                    dom.add("type", "checkcolumn");
                    pdom.appendChild(dom);
                    b = false;
                    break;
                }
                case 5: {
                    dom.add("type", "indexcolumn");
                    if (Integer.parseInt(colunmObj.getColumnWidth()) >= 0) {
                        dom.setCellBody(colunmObj.getShowName());
                        dom.add("align", colunmObj.getHAlign());
                        dom.add("headerAlign", "center");
                    }
                    pdom.appendChild(dom);
                    b = false;
                    break;
                }
                case 6: {
                    b = false;
                    break;
                }
                case 7: {
                    dom.add("renderer", "com.sdjxd.pms.platform.form.miniCell.MiniDataGrid.formatImage");
                    dom.add("data-options", "{_gridId:" + this.getId() + ",srcStr:'" + colunmObj.getAssitInfo().replace("\"", "\\'") + "',eventStr:'" + colunmObj.getEventArg().replace("'", "\\'") + "'}");
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
            }
            if (b) {
                fieldMeanBean = (FieldMeanBean)listFieldMean.get(colunmObj.getMeanId());
                dom.add("field", colunmObj.getAsName());
                dom.add("name", colunmObj.getAsName());
                dom.setCellBody(colunmObj.getShowName());
                dom.add("align", colunmObj.getHAlign());
                dom.add("headerAlign", "center");
                pdom.appendChild(dom);
            }
            ++i;
        }
    }

    private String installGridData(ListStyle listStyle) throws Exception {
        if (listStyle.isLoadData()) {
            if (this.customUrl.equals("")) {
                return HussarJson.gson_toJson((Object)listStyle.getData());
            }
            return HussarJson.gson_toJson((Object)this.getCustomUrlData(listStyle).get("dataDb"));
        }
        return "{data:[],total:0}";
    }

    private Map<String, Object> getCustomUrlData(ListStyle listStyle) {
        if (this.customUrl == null || this.customUrl.equals("")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("pageSize", "0");
            map.put("rowCount", "0");
            map.put("dataDb", new ArrayList());
            return map;
        }
        this.inItCustomUrlData(listStyle);
        return this.curtomData;
    }

    private void inItCustomUrlData(ListStyle listStyle) {
        if (this.curtomData == null) {
            try {
                CustomListData cus = (CustomListData)BeanTool.getInstance(this.customUrl);
                if (cus != null) {
                    this.curtomData = cus.getData(listStyle.getPageDataSize(), 0, "", listStyle.getOrderField());
                }
            }
            catch (Exception e) {
                log.error((Object)("\u5217\u8868\u83b7\u53d6\u81ea\u5b9a\u4e49\u6570\u636e\u6e90\u5931\u8d25\uff01" + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    private String getOrderSql(ListStyle listStyle) {
        return HussarJson.gson_toJson((Object)((Object)listStyle.getOrder()));
    }

    private void dealTableLink(FormInstance form) {
        MiniDataGridIns formCell = (MiniDataGridIns)form.getCell(this.id);
        ListStyle listStyle = formCell.getListStyle();
        this.tableLinkInfo = MiniDataGrid.getTableLinkInfo(this.tableLinkId, form);
        if (this.tableLinkInfo != null) {
            String field = this.tableLinkInfo.get("field");
            String fieldValue = this.tableLinkInfo.get("fieldValue");
            if (field == null || fieldValue == null || "".equals(field) || "".equals(fieldValue)) {
                return;
            }
            listStyle.addFilterSql(new StringBuffer("(").append(field).append("='").append(fieldValue).append("')").toString());
        }
    }

    public static Object getListData(String formInstanceId, String formId, int cellId, String styleId, String orderSql, String filterSql, int pageIndex, int pageDataSize) throws Exception {
        String defenseSQLInjection = Global.getConfig((String)"defenseSQLInjection");
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        if ("true".equalsIgnoreCase(defenseSQLInjection)) {
            throw new Exception("\u542f\u7528\u9632sql\u6ce8\u5165\u65f6\uff0c\u7981\u6b62\u8c03\u7528\u8be5\u65b9\u6cd5\uff01");
        }
        String cusUrl = new PatternDao().getPatternCellAttributes1(formId, String.valueOf(cellId)).get("E34A1B32-0A38-485C-B16E-7EFD04420ED5");
        if (cusUrl != null && cusUrl.length() > 0 && !"NULL".equals(cusUrl.toUpperCase())) {
            CustomListData curData = (CustomListData)BeanTool.getInstance(cusUrl);
            Map<String, Object> urlData = curData.getData(pageDataSize, pageIndex, filterSql, orderSql);
            retMap.put("data", urlData.get("dataDb"));
            retMap.put("listStyle", urlData);
            retMap.put("total", urlData.get("rowsCount"));
        } else {
            ListStyle daListStyle = MiniDataGrid.getListData1(formInstanceId, formId, cellId, styleId, orderSql, filterSql, pageIndex, pageDataSize);
            List dataTmp = daListStyle.getData();
            ArrayList dataList = new ArrayList();
            for (ListMap listMap : dataTmp) {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                int i = 0;
                int len = listMap.size();
                while (i < len) {
                    Object value = listMap.getValue(i);
                    Object key = listMap.getKey(i);
                    map.put(key, value);
                    ++i;
                }
                dataList.add(map);
            }
            retMap.put("data", dataList);
            retMap.put("listStyle", daListStyle);
            retMap.put("total", daListStyle.getRowsCount());
        }
        return retMap;
    }

    private static ListStyle getListData1(String formInstanceId, String formId, int cellId, String styleId, String orderSql, String filterSql, int pageIndex, int pageDataSize) throws Exception {
        ICell[] cells;
        CheckClient cc = new CheckClient();
        if (!cc.checkFilter(filterSql)) {
            return null;
        }
        Form form = Form.getPattern(formId);
        if (form != null && (cells = form.getCells()) != null && cells.length > cellId && cells[cellId] != null && cells[cellId] instanceof MiniDataGrid) {
            FormInstance formInstance = FormInstance.load(formInstanceId, form);
            ListStyle listStyle = MiniDataGrid.initListStyle(formInstance, (MiniDataGrid)cells[cellId], styleId, orderSql, filterSql, pageIndex, true, pageDataSize);
            return listStyle;
        }
        return null;
    }

    public static Object getListDataByQueryParam(String formInstanceId, String formId, int cellId, String styleId, String orderSql, HashMap<String, Object> queryParam, int pageIndex, int pageDataSize) throws Exception {
        String filterSql = GlobalSql.getQuerySql(queryParam);
        if (filterSql == null) {
            filterSql = "";
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String cusUrl = new PatternDao().getPatternCellAttributes1(formId, String.valueOf(cellId)).get("E34A1B32-0A38-485C-B16E-7EFD04420ED5");
        if (cusUrl != null && cusUrl.length() > 0 && !"NULL".equals(cusUrl.toUpperCase())) {
            CustomListData curData = (CustomListData)BeanTool.getInstance(cusUrl);
            Map<String, Object> urlData = curData.getData(pageDataSize, pageIndex, filterSql, orderSql);
            retMap.put("data", urlData.get("dataDb"));
            retMap.put("listStyle", urlData);
            retMap.put("total", urlData.get("rowsCount"));
        } else {
            ListStyle daListStyle = MiniDataGrid.getListData1(formInstanceId, formId, cellId, styleId, orderSql, filterSql, pageIndex, pageDataSize);
            List dataTmp = daListStyle.getData();
            ArrayList dataList = new ArrayList();
            for (ListMap listMap : dataTmp) {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                int i = 0;
                int len = listMap.size();
                while (i < len) {
                    Object value = listMap.getValue(i);
                    Object key = listMap.getKey(i);
                    map.put(key, value);
                    ++i;
                }
                dataList.add(map);
            }
            retMap.put("data", dataList);
            retMap.put("listStyle", daListStyle);
            retMap.put("total", daListStyle.getRowsCount());
        }
        return retMap;
    }

    private static ListStyle initListStyle(FormInstance formInstance, MiniDataGrid listCell, String styleId, String orderSql, String filterSql, int pageIndex, boolean loadData, int pageDataSize) throws Exception {
        Context context = com.sdjxd.pms.platform.base.Global.getContext();
        ListStyle listStyle = ListStyle.getInstance(styleId);
        Map<String, String> tableLinkInfo = null;
        if (listStyle != null) {
            listStyle.addFilterSql(filterSql);
            String defenseSQLInjection = Global.getConfig((String)"defenseSQLInjection");
            String filterStr = context.getParameter("filter");
            if ("true".equalsIgnoreCase(defenseSQLInjection) || !StringTool.isEmpty(filterStr) && filterStr.startsWith("{")) {
                Object arg = BeanTool.parse(filterStr);
                if (arg instanceof Map) {
                    Map queryParam = (Map)arg;
                    String sql2 = GlobalSql.getQuerySql((Map)queryParam);
                    if (!StringTool.isEmpty(sql2)) {
                        listStyle.addFilterSql(sql2);
                    }
                } else if (arg != null) {
                    log.info((Object)"\u4f7f\u7528\u9632sql\u6ce8\u5165\uff0c\u901a\u8fc7url\u8bbe\u7f6e\u5217\u8868\u8fc7\u6ee4\u6761\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
                }
            } else {
                listStyle.addFilterSql(filterStr);
            }
            if ("1".equals(com.sdjxd.pms.platform.base.Global.getConfig("isDataLimitControl"))) {
                User user = User.getCurrentUser();
                ArrayList<String> colNames = new ArrayList<String>();
                List columnDatas = listStyle.getColumnData();
                int i = 0;
                while (i < columnDatas.size()) {
                    String columnId;
                    ListStyleColumnData columnData = (ListStyleColumnData)columnDatas.get(i);
                    if (2 != columnData.getColumnType() && (columnId = columnData.getColumnId()) != null && columnId.length() != 0) {
                        colNames.add(columnId);
                    }
                    ++i;
                }
                if (user != null) {
                    String table = listStyle.getTableName();
                    PermitCtrl permit = new PermitCtrl();
                    String userId = user.getId();
                    String limitSql = permit.getLimitSql(userId, table, Const.TABLEOPER.SELECT, colNames);
                    if (!StringTool.isEmpty(limitSql)) {
                        listStyle.addFilterSql(limitSql);
                    }
                }
            }
            if (listCell != null && formInstance != null && (tableLinkInfo = MiniDataGrid.getTableLinkInfo(listCell.tableLinkId, formInstance)) != null) {
                String field = tableLinkInfo.get("field");
                String fieldValue = tableLinkInfo.get("fieldValue");
                if (field != null && fieldValue != null && !"".equals(field) && !"".equals(fieldValue)) {
                    listStyle.addFilterSql(new StringBuffer("(").append(field).append("='").append(fieldValue).append("')").toString());
                }
            }
            if (listCell != null && !StringTool.isEmpty(listCell.userDefinfo)) {
                listStyle.setUserDefinfo(listCell.userDefinfo);
            }
            if (!StringTool.isEmpty(orderSql)) {
                String[] order = orderSql.split(",");
                int i = order.length - 1;
                while (i >= 0) {
                    String[] orderField = order[i].split(" ");
                    listStyle.addOrderField(orderField[0], orderField[1]);
                    --i;
                }
            }
            if (pageIndex < 0) {
                listStyle.setAllowPage(false);
                listStyle.setPageDataSize(-1);
            } else {
                listStyle.setPageIndex(pageIndex);
                if (pageDataSize > 0) {
                    listStyle.setPageDataSize(pageDataSize);
                }
            }
        }
        return listStyle;
    }

    private static Map<String, String> getTableLinkInfo(String h_tableLinkId, FormInstance h_formIns) {
        String field = "";
        String PField = "";
        String fieldValue = "";
        HashMap<String, String> item = null;
        String sql2 = EditGridSql.getTableLinkSql(h_tableLinkId);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs != null && rs.next()) {
                field = rs.getString("LINKCOLUMNID");
                PField = rs.getString("PKEYCOLUMNID");
            }
        }
        catch (SQLException exp) {
            return null;
        }
        fieldValue = h_formIns.getId();
        if (fieldValue == null || "".equals(fieldValue)) {
            fieldValue = com.sdjxd.pms.platform.base.Global.getContext().getParameter("parentID");
        }
        if (field == null || "".equals(field) || fieldValue == null || "".equals(fieldValue)) {
            return null;
        }
        item = new HashMap<String, String>();
        item.put("type", "0");
        item.put("field", field);
        item.put("fieldValue", fieldValue);
        return item;
    }

    public static void main(String[] args) {
    }

    public static List<Map<String, String>> getCellColumnMeans(Map<String, String> mean, String filter) {
        ArrayList<Map<String, String>> objList = new ArrayList<Map<String, String>>();
        if (mean != null && mean.get("tableName") != null && mean.get("idField") != null && mean.get("nameField") != null) {
            String sql2 = "select " + mean.get("idField") + "," + mean.get("nameField") + " from " + mean.get("tableName") + " " + mean.get("query") + " " + filter + " " + mean.get("orderSql");
            try {
                RowSet rs = DbOper.executeQuery(sql2);
                while (rs.next()) {
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put("id", rs.getString(mean.get("idField")));
                    tempMap.put("text", rs.getString(mean.get("nameField")));
                    objList.add(tempMap);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return objList;
    }

    @Override
    public FormCell createCellInstance() {
        return new MiniDataGridIns();
    }

    @Override
    public void renderInstanceValue(FormInstance form) {
        MiniDataGridIns formCell = (MiniDataGridIns)form.getCell(this.id);
        String styleId_Real = this.styleId;
        String listStyleidByUrl = com.sdjxd.pms.platform.base.Global.getContext().getParameter("listStyleID");
        if (listStyleidByUrl != null && listStyleidByUrl.length() > 0) {
            styleId_Real = listStyleidByUrl;
        } else {
            String[] assitInfo = (String[])StringTool.strToArray(this.data.assitInfo);
            if (assitInfo != null && assitInfo.length > 0) {
                styleId_Real = assitInfo[0];
            }
        }
        try {
            ListStyle listStyle = ListStyle.getInstance(styleId_Real);
            String defenseSQLInjection = Global.getConfig((String)"defenseSQLInjection");
            Context context = com.sdjxd.pms.platform.base.Global.getContext();
            String filterStr = context.getParameter("filter");
            if ("true".equalsIgnoreCase(defenseSQLInjection) || !StringTool.isEmpty(filterStr) && filterStr.startsWith("{")) {
                Object arg = BeanTool.parse(filterStr);
                if (arg instanceof Map) {
                    Map queryParam = (Map)arg;
                    String sql2 = GlobalSql.getQuerySql((Map)queryParam);
                    if (!StringTool.isEmpty(sql2)) {
                        listStyle.addFilterSql(sql2);
                    }
                } else if (arg != null) {
                    log.info((Object)"\u4f7f\u7528\u9632sql\u6ce8\u5165\uff0c\u901a\u8fc7url\u8bbe\u7f6e\u5217\u8868\u8fc7\u6ee4\u6761\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
                }
            } else if (filterStr != null && filterStr.length() > 0) {
                listStyle.addFilterSql(filterStr);
            }
            formCell.setStyleId(styleId_Real);
            formCell.setListStyle(listStyle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CellEvents getCellEvent() {
        String className = (String)this.dataExt.get("9493B040-16B2-4696-89D5-64FE23D4BCE4");
        if (!"".equals(className)) {
            return (CellEvents)BeanTool.getInstance(className);
        }
        return null;
    }

    public String getStyleId() {
        String styleId = "";
        String[] assitInfo = (String[])StringTool.strToArray(this.data.assitInfo);
        if (assitInfo != null && assitInfo.length > 0) {
            styleId = assitInfo[0];
        }
        return styleId;
    }
}

