/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.ComboBoxColumnMeanBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniDom;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class MiniComboBox
extends MiniCell {
    private static Logger log = Logger.getLogger(MiniComboBox.class);
    private ComboBoxColumnMeanBean columnMean;
    private boolean showDefault = false;

    public MiniComboBox(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.columnMean = new ComboBoxColumnMeanBean(model.meanDataSourceName, model.fieldMeanValue, this.getLimitInfoArray());
        this.readAttributesExt();
    }

    @Override
    public void setDefault(FormInstance form) {
        this.showDefault = true;
    }

    @Override
    protected String renderHtml(FormInstance formIns) {
        StringBuffer html = new StringBuffer();
        MiniDom dom = new MiniDom("div");
        dom.add("textField", "optionText");
        dom.add("valueField", "optionValue");
        dom.add("id", this.getCellId());
        dom.add("showName", this.getCellName());
        dom.add("showClose", String.valueOf(this.isShowClose()));
        dom.add("class", "mini-combobox");
        dom.add("borderStyle", this.getBorderStyle());
        dom.add("inputStyle", "vertical-align:middle;line-height:" + this.getHeight() + ";" + this.getFontStyle());
        dom.add("height", this.getHeight());
        dom.add("width", this.getWidth());
        dom.add("allowInput", String.valueOf(this.isAllowInput()));
        dom.add("showNullItem", String.valueOf(this.showNullItem()));
        dom.add("multiSelect", String.valueOf(this.isMultiSelect()));
        FormCell formCell = formIns.getCell()[this.getId()];
        dom.add("value", this.getValue(formCell));
        if (this.data.maxSize != 0) {
            dom.add("maxLength", String.valueOf(this.data.maxSize));
        }
        dom.add("limit", String.valueOf(this.limit));
        dom.add(this.getCellLimits(formIns));
        dom.addStyle(this.getCellPositions(formIns));
        dom.render(html);
        return html.toString();
    }

    @Override
    protected String renderScriptObject(FormInstance formIns) {
        StringBuffer sb = new StringBuffer();
        List cellData = this.getOptionData(formIns);
        if (cellData != null && cellData.size() > 0) {
            JSONArray jsonArray = JSONArray.fromObject((Object)cellData);
            sb.append("var cellData_").append(this.getId()).append(" = ").append(jsonArray.toString()).append(";\r\n");
        } else {
            sb.append("var cellData_").append(this.getId()).append(" = null").append(";\r\n");
        }
        ComboBoxColumnMeanBean bean = new ComboBoxColumnMeanBean(this.data.meanDataSourceName, this.data.fieldMeanValue, this.getLimitInfoArray());
        sb.append("var cmbMean" + this.id);
        sb.append(" = new com.sdjxd.pms.platform.form.cell.ComboBoxColumnMean({");
        if (!"".equals(bean.assistInfo)) {
            sb.append("assistInfo:").append(bean.assistInfo);
        }
        if (!"".equals(bean.dataSourceName)) {
            sb.append(",dataSourceName:\"").append(bean.dataSourceName).append("\"");
        }
        if (bean.fillMode != 0) {
            sb.append(",fillMode:").append(bean.fillMode);
        }
        if (!"".equals(bean.id)) {
            sb.append(",id:\"").append(bean.id).append("\"");
        }
        if (!"".equals(bean.moduleName)) {
            sb.append(",moduleName:\"").append(bean.moduleName).append("\"");
        }
        if (!"".equals(bean.name)) {
            sb.append(",name:\"").append(bean.name).append("\"");
        }
        sb.append("});\r\n");
        JSONObject jsonObj = JSONObject.fromObject((Object)this.getMiniOptionMap(formIns));
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.miniCell.ComboBox(").append(jsonObj.toString()).append(",cmbMean").append(this.getId()).append(",").append("cellData_").append(this.getId()).append("));\r\n");
        String backgroundColor = this.getBKColor();
        if (backgroundColor != null) {
            sb.append("document.getElementById(\"").append(this.getCellId()).append("$text\").parentNode.style.backgroundColor = \"").append(backgroundColor).append("\";\r\n ");
        }
        sb.append(this.getEventScript(formIns));
        return sb.toString();
    }

    private List getOptionData(FormInstance formIns) {
        List options = null;
        String assitInfo = this.data.fieldMeanValue;
        assitInfo = StringTool.replaceKeyWord(assitInfo);
        assitInfo = FormInstance.replaceParaValue(assitInfo, formIns);
        PatternDao dao = (PatternDao)BeanFactory.getSingleInstance("PatternDao");
        options = dao.getdropDownOption(this.data.meanDataSourceName, assitInfo, this.getLimitInfoArray());
        return options;
    }

    private Map getMiniOptionMap(FormInstance formIns) {
        HashMap<String, Object> optionMap = new HashMap<String, Object>();
        optionMap.put("id", String.valueOf(this.getId()));
        optionMap.put("miniid", this.getCellId());
        optionMap.put("tagId", this.getCellId());
        optionMap.put("needSave", this.isNeedSave());
        optionMap.put("showName", this.getCellName());
        FormCell[] cells = formIns.getCell();
        FormCell cell = cells[this.getId()];
        optionMap.put("limit", cell.getLimit());
        String defaultValue = this.getDefaultValue(formIns);
        optionMap.put("defaultValue", defaultValue);
        optionMap.put("needPrint", cell.isPrint());
        optionMap.put("divId", this.data.areaId);
        if (this.data.maxSize != 0) {
            optionMap.put("maxLength", String.valueOf(this.data.maxSize));
        }
        optionMap.put("allowInput", this.isAllowInput());
        optionMap.put("valueField", this.data.valueField);
        optionMap.put("textField", this.data.textField);
        return optionMap;
    }

    private String getDefaultValue(FormInstance formIns) {
        if (!this.showDefault) {
            return "";
        }
        String defaultValue = "";
        if (formIns.getCell() != null && this.id < formIns.getCell().length && formIns.getCell()[this.id] != null) {
            String cellValue = formIns.getCell()[this.id].getValue();
            if (cellValue != null && cellValue.length() != 0) {
                defaultValue = "";
            } else if (this.data.cellLabel != null) {
                defaultValue = this.data.cellLabel;
                defaultValue = StringTool.replaceKeyWord(defaultValue, formIns);
                defaultValue = FormInstance.replaceParaValue(defaultValue, formIns);
            }
        } else {
            defaultValue = "";
        }
        return defaultValue;
    }

    private boolean isShowClose() {
        String isShowClose = (String)this.dataExt.get("AC18BB0B-72C8-44F9-9855-064181EF3621");
        return "1".equals(isShowClose);
    }

    private boolean isAllowInput() {
        return this.data.readonly == 1;
    }

    private boolean isMultiSelect() {
        return this.columnMean.allowMultiSelect;
    }

    private boolean showNullItem() {
        return this.columnMean.appendEmptyItem;
    }
}

