/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.ComboBoxColumnMeanBean;
import com.sdjxd.pms.platform.form.model.DropDownOptionBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniDom;
import com.sdjxd.pms.platform.form.service.minicell.MiniRadio;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class MiniCheckBoxList
extends MiniCell
implements ICell {
    private static Logger log = Logger.getLogger(MiniRadio.class);
    private static final long serialVersionUID = 1L;
    private String repeatLayout = "none";
    private String repeatDirection = "horizontal";
    private String repeatItems = "0";
    private StringBuffer useDefineCssCls = new StringBuffer(100);
    private boolean showDefault = false;

    public MiniCheckBoxList(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.readAttributesExt();
        this.setRepeatLayout((String)this.dataExt.get("59A2A154-CD13-4B99-802A-56568A40FAEF"));
        this.setRepeatDirection((String)this.dataExt.get("8881002D-EDAE-470C-A82D-F571B47522F5"));
        this.setRepeatItems((String)this.dataExt.get("B7BC5344-585E-474F-8ECE-6520F3DCA599"));
        if (this.data.textColorStyle != null && this.data.textColorStyle.length() != 0) {
            this.addUseDefineCssCls(this.data.textColorStyle);
        }
        if (this.data.alignStyle != null && this.data.alignStyle.length() != 0) {
            this.addUseDefineCssCls(this.data.alignStyle);
        }
        if (this.data.fontStyle != null && this.data.fontStyle.length() != 0) {
            this.addUseDefineCssCls(this.data.fontStyle);
        }
        if (this.data.bkColorStyle != null && this.data.bkColorStyle.length() != 0) {
            this.addUseDefineCssCls(this.data.bkColorStyle);
        }
    }

    @Override
    protected String renderHtml(FormInstance form) throws Exception {
        MiniDom radioListDom = new MiniDom("div");
        radioListDom.add("id", this.getCellId());
        radioListDom.add("class", "mini-checkboxlist");
        radioListDom.add("repeatLayout", this.repeatLayout);
        radioListDom.add("repeatDirection", this.repeatDirection);
        radioListDom.add("repeatItems", this.repeatItems);
        radioListDom.addStyle(this.getCellPositions(form));
        radioListDom.add(this.getCellSizes(form));
        radioListDom.add(this.getCellLimits(form));
        if (this.data.textColorStyle != null && this.data.textColorStyle.length() != 0) {
            radioListDom.addClass("text", this.data.textColorStyle);
        }
        if (this.data.alignStyle != null && this.data.alignStyle.length() != 0) {
            radioListDom.addClass("align", this.data.alignStyle);
        }
        if (this.data.fontStyle != null && this.data.fontStyle.length() != 0) {
            radioListDom.addClass("font", this.data.fontStyle);
        }
        if (this.data.bkColorStyle != null && this.data.bkColorStyle.length() != 0) {
            radioListDom.addClass("bgColorStyle", this.data.bkColorStyle);
        }
        String cellValue = null;
        FormCell[] formCell = form.getCell();
        if (this.id < formCell.length && formCell[this.id] != null && (cellValue = formCell[this.id].getValue()) != null && cellValue.length() != 0) {
            radioListDom.add("value", cellValue);
        }
        StringBuffer buffer = new StringBuffer(1024);
        radioListDom.render(buffer);
        return buffer.toString();
    }

    @Override
    protected String renderScriptObject(FormInstance form) throws Exception {
        if (this.data.fieldMeanValue == null || this.data.fieldMeanValue.length() == 0) {
            throw new Exception("\u590d\u9009\u6846\u7f3a\u5c11\u5b57\u6bb5\u542b\u4e49\uff01");
        }
        StringBuffer sb = new StringBuffer();
        if (this.data.fieldMeanValue != null && this.data.fieldMeanValue.length() != 0) {
            ComboBoxColumnMeanBean bean = new ComboBoxColumnMeanBean(this.data.meanDataSourceName, this.data.fieldMeanValue, this.getLimitInfoArray());
            sb.append("var  cmbData" + this.id);
            sb.append(" = ").append(MiniCheckBoxList.getComOptsData(this.LoadOptionsData(form))).append(";");
            sb.append("var cmbMean" + this.id);
            sb.append(" = new com.sdjxd.pms.platform.form.cell.ComboBoxColumnMean({");
            if (!"".equals(bean.assistInfo)) {
                sb.append("assistInfo:").append(bean.assistInfo);
            }
            if (!"".equals(bean.dataSourceName)) {
                sb.append(",dataSourceName:\"").append(bean.dataSourceName).append("\"");
            }
            if (bean.fillMode != 0) {
                sb.append(",fillMode:").append(bean.fillMode);
            }
            if (!"".equals(bean.id)) {
                sb.append(",id:\"").append(bean.id).append("\"");
            }
            if (!"".equals(bean.moduleName)) {
                sb.append(",moduleName:\"").append(bean.moduleName).append("\"");
            }
            if (!"".equals(bean.name)) {
                sb.append(",name:\"").append(bean.name).append("\"");
            }
            sb.append("});\r\n");
            sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.miniCell.CheckBoxList({id:");
            sb.append(this.id);
            sb.append(",valueField:'").append(this.data.valueField).append("'");
            sb.append(",textField:'").append(this.data.textField).append("'");
            sb.append(",tagId:");
            sb.append("\"" + this.getCellId()).append("\"");
            sb.append(",divId:").append(this.data.areaId);
            sb.append(",userDefinfo:");
            sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
            sb.append(",bgColorStyle:'").append(this.data.bkColorStyle).append("'");
            sb.append(",readOnlyBgColorStyle:'").append(this.data.readBkColorStyle).append("'");
            sb.append(",showName:\"" + this.cellName + "\"");
            if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
                sb.append(",limit:");
                sb.append(form.getCell()[this.id].getLimit());
            }
            String defaultValue = "";
            if (this.showDefault && form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
                String cellValue = form.getCell()[this.id].getValue();
                if (cellValue != null && cellValue.length() != 0) {
                    defaultValue = "";
                } else if (this.data.cellLabel != null) {
                    defaultValue = StringTool.replaceKeyWord(this.data.cellLabel);
                    defaultValue = FormInstance.replaceParaValue(defaultValue, form);
                }
            } else {
                defaultValue = "";
            }
            sb.append(",defaultValue:'").append(defaultValue).append("'");
            sb.append(",needSave:");
            sb.append(this.isNeedSave());
            sb.append(",miniid:");
            sb.append("'" + this.getCellId() + "'");
            sb.append(",userDefCls:");
            sb.append("'" + this.useDefineCssCls + "'");
            sb.append("}, cmbMean");
            sb.append(this.id);
            sb.append(", cmbData").append(this.id);
            sb.append("));\r\n");
            sb.append(this.getEventScript(form));
            return sb.toString();
        }
        return "";
    }

    @Override
    public void setDefault(FormInstance form) {
        this.showDefault = true;
    }

    private List LoadOptionsData(FormInstance form) {
        String assitInfo = this.data.fieldMeanValue;
        assitInfo = StringTool.replaceKeyWord(assitInfo);
        assitInfo = FormInstance.replaceParaValue(assitInfo, form);
        PatternDao dao = (PatternDao)BeanFactory.getSingleInstance("PatternDao");
        List options = dao.getdropDownOption(this.data.meanDataSourceName, assitInfo, this.getLimitInfoArray());
        return options;
    }

    public static String getComOptsData(List optionArr) {
        JSONArray re = new JSONArray();
        if (optionArr != null) {
            int index = 0;
            while (index < optionArr.size()) {
                DropDownOptionBean option = (DropDownOptionBean)optionArr.get(index);
                JSONObject o = new JSONObject();
                o.put((Object)"id", (Object)option.getOptionValue());
                o.put((Object)"text", (Object)option.getOptionText());
                re.add((Object)o);
                ++index;
            }
        }
        return re.toString();
    }

    public void addUseDefineCssCls(String useDefineCssCls) {
        if (this.useDefineCssCls.length() > 0) {
            this.useDefineCssCls.append(" ");
        }
        this.useDefineCssCls.append(useDefineCssCls);
    }

    public String getRepeatLayout() {
        return this.repeatLayout;
    }

    public void setRepeatLayout(String repeatLayout) {
        this.repeatLayout = "3".equals(repeatLayout) ? "flow" : ("2".equals(repeatLayout) ? "table" : "none");
    }

    public String getRepeatDirection() {
        return this.repeatDirection;
    }

    public void setRepeatDirection(String repeatDirection) {
        this.repeatDirection = "2".equals(repeatDirection) ? "vertical" : "horizontal";
    }

    public String getRepeatItems() {
        return this.repeatItems;
    }

    public void setRepeatItems(String repeatItems) {
        this.repeatItems = StringTool.isEmpty(repeatItems) ? "0" : repeatItems;
    }
}

