/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.dao.DataConst;
import com.sdjxd.pms.platform.form.model.CellActionBean;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.model.Css;
import com.sdjxd.pms.platform.form.service.CellEvent;
import com.sdjxd.pms.platform.form.service.CellIndex;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public abstract class MiniCell
extends BaseClass
implements ICell {
    private static Logger log = Logger.getLogger(MiniCell.class);
    private static final long serialVersionUID = 1L;
    public static int MAXEVENT = 100;
    protected CellBean data;
    protected Map<String, String> dataExt;
    protected int cellType;
    protected int id;
    protected String cellPrefix;
    protected String cellId;
    protected String userDefinfo;
    protected String cellName;
    protected int limit;
    protected CellEvent[] events;
    protected Form pattern;
    protected int areaId;
    protected String position = SheetConstants.CELL.DEFAULTVALUE.POSITION;
    protected int top = 0;
    protected int left = 0;
    protected int width = 0;
    protected String widthScale;
    protected int height = 0;
    protected String heightScale;
    protected int tabindex = 0;
    protected int border = 0;
    protected List<ICell> controls;
    protected String childPosition;
    protected ICell parentControls;

    public MiniCell(Form pattern) {
        pattern.setNewPattern(true);
        this.pattern = pattern;
        this.cellPrefix = "cellId";
    }

    @Override
    public void setData(CellBean model) throws Exception {
        CellIndex cellIndex;
        this.events = new CellEvent[MAXEVENT];
        this.controls = new ArrayList<ICell>();
        if (model == null) {
            return;
        }
        this.data = model;
        this.cellType = model.cellType;
        this.id = model.cellId;
        this.cellId = String.valueOf(this.cellPrefix) + model.cellId;
        this.cellName = model.cellName;
        this.userDefinfo = model.userDefinfo;
        this.limit = model.limit;
        this.areaId = model.areaId;
        if (model.valueField != null && model.valueField.length() != 0 && (cellIndex = (CellIndex)this.pattern.getCellIndex().get(model.valueField)) != null) {
            cellIndex.setCell(CellIndex.VALUE, this.id);
        }
        if (model.textField != null && model.textField.length() != 0 && (cellIndex = (CellIndex)this.pattern.getCellIndex().get(model.textField)) != null) {
            cellIndex.setCell(CellIndex.TEXT, this.id);
        }
        this.position = model.position == null ? DataConst.CELL.POSITION.ABSOLUTE : model.position;
        this.childPosition = model.childPosition == null ? DataConst.CELL.POSITION.ABSOLUTE : model.childPosition;
        this.top = model.y1;
        this.left = model.x1;
        this.width = model.width;
        this.widthScale = model.widthScale != null && (model.widthScale.length() == 0 || model.widthScale.equals("0")) ? null : model.widthScale;
        this.height = model.height;
        this.heightScale = model.heightScale != null && (model.heightScale.length() == 0 || model.heightScale.equals("0")) ? null : model.heightScale;
        this.tabindex = model.dtextNum;
        this.border = model.lineWidth;
        if (this.getAreaId() != -1) {
            this.setParentControls(this.pattern.getCells()[this.getAreaId()]);
        } else {
            this.setParentControls(null);
            this.pattern.addCell(this);
        }
    }

    @Override
    public void render(FormInstance formIns) throws Exception {
        this.renderInstanceValue(formIns);
        formIns.getRenderHtml().write(this.renderHtml(formIns));
        formIns.addScript("form_obj_cell_" + this.id, this.renderScriptObject(formIns));
    }

    public void renderInstanceValue(FormInstance form) {
    }

    protected abstract String renderHtml(FormInstance var1) throws Exception;

    protected abstract String renderScriptObject(FormInstance var1) throws Exception;

    protected void readAttributesExt() {
        if (this.data != null) {
            this.dataExt = this.data.extAttrs != null ? this.data.extAttrs : new HashMap<String, String>();
        }
    }

    @Override
    public void addEvent(CellActionBean action) {
        if (action == null) {
            return;
        }
        int eventId = action.getEventId();
        CellEvent event = this.events[eventId];
        if (event != null) {
            event.addAction(action);
        } else {
            this.events[eventId] = new CellEvent(action);
        }
    }

    @Override
    public void addEvent(String eventCode, String strAction) {
        CellEvent cellEvent = this.getEvent(eventCode);
        if (cellEvent != null) {
            cellEvent.addAction(this.id, strAction);
        } else {
            int eventId = CellEvent.getEventId(eventCode);
            if (eventId >= 0) {
                this.events[eventId] = cellEvent = new CellEvent(eventId, this.id, strAction);
            } else {
                log.error((Object)("\u672a\u5904\u7406\u7684\u4e8b\u4ef6\uff1a" + eventCode));
            }
        }
    }

    protected Map getCellLimits(FormInstance form) {
        HashMap<String, String> limits = new HashMap<String, String>();
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            if (form.getCell()[this.id].isEnabled()) {
                limits.put("enabled", "true");
            } else {
                limits.put("enabled", "false");
            }
            if (form.getCell()[this.id].isVisible()) {
                limits.put("visible", "true");
            } else {
                limits.put("visible", "false");
            }
            if (form.getCell()[this.id].getLimit() == 2) {
                limits.put("required", "true");
            }
        }
        return limits;
    }

    protected Map getCellSizes(FormInstance form) {
        HashMap<String, String> sizes = new HashMap<String, String>();
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            String oHeight = this.heightScale != null && this.heightScale.length() != 0 ? this.heightScale : String.valueOf(this.height) + "px";
            sizes.put("height", oHeight);
            String oWidth = this.widthScale != null ? this.widthScale : String.valueOf(this.width) + "px";
            Object mobileRate = Global.getContext().getSession("weChatAdaptRate");
            if (mobileRate != null && oWidth.indexOf("%") <= -1) {
                oWidth = oWidth.substring(0, oWidth.indexOf("px"));
                double actWidth = Double.parseDouble(oWidth.trim()) * Double.parseDouble(mobileRate.toString().trim());
                oWidth = String.valueOf(actWidth) + "px";
            }
            sizes.put("width", oWidth);
        }
        return sizes;
    }

    protected Map getCellPositions(FormInstance form) {
        HashMap<String, String> positions = new HashMap<String, String>();
        if (form.getCell() != null && this.getId() < form.getCell().length && form.getCell()[this.getId()] != null) {
            positions.put("position", this.position);
            positions.put("top", String.valueOf(this.top) + "px");
            Object mobileRate = Global.getContext().getSession("weChatAdaptRate");
            if (mobileRate != null) {
                positions.put("left", String.valueOf((double)this.left * Double.parseDouble(mobileRate.toString().trim())) + "px");
            } else {
                positions.put("left", String.valueOf(this.left) + "px");
            }
            if ("" != this.data.zIndex) {
                positions.put("z-index", this.data.zIndex);
            }
        }
        return positions;
    }

    public String getBorderStyle() {
        StringBuffer s = new StringBuffer();
        try {
            if (this.data.borderStyle != null) {
                s.append(this.getStyleTextById(this.data.borderStyle));
                if (this.data.lineWidth >= 0) {
                    s.append(";border-width:").append(this.data.lineWidth).append("px");
                }
            }
        }
        catch (Exception e) {
            log.info((Object)"\u8bfb\u53d6\u5143\u4ef6\u8fb9\u6846\u6837\u5f0f\u5931\u8d25\uff01", (Throwable)e);
        }
        return s.toString();
    }

    public String getFontStyle() {
        try {
            if (this.data.fontStyle != null) {
                StringBuffer css = new StringBuffer();
                css.append(this.getStyleTextById(this.data.fontStyle));
                css.append(this.getStyleTextById(this.data.textColorStyle));
                return css.toString();
            }
        }
        catch (Exception e) {
            log.info((Object)"\u8bfb\u53d6\u5b57\u4f53\u6837\u5f0f\u5931\u8d25\uff01", (Throwable)e);
        }
        return "";
    }

    public String getBKStyle() {
        return this.getStyleTextById(this.data.bkColorStyle);
    }

    public String getTAStyle() {
        return this.getStyleTextById(this.data.alignStyle);
    }

    public String getBKColor() {
        String color = null;
        TreeMap map = Form.getCss();
        Css css = (Css)map.get(this.data.bkColorStyle);
        if (css != null) {
            color = css.getValue("background-color");
        }
        return color;
    }

    public Map getStyleMapById(String styleCode) {
        Css css;
        TreeMap map = Form.getCss();
        if (!StringTool.isEmpty(styleCode) && (css = (Css)map.get(styleCode)) != null) {
            return css.getStyleMap();
        }
        return null;
    }

    public String getStyleTextById(String styleCode) {
        String styleText = "";
        try {
            TreeMap map;
            Css css;
            if (!StringTool.isEmpty(styleCode) && (css = (Css)(map = Form.getCss()).get(styleCode)) != null && (styleText = css.getStyletext()) != null && styleText.length() > 0 && styleText.charAt(styleText.length() - 1) != ';') {
                styleText = String.valueOf(styleText) + ";";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return styleText;
    }

    protected String getEventScript(FormInstance form) {
        FormCell formCell;
        if (this.id < form.getCell().length && (formCell = form.getCell()[this.id]) != null) {
            StringBuffer sb = new StringBuffer(128);
            int i = 0;
            while (i < MAXEVENT) {
                if (this.events[i] != null) {
                    String sender = "defaultForm.getCellById(" + this.id + ")";
                    sb.append(this.events[i].renderMiniEvent(sender));
                }
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    public CellEvent getEvent(String eventCode) {
        int i = 0;
        while (i < this.events.length) {
            if (this.events[i] != null && this.events[i].getEventCode().equals(eventCode)) {
                return this.events[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setDefault(FormInstance form) {
        String defaultValue = this.data.cellLabel;
        String cellType = SheetConstants.CELL.getType(this.cellType);
        if (cellType.equals("ComboBox") || cellType.equals("Check")) {
            return;
        }
        defaultValue = StringTool.replaceKeyWord(defaultValue, form);
        defaultValue = FormInstance.replaceParaValue(defaultValue, form);
        int i = 0;
        while (i < this.controls.size()) {
            this.controls.get(i).setDefault(form);
            ++i;
        }
        if (!StringTool.isEmpty(defaultValue)) {
            form.getCell()[this.id].setText(defaultValue);
        }
    }

    @Override
    public void save(FormInstance form, List list) {
        try {
            FormCell[] formCell = form.getCell();
            if (formCell[this.id] == null || !this.isNeedSave()) {
                return;
            }
            String textField1 = this.getTextField();
            String valueField1 = this.getValueField();
            boolean saveText = true;
            boolean saveValue = true;
            StringBuffer sql2 = new StringBuffer(256);
            int sortIndex = 0;
            String tableName = String.valueOf(this.pattern.getDataUserName()) + this.pattern.getTextTable();
            sql2.append("DELETE FROM ");
            sql2.append(tableName);
            sql2.append(" WHERE SHEETID='");
            sql2.append(form.getId());
            if (Form.FOrmType.equals("0")) {
                sql2.append("' AND CELLID=");
                sql2.append(this.data.entityAttrId);
            }
            list.add(sql2.toString());
            if (saveText || saveValue) {
                if (formCell[this.id] == null) {
                    return;
                }
                String text = formCell[this.id].getText();
                String cellValue = formCell[this.id].getValue();
                if (text == null) {
                    text = "";
                }
                if (cellValue == null) {
                    cellValue = "";
                }
                int valueLen = cellValue.length();
                int textLen = text.length();
                sortIndex = 0;
                while (sortIndex * 150 <= valueLen || sortIndex * 150 <= textLen) {
                    sql2.setLength(0);
                    String curValue = valueLen > (sortIndex + 1) * 150 ? cellValue.substring(sortIndex * 150, sortIndex * 150 + 150) : (valueLen <= (sortIndex + 1) * 150 && valueLen > sortIndex * 150 ? cellValue.substring(sortIndex * 150) : "");
                    String curText = textLen > (sortIndex + 1) * 150 ? text.substring(sortIndex * 150, sortIndex * 150 + 150) : (textLen <= (sortIndex + 1) * 150 && textLen > sortIndex * 150 ? text.substring(sortIndex * 150) : "");
                    sql2.append("INSERT INTO ");
                    sql2.append(tableName);
                    sql2.append("(SHEETID,CELLID,SORTID,CELLVALUE,CELLTEXT) VALUES('");
                    sql2.append(form.getId());
                    sql2.append("',");
                    sql2.append(this.data.entityAttrId);
                    sql2.append(",");
                    sql2.append(sortIndex);
                    sql2.append(",'");
                    if (saveValue) {
                        sql2.append(DbOper.toDb(curValue));
                    }
                    sql2.append("','");
                    if (saveText) {
                        sql2.append(DbOper.toDb(curText));
                    }
                    sql2.append("')");
                    list.add(sql2.toString());
                    ++sortIndex;
                }
            }
        }
        catch (Exception exp) {
            System.out.print(exp);
        }
    }

    @Override
    public void saveCell(FormInstance form, List list, int cellId) {
    }

    public int getAreaId() {
        return this.areaId;
    }

    public String getCellId() {
        return this.cellId;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getCellType() {
        return this.cellType;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public int getLimit(FormInstance form) {
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            return form.getCell()[this.id].getLimit();
        }
        return this.limit;
    }

    @Override
    public String getValueField() {
        return this.data.valueField;
    }

    @Override
    public String getTextField() {
        return this.data.textField;
    }

    @Override
    public String getCellName() {
        return this.cellName;
    }

    @Override
    public String getText(FormCell formCell) {
        return formCell.getText();
    }

    @Override
    public String getValue(FormCell formCell) {
        return formCell.getValue();
    }

    public String getHeight() {
        if (this.data.heightScale != null && this.data.heightScale.length() != 0) {
            return this.data.heightScale;
        }
        if (this.data.height != 0) {
            return String.valueOf(this.data.height) + "px";
        }
        return "30px";
    }

    public String getWidth() {
        String widthAct = this.data.widthScale != null && this.data.widthScale.length() != 0 ? this.data.widthScale : (this.data.width != 0 ? String.valueOf(this.data.width) + "px" : "30px");
        Object mobileRate = Global.getContext().getSession("weChatAdaptRate");
        if (mobileRate != null && widthAct.indexOf("%") <= -1) {
            widthAct = widthAct.substring(0, widthAct.indexOf("px"));
            double actWidth = Double.parseDouble(widthAct.trim()) * Double.parseDouble(mobileRate.toString().trim());
            widthAct = String.valueOf(actWidth) + "px";
        }
        return widthAct;
    }

    protected boolean isNeedSave() {
        return this.data.isNeedSave == 1;
    }

    @Override
    public int getDefaultValueTime() {
        return this.data.defaultValueTime;
    }

    public ICell getParentControls() {
        return this.parentControls;
    }

    @Override
    public String getChildPosition() {
        if (this.childPosition == null) {
            if (this.parentControls != null) {
                return this.parentControls.getChildPosition();
            }
            return SheetConstants.CELL.DEFAULTVALUE.CHILD_POSITION;
        }
        return this.childPosition;
    }

    @Override
    public List<ICell> getControls() {
        return this.controls;
    }

    @Override
    public ArrayList getEventForMobile() {
        ArrayList<ArrayList> eventsList = new ArrayList<ArrayList>();
        int i = 0;
        while (i < this.events.length) {
            ArrayList eventList;
            if (this.events[i] != null && (eventList = this.events[i].getEventForMobile()) != null) {
                eventsList.add(eventList);
            }
            ++i;
        }
        if (eventsList.size() == 0) {
            return null;
        }
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        list.add(new Integer(this.id));
        list.add(eventsList);
        return list;
    }

    public void setParentControls(ICell parentControls) {
        if (this.getParentControls() == null) {
            this.pattern.removeCell(this);
        }
        if (this.parentControls == null || !this.parentControls.equals(parentControls)) {
            this.noRender();
            if (this.parentControls != null) {
                this.parentControls.noRender();
                this.parentControls.getControls().remove(this);
            }
            this.parentControls = parentControls;
            if (parentControls != null) {
                parentControls.getControls().add(this);
                String cp = parentControls.getChildPosition();
                if (!"".equals(cp)) {
                    this.position = cp;
                }
                if (DataConst.CELL.POSITION.RELATIVE.equals(cp)) {
                    this.left = 0;
                    this.top = 0;
                }
                this.parentControls.noRender();
            }
        }
    }

    @Override
    public String[] getLimitInfoArray() {
        Object[] temp = StringTool.strToArray(this.data.LimitInfo);
        if (temp == null || temp.length == 0) {
            return null;
        }
        return (String[])temp;
    }

    @Override
    public void noRender() {
    }

    @Override
    public Map getAttributes() {
        return null;
    }

    @Override
    public void renderAfterEnd(FormInstance form) throws Exception {
    }

    @Override
    public FormCell createCellInstance() {
        return new FormCell();
    }
}

