/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniDom;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MiniCKEditor
extends MiniCell {
    private String jsPath = "/pms/platform/form/miniCell/ckeditor/ckeditor.js";

    public MiniCKEditor(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.readAttributesExt();
    }

    @Override
    protected String renderHtml(FormInstance formIns) throws Exception {
        MiniDom divdom = new MiniDom("div");
        MiniDom textAreaDom = new MiniDom("input");
        divdom.add("id", this.getCellId());
        textAreaDom.add("id", "ckedit" + this.getId());
        divdom.add("name", this.cellName);
        divdom.add("width", this.getWidth());
        divdom.add("height", this.getHeight());
        divdom.add("inputStyle", "line-height:1.5;");
        divdom.addStyle("overflow", "hidden");
        divdom.add(this.getCellLimits(formIns));
        divdom.addStyle(this.getCellPositions(formIns));
        divdom.addStyle(this.getCellSizes(formIns));
        divdom.appendChild(textAreaDom);
        StringBuffer buffer = new StringBuffer(1024);
        divdom.render(buffer);
        return buffer.toString();
    }

    @Override
    protected String renderScriptObject(FormInstance formIns) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.miniCell.word({id:");
        sb.append(this.id);
        sb.append(",miniid:'").append(this.getCellId()).append("'");
        sb.append(",valueField:'").append(this.data.valueField).append("'");
        sb.append(",textField:'").append(this.data.textField).append("'");
        sb.append(",width:'").append(this.getWidth()).append("'");
        sb.append(",height:'").append(this.data.height).append("px").append("'");
        sb.append(",value:'").append(formIns.getCell()[this.id].getText().replaceAll("[\\t\\n\\r]", "")).append("'");
        sb.append(",limits:'").append(this.getCellLimits(formIns)).append("'");
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'").append(",limit:").append(formIns.getCell()[this.id].getLimit());
        if (Form.FOrmType.equals("0")) {
            sb.append(",needSave:");
            sb.append(this.isNeedSave());
            sb.append(",needPrint:");
            sb.append(formIns.getCell()[this.id].isPrint());
            sb.append(",showName:\"" + this.cellName + "\"");
        }
        sb.append("}));\r\n");
        sb.append(this.getEventScript(formIns));
        formIns.addScriptExtend("MiniCKEditor", String.valueOf(Global.getName()) + this.jsPath);
        return sb.toString();
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static String replaceTextBase(String str) throws Base64DecodingException, UnsupportedEncodingException {
        String text = "";
        byte[] contBytes = null;
        contBytes = Base64.decode(str.getBytes("GBK"));
        text = new String(contBytes, "GBK");
        return text;
    }
}

