/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.minicell;

import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.CellEvent;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormCell;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.ICell;
import com.sdjxd.pms.platform.form.service.minicell.MiniCell;
import com.sdjxd.pms.platform.form.service.minicell.MiniDom;
import com.sdjxd.pms.platform.tool.StringTool;
import java.util.HashMap;
import java.util.Map;

public class MiniButtonEdit
extends MiniCell {
    protected String fieldMeanValue;
    private String label;
    private String showClose = "false";
    protected String fieldMeanType;
    private StringBuffer useDefineCssCls = new StringBuffer(100);
    private Boolean hasBtnClick = false;

    public MiniButtonEdit(Form pattern) {
        super(pattern);
    }

    @Override
    public void setData(CellBean model) throws Exception {
        super.setData(model);
        this.fieldMeanValue = model.fieldMeanValue;
        this.fieldMeanType = model.fieldMeanType;
        this.readAttributesExt();
        this.setShowClose((String)this.dataExt.get("2675A592-25E0-446C-BB34-EC560066D731"));
        if (this.data.alignStyle != null && this.data.alignStyle.length() != 0) {
            this.addUseDefineCssCls(this.data.alignStyle);
        }
        if (this.data.bkColorStyle != null && this.data.bkColorStyle.length() != 0) {
            this.addUseDefineCssCls(this.data.bkColorStyle);
        }
    }

    @Override
    public void setDefault(FormInstance form) {
        super.setDefault(form);
        FormCell formCell = form.getCell()[this.id];
        String defaultValue = formCell.getText();
        defaultValue = StringTool.replaceKeyWord(defaultValue, form);
        defaultValue = FormInstance.replaceParaValue(defaultValue, form);
        int i = 0;
        while (i < this.controls.size()) {
            ((ICell)this.controls.get(i)).setDefault(form);
            ++i;
        }
        if (!StringTool.isEmpty(defaultValue)) {
            form.getCell()[this.id].setValue(defaultValue);
        }
    }

    @Override
    protected String renderHtml(FormInstance form) throws Exception {
        MiniDom buttonEditDom = new MiniDom("div");
        buttonEditDom.add("id", this.getCellId());
        buttonEditDom.add("class", "mini-buttonedit");
        buttonEditDom.add("selectOnFocus", "true");
        buttonEditDom.add("showClose", this.showClose);
        buttonEditDom.add("borderStyle", this.getBorderStyle());
        String str = String.valueOf(this.getBKStyle()) + this.getTAStyle() + this.getFontStyle();
        buttonEditDom.add("inputStyle", str);
        buttonEditDom.add("height", this.getHeight());
        buttonEditDom.add("width", this.getWidth());
        buttonEditDom.add("allowInput", String.valueOf(this.isAllowInput()));
        buttonEditDom.add("validateOnChanged", "true");
        buttonEditDom.add("validateOnLeave", "false");
        if (this.data.maxSize != 0) {
            buttonEditDom.add("maxLength", String.valueOf(this.data.maxSize));
        }
        buttonEditDom.add("text", form.getCell()[this.id].getText());
        buttonEditDom.add("value", form.getCell()[this.id].getValue());
        buttonEditDom.add(this.getCellLimits(form));
        buttonEditDom.addStyle(this.getCellPositions(form));
        if (this.data.alignStyle != null && this.data.alignStyle.length() != 0) {
            buttonEditDom.addClass("align", this.data.alignStyle);
        }
        if (this.data.bkColorStyle != null && this.data.bkColorStyle.length() != 0) {
            buttonEditDom.addClass("bgColorStyle", this.data.bkColorStyle);
        }
        StringBuffer buffer = new StringBuffer(1024);
        buttonEditDom.render(buffer);
        return buffer.toString();
    }

    @Override
    protected String renderScriptObject(FormInstance form) throws Exception {
        StringBuffer sb = new StringBuffer();
        CellEvent[] events = this.events;
        int i = 0;
        while (i < events.length) {
            if (events[i] != null && "onButtonEdit".equals(events[i].getEventCode())) {
                this.hasBtnClick = true;
            }
            ++i;
        }
        if (!(this.fieldMeanValue != null && this.fieldMeanValue != "" || this.hasBtnClick.booleanValue())) {
            throw new Exception("\u8bf7\u914d\u7f6e\u5f39\u51fa\u5bf9\u8c61\u6216\u6309\u94ae\u70b9\u51fb\u4e8b\u4ef6\uff01");
        }
        if (this.fieldMeanType != null && this.fieldMeanType.equals("MIUI_Selector") && this.fieldMeanValue != null && this.fieldMeanValue.length() != 0) {
            Map<String, String> map = this.LoadData(form);
            sb.append("var selColMean").append(this.id);
            sb.append(" = new com.sdjxd.pms.platform.form.cell.SelectorColumnMean({");
            if (map.get("nameField") != null) {
                sb.append("nameField:").append((Object)map.get("nameField"));
            }
            if (map.get("idField") != null) {
                sb.append(",idField:").append((Object)map.get("idField"));
            }
            if (map.get("tableName") != null) {
                sb.append(",tableName:").append((Object)map.get("tableName"));
            }
            if (map.get("dialogArg") != null) {
                sb.append(",dialogArg:").append((Object)map.get("dialogArg"));
            }
            if (map.get("url") != null) {
                sb.append(",url:").append(StringTool.replaceKeyWord(map.get("url")));
            }
            sb.append("});\r\n");
        }
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.miniCell.ButtonEdit({id:");
        sb.append(this.id);
        sb.append(",miniid:'").append(this.getCellId()).append("'");
        sb.append(",valueField:'").append(this.data.valueField).append("'");
        sb.append(",textField:'").append(this.data.textField).append("'");
        if (this.fieldMeanType != null && this.fieldMeanType.equals("MIUI_Selector") && this.fieldMeanValue != null && this.fieldMeanValue.length() != 0) {
            Map<String, String> map = this.LoadData(form);
            int n = map.get("url").toString().indexOf("/");
            String url = n != -1 ? this.removeCharAt(map.get("url").toString(), n) : map.get("url").toString();
            sb.append(",url:").append(url);
            sb.append(",dialogArg:").append((Object)map.get("dialogArg"));
        }
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",userDefinfo:");
        sb.append("'" + StringTool.toJson(this.userDefinfo) + "'");
        sb.append(",bgColorStyle:'").append(this.data.bkColorStyle).append("'");
        sb.append(",readOnlyBgColorStyle:'").append(this.data.readBkColorStyle).append("'");
        sb.append(",showName:\"" + this.cellName + "\"");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",fieldMeanValue:'").append(this.fieldMeanValue).append("'");
        sb.append(",hasBtnClick:\"").append(this.hasBtnClick).append("\"");
        sb.append(",label:\"" + StringTool.toJson(this.label) + "\"");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append(",needPrint:").append(form.getCell()[this.id].isPrint());
        sb.append(",allowInput:\"").append(String.valueOf(this.isAllowInput())).append("\"");
        sb.append(",value:\"").append(form.getCell()[this.id].getValue()).append("\"");
        if (this.data.maxSize != 0) {
            sb.append(",maxLength:\"").append(String.valueOf(this.data.maxSize)).append("\"");
        }
        sb.append(",isMultiLine:false");
        sb.append(",needSave:").append(this.isNeedSave());
        sb.append(",userDefCls:");
        sb.append("'" + this.useDefineCssCls + "'");
        sb.append("}));\r\n");
        String backgroundColor = this.getBKColor();
        if (backgroundColor != null) {
            sb.append("document.getElementById(\"").append(this.getCellId()).append("$text\").parentNode.style.backgroundColor = \"").append(backgroundColor).append("\";\r\n ");
        }
        sb.append(this.getEventScript(form));
        return sb.toString();
    }

    private Map<String, String> LoadData(FormInstance form) {
        String assitInfo = this.data.fieldMeanValue;
        if (assitInfo != null) {
            assitInfo = assitInfo.substring(1, assitInfo.length() - 1);
            String[] strArray = null;
            strArray = assitInfo.split(",");
            int m = strArray[0].indexOf("\\");
            if (m != -1) {
                strArray[0] = this.removeCharAt(strArray[0], m);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("url", strArray[0]);
            map.put("idField", strArray[1]);
            map.put("nameField", strArray[2]);
            map.put("tableName", strArray[3]);
            map.put("dialogArg", strArray[4]);
            return map;
        }
        return null;
    }

    private String removeCharAt(String str, int index) {
        return String.valueOf(str.substring(0, index)) + str.substring(index + 1);
    }

    private boolean isAllowInput() {
        return this.data.readonly == 1;
    }

    public void addUseDefineCssCls(String useDefineCssCls) {
        if (this.useDefineCssCls.length() > 0) {
            this.useDefineCssCls.append(" ");
        }
        this.useDefineCssCls.append(useDefineCssCls);
    }

    public String getShowClose() {
        return this.showClose;
    }

    public void setShowClose(String showClose) {
        this.showClose = "1".equals(showClose) ? "true" : "false";
    }
}

