/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell.easyui;

import com.sdjxd.pms.platform.base.Constants;
import com.sdjxd.pms.platform.data.ListMap;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.ListExtendColumnData;
import com.sdjxd.pms.platform.form.model.ListExtendData;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.table.model.TableBean;
import com.sdjxd.pms.platform.table.service.Table;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.log4j.Logger;

public class ListExtend {
    private static Logger log = Logger.getLogger(ListExtend.class);
    private static PatternDao dao = (PatternDao)BeanFactory.getSingleInstance("PatternDao");
    private String styleId;
    private ListExtendData styleData;
    private List<ListExtendColumnData> columnData;
    private String tableId;
    private String tableName;
    private String dataSourceName;
    private String dataUserName;
    private int pageIndex = 1;
    private int rowsCount = -1;
    private int pageCount = -1;
    private int currentRowCount = -1;
    private ListMap order = new ListMap();
    private String query;
    private String initQuery;
    private String finalQuery;
    private String userDefinfo;
    private int pageDataSize;
    private boolean isAutoHeight;
    private String sqlInfo;
    private boolean allowPage;
    private boolean loadData;
    private boolean headerSort;
    private String pkCol;
    private int isView;
    private String viewName;
    public List data;

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getSqlInfo() {
        return this.sqlInfo;
    }

    public void setSqlInfo(String sqlInfo) {
        this.sqlInfo = sqlInfo;
    }

    public ListExtendData getStyleData() {
        return this.styleData;
    }

    public void setStyleData(ListExtendData styleData) {
        this.styleData = styleData;
    }

    public boolean getIsAutoHeight() {
        return this.isAutoHeight;
    }

    public void setIsAutoHeight(boolean isAutoHeight) {
        this.isAutoHeight = isAutoHeight;
    }

    public ListExtend() {
    }

    public static ListExtend getInstance(String styleId) throws Exception {
        if (StringTool.isEmpty(styleId)) {
            return null;
        }
        ListExtendData styleData = ListExtend.getData(styleId);
        if (styleData == null) {
            return null;
        }
        if (styleData.getTableId() == null || "".equals(styleData.getTableId())) {
            return new ListExtend(styleData, true);
        }
        return new ListExtend(styleData);
    }

    public static ListExtendData getData(String styleId) throws Exception {
        return dao.getListExtend(styleId);
    }

    private ListExtend(ListExtendData styleData, boolean noTableId) throws Exception {
        this();
        this.styleId = styleData.getStyleId();
        this.pkCol = (String)styleData.getPkField()[0];
        this.addOrderField(this.getPkCol(), "ASC");
        this.tableId = "";
        this.pageDataSize = styleData.getPageSize();
        this.allowPage = styleData.isAllowPage();
        this.loadData = styleData.isLoadData();
        this.styleData = styleData;
        this.columnData = dao.getListExtendColumn(this.styleId, this.isView, "");
        this.sqlInfo = styleData.getSqlInfo();
        Object[] orderList = styleData.getSortWay();
        if (orderList != null) {
            int orderSize = orderList.length;
            int i = orderSize - 1;
            while (i >= 0) {
                Object dataItem = orderList[i];
                if (dataItem instanceof String[]) {
                    String[] theOrder = (String[])dataItem;
                    this.addOrderField(theOrder[0], theOrder[1]);
                }
                --i;
            }
        }
    }

    private ListExtend(ListExtendData styleData) throws Exception {
        this();
        this.styleId = styleData.getStyleId();
        TableBean table = Table.getTable(styleData.getTableId());
        this.pkCol = (String)styleData.getPkField()[0];
        this.tableId = table.getTableId();
        this.tableName = table.getTableName();
        this.dataSourceName = table.getDataSourceName();
        this.dataUserName = table.getDataUserName();
        this.addOrderField(this.getPkCol(), "ASC");
        this.query = null;
        this.finalQuery = null;
        this.isView = table.getIsView();
        this.pageDataSize = styleData.getPageSize();
        this.allowPage = styleData.isAllowPage();
        this.loadData = styleData.isLoadData();
        this.columnData = dao.getListExtendColumn(this.styleId, this.isView, styleData.getStyleId());
        this.sqlInfo = styleData.getSqlInfo();
        this.styleData = styleData;
        Object[] orderList = styleData.getSortWay();
        if (orderList != null) {
            int orderSize = orderList.length;
            int i = orderSize - 1;
            while (i >= 0) {
                Object dataItem = orderList[i];
                if (dataItem instanceof String[]) {
                    String[] theOrder = (String[])dataItem;
                    this.addOrderField(theOrder[0], theOrder[1]);
                }
                --i;
            }
        }
    }

    public int getIsView() {
        return this.isView;
    }

    public void addFilterSql(String sql2) {
        if (StringTool.isEmpty(sql2) || sql2.trim().length() == 0) {
            return;
        }
        this.finalQuery = null;
        String filterSql = sql2;
        StringBuffer sb = new StringBuffer(128);
        if (StringTool.isEmpty(this.query)) {
            sb.append(filterSql);
        } else {
            sb.append("(").append(this.query).append(") AND (").append(filterSql).append(")");
        }
        this.query = sb.toString();
    }

    public void addOrderField(String fieldName, String orderType) {
        if (fieldName != null && fieldName.length() != 0) {
            if (orderType == null || orderType.length() == 0) {
                this.order.add(0, fieldName, "ASC");
            } else {
                this.order.add(0, fieldName, orderType);
            }
        }
    }

    public String getOrderField() {
        StringBuffer sb = new StringBuffer(64);
        int orderSize = this.order.size();
        int i = 0;
        while (i < orderSize) {
            String key = (String)this.order.getKey(i);
            sb.append(",");
            sb.append(key);
            sb.append(" ");
            sb.append((String)this.order.getValue(i));
            ++i;
        }
        if (orderSize > 0) {
            return sb.substring(1);
        }
        return this.pkCol;
    }

    public ListMap getOrder() {
        return this.order;
    }

    public int getPageDataSize() {
        return this.pageDataSize;
    }

    public int getRowsCount() {
        return this.rowsCount;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex < 1 ? 1 : pageIndex;
    }

    public void setRowsCount(int rowsCount) {
        this.rowsCount = rowsCount;
        int dataSize = this.getPageDataSize();
        if (this.allowPage && dataSize > 0) {
            this.pageCount = this.rowsCount / dataSize;
            if (this.rowsCount % dataSize > 0) {
                ++this.pageCount;
            }
            if (this.pageCount <= 0) {
                if (this.rowsCount == 0) {
                    this.pageCount = 0;
                    this.pageIndex = 1;
                } else {
                    this.pageCount = 1;
                    this.pageIndex = 1;
                }
            }
        } else {
            this.pageCount = 1;
        }
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setCurrentRowCount(int currentRowCount) {
        this.currentRowCount = currentRowCount;
    }

    public int getPageCount() {
        if (this.rowsCount < 0) {
            log.error((Object)"\u5fc5\u987b\u5148\u8c03\u7528getData()");
        }
        return this.pageCount;
    }

    public int getCurrentRowCount() {
        return this.currentRowCount;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public String getPkCol() {
        return this.pkCol;
    }

    public String getQuery() {
        return this.getQuery(null);
    }

    public String getQuery(FormInstance formInstance) {
        if (this.finalQuery == null || "null".equals(this.finalQuery)) {
            this.finalQuery = this.initQuery == null || this.initQuery.length() == 0 || "null".equals(this.initQuery) ? (this.query == null || this.query.length() == 0 || "null".equals(this.query) ? "1=1" : this.query) : (this.query == null || this.query.length() == 0 ? this.initQuery : "(" + this.initQuery + ") AND (" + this.query + ")");
            this.finalQuery = this.finalQuery.replaceAll("\\[cell.userDefinfo\\]", this.userDefinfo);
            this.finalQuery = StringTool.replace(this.finalQuery, "='" + Constants.resources_blankRootNodeId + "'", " is null");
            if (formInstance != null) {
                this.finalQuery = FormInstance.replaceParaValue(this.finalQuery, formInstance);
            }
            this.finalQuery = StringTool.replaceKeyWord(this.finalQuery, formInstance);
        }
        return this.finalQuery;
    }

    public String getTableNoTableId(FormInstance formInstance) {
        if ("".equals(this.tableId)) {
            this.tableName = this.tableName.replaceAll("\\[cell.userDefinfo\\]", this.userDefinfo);
            this.tableName = StringTool.replace(this.tableName, "='" + Constants.resources_blankRootNodeId + "'", " is null");
            if (formInstance != null) {
                this.tableName = FormInstance.replaceParaValue(this.tableName, formInstance);
            }
            this.tableName = StringTool.replaceKeyWord(this.tableName, formInstance);
        }
        return this.tableName;
    }

    public List<ListExtendColumnData> getColumnData() {
        return this.columnData;
    }

    public boolean isHeaderSort() {
        return this.headerSort;
    }

    public void setPageDataSize(int pageDataSize) {
        this.pageDataSize = pageDataSize;
    }

    public String toJson() {
        StringBuffer sb = new StringBuffer(128);
        Class<?> classType = null;
        ListExtend obj = this;
        Class<?> parentType = obj.getClass();
        sb.insert(0, "{");
        while (parentType != null && !parentType.equals(classType)) {
            Field[] field = parentType.getDeclaredFields();
            int index = 0;
            while (index < field.length) {
                if (!Modifier.isStatic(field[index].getModifiers())) {
                    String fieldName = field[index].getName();
                    sb.append(BeanTool.toJson(fieldName));
                    sb.append(":");
                    Object fieldValue = null;
                    if ("query".equals(fieldName)) {
                        fieldValue = "";
                    } else {
                        try {
                            field[index].setAccessible(true);
                            fieldValue = field[index].get(obj);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    sb.append(BeanTool.toJson(fieldValue));
                    sb.append(",");
                }
                ++index;
            }
            classType = parentType;
            parentType = classType.getSuperclass();
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public String getField() {
        if (this.columnData == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(128);
        int len = this.columnData.size();
        boolean hasPk = false;
        ListExtendColumnData column = null;
        int i = 0;
        while (i < len) {
            String columnId;
            column = this.columnData.get(i);
            if (2 != column.getColumnType() && (columnId = column.getColumnId()) != null && columnId.length() != 0) {
                hasPk = hasPk || columnId.equals(this.pkCol);
                sb.append(",").append(columnId);
            }
            ++i;
        }
        if (this.pkCol != null && this.pkCol.length() != 0 && !hasPk) {
            sb.append(",").append(this.pkCol);
        }
        return sb.substring(1);
    }

    public boolean isAllowPage() {
        return this.allowPage;
    }

    public boolean isLoadData() {
        return this.loadData;
    }

    public void setAllowPage(boolean allowPage) {
        this.allowPage = allowPage;
    }

    public void setQuery(String query) {
        this.finalQuery = null;
        this.query = query;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDataUserName() {
        return this.dataUserName == null ? "" : this.dataUserName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getUserDefinfo() {
        return this.userDefinfo;
    }

    public void setUserDefinfo(String userDefinfo) {
        this.userDefinfo = userDefinfo;
    }
}

