/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.DynamicCell;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class WordCell
extends DynamicCell {
    private static final long serialVersionUID = 1L;

    public WordCell(Form pattern) {
        super(pattern);
        pattern.setOldPattern(true);
        this.tagName = "div";
    }

    @Override
    public String getTextAttribute() {
        return "FCKeditorAPI.GetInstance('" + this.cellId + "').GetXHTML(true)";
    }

    @Override
    public void render(FormInstance form) throws Exception {
        PrintWriter renderHtml = form.getRenderHtml();
        StringBuffer output = new StringBuffer();
        String cellText = form.getCell()[this.id].getText();
        String label = StringTool.replaceKeyWord(this.label);
        if (cellText == null) {
            cellText = "";
        }
        output.append("<input type=\"hidden\" id=\"content").append(this.cellId);
        output.append("\"  value = '");
        output.append(label);
        output.append("' write=\"false\" />");
        output.append("<div id =\"").append(this.cellId);
        output.append("\" style='position:");
        output.append(this.position);
        output.append(";left:");
        output.append(this.data.x1).append("px;top:").append(this.data.y1);
        output.append("px");
        if (StringTool.isEmpty(this.widthScale)) {
            output.append(";width:").append(this.width).append("px");
        } else {
            output.append(";width:").append(this.widthScale);
        }
        if (StringTool.isEmpty(this.heightScale)) {
            output.append(";height:").append(this.height).append("px");
        } else {
            output.append(";height:").append(this.heightScale);
        }
        output.append(";overflow:auto;'>");
        output.append("<script type=\"text/javascript\">\n");
        String appName = Global.getName();
        output.append("var sBasePath = \"").append(appName);
        output.append("/pms/platform/form/cell/word/\" ;\n");
        output.append("var oFCKeditor = new FCKeditor( '");
        output.append(this.cellId);
        output.append("' ) ;\n");
        output.append("oFCKeditor.BasePath\t= sBasePath ;\n");
        output.append("oFCKeditor.ToolbarSet = \"commonUse\" ;\n");
        output.append("oFCKeditor.Top =").append(this.data.y1).append(";\n");
        output.append("oFCKeditor.Left =").append(this.data.x1).append(";\n");
        if (this.id < form.getCell().length && form.getCell()[this.id] != null) {
            output.append("oFCKeditor.Value\t= \"").append(StringTool.toJson(cellText)).append("\" ;\n");
        }
        output.append("oFCKeditor.Create() ;\n");
        output.append("</script>");
        output.append("</div>");
        ((Writer)renderHtml).write(output.toString());
        this.renderScriptObject(form);
    }

    @Override
    protected void renderScriptObject(FormInstance form) {
        StringBuffer sb = new StringBuffer();
        String label = StringTool.replaceKeyWord(this.label);
        sb.append("defaultForm.addChild(new com.sdjxd.pms.platform.form.cell.Word({id:");
        sb.append(this.id);
        sb.append(",tagId:");
        sb.append("document.getElementById(\"cellId" + this.id).append("\")");
        sb.append(",divId:").append(this.data.areaId);
        sb.append(",needSave:").append(this.isNeedSave());
        sb.append(",showName:\"" + StringTool.toJson(this.cellName) + "\"");
        sb.append(",label:\"" + StringTool.toJson(label) + "\"");
        sb.append(",userDefinfo:").append("'" + StringTool.toJson(this.userDefinfo) + "'");
        if (form.getCell() != null && this.id < form.getCell().length && form.getCell()[this.id] != null) {
            sb.append(",limit:");
            sb.append(form.getCell()[this.id].getLimit());
        }
        sb.append("}));\n");
        if (!form.getCell()[this.id].isEnabled() || 1 == this.data.limit) {
            sb.append("defaultForm.getCellById(").append(this.id).append(").attachEvent('onload',function(){");
            sb.append("defaultForm.getCellById(").append(this.id).append(").setReadOnly(true);});\n");
        }
        form.addScript("form_obj_cell_" + this.id, sb.toString());
    }

    public static String replaceTextBase(String str) throws Base64DecodingException, UnsupportedEncodingException {
        String text = "";
        byte[] contBytes = null;
        contBytes = Base64.decode(str.getBytes("GBK"));
        text = new String(contBytes, "GBK");
        return text;
    }
}

