/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.form.service.cell;

import com.sdjxd.pms.platform.form.model.CellBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.form.service.cell.Cell;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.TreeMap;

public class VisualCell
extends Cell {
    private static final long serialVersionUID = 1L;
    protected Form pattern = null;
    private int areaId = -1;

    public VisualCell(Form pattern) {
        this.style = new TreeMap();
        this.classNames = new TreeMap();
        this.clearEvent();
        this.setPattern(pattern);
    }

    @Override
    protected void renderAttribute(FormInstance form) throws Exception {
        super.renderAttribute(form);
        this.renderClass(form);
        this.renderStyle(form);
        this.renderEvent(form);
    }

    @Override
    protected void renderStyle(FormInstance form) throws Exception {
        PrintWriter renderHtml = form.getRenderHtml();
        ((Writer)renderHtml).write(" style=\"");
        this.renderCommonStyle(form);
        this.renderVisible(form);
        this.renderPrint(form);
        ((Writer)renderHtml).write("\"");
    }

    @Override
    protected void renderClass(FormInstance form) throws Exception {
        PrintWriter renderHtml = form.getRenderHtml();
        ((Writer)renderHtml).write(" class=\"");
        this.renderCommonClass(form);
        this.renderEditClass(form);
        ((Writer)renderHtml).write("\"");
    }

    @Override
    public void setData(CellBean model) throws Exception {
        if (model == null) {
            return;
        }
        super.setData(model);
        this.setAreaId(model.areaId);
        this.setStyle();
        this.setClassName();
        if (this.getAreaId() != -1) {
            this.setParentControls(this.pattern.getCells()[this.getAreaId()]);
        } else {
            this.setParentControls(null);
            this.pattern.addCell(this);
        }
    }

    public int getAreaId() {
        return this.areaId;
    }

    protected void setAreaId(int areaId) {
        this.areaId = areaId;
    }

    public Form getPattern() {
        return this.pattern;
    }

    public void setPattern(Form pattern) {
        this.pattern = pattern;
    }
}

